/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.ISrcScore;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFactory;
import kd.scm.src.common.score.analyse.ISrcScoreReturnHandle;
import kd.scm.src.common.score.analyse.ISrcScoreReturnVerify;
import kd.scm.src.common.score.autoscore.ISrcAutoGetValue;
import kd.scm.src.common.score.prepare.SrcScoreGetFields;
import kd.scm.src.common.score.prepare.SrcScoreGetQFilterBizOpen;
import kd.scm.src.common.score.prepare.SrcScoreGetQFilterStatic;
import kd.scm.src.common.score.prepare.SrcScoreQueryData;
import kd.scm.src.common.score.result.SrcScoreHandleAnalysis;

public class SrcScoreFacade {
    public static SrcScoreContext createScoreContext(IFormView view) {
        return SrcScoreFactory.getInitContextInstance().createScoreContext(view);
    }

    public static void getSelectFields(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getSelectFieldsInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
    }

    public static void getQFilter(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getQFilterInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
    }

    public static void queryScoreData(SrcScoreContext context) {
        SrcScoreFactory.getQueryDataInstance().process(context);
    }

    public static void loadScoreData(SrcScoreContext context) {
        SrcScoreFactory.getLoadDataInstance().process(context);
    }

    public static void saveScoreData(SrcScoreContext context) {
        SrcScoreFactory.getSaveDataInstance().process(context);
    }

    public static void inputControl(IFormView view, int rowIndex) {
        SrcScoreContext context = SrcScoreFacade.createScoreContext(view);
        context.setShowMessage(true);
        context.setCurrentRowIndex(rowIndex);
        DynamicObject currentScoreRow = context.getView().getModel().getEntryRowEntity("score_entry", rowIndex);
        context.setCurrentScoreRow(currentScoreRow);
        SrcScoreFacade.prepareCalcData(context);
        SrcScoreFacade.verifyScoreData(context);
        if (!context.isVerifySucced() && context.getVerifyMessage().length() > 0 && context.isShowMessage()) {
            context.getView().showMessage(context.getVerifyMessage());
        }
    }

    public static void calculateScore(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getCalcScoreInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
    }

    public static void afterCopyScore(SrcScoreContext context) {
        ISrcScore scoreInstance = SrcScoreFactory.getAfterCopyInstance();
        scoreInstance.process(context);
    }

    public static void prepareCalcData(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getCalcPrepareInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
    }

    public static void verifyScoreData(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getVerifyDataInstances();
        context.setVerifySucced(true);
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
            if (context.isVerifySucced()) continue;
            break;
        }
        SrcScoreFactory.getVerifyAfterInstance().process(context);
    }

    public static void handleScorerStatus(SrcScoreContext context) {
        SrcScoreFactory.getHandleScorerInstance().process(context);
    }

    public static void handleSystemIndexStatus(SrcScoreContext context) {
        SrcScoreFactory.getHandleSysIndexInstance().process(context);
    }

    public static void handleManualIndexStatus(SrcScoreContext context) {
        SrcScoreFactory.getHandleManIndexInstance().process(context);
    }

    public static void handleScoreStatus(SrcScoreContext context) {
        SrcScoreFactory.getHandleScoreStatusInstance().process(context);
    }

    public static void handleVeto(SrcScoreContext context) {
        SrcScoreFactory.getHandleVetoInstance().process(context);
    }

    public static void submitScoreData(SrcScoreContext context) {
        context.setCommitSucced(true);
        context.setPrepareMessage("");
        SrcScoreFacade.verifyCommitData(context);
        if (!context.isCommitSucced()) {
            return;
        }
        SrcScoreFacade.prepareCommitData(context);
        if (!context.isCommitSucced()) {
            return;
        }
        context.setCommitMessage("");
        SrcScoreFacade.commitScoreData(context);
        if (context.getCommitMessage().length() > 0 && context.isShowMessage()) {
            context.getView().showMessage(context.getCommitMessage());
        }
        if (context.isCommitSucced()) {
            SrcScoreFacade.getSelectFields(context);
            SrcScoreFacade.getCacheFilterOrBuildFilter(context);
            SrcScoreFacade.queryScoreData(context);
            SrcScoreFacade.loadScoreData(context);
        }
    }

    public static void getCacheFilterOrBuildFilter(SrcScoreContext context) {
        String qfilterObj = context.getView().getPageCache().get("qfilter");
        if (null != qfilterObj) {
            QFilter qfilter = QFilter.fromSerializedString((String)context.getView().getPageCache().get("qfilter"));
            context.setScoreQFilter(qfilter);
        } else {
            SrcScoreFacade.getQFilter(context);
            context.getView().getPageCache().put("qfilter", context.getScoreQFilter().toSerializedString());
        }
    }

    private static void verifyCommitData(SrcScoreContext context) {
        List<ISrcScore> verifyInstances = SrcScoreFactory.getHandleVerifyInstances();
        for (ISrcScore verifyInstance : verifyInstances) {
            verifyInstance.process(context);
        }
        if (!context.isCommitSucced() && context.getCommitMessage().length() > 0 && context.isShowMessage()) {
            context.getView().showMessage(context.getCommitMessage());
        }
    }

    private static void prepareCommitData(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getHandlePrepareInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
        if (!context.isCommitSucced() && context.getCommitMessage().length() > 0 && context.isShowMessage()) {
            context.getView().showMessage(context.getCommitMessage());
        }
    }

    private static void commitScoreData(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getCommitScoreInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
        if (!context.isCommitSucced() && context.getCommitMessage().length() > 0 && context.isShowMessage()) {
            context.getView().showMessage(context.getCommitMessage());
        }
    }

    public static void autoScoreForIndex(SrcScoreContext context) {
        List<ISrcScore> scoreInstances = SrcScoreFactory.getAutoScoreIndexInstances();
        for (ISrcScore scoreInstance : scoreInstances) {
            scoreInstance.process(context);
        }
    }

    public static void autoScoreForProject(SrcScoreContext context) {
        ISrcScore scoreInstance = SrcScoreFactory.getAutoScoreProjectInstance();
        scoreInstance.process(context);
        if (context.getAutoScoreMessage().length() > 0 && context.isShowMessage()) {
            context.getView().showMessage(context.getAutoScoreMessage());
        }
    }

    public static void sendScoreTaskMessage(DynamicObject billObj, String billType, String operation) {
        long billId = PdsCommonUtils.object2Long((Object)billObj.getPkValue());
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        if (Objects.equals(operation, "allopen") || Objects.equals(operation, "tecopen") || Objects.equals(operation, "bizopen") || Objects.equals(operation, "aptopen") || Objects.equals(operation, "pushscore")) {
            OperationServiceHelper.executeOperate((String)"scoretasksendmsg", (String)"pds_sendmessage", (Object[])new Long[]{billId}, (OperateOption)option);
        } else if (Objects.equals(billType, "src_aptitudeaudit")) {
            OperationServiceHelper.executeOperate((String)"aptitudeauditsendmsg", (String)"pds_sendmessage", (Object[])new Long[]{billId}, (OperateOption)option);
        } else if (Objects.equals(billType, "src_aptitudeaudit2")) {
            OperationServiceHelper.executeOperate((String)"aptitudeaudit2sendmsg", (String)"pds_sendmessage", (Object[])new Long[]{billId}, (OperateOption)option);
        } else if (Objects.equals(billType, "src_expertevaluate")) {
            OperationServiceHelper.executeOperate((String)"scoretasksendmsg", (String)"src_expertevaluate", (Object[])new Long[]{billId}, (OperateOption)option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scoreReturn(Object[] objects, SrcScoreContext context) {
        List<ISrcScoreReturnVerify> verifiers = SrcScoreFactory.getScoreReturnVerifyInstances();
        context.setVerifySucced(true);
        for (ISrcScoreReturnVerify verifier : verifiers) {
            if (!context.isVerifySucced()) continue;
            verifier.process(context);
        }
        if (!context.isVerifySucced()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            List<ISrcScoreReturnHandle> handlers = SrcScoreFactory.getScoreReturnHandleInstances();
            for (ISrcScoreReturnHandle handler : handlers) {
                if (!context.isVerifySucced()) continue;
                handler.process(context);
            }
        }
    }

    public static void computeDetailAVG(Set<Long> projectSet) {
        SrcScoreHandleAnalysis handler = new SrcScoreHandleAnalysis();
        SrcScoreContext context = new SrcScoreContext();
        context.setProjectSet(projectSet);
        handler.process(context);
    }

    public static DynamicObject[] getScoreDetailRows(SrcScoreContext context) {
        QFilter filters = new QFilter("project", "=", (Object)context.getProjectId());
        filters.and("billid.bizstatus", "!=", (Object)"E");
        filters.and("entryid.indexlib.id", ">", (Object)0L);
        boolean isEvaluate = null == context.getView() ? false : SrcScoreFacade.isEvaluateScore(context.getView().getEntityId());
        String entityName = isEvaluate ? "src_evaluateanalyse" : "src_scoreanalyse";
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters.toArray());
    }

    public static DynamicObject[] getSupAnalyDetailRows(long billId, String entityName) {
        QFilter filters = new QFilter("billid", "=", (Object)billId);
        filters.and("index.indexlib.id", ">", (Object)0L);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters.toArray());
    }

    public static void autoGetIndexValue(DynamicObject[] autoGetValueRows) {
        SrcScoreContext context = new SrcScoreContext();
        context.setAutoGetValueRows(autoGetValueRows);
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstances(ISrcAutoGetValue.class.getSimpleName(), null);
        for (ISrcAutoGetValue handler : handlers) {
            handler.process(context);
        }
    }

    public static String getIndexKey(SrcScoreContext context) {
        return context.getIndexObj().getString("valuefield");
    }

    public static String getIndexCombKey(SrcScoreContext context) {
        return "";
    }

    public static void scoreReturn(IFormView view, BeforeDoOperationEventArgs args, Object[] objects) {
        if (null == objects || objects.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u9000\u56de\u91cd\u8bc4\u7684\u8bb0\u5f55\u3002", (String)"SrcScoreFacade_4", (String)"scm-src-common", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        SrcScoreContext context = new SrcScoreContext();
        context.setObjects(objects);
        context.setScorerMap(new HashMap<String, DynamicObject[]>(1));
        Map paramMap = view.getFormShowParameter().getCustomParams();
        context.setParamMap(paramMap);
        context.setView(view);
        context.setEvaluate(SrcScoreFacade.isEvaluateScore(view.getEntityId()));
        SrcScoreFacade.scoreReturn(objects, context);
        if (context.isVerifySucced()) {
            if (null != view && null != view.getParentView()) {
                view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u91cd\u8bc4\u6210\u529f\u3002", (String)"SrcScoreFacade_7", (String)"scm-src-common", (Object[])new Object[0]));
                PdsCommonUtils.refreshParentView((IFormView)view);
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u8bb0\u5f55\u4e0d\u7b26\u5408\u9000\u56de\u91cd\u8bc4\u7684\u6761\u4ef6\u3002", (String)"SrcScoreFacade_6", (String)"scm-src-common", (Object[])new Object[0]), context.getVerifyMessage(), null);
            args.setCancel(true);
        }
    }

    public static Object[] getSelectDetailids(IFormView view) {
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        int[] indexs = grid.getSelectRows();
        Object[] objects = new Object[indexs.length];
        for (int i = 0; i < indexs.length; ++i) {
            DynamicObject row = view.getModel().getEntryRowEntity("entryentity", indexs[i]);
            objects[i] = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("detailid"));
        }
        return objects;
    }

    public static void saveData(DynamicObjectCollection rows, Object[] objects, String entityName) {
        Map<Long, DynamicObject> scoreMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("detailid.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        if (scoreMap.size() == 0) {
            return;
        }
        QFilter qFilters = new QFilter("id", "in", (Object)objects).and("scored", "=", (Object)"1");
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] scorerObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qFilters.toArray());
        if (scorerObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> scoreList = new ArrayList<DynamicObject>(scorerObjs.length);
        for (DynamicObject scorerObj : scorerObjs) {
            DynamicObject obj = scoreMap.get(scorerObj.getLong("id"));
            if (null == obj) continue;
            scorerObj.set("reason", (Object)obj.getString("reason"));
            scoreList.add(scorerObj);
        }
        PdsCommonUtils.saveDynamicObjects(scoreList);
    }

    public static Set<Long> getScorerProjectIds(IFormView view) {
        DynamicObjectCollection rows = SrcScoreFacade.getScorerScoreObjs(view);
        if (null != rows && rows.size() > 0) {
            return rows.stream().map(e -> e.getLong("project")).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    public static Set<Long> getScorerPurOrgIds(IFormView view) {
        DynamicObjectCollection rows = SrcScoreFacade.getScorerScoreObjs(view);
        if (null != rows && rows.size() > 0) {
            return rows.stream().map(e -> e.getLong("org")).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    public static DynamicObjectCollection getScorerScoreObjs(IFormView view) {
        Map paramMap = view.getFormShowParameter().getCustomParams();
        SrcScoreContext context = SrcScoreFacade.createScoreContext(view.getParentView());
        context.setParamMap(paramMap);
        ISrcScore handler = new SrcScoreGetQFilterStatic();
        handler.process(context);
        handler = new SrcScoreGetQFilterBizOpen();
        handler.process(context);
        handler = new SrcScoreGetFields();
        handler.process(context);
        handler = new SrcScoreQueryData();
        handler.process(context);
        return context.getScoreObjs();
    }

    public static boolean isEvaluateScore(String entityName) {
        if (null == entityName || StringUtils.isBlank((CharSequence)entityName) || entityName.length() < 12) {
            return false;
        }
        return "src_evaluate".equals(entityName.substring(0, 12)) || "src_submitopinion".equals(entityName) || "src_expertevaluate".equals(entityName);
    }
}

