/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.assessstatus.ISrcAssessStatusHandler;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusContext;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusHandlerApt;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusHandlerApt2;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusHandlerBiz;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusHandlerTec;
import kd.scm.src.common.score.assessstatus.SrcScoreAssessStatusHandler;
import kd.scm.src.common.score.assessstatus.SrcScorerTaskStatusHandler;
import kd.scm.src.common.score.autoscore.ISrcAutoGetValue;

public class SrcScoreHelper {
    private static final String regEx = "^(([1-9]{1}\\d*)|(0{1}))(\\.\\d{1,3})?$";

    public static boolean isNumberValue(DynamicObject scoreObj, String propertyName) {
        String propertyValue = scoreObj.getString(propertyName);
        return propertyValue.matches(regEx);
    }

    public static boolean isNumberValue(String propertyValue) {
        return propertyValue.matches(regEx);
    }

    public static String formatNumberValue(Object value) {
        String newValue = "";
        String string = value == null ? "" : (value.toString().trim().length() == 0 ? "" : (newValue = new BigDecimal(value.toString()).compareTo(BigDecimal.ZERO) == 0 ? "0" : value.toString()));
        if (newValue.length() != 0) {
            newValue = new BigDecimal(newValue).stripTrailingZeros().toPlainString();
        }
        return newValue;
    }

    public static void getIndexObj(SrcScoreContext context) {
        if (context.getIndexId() == 0L) {
            return;
        }
        String key = "src_index|" + String.valueOf(context.getIndexId());
        DynamicObject indexObj = (DynamicObject)PdsObjectPools.getInstance((String)key);
        if (indexObj == null && QueryServiceHelper.exists((String)"src_index", (Object)context.getIndexId())) {
            indexObj = BusinessDataServiceHelper.loadSingle((Object)context.getIndexId(), (String)"src_index");
            PdsObjectPools.putInstance((String)key, (Object)indexObj);
        }
        context.setIndexObj(indexObj);
    }

    public static void getIndexPlugin(SrcScoreContext context) {
        if (context.getIndexObj() == null) {
            return;
        }
        String pluginName = context.getIndexObj().getString("pluginname");
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            return;
        }
        ISrcAutoGetValue indexPlugin = (ISrcAutoGetValue)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(pluginName);
        context.setIndexPlugin(indexPlugin);
    }

    public static QFilter getBaseTypeFilter(SrcScoreContext context, String keyField) {
        QFilter qfilters = new QFilter(keyField, "!=", (Object)"4");
        qfilters.and(keyField, "!=", (Object)"7");
        Map paramMap = context.getParamMap();
        if (null == paramMap && context.getView() != null) {
            paramMap = context.getView().getFormShowParameter().getCustomParams();
        }
        if (null != paramMap && paramMap.size() > 0 && !StringUtils.isBlank(paramMap.get("basetype"))) {
            Object bastTypeObj = context.getParamMap().get("basetype");
            qfilters = bastTypeObj instanceof Set || bastTypeObj instanceof List ? new QFilter(keyField, "in", bastTypeObj) : new QFilter(keyField, "=", bastTypeObj);
        }
        return qfilters;
    }

    private static String getScoreBaseType(SrcScoreContext context) {
        List bastTypeList;
        Map paramMap = context.getParamMap();
        if (null == paramMap && context.getView() != null) {
            paramMap = context.getView().getFormShowParameter().getCustomParams();
        }
        if (null == paramMap) {
            return "";
        }
        Object bastTypeObj = paramMap.get("basetype");
        String baseType = bastTypeObj instanceof List ? ((bastTypeList = (List)bastTypeObj).size() > 1 ? "1" : (String)bastTypeList.get(0)) : PdsCommonUtils.object2String(paramMap.get("basetype"), (String)"");
        return baseType;
    }

    public static boolean isAptitudeScore1(SrcScoreContext context) {
        String baseType = SrcScoreHelper.getScoreBaseType(context);
        return baseType.equals("4");
    }

    public static boolean isAptitudeScore2(SrcScoreContext context) {
        String baseType = SrcScoreHelper.getScoreBaseType(context);
        return baseType.equals("7");
    }

    private static QFilter getProjectFilter(long projectId, long packageId) {
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        if (packageId > 0L) {
            qFilter.and("package.id", "=", (Object)packageId);
        }
        return qFilter;
    }

    public static QFilter getUnScoreFilter(long projectId, long packageId) {
        QFilter qFilter = SrcScoreHelper.getProjectFilter(projectId, packageId);
        qFilter.and("bizstatus", "!=", (Object)SrmScoreStatusEnum.SCORED.getValue());
        qFilter.and("bizstatus", "!=", (Object)"E");
        return qFilter;
    }

    public static QFilter getHasScoreFilter(long projectId, long packageId) {
        QFilter qFilter = SrcScoreHelper.getProjectFilter(projectId, packageId);
        qFilter.and("bizstatus", "=", (Object)SrmScoreStatusEnum.SCORED.getValue());
        return qFilter;
    }

    public static QFilter getUnScoreIndexFilter(long projectId, long packageId, QFilter indexFilter) {
        return SrcScoreHelper.getUnScoreFilter(projectId, packageId).and(indexFilter);
    }

    public static QFilter getHasScoreIndexFilter(long projectId, long packageId, QFilter indexFilter) {
        return SrcScoreHelper.getHasScoreFilter(projectId, packageId).and(indexFilter);
    }

    public static boolean isAllScored(QFilter hasScoreFilter, QFilter unScoreFilter) {
        return QueryServiceHelper.exists((String)"src_scoretask", (QFilter[])hasScoreFilter.toArray()) && !QueryServiceHelper.exists((String)"src_scoretask", (QFilter[])unScoreFilter.toArray());
    }

    public static void assessStatusCommHandle(SrcAssessStatusContext context, String number, String defaultPlugin) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, defaultPlugin);
        for (ISrcAssessStatusHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void handleTecStatus(SrcAssessStatusContext context) {
        SrcScoreHelper.assessStatusCommHandle(context, SrcAssessStatusHandlerTec.class.getSimpleName(), SrcAssessStatusHandlerTec.class.getName());
    }

    public static void handleBizStatus(SrcAssessStatusContext context) {
        SrcScoreHelper.assessStatusCommHandle(context, SrcAssessStatusHandlerBiz.class.getSimpleName(), SrcAssessStatusHandlerBiz.class.getName());
    }

    public static void handleAptStatus(SrcAssessStatusContext context) {
        SrcScoreHelper.assessStatusCommHandle(context, SrcAssessStatusHandlerApt.class.getSimpleName(), SrcAssessStatusHandlerApt.class.getName());
    }

    public static void handleAptStatus2(SrcAssessStatusContext context) {
        SrcScoreHelper.assessStatusCommHandle(context, SrcAssessStatusHandlerApt2.class.getSimpleName(), SrcAssessStatusHandlerApt2.class.getName());
    }

    public static void handleScorerTaskStatus(SrcAssessStatusContext context) {
        SrcScoreHelper.assessStatusCommHandle(context, SrcScorerTaskStatusHandler.class.getSimpleName(), SrcScorerTaskStatusHandler.class.getName());
    }

    private static void handleAssessStatus(SrcAssessStatusContext context) {
        SrcScoreHelper.assessStatusCommHandle(context, SrcScoreAssessStatusHandler.class.getSimpleName(), SrcScoreAssessStatusHandler.class.getName());
    }

    public static void handleAssessStatus(SrcScoreContext scoreContext, DynamicObject scorertaskObj, List<DynamicObject> scorertaskList, List<DynamicObject> packageList, boolean isAuditScore) {
        SrcAssessStatusContext context = new SrcAssessStatusContext();
        context.setScorertaskObj(scorertaskObj);
        context.setScorertaskList(scorertaskList);
        context.setPackageList(packageList);
        context.setAuditScore(isAuditScore);
        context.setScoreContext(scoreContext);
        context.setOpKey(scoreContext.getOpKey());
        SrcScoreHelper.handleAssessStatus(context);
        scoreContext.setFinishScore(context.isFinishScore());
    }

    public static boolean isNeedSuggestion(IFormView view, long projectId) {
        Map paramMap = view.getFormShowParameter().getCustomParams();
        if (null == paramMap) {
            return false;
        }
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"srctype.id,id", (QFilter[])qfilters.toArray());
        if (null == projectObj) {
            return false;
        }
        String isneedsuggestion = null;
        String baseType = PdsCommonUtils.object2String(paramMap.get("basetype"), (String)"");
        isneedsuggestion = baseType.equals("4") ? "isneedsuggestion" : (baseType.equals("7") ? "isneedsuggestion2" : "isneedsuggestion3");
        return ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)projectObj.getLong("srctype.id"), (String)isneedsuggestion, (Object)false, (long)projectObj.getLong("id")));
    }

    public static String getBillId(IFormView view) {
        long billId = PdsCommonUtils.object2Long((Object)view.getModel().getValue("project_id"));
        if (billId == 0L) {
            Map params = view.getFormShowParameter().getCustomParams();
            billId = PdsCommonUtils.object2Long(params.get("billid"));
        }
        String basetype = view.getModel().getDataEntity().getString("basetype");
        return String.valueOf(billId) + '_' + basetype;
    }
}

