/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.analyse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.score.analyse.ISrcScoreReturnHandle;

public class SrcReturnScoreAnalyse
implements ISrcScoreReturnHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.updateScoreAnalyse(context);
    }

    private void updateScoreAnalyse(SrcScoreContext context) {
        Map<String, DynamicObject[]> scorerMap = context.getScorerMap();
        DynamicObject[] scorerObjs = scorerMap.get("scorer");
        HashSet excludedFields = new HashSet();
        List properties = null;
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(scorerObjs.length);
        String entityName = SrcScoreFacade.isEvaluateScore(context.getView().getEntityId()) ? "src_evaluatereturn" : "src_scorereturn";
        for (DynamicObject scorerObj : scorerObjs) {
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            if (null == properties) {
                properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)logObj);
            }
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)scorerObj, (DynamicObject)logObj, (List)properties, excludedFields, (int)-1);
            logObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            logObjs.add(logObj);
            scorerObj.set("scored", (Object)"0");
            scorerObj.set("invalid", (Object)"0");
            scorerObj.set("value", (Object)0);
            scorerObj.set("score", (Object)0);
            scorerObj.set("scorerscore", (Object)0);
            scorerObj.set("note", null);
            scorerObj.set("isfitted", (Object)"0");
        }
        PdsCommonUtils.saveDynamicObjects(logObjs);
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])scorerObjs);
    }
}

