/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.analyse;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.analyse.ISrcScoreReturnHandle;

public class SrcReturnScoreSuggestion
implements ISrcScoreReturnHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.updateScoreSuggestion(context);
    }

    private void updateScoreSuggestion(SrcScoreContext context) {
        String entityName = context.isEvaluate() ? "src_evaluateopinionf7" : "src_scoresuggestionf7";
        Map<String, DynamicObject[]> scorerMap = context.getScorerMap();
        DynamicObject[] scorerObjs = scorerMap.get("scorer");
        Set taskIdSet = Arrays.asList(scorerObjs).stream().map(e -> e.getLong("billid.id")).distinct().collect(Collectors.toSet());
        Set scorerSet = Arrays.asList(scorerObjs).stream().map(e -> e.getLong("scorer.id")).distinct().collect(Collectors.toSet());
        Set agentSet = Arrays.asList(scorerObjs).stream().map(e -> e.getLong("agent.id")).distinct().collect(Collectors.toSet());
        QFilter qfilters = new QFilter("billid", "in", taskIdSet).and(new QFilter("scorer", "in", scorerSet).or("agent", "in", agentSet));
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] suggestionObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (suggestionObjs == null || suggestionObjs.length == 0) {
            return;
        }
        Set keys = Arrays.asList(scorerObjs).stream().map(e -> e.getString("scorer.id") + '_' + e.getString("billid.id")).distinct().collect(Collectors.toSet());
        for (DynamicObject suggestionObj : suggestionObjs) {
            String key = suggestionObj.getString("scorer.id") + '_' + suggestionObj.getString("billid.id");
            if (!keys.contains(key)) continue;
            suggestionObj.set("scorerscore", (Object)"0");
            suggestionObj.set("isvalid", (Object)"0");
            suggestionObj.set("suggestion", null);
            suggestionObj.set("attachment", null);
        }
        SaveServiceHelper.save((DynamicObject[])suggestionObjs);
    }
}

