/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.assessstatus;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.util.SendMessageUtils;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.assessstatus.ISrcAssessStatusHandler;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusContext;
import kd.scm.src.common.util.SrcBidAssessUtils;

public class SrcAssessStatusHandlerTec
implements ISrcAssessStatusHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcAssessStatusContext context) {
        QFilter unScoreFilter;
        if (!context.getPackageObj().getBoolean("istecopen")) {
            return;
        }
        QFilter indexFilter = this.getIndexFilter(context.getScorertaskObj());
        QFilter hasScoreFilter = SrcScoreHelper.getHasScoreIndexFilter(context.getProjectId(), context.getPackageId(), indexFilter);
        if (SrcScoreHelper.isAllScored(hasScoreFilter, unScoreFilter = SrcScoreHelper.getUnScoreIndexFilter(context.getProjectId(), context.getPackageId(), indexFilter))) {
            this.handleAssessStatus(context);
        }
        if (!context.isSendMessage() && SrcScoreHelper.isAllScored(hasScoreFilter = SrcScoreHelper.getHasScoreIndexFilter(context.getProjectId(), 0L, indexFilter), unScoreFilter = SrcScoreHelper.getUnScoreIndexFilter(context.getProjectId(), 0L, indexFilter)) && Objects.equals(context.getOpKey(), "scoresubmit")) {
            SendMessageUtils.sendMessage((long)context.getProjectId(), (String)"tecallscored");
            context.setSendMessage(true);
        }
    }

    protected QFilter getIndexFilter(DynamicObject scorertaskObj) {
        QFilter qFilter = new QFilter("indextype.basetype", "!=", (Object)"4").and("indextype.basetype", "!=", (Object)"7");
        if (SrcBidAssessUtils.isNeedExcludeBizIndex(scorertaskObj) || "4".equals(scorertaskObj.getString("opentype"))) {
            qFilter.and("indextype.basetype", "!=", (Object)"2");
        }
        return qFilter;
    }

    protected void handleAssessStatus(SrcAssessStatusContext context) {
        context.getPackageObj().set("istecassess", (Object)"1");
        Date tecAssessDate = context.getPackageObj().getDate("tecassessdate");
        if (Objects.isNull(tecAssessDate)) {
            context.getPackageObj().set("tecassessdate", (Object)TimeServiceHelper.now());
        }
        context.setPackageChanged(true);
        context.subPackageNum();
    }
}

