/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.autoscore;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.autoscore.ISrcAutoScore;

public class SrcAutoScoreByRule
implements ISrcAutoScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        if (!context.isAutoScored()) {
            this.calcScoreByRule(context);
        }
    }

    protected void calcScoreByRule(SrcScoreContext context) {
        if (null == context.getTxtValue() && null == context.getNumValue()) {
            return;
        }
        if (context.getIndexObj() == null) {
            return;
        }
        DynamicObjectCollection scoreRules = context.getIndexObj().getDynamicObjectCollection("entryentity");
        if (null == scoreRules || scoreRules.size() == 0) {
            return;
        }
        List ruleList = scoreRules.stream().filter(ruleObj -> this.scoreRuleFilter(context, (DynamicObject)ruleObj)).collect(Collectors.toList());
        if (ruleList != null && ruleList.size() > 0) {
            context.setScore(((DynamicObject)ruleList.get(0)).getBigDecimal("itemscore"));
            context.setAutoScored(true);
        }
    }

    public boolean scoreRuleFilter(SrcScoreContext context, DynamicObject ruleObj) {
        String property = context.getIndexObj().getString("property");
        if (property == null || "2".equals(property)) {
            if (null == context.getTxtValue()) {
                return false;
            }
            return ruleObj.getString("itemvalue").equals(context.getTxtValue()) && !StringUtils.isBlank((CharSequence)context.getTxtValue());
        }
        if (null == context.getNumValue()) {
            return false;
        }
        return ruleObj.getBigDecimal("valuefrom").compareTo(context.getNumValue()) <= 0 && ruleObj.getBigDecimal("valueto").compareTo(context.getNumValue()) > 0;
    }
}

