/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.autoscore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.autoscore.ISrcAutoScore;

public class SrcAutoScoreForProject
implements ISrcAutoScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.autoScoreForProject(context);
        if (!context.isAutoScored()) {
            context.setAutoScoreMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u81ea\u52a8\u8bc4\u5206\u7684\u6307\u6807\u3002", (String)"SrcAutoScoreForProject_0", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }

    protected void autoScoreForProject(SrcScoreContext context) {
        DynamicObject[] scoreRows = SrcScoreFacade.getScoreDetailRows(context);
        if (scoreRows == null || scoreRows.length == 0) {
            return;
        }
        ArrayList<DynamicObject> scoreObjs = new ArrayList<DynamicObject>(scoreRows.length);
        for (DynamicObject scoreRow : scoreRows) {
            this.initScoreContext(context, scoreRow);
            if (context.getIndexId() <= 0L) continue;
            SrcScoreFacade.autoScoreForIndex(context);
            this.setIndexScoreValue(context, scoreObjs, scoreRow);
        }
        if (scoreObjs != null && scoreObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])scoreObjs.toArray(new DynamicObject[scoreObjs.size()]));
            context.setAutoScored(true);
            context.setAutoScoreMessage(String.format(ResManager.loadKDString((String)"\u5171\u81ea\u52a8\u8bc4\u5206\uff1a%1$s \u4e2a\u6307\u6807\u3002", (String)"SrcAutoScoreForProject_1", (String)"scm-src-common", (Object[])new Object[0]), scoreObjs.size()));
        }
    }

    protected void initScoreContext(SrcScoreContext context, DynamicObject scoreRow) {
        BigDecimal classRatio;
        context.setAutoScored(false);
        context.setNumValue(null);
        context.setTxtValue(null);
        context.setValue(BigDecimal.ZERO);
        context.setScore(BigDecimal.ZERO);
        context.setNote("");
        long indexId = scoreRow.getLong("entryid.indexlib.id");
        SrcScoreHelper.getIndexObj(context);
        long supplierId = scoreRow.getLong("billid.supplier.id");
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)scoreRow.getDynamicObject("project")));
        context.setSupplierId(supplierId);
        context.setIndexId(indexId);
        String scoreMethod = PdsCommonUtils.object2String((Object)scoreRow.getString("index.scoremethod"), (String)"1");
        context.setScoreMethod(scoreMethod);
        BigDecimal schemeScore = BigDecimal.valueOf(100L);
        if ("3".equals(scoreMethod) && (schemeScore = scoreRow.getBigDecimal("index.schemescore")).compareTo(BigDecimal.ZERO) <= 0) {
            schemeScore = BigDecimal.valueOf(100L);
        }
        if ((classRatio = scoreRow.getBigDecimal("billid.indexscore").divide(schemeScore, 10, 5)).compareTo(BigDecimal.ZERO) == 0) {
            classRatio = BigDecimal.ONE;
        }
        context.setClassRatio(classRatio);
        BigDecimal indexScore = scoreRow.getBigDecimal("indexscore");
        context.setIndexScore(indexScore);
        BigDecimal indexRatio = BigDecimal.ONE;
        switch (scoreMethod) {
            case "1": {
                indexRatio = indexScore.divide(BigDecimal.valueOf(100L));
                break;
            }
            case "2": {
                indexRatio = BigDecimal.ONE;
                break;
            }
            case "3": {
                indexRatio = indexScore.divide(schemeScore, 10, 5);
            }
        }
        context.setIndexRatio(indexRatio);
        BigDecimal scorerRatio = indexRatio.multiply(classRatio);
        if (scorerRatio.compareTo(BigDecimal.ZERO) == 0) {
            scorerRatio = BigDecimal.ONE;
        }
        context.setScorerRatio(scorerRatio);
    }

    public void setIndexScoreValue(SrcScoreContext context, List<DynamicObject> scoreObjs, DynamicObject scoreRow) {
        if (context.isAutoScored()) {
            BigDecimal score = context.getScore().multiply(context.getScorerRatio());
            scoreRow.set("value", (Object)context.getScore());
            scoreRow.set("score", (Object)context.getScore().multiply(context.getIndexRatio()));
            scoreRow.set("scorerscore", (Object)score);
            scoreRow.set("isautoscore", (Object)true);
            scoreRow.set("note", (Object)context.getNote());
            scoreRow.set("scored", (Object)true);
            scoreObjs.add(scoreRow);
        }
    }
}

