/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.process;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.process.ISrcScoreSaveData;

public class SrcScoreSaveData
implements ISrcScoreSaveData {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.saveScoreData(context);
    }

    protected void saveScoreData(SrcScoreContext context) {
        DynamicObjectCollection scoreRows = context.getView().getModel().getEntryEntity("score_entry");
        Map<String, DynamicObject> scoreMap = scoreRows.stream().filter(e -> e.getBoolean("scorerscored") && context.getScoreTaskStatus().contains(e.getString("bizstatus"))).collect(Collectors.groupingBy(e -> e.getString("detailid"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        Set scoreIdSet = scoreMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet());
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", scoreIdSet)};
        String entityName = context.isEvaluate() ? "src_evaluatetask_scorerf7" : "src_scoretask_scorerf7";
        DynamicObject[] detailObjs = BusinessDataServiceHelper.load((String)entityName, (String)"id,value,score,note,reason,scorerscore,isfitted,scorerscored", (QFilter[])qFilters);
        if (detailObjs == null || detailObjs.length == 0) {
            return;
        }
        for (DynamicObject detailObj : detailObjs) {
            DynamicObject scoreObj = scoreMap.get(detailObj.getString("id"));
            if (null == scoreObj) continue;
            detailObj.set("value", scoreObj.get("value"));
            detailObj.set("score", scoreObj.get("score"));
            detailObj.set("note", scoreObj.get("note"));
            detailObj.set("reason", scoreObj.get("reason"));
            detailObj.set("scorerscore", scoreObj.get("scorerscore"));
            detailObj.set("isfitted", scoreObj.get("isfitted"));
        }
        Object[] result = SaveServiceHelper.save((DynamicObject[])detailObjs);
        if (null != result && result.length > 0 && context.isShowMessage()) {
            context.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u4fdd\u5b58\u6210\u529f\u3002", (String)"SrcScoreSaveData_0", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }
}

