/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;
import kd.scm.src.common.score.push.SrcScoreTaskFacade;

public class SrcScoreTaskCreateTaskBill
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        if (null != context.getTenderSuppliers() && context.getTenderSuppliers().length > 0) {
            this.createScoreTaskBill(context);
        }
    }

    protected void createScoreTaskBill(SrcScoreTaskContext context) {
        for (DynamicObject tenderSupplier : context.getTenderSuppliers()) {
            context.setTenderSupplier(tenderSupplier);
            if ((!"2".equals(context.getBaseType()) && context.isPushTecByPurlist() || "2".equals(context.getBaseType()) && context.isPushBizByPurlist()) && null != context.getPurlistIdSet() && context.getPurlistIdSet().size() > 0) {
                for (String purlistId : context.getPurlistIdSet()) {
                    String[] purlistIds = purlistId.split("\\_");
                    if (Long.parseLong(purlistIds[0]) != tenderSupplier.getLong("supplier.id") || Long.parseLong(purlistIds[1]) != tenderSupplier.getLong("package.id")) continue;
                    context.setPurlistId(Long.parseLong(purlistIds[2]));
                    this.createScoreTask(context, true);
                }
            } else {
                context.setPurlistId(0L);
                this.createScoreTask(context, false);
            }
            if (context.isAptitudeAudit()) {
                tenderSupplier.set("isaptpush", (Object)"1");
            } else if (context.isAptitudeAudit2()) {
                tenderSupplier.set("isaptpush2", (Object)"1");
            } else if (context.isExpertEvaluate()) {
                tenderSupplier.set("isevaluatepush", (Object)"1");
            } else {
                tenderSupplier.set("isbidpush", (Object)"1");
            }
            if (!(context.isAptitudeAudit() || context.isAptitudeAudit2() || context.isExpertEvaluate())) {
                tenderSupplier.set("entrystatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
            }
            if (!context.getAllTenderSuppliers().stream().noneMatch(e -> e.getLong("id") == tenderSupplier.getLong("id"))) continue;
            context.getAllTenderSuppliers().add(tenderSupplier);
        }
    }

    protected void createScoreTask(SrcScoreTaskContext context, boolean isByPurlist) {
        DynamicObjectCollection rows = context.getSchemeIndexs();
        Map<Long, List<DynamicObject>> baseTypeMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("indextype.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : baseTypeMap.entrySet()) {
            Long indextypeId = entry.getKey();
            String baseType = baseTypeMap.get(indextypeId).get(0).getString("indextype.basetype");
            if (indextypeId == 0L) {
                indextypeId = context.getSchemeObj().getLong("type.id");
            }
            if (isByPurlist && (context.isPushTecByPurlist() && !context.isPushBizByPurlist() ? "2".equals(baseType) : !context.isPushTecByPurlist() && context.isPushBizByPurlist() && !"2".equals(baseType))) continue;
            context.setIndextypeId(indextypeId);
            if (!context.getScoreTaskSet().add(SrcScoreTaskFacade.getScoreTaskKey(context))) continue;
            SrcScoreTaskFacade.createScoreTaskBillObj(context);
            DynamicObject scoreTaskObj = context.getScoreTaskObj();
            SrcScoreTaskFacade.createTecSumObj(context);
            context.setIndexSeq(1);
            SrcScoreTaskFacade.createIndexEntry(context);
            if ("publish".equals(context.getOperateKey())) {
                if (!scoreTaskObj.getBoolean("isaptitudereply") && !scoreTaskObj.getBoolean("ispuraptitude")) {
                    scoreTaskObj.set("ispuraptitude", (Object)true);
                }
                TndQuoteUtil.copyDynamicObjectValue((DynamicObject)context.getBillObj(), (DynamicObject)scoreTaskObj);
            }
            context.getScoreTaskObjs().add(scoreTaskObj);
            context.getAllIndexObjs().addAll(context.getIndexObjs());
            context.setIndexObjs(new ArrayList<DynamicObject>());
        }
    }
}

