/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;
import kd.scm.src.common.score.push.SrcScoreTaskAutoScore;
import kd.scm.src.common.score.push.SrcScoreTaskCreateIndexEntry;
import kd.scm.src.common.score.push.SrcScoreTaskCreateIndexEntryObj;
import kd.scm.src.common.score.push.SrcScoreTaskCreateSchemeIndex;
import kd.scm.src.common.score.push.SrcScoreTaskCreateScorerSubEntry;
import kd.scm.src.common.score.push.SrcScoreTaskCreateTaskBill;
import kd.scm.src.common.score.push.SrcScoreTaskCreateTaskBillObj;
import kd.scm.src.common.score.push.SrcScoreTaskCreateTecSumObj;
import kd.scm.src.common.score.push.SrcScoreTaskGetConfigParam;
import kd.scm.src.common.score.push.SrcScoreTaskInitContext;
import kd.scm.src.common.score.push.SrcScoreTaskPushHandle;
import kd.scm.src.common.score.push.SrcScoreTaskSaveResult;
import kd.scm.src.common.score.push.SrcScoreTaskUpdateStatus;

public class SrcScoreTaskFacade {
    public static void initContext(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstances(SrcScoreTaskInitContext.class.getSimpleName(), SrcScoreTaskInitContext.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void pushScoreTask(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskPushHandle.class.getSimpleName(), SrcScoreTaskPushHandle.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void saveScoreTask(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskSaveResult.class.getSimpleName(), SrcScoreTaskSaveResult.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void autoScoreHandle(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskAutoScore.class.getSimpleName(), SrcScoreTaskAutoScore.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void updateScorerTaskStatus(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskUpdateStatus.class.getSimpleName(), SrcScoreTaskUpdateStatus.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void getConfigParam(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskGetConfigParam.class.getSimpleName(), SrcScoreTaskGetConfigParam.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createScoreTaskBill(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateTaskBill.class.getSimpleName(), SrcScoreTaskCreateTaskBill.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createBizSchemeIndexs(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateSchemeIndex.class.getSimpleName(), SrcScoreTaskCreateSchemeIndex.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createScoreTaskBillObj(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateTaskBillObj.class.getSimpleName(), SrcScoreTaskCreateTaskBillObj.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createTecSumObj(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateTecSumObj.class.getSimpleName(), SrcScoreTaskCreateTecSumObj.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createIndexEntry(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateIndexEntry.class.getSimpleName(), SrcScoreTaskCreateIndexEntry.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createIndexEntryObj(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateIndexEntryObj.class.getSimpleName(), SrcScoreTaskCreateIndexEntryObj.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void createScorerSubEntry(SrcScoreTaskContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcScoreTaskCreateScorerSubEntry.class.getSimpleName(), SrcScoreTaskCreateScorerSubEntry.class.getName());
        for (ISrcScoreTaskPush handler : handlers) {
            handler.process(context);
        }
    }

    public static void getHasPushScoreTaskSet(SrcScoreTaskContext context) {
        QFilter qfilters = new QFilter("project", "=", (Object)context.getProjectId());
        qfilters.and("bizstatus", "!=", (Object)"E");
        String selectFields = "project,package,purlist,suppliertype,supplier,indextype,srcentryid";
        String entityName = context.isExpertEvaluate() ? "src_evaluatetask" : "src_scoretask";
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (null != taskObjs && taskObjs.length > 0) {
            HashSet<String> scoreTaskSet = new HashSet<String>(taskObjs.length);
            for (DynamicObject taskObj : taskObjs) {
                scoreTaskSet.add(SrcScoreTaskFacade.getScoreTaskKey(taskObj));
            }
            context.setScoreTaskSet(scoreTaskSet);
        }
    }

    public static String getScoreTaskKey(DynamicObject taskObj) {
        StringBuilder sb = new StringBuilder();
        sb.append(taskObj.getLong("project.id")).append('_');
        sb.append(taskObj.getLong("package.id")).append('_');
        sb.append(taskObj.getLong("purlist.id")).append('_');
        sb.append(taskObj.getLong("supplier.id")).append('_');
        sb.append(taskObj.getLong("indextype.id"));
        return sb.toString();
    }

    public static String getScoreTaskKey(SrcScoreTaskContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getProjectId()).append('_');
        if (!"2".equals(context.getManageType())) {
            sb.append(context.getTenderSupplier().getLong("package.id")).append('_');
        } else {
            sb.append(context.getPackageId()).append('_');
        }
        sb.append(context.getPurlistId()).append('_');
        sb.append(context.getTenderSupplier().getLong("supplier.id")).append('_');
        sb.append(context.getIndextypeId()).append('_');
        sb.append(context.getConfigObj().getPkValue());
        return sb.toString();
    }

    public static boolean isExistsUnPushSupplier(DynamicObject billObj) {
        if (!PdsCommonUtils.isSaveStatus((DynamicObject)billObj)) {
            return false;
        }
        long billId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        QFilter qfilters = new QFilter("billid", "=", (Object)billId);
        qfilters.and("isbidpush", "=", (Object)"0");
        qfilters.and("istender", "=", (Object)"1");
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
        return QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilters.toArray());
    }

    public static void getBaseTypeMap(SrcScoreTaskContext context) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_indexclass", (String)"id,basetype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        Map<Long, DynamicObject> baseTypeMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        context.setBaseTypeMap(baseTypeMap);
    }
}

