/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;
import kd.scm.src.common.score.push.SrcScoreTaskFacade;
import kd.scm.src.common.util.SrcBidAssessUtils;

public class SrcScoreTaskInitContext
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        this.initContext(context);
    }

    protected void initContext(SrcScoreTaskContext context) {
        this.initConfigCompKey(context);
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        context.setProjectId(projectId);
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("srctype"));
        boolean isOpenBySupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isopenbysupplier", (Object)Boolean.FALSE, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj())));
        context.setOpenBySupplier(isOpenBySupplier);
        if (context.isExpertEvaluate()) {
            context.setSelectPackageIds(PdsCommonUtils.buildSet((Long[])new Long[]{0L}));
        } else {
            Set<Long> selectPackageIds = SrcBidOpenFacade.getSelectPackageIds(projectId, context.getView() == null ? "src_bidassess" : context.getView().getEntityId());
            context.setSelectPackageIds(selectPackageIds);
        }
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        if (!context.isOpenBySupplier() && !context.isExpertEvaluate()) {
            if (context.isAptitudeAudit()) {
                if (!"publish".equals(context.getOperation())) {
                    qFilter.and("package.isaptopen", "=", (Object)"1");
                }
            } else if (context.isAptitudeAudit2()) {
                qFilter.and("package.istecopen", "=", (Object)"1");
            } else if ("2".equals(context.getBillObj().getString("opentype"))) {
                qFilter.and("package.istecopen", "=", (Object)"1");
                if ("src_bidassess".equals(context.getBillObj().getDataEntityType().getName())) {
                    qFilter.and("indextype.basetype", "!=", (Object)"2");
                } else if ("src_compare".equals(context.getBillObj().getDataEntityType().getName())) {
                    qFilter.and("indextype.basetype", "=", (Object)"2");
                }
            } else if (SrcBidAssessUtils.isParallelOpenTec(context.getBillObj())) {
                qFilter.and("indextype.basetype", "!=", (Object)"2");
            } else if (SrcBidAssessUtils.isParallelOpenBiz(context.getBillObj())) {
                qFilter.and("indextype.basetype", "=", (Object)"2");
            }
        }
        if (null == context.getSelectedRowDatas() || context.getSelectedRowDatas().size() == 0) {
            // empty if block
        }
        context.setqFilter(qFilter);
        String selectFields = DynamicObjectUtil.getSelectfields((String)context.getConfigCompKeyF7(), (boolean)false);
        DynamicObject[] configObjs = BusinessDataServiceHelper.load((String)context.getConfigCompKeyF7(), (String)selectFields, (QFilter[])context.getqFilter().toArray());
        if (configObjs == null || configObjs.length == 0) {
            context.setMessage(ResManager.loadKDString((String)"\u8bc4\u6807\u8bbe\u7f6e\u4e2d\u6ca1\u6709\u672a\u4e0b\u8fbe\u7684\u8bb0\u5f55,\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u3002", (String)"SrcScoreTaskInitContext_0", (String)"scm-src-common", (Object[])new Object[0]));
            context.setSucced(false);
            return;
        }
        context.setConfigObjs(configObjs);
        if (context.isExpertEvaluate()) {
            context.setScoreType(context.getBillObj().getString("scoretype"));
        } else if (context.isAptitudeAudit() || context.isAptitudeAudit2()) {
            context.setScoreType(context.getBillObj().getString("aptitudetype"));
        } else {
            DynamicObject configObj = QueryServiceHelper.queryOne((String)context.getConfigCompKey(), (String)"scoretype,isbizscore,isbyproject", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)configObjs[0].getLong("billid"))});
            if (configObj != null) {
                context.setScoreType(configObj.getString("scoretype"));
                context.setBizScore(configObj.getBoolean("isbizscore"));
                context.setByProject(configObj.getBoolean("isbyproject"));
            }
        }
        String manageType = context.getBillObj().getString("managetype");
        context.setManageType(manageType);
        SrcScoreTaskFacade.getBaseTypeMap(context);
        boolean isPushTecByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushTecScoreTaskByPurlist", (Object)false, (long)context.getProjectId()));
        context.setPushTecByPurlist(isPushTecByPurlist);
        boolean isPushBizByPurlist = false;
        if (context.isBizScore()) {
            isPushBizByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushBizScoreTaskByPurlist", (Object)false, (long)context.getProjectId()));
        }
        context.setPushBizByPurlist(isPushBizByPurlist);
        if (isPushBizByPurlist || isPushTecByPurlist) {
            this.getPurlistIdSet(context);
        } else {
            boolean isCreateBizIndex = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isCreateBizIndexByQuoteBill", (Object)false, (long)context.getProjectId()));
            context.setCreateBizIndex(isCreateBizIndex);
        }
        SrcScoreTaskFacade.getHasPushScoreTaskSet(context);
        this.getScoreTaskSet(context);
    }

    public void initConfigCompKey(SrcScoreTaskContext context) {
        context.setConfigCompKey("src_bidopen_config");
        context.setConfigCompKeyF7("src_bidopenconfig");
        context.setResultCompKeyF7("src_bidassess_tec");
        String entityName = context.getBillObj().getDataEntityType().getName();
        if ("pushaptitude".equals(context.getOperation()) || "publish".equals(context.getOperation())) {
            if ("src_aptitudeaudit".equals(entityName)) {
                context.setAptitudeAudit(true);
                context.setConfigCompKey("src_aptitudeconfig");
                context.setConfigCompKeyF7("src_aptitudeconfigf7");
                context.setResultCompKey("src_aptituderesult");
                context.setResultCompKeyF7("src_aptituderesultf7");
            } else if ("src_aptitudeaudit2".equals(entityName)) {
                context.setAptitudeAudit2(true);
                context.setConfigCompKey("src_aptitudeconfig2");
                context.setConfigCompKeyF7("src_aptitudeconfig2f7");
                context.setResultCompKey("src_aptituderesult2");
                context.setResultCompKeyF7("src_aptituderesult2f7");
            }
        } else if ("pushevaluate".equals(context.getOperation())) {
            context.setExpertEvaluate(true);
            context.setConfigCompKey("src_evaluateconfig");
            context.setConfigCompKeyF7("src_evaluateconfigf7");
            context.setResultCompKey("src_evaluateresult");
            context.setResultCompKeyF7("src_evaluateresultf7");
        }
    }

    public void getPurlistIdSet(SrcScoreTaskContext context) {
        QFilter qFilter = new QFilter("project.id", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            qFilter.and("package.id", "=", (Object)context.getPackageId());
        }
        qFilter.and("supplier", ">", (Object)0);
        qFilter.and(new QFilter("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue()).or("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue()));
        qFilter.and("isdiscarded", "=", (Object)"0");
        qFilter.and("isbizitem", "=", (Object)"0");
        qFilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.TERMINATED.getValue());
        qFilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.INVALID.getValue());
        qFilter.and("billtype", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{"2", "4"}));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"supplier.id,package.id,id", (QFilter[])qFilter.toArray());
        if (rows.size() > 0) {
            context.setPurlistIdSet(rows.stream().map(e -> e.getString("supplier.id") + '_' + e.getString("package.id") + '_' + e.getString("id")).collect(Collectors.toSet()));
        }
    }

    public void getScoreTaskSet(SrcScoreTaskContext context) {
        QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
        qFilter.and("bizstatus", "!=", (Object)"E");
        String selectFields = "project.id,package.id,purlist.id,supplier.id,indextype.id,srcentryid";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_scoretask", (String)selectFields, (QFilter[])qFilter.toArray());
        if (rows.size() > 0) {
            context.setScoreTaskSet(rows.stream().map(e -> e.getString("project.id") + '_' + e.getString("package.id") + '_' + e.getString("purlist.id") + '_' + e.getString("supplier.id") + '_' + e.getString("indextype.id") + '_' + e.getString("srcentryid")).collect(Collectors.toSet()));
        }
    }
}

