/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;
import kd.scm.src.common.score.push.SrcScoreTaskFacade;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcScoreTaskPushHandle
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        this.pushScoreTask(context);
    }

    protected void pushScoreTask(SrcScoreTaskContext context) {
        StringBuilder logInfo = new StringBuilder();
        boolean isPushScore = false;
        Set<Object> validPackageIds = new HashSet();
        boolean isNeedPackageControl = this.isNeedPackageControl(context);
        if (isNeedPackageControl) {
            validPackageIds = SrcPurListUtil.getValidPackageIds(context.getProjectId());
            logInfo.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u6e05\u5355\u4e2d\u6709\u6548\u6807\u6bb5\uff1a", (String)"SrcScoreTaskPushHandle_1", (String)"scm-src-common", (Object[])new Object[0])).append(validPackageIds).append("\n");
        }
        logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u6240\u6709\u6807\u6bb5\uff1a", (String)"SrcScoreTaskPushHandle_2", (String)"scm-src-common", (Object[])new Object[0])).append(context.getSelectPackageIds()).append("\n");
        Iterator<Long> iterator = context.getSelectPackageIds().iterator();
        while (iterator.hasNext()) {
            long packageId;
            long currentPackageId = packageId = iterator.next().longValue();
            context.setPackageId(packageId);
            logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5904\u7406\u7684\u6807\u6bb5\uff1a", (String)"SrcScoreTaskPushHandle_3", (String)"scm-src-common", (Object[])new Object[0])).append(packageId).append("\u3002");
            for (DynamicObject configObj : context.getConfigObjs()) {
                String openType;
                long cfgPackageId = SrmCommonUtil.getPkValue((DynamicObject)configObj.getDynamicObject("package"));
                logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u6807\u8bbe\u7f6e\u7684\u6807\u6bb5\uff1a", (String)"SrcScoreTaskPushHandle_4", (String)"scm-src-common", (Object[])new Object[0])).append(cfgPackageId).append("\u3002");
                if (isNeedPackageControl && cfgPackageId > 0L && !validPackageIds.contains(cfgPackageId)) {
                    logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u6807\u8bbe\u7f6e\u7684\u6807\u6bb5\u4e0d\u662f\u6709\u6548\u6807\u6bb5\uff0c\u4e0d\u9700\u8981\u4e0b\u8fbe\u3002", (String)"SrcScoreTaskPushHandle_5", (String)"scm-src-common", (Object[])new Object[0]));
                    continue;
                }
                if (cfgPackageId > 0L && cfgPackageId != currentPackageId) {
                    logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u6807\u8bbe\u7f6e\u7684\u6807\u6bb5\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u4e0e\u5f53\u524d\u5f85\u5904\u7406\u7684\u6807\u6bb5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u9700\u8981\u4e0b\u8fbe\u3002", (String)"SrcScoreTaskPushHandle_6", (String)"scm-src-common", (Object[])new Object[0]));
                    continue;
                }
                context.setConfigObj(configObj);
                context.setPackageSucced(true);
                SrcScoreTaskFacade.getConfigParam(context);
                if (!context.isPackageSucced()) {
                    logInfo.append(context.getMessage());
                    logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5904\u7406\u7684\u6807\u6bb5\u4e0d\u7b26\u5408\u4e0b\u8fbe\u6761\u4ef6\uff0c\u4e0d\u9700\u8981\u4e0b\u8fbe\u3002", (String)"SrcScoreTaskPushHandle_7", (String)"scm-src-common", (Object[])new Object[0]));
                    continue;
                }
                if (null == context.getTenderSuppliers() || context.getTenderSuppliers().length == 0) {
                    logInfo.append(ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u4e0b\u8fbe\u7684\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u4e0b\u8fbe\u3002", (String)"SrcScoreTaskPushHandle_8", (String)"scm-src-common", (Object[])new Object[0]));
                    continue;
                }
                SrcScoreTaskFacade.createScoreTaskBill(context);
                context.getAllScoreTaskObjs().addAll(context.getScoreTaskObjs());
                context.setScoreTaskObjs(new ArrayList<DynamicObject>());
                context.getAllTecSumObjs().addAll(context.getTecSumObjs());
                context.setTecSumObjs(new ArrayList<DynamicObject>());
                String string = openType = context.isAptitudeAudit() ? "isaptopen" : "istecopen";
                if (!context.isAptitudeAudit() && context.isOpenBySupplier()) {
                    if (SrcBidOpenFacade.isAllSupplierOpen(context.getProjectId(), cfgPackageId, openType)) {
                        configObj.set("entrystatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
                    }
                } else {
                    configObj.set("entrystatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
                }
                isPushScore = true;
            }
        }
        if (!isPushScore && !context.isSucced()) {
            context.setSucced(false);
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4e0b\u8fbe\u7684\u6807\u6bb5\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a\n", (String)"SrcScoreTaskPushHandle_9", (String)"scm-src-common", (Object[])new Object[0]));
            sb.append(context.getMessage()).append("\n");
            sb.append((CharSequence)logInfo);
            context.setMessage(sb.toString());
        }
    }

    private boolean isNeedPackageControl(SrcScoreTaskContext context) {
        String sourceclass;
        String entityName = context.getBillObj().getDataEntityType().getName();
        if ("src_expertevaluate".equals(entityName)) {
            return false;
        }
        if (null != context.getBillObj().getDynamicObjectType().getProperty("sourceclass") && "C011402".equals(sourceclass = context.getBillObj().getString("sourceclass.number"))) {
            return false;
        }
        if (!"src_aptitudeaudit".equals(entityName) && !"src_aptitudeaudit2".equals(entityName)) {
            return !SrcBidOpenUtils.isOpenTecBeforePublish(context.getBillObj());
        }
        String suppliertype = context.getBillObj().getString("suppliertype");
        return !"1".equals(suppliertype) && !"2".equals(suppliertype);
    }
}

