/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;

public class SrcScoreHandleAnalysis
implements ISrcScoreCommitScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.computeDetailAVG(context);
    }

    protected void computeDetailAVG(SrcScoreContext context) {
        Set<Long> projectIds = context.getProjectSet();
        Set<Long> scoreTaskSet = this.getFinishScoreTaskIds(context);
        String entityName = context.isEvaluate() ? "src_evaluateanalyse" : "src_scoreanalyse";
        for (long projectId : projectIds) {
            Map<String, Object> dataMap;
            QFilter filter = new QFilter("project", "=", (Object)projectId);
            filter.and("invalid", "!=", (Object)"2");
            filter.and("invalid", "!=", (Object)"3");
            filter.and("billid.bizstatus", "!=", (Object)"E");
            filter.and("billid.id", "in", scoreTaskSet);
            filter.and(SrcScoreHelper.getBaseTypeFilter(context, "billid.indextype.basetype"));
            String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filter.toArray());
            if (objs == null || (dataMap = this.getScoreanalyse(objs)) == null) continue;
            this.setScoreanalyseInvalid(dataMap);
        }
    }

    protected void setScoreanalyseInvalid(Map<String, Object> dataMap) {
        Map scoreSumMap = (Map)dataMap.get("scoreSumMap");
        Map scoreCountMap = (Map)dataMap.get("scoreCountMap");
        HashMap offSetMap = (HashMap)dataMap.get("offSetMap");
        HashMap scoreanalyseMap = (HashMap)dataMap.get("scoreanalyseMap");
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
        for (Map.Entry entry : scoreSumMap.entrySet()) {
            String key = (String)entry.getKey();
            BigDecimal valueSum = (BigDecimal)entry.getValue();
            BigDecimal count = BigDecimal.ZERO;
            BigDecimal offset = BigDecimal.ZERO;
            count = (BigDecimal)scoreCountMap.get(key);
            if (null == count || count.compareTo(BigDecimal.ZERO) == 0) continue;
            if (offSetMap.containsKey(key)) {
                offset = (BigDecimal)offSetMap.get(key);
            }
            if (count.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal average = valueSum.divide(count, 3, RoundingMode.HALF_UP);
            if (!scoreanalyseMap.containsKey(key)) continue;
            List list = (List)scoreanalyseMap.get(key);
            for (DynamicObject row : list) {
                row.set("average", (Object)average);
                BigDecimal value = row.getBigDecimal("value") == null ? BigDecimal.ZERO : row.getBigDecimal("value");
                BigDecimal offSetRate = BigDecimal.ZERO.compareTo(average) == 0 ? BigDecimal.ZERO : value.subtract(average).divide(average, 3, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).abs();
                boolean isChanged = false;
                if (row.getBoolean("entryid.isthreshold")) {
                    BigDecimal threshold = row.getBigDecimal("entryid.threshold");
                    if (average.compareTo(BigDecimal.ZERO) > 0 && average.compareTo(threshold) >= 0) {
                        row.set("isoverthreshold", (Object)Boolean.FALSE);
                        isChanged = true;
                    } else if (row.getBoolean("index.isfitted")) {
                        if (row.getBoolean("isfitted")) {
                            row.set("isoverthreshold", (Object)Boolean.FALSE);
                            isChanged = true;
                        } else {
                            row.set("isoverthreshold", (Object)Boolean.TRUE);
                            isChanged = true;
                        }
                    } else if (average.compareTo(threshold) >= 0) {
                        row.set("isoverthreshold", (Object)Boolean.FALSE);
                        isChanged = true;
                    } else {
                        row.set("isoverthreshold", (Object)Boolean.TRUE);
                        isChanged = true;
                    }
                } else {
                    row.set("isoverthreshold", (Object)Boolean.FALSE);
                    isChanged = true;
                }
                if (row.getString("invalid").equals("0") && offSetRate.compareTo(offset) > 0) {
                    row.set("invalid", (Object)"1");
                    isChanged = true;
                }
                if (!isChanged) continue;
                objList.add(row);
            }
        }
        if (objList != null && objList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[objList.size()]));
        }
    }

    protected Map<String, Object> getScoreanalyse(DynamicObject[] objs) {
        boolean flag;
        HashMap<String, BigDecimal> scoreSumMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> scoreCountMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> offSetMap = new HashMap<String, BigDecimal>(16);
        HashMap scoreanalyseMap = new HashMap(16);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        HashMap<String, DynamicObject> schemeMap = new HashMap<String, DynamicObject>(16);
        for (int i = 0; i < objs.length; ++i) {
            List<DynamicObject> scoreanalyseList;
            DynamicObject obj = objs[i];
            DynamicObject billid = obj.getDynamicObject("billid");
            DynamicObject scheme = billid.getDynamicObject("scheme");
            String schemeId = scheme.getString("id");
            BigDecimal offset = BigDecimal.ZERO;
            if (schemeMap.containsKey(schemeId)) {
                scheme = (DynamicObject)schemeMap.get(schemeId);
            } else {
                scheme = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (String)"src_scheme", (String)"offset,type.id");
                schemeMap.put(schemeId, scheme);
            }
            BigDecimal bigDecimal = offset = scheme.getBigDecimal("offset") == null ? BigDecimal.ZERO : scheme.getBigDecimal("offset");
            if (offset.compareTo(BigDecimal.ZERO) == 0) {
                offset = BigDecimal.valueOf(50L);
            }
            DynamicObject entryid = obj.getDynamicObject("entryid");
            BigDecimal value = obj.getBigDecimal("value");
            String key = entryid.getString("id");
            if (scoreanalyseMap.containsKey(key)) {
                scoreanalyseList = (List)scoreanalyseMap.get(key);
                scoreanalyseList.add(obj);
                scoreanalyseMap.put(key, scoreanalyseList);
            } else {
                scoreanalyseList = new ArrayList();
                scoreanalyseList.add(obj);
                scoreanalyseMap.put(key, scoreanalyseList);
            }
            scoreSumMap.merge(key, value, BigDecimal::add);
            scoreCountMap.merge(key, BigDecimal.ONE, BigDecimal::add);
            if (null != offSetMap.get(key)) continue;
            offSetMap.put(key, offset);
        }
        boolean bl = flag = scoreSumMap == null || scoreSumMap != null && scoreSumMap.size() == 0;
        if (flag) {
            return null;
        }
        dataMap.put("scoreanalyseMap", scoreanalyseMap);
        dataMap.put("scoreSumMap", scoreSumMap);
        dataMap.put("scoreCountMap", scoreCountMap);
        dataMap.put("offSetMap", offSetMap);
        return dataMap;
    }

    protected Set<Long> getFinishScoreTaskIds(SrcScoreContext context) {
        String entityName = context.isEvaluate() ? "src_evaluatetask" : "src_scoretask";
        Set<Long> projectIds = context.getProjectSet();
        QFilter qFilter = new QFilter("project.id", "in", projectIds);
        qFilter.and("bizstatus", "=", (Object)"D");
        qFilter.and(SrcScoreHelper.getBaseTypeFilter(context, "indextype.basetype"));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{qFilter});
        Set<Long> scoreTaskIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return scoreTaskIds;
    }
}

