/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;

public class SrcScoreHandleScorerTask
implements ISrcScoreCommitScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        if (SrcScoreHelper.isAptitudeScore1(context) || SrcScoreHelper.isAptitudeScore2(context) || context.isEvaluate()) {
            return;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_scorertask", (boolean)false);
        DynamicObject[] scorertaskObjs = BusinessDataServiceHelper.load((String)"src_scorertask", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", context.getProjectSet())});
        if (scorertaskObjs == null || scorertaskObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> scorertaskList = new ArrayList<DynamicObject>(1);
        for (DynamicObject scorertaskObj : scorertaskObjs) {
            this.handleScorerTaskStatus(scorertaskObj, scorertaskList);
            this.syntheticalCalculate(scorertaskObj);
        }
        PdsCommonUtils.saveDynamicObjects(scorertaskList);
    }

    protected void handleScorerTaskStatus(DynamicObject scorertaskObj, List<DynamicObject> scorertaskList) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)scorertaskObj);
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        qFilter.and("bizstatus", "=", (Object)SrmScoreStatusEnum.SCORED.getValue());
        qFilter.and("indextype.basetype", "!=", (Object)"4");
        qFilter.and("indextype.basetype", "!=", (Object)"7");
        qFilter.and("bizstatus", "!=", (Object)"E");
        if (QueryServiceHelper.exists((String)"src_scoretask", (QFilter[])qFilter.toArray())) {
            DynamicObject scorerTaskObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_scorertask");
            boolean isTaskChanged = false;
            if (StringUtils.isBlank((Object)scorerTaskObj.get("billstatus"))) {
                scorerTaskObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                isTaskChanged = true;
            }
            if (!scorerTaskObj.getString("scorestatus").equals(ProcessStatusEnums.PROCESSED.getValue())) {
                scorerTaskObj.set("scorestatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
                isTaskChanged = true;
            }
            if (isTaskChanged) {
                scorertaskList.add(scorerTaskObj);
            }
        }
    }

    protected void syntheticalCalculate(DynamicObject scorertaskObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)scorertaskObj);
        List<String> bizStatus = Arrays.asList("A", "B", "C");
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        qFilter.and("bizstatus", "in", bizStatus);
        qFilter.and("indextype.basetype", "!=", (Object)"4");
        qFilter.and("indextype.basetype", "!=", (Object)"7");
        qFilter.and("bizstatus", "!=", (Object)"E");
        if (!QueryServiceHelper.exists((String)"src_scoretask", (QFilter[])qFilter.toArray())) {
            SrcCalcHelper.syntheticalCalculate("src_compare", projectId);
        }
    }
}

