/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;
import kd.scm.src.common.score.result.SrcScoreHandleContext;

public class SrcScoreHandleVeto
implements ISrcScoreCommitScore {
    @Override
    public void process(SrcScoreContext context) {
        this.handleVeto(context.getHandleContext());
    }

    protected void handleVeto(SrcScoreHandleContext context) {
        DynamicObjectCollection indexObjs = context.getScoreTaskObj().getDynamicObjectCollection("entry");
        ArrayList<Long> classIds = new ArrayList<Long>();
        boolean isVeto = false;
        boolean isAllVeto = false;
        for (DynamicObject indexObj : indexObjs) {
            String veto;
            long typeId = SrmCommonUtil.getPkValue((DynamicObject)indexObj.getDynamicObject("index.indextype"));
            long classId = SrmCommonUtil.getPkValue((DynamicObject)indexObj.getDynamicObject("index.indexclass"));
            long indexId = SrmCommonUtil.getPkValue((DynamicObject)indexObj.getDynamicObject("index"));
            switch (veto = indexObj.getString("veto")) {
                case "1": {
                    classIds.add(typeId);
                    isVeto = true;
                    break;
                }
                case "2": {
                    classIds.add(classId);
                    isVeto = true;
                    break;
                }
                case "3": {
                    classIds.add(indexId);
                    isVeto = true;
                    break;
                }
                case "4": {
                    isVeto = true;
                    isAllVeto = true;
                    break;
                }
            }
        }
        if (isVeto) {
            BigDecimal sumScore = BigDecimal.ZERO;
            for (DynamicObject indexObj : indexObjs) {
                boolean isDeduct = indexObj.getBoolean("index.isdeduct");
                long typeId = SrmCommonUtil.getPkValue((DynamicObject)indexObj.getDynamicObject("index.indextype"));
                long classId = SrmCommonUtil.getPkValue((DynamicObject)indexObj.getDynamicObject("index.indexclass"));
                long indexId = SrmCommonUtil.getPkValue((DynamicObject)indexObj.getDynamicObject("index"));
                BigDecimal finalScore = indexObj.getBigDecimal("finalscore");
                if (classIds.contains(typeId) || classIds.contains(classId) || classIds.contains(indexId) || isAllVeto) {
                    indexObj.set("finalscore", null);
                    continue;
                }
                if (isDeduct) {
                    sumScore = sumScore.min(finalScore);
                    continue;
                }
                sumScore = sumScore.add(finalScore);
            }
            context.setSumScore(sumScore);
        }
    }
}

