/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.srcbotp;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.srcbotp.IProjectBotp;
import kd.scm.src.common.srcbotp.IPurlistBotp;
import kd.scm.src.common.srcbotp.ISrcProjectBotpExtHandler;
import kd.scm.src.common.srcbotp.SrcBotpContext;
import kd.scm.src.common.srcbotp.SrcProjectBotpGetPurlistTpl;
import kd.scm.src.common.srcbotp.SrcProjectBotpStand;
import kd.scm.src.common.srcbotp.SrcPurlistBotpStand;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcBotpUtils {
    protected static final String[] SET_VALUES = new String[]{"creator", "createtime", "billno", "billdate", "billstatus", "bizstatus", "tieredtype"};
    protected static final Set<String> EXCLUDED_SET = new HashSet<String>(Arrays.asList(SET_VALUES));

    public static SrcBotpContext getContextInstance() {
        return (SrcBotpContext)ExtPluginFactory.getInstance().getExtPluginInstance(SrcBotpContext.class.getSimpleName(), SrcBotpContext.class.getName());
    }

    public static void createProject(SrcBotpContext context) {
        IProjectBotp botpInstance = (IProjectBotp)ExtPluginFactory.getInstance().getExtPluginInstance(IProjectBotp.class.getSimpleName());
        if (null == botpInstance) {
            botpInstance = new SrcProjectBotpStand();
        }
        botpInstance.execute(context);
        if (context.isSucced()) {
            SrcBotpUtils.createPurlist(context);
        }
        SrcBotpUtils.buildeMessage(context, SrcBotpUtils.getBillNo(context));
        HashMap<String, String> resultMap = new HashMap<String, String>(3);
        if (context.isSucced()) {
            try {
                resultMap.put("sceneIds", JSONUtils.toString(SrcBotpUtils.getSceneMap(context.getTargetObjs())));
            }
            catch (IOException e) {
                BizLog.log((String)ResManager.loadKDString((String)"json\u89e3\u6790\u9519\u8bef\u3002", (String)"SrcBotpUtils_0", (String)"scm-src-common", (Object[])new Object[0]));
            }
            resultMap.put("title", ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f\uff0c\u5355\u53f7\u89c1\u8be6\u60c5\u3002", (String)"SrcBotpUtils_1", (String)"scm-src-common", (Object[])new Object[0]));
        } else {
            resultMap.put("title", ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u539f\u56e0\u89c1\u8be6\u60c5\u3002", (String)"SrcBotpUtils_2", (String)"scm-src-common", (Object[])new Object[0]));
        }
        resultMap.put("message", context.getMessage());
        resultMap.put("succed", String.valueOf(context.isSucced()));
        context.setResultMap(resultMap);
    }

    private static Map<String, String> getSceneMap(List<DynamicObject> targetObjs) {
        return targetObjs.stream().collect(Collectors.toMap(obj -> Optional.ofNullable(obj.getDynamicObject("scene")).map(DataEntityBase::getPkValue).map(Object::toString).orElse("0"), obj -> obj.getString("billno")));
    }

    public static void createPurlist(SrcBotpContext context) {
        List<DynamicObject> targetObjs;
        IPurlistBotp botpInstance = (IPurlistBotp)ExtPluginFactory.getInstance().getExtPluginInstance(IPurlistBotp.class.getSimpleName());
        if (null == botpInstance) {
            botpInstance = new SrcPurlistBotpStand();
        }
        if ((targetObjs = context.getTargetObjs()) == null || targetObjs.size() == 0) {
            SrcBotpUtils.buildeMessage(context, ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u63a8\u751f\u6210\u5bfb\u6e90\u9879\u76ee\uff0c\u65e0\u6cd5\u521b\u5efa\u5bf9\u5e94\u7684\u91c7\u8d2d\u6e05\u5355\u3002", (String)"SrcBotpUtils_3", (String)"scm-src-common", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject targetObj : targetObjs) {
            if (!targetObj.getBoolean("source.sceneitem")) continue;
            List<String> entityKeys = SrcBotpUtils.getEntityKeys(context, targetObj);
            for (String entityKey : entityKeys) {
                SrcBotpUtils.createPurlistComponent(context, targetObj, entityKey, botpInstance);
            }
        }
    }

    private static void createPurlistComponent(SrcBotpContext context, DynamicObject projectObj, String entityKey, IPurlistBotp botpInstance) {
        SrcBotpContext purlistContext = SrcBotpUtils.getContextInstance();
        purlistContext.setSourceBill(context.getPurlistSourceBill());
        purlistContext.setTargetBill(context.getPurlistTargetBill());
        purlistContext.setPentitykey(context.getPentitykey() == null ? context.getTargetBill() : context.getPentitykey());
        purlistContext.setEntitykeys(Collections.singletonList(entityKey));
        purlistContext.setBySceneItem(context.isBySceneItem());
        purlistContext.setSourceObjs(Collections.singletonList(projectObj));
        purlistContext.setEntryStatus(context.getEntryStatus());
        botpInstance.execute(purlistContext);
        SrcBotpUtils.buildeMessage(context, purlistContext.getMessage());
    }

    private static void commonPushArgs(SrcBotpContext context) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(context.getSourceBill());
        pushArgs.setTargetEntityNumber(context.getTargetBill());
        pushArgs.setBuildConvReport(true);
        SrcBotpUtils.getConvertRule(context);
        pushArgs.setRuleId(context.getRules() == null ? null : context.getRules().get(0).getId());
        context.setPushArgs(pushArgs);
    }

    public static void projectPushArgs(SrcBotpContext context) {
        SrcBotpUtils.commonPushArgs(context);
        PushArgs pushArgs = context.getPushArgs();
        List<DynamicObject> sourceObjs = context.getSourceObjs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(sourceObjs.size());
        for (DynamicObject sourceObj : sourceObjs) {
            ListSelectedRow row = new ListSelectedRow((Object)1);
            row.setPrimaryKeyValue(sourceObj.getPkValue());
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        context.setPushArgs(pushArgs);
    }

    public static void purlistPushArgs(SrcBotpContext context) {
        QFilter qFilter;
        SrcBotpUtils.commonPushArgs(context);
        PushArgs pushArgs = context.getPushArgs();
        String projectName = context.getSourceObjs().get(0).getString("billno");
        DynamicObject soureObj = context.getSourceObjs().get(0).getDynamicObject("source");
        if (soureObj == null) {
            SrcBotpUtils.buildeMessage(context, String.format(ResManager.loadKDString((String)"%1$s\u7684\u9879\u76ee \u4e3a\u7a7a\uff0c\u8bf7\u5728BOTP\u914d\u7f6e\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"SrcBotpUtils_10", (String)"scm-src-common", (Object[])new Object[0]), projectName));
            return;
        }
        DynamicObject sceneObj = context.getSourceObjs().get(0).getDynamicObject("scene");
        if (sceneObj == null) {
            SrcBotpUtils.buildeMessage(context, String.format(ResManager.loadKDString((String)"%1$s\u7684\u5bfb\u6e90\u573a\u666f \u4e3a\u7a7a\uff0c\u8bf7\u5728BOTP\u914d\u7f6e\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"SrcBotpUtils_11", (String)"scm-src-common", (Object[])new Object[0]), projectName));
            return;
        }
        DynamicObjectCollection rows = null;
        if (context.isBySceneItem()) {
            long sceneId = SrmCommonUtil.getPkValue((DynamicObject)sceneObj);
            qFilter = new QFilter("entryid", "=", (Object)sceneId);
            rows = QueryServiceHelper.query((String)"src_decisionitem", (String)"fbasedataid id", (QFilter[])qFilter.toArray());
        } else {
            long sourceId = SrmCommonUtil.getPkValue((DynamicObject)soureObj);
            qFilter = new QFilter("source", "=", (Object)sourceId);
            rows = QueryServiceHelper.query((String)"src_demandf7two", (String)"id", (QFilter[])qFilter.toArray());
        }
        if (rows == null || rows.size() == 0) {
            SrcBotpUtils.buildeMessage(context, String.format(ResManager.loadKDString((String)"%1$s\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6807\u7684\u4fe1\u606f\uff0c\u65e0\u6cd5\u521b\u5efa\u91c7\u8d2d\u6e05\u5355\u3002", (String)"SrcBotpUtils_12", (String)"scm-src-common", (Object[])new Object[0]), projectName));
            return;
        }
        Set entryIdSet = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        rows = QueryServiceHelper.query((String)context.getSourceBill(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", entryIdSet)});
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(rows.size());
        for (DynamicObject row : rows) {
            ListSelectedRow selectedRow = new ListSelectedRow((Object)1);
            selectedRow.setPrimaryKeyValue((Object)row.getLong("id"));
            selectedRowList.add(selectedRow);
        }
        pushArgs.setSelectedRows(selectedRowList);
        context.setPushArgs(pushArgs);
    }

    public static void doConvertService(SrcBotpContext context) {
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)context.getPushArgs());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)context.getTargetBill());
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        if (result.isSuccess()) {
            List targetObjs = result.loadTargetDataObjects(refDataProvider, mainType);
            String sourceType = context.getSourceType();
            if (StringUtils.isNotEmpty((String)sourceType)) {
                targetObjs = targetObjs.stream().filter(obj -> {
                    DynamicObject sourceObj = obj.getDynamicObject("sourcetype");
                    return Objects.nonNull(sourceObj) && Objects.equals(sourceObj.getString("number"), sourceType);
                }).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)targetObjs)) {
                SrcBotpUtils.buildeMessage(context, ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a \u672c\u5bfb\u6e90\u65b9\u5f0f\u5df2\u751f\u6210\u76f8\u5e94\u7684\u9879\u76ee\u542f\u52a8\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002 ", (String)"SrcBotpUtils_15", (String)"scm-src-common", (Object[])new Object[0]));
                return;
            }
            context.setTargetObjs(targetObjs);
        } else {
            context.setSucced(false);
            if (CollectionUtils.isEmpty((Collection)result.getBillReports())) {
                SrcBotpUtils.buildeMessage(context, result.getMessage());
            } else {
                SrcBotpUtils.buildeMessage(context, ((SourceBillReport)result.getBillReports().get(0)).getFailMessage());
            }
        }
    }

    public static void updateProject(SrcBotpContext context) {
        List<DynamicObject> targetObjs = context.getTargetObjs();
        if (null == targetObjs || targetObjs.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> projectObjs = new ArrayList<DynamicObject>(targetObjs.size());
        List entryKeys = PdsMetadataUtil.getEntryKey((String)context.getTargetBill());
        for (DynamicObject targetObj : targetObjs) {
            long projectId = SrcProjectUtil.createNewBillId(context.getTargetBill(), targetObj.getString("sourcetype.number"), targetObj.getLong("srctype.id"), false);
            DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)context.getTargetBill());
            List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)targetObj);
            for (String property : properties) {
                if (EXCLUDED_SET.contains(property)) continue;
                projectObj.set(property, targetObj.get(property));
            }
            SrcBotpUtils.setEntryProperties(entryKeys, targetObj, projectObj);
            SrcBotpUtils.setPriceConfirmSupplier(projectObj);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectObj});
            ExtPluginContext extContext = new ExtPluginContext();
            extContext.setProjectObj(projectObj);
            ExtPluginFactory.getInstance();
            ExtPluginFactory.executeExtplugin((String)ISrcProjectBotpExtHandler.class.getSimpleName(), (ExtPluginContext)extContext, (boolean)true);
            projectObjs.add(projectObj);
        }
        context.setTargetObjs(projectObjs);
    }

    private static void setEntryProperties(List<String> entryKeys, DynamicObject targetObj, DynamicObject projectObj) {
        for (String entryKey : entryKeys) {
            DynamicObjectCollection cols = targetObj.getDynamicObjectCollection(entryKey);
            if (CollectionUtils.isEmpty((Collection)cols)) continue;
            projectObj.set(entryKey, (Object)cols);
        }
    }

    public static void updatePurlist(SrcBotpContext context) {
        List<DynamicObject> targetObjs = context.getTargetObjs();
        if (null == targetObjs || targetObjs.size() == 0) {
            return;
        }
        DynamicObject projectObj = null == context.getSourceObjs() || context.getSourceObjs().size() == 0 ? null : context.getSourceObjs().get(0);
        DynamicObject supplierObj = SrcBotpUtils.getSceneSupplierObj(projectObj, PdsCommonUtils.buildSet((Long[])new Long[]{SourceTypeEnums.DIRECT_PUR.getId(), SourceTypeEnums.NET_PUR.getId(), SourceTypeEnums.INPUT_PRICE.getId(), SourceTypeEnums.INTERNAL_SALE.getId()}));
        ArrayList<DynamicObject> purlistObjs = new ArrayList<DynamicObject>(targetObjs.size());
        long parentId = SrmCommonUtil.getPkValue((DynamicObject)context.getSourceObjs().get(0));
        for (DynamicObject targetObj : targetObjs) {
            targetObj.set("parentid", (Object)parentId);
            targetObj.set("pentitykey", (Object)context.getPentitykey());
            targetObj.set("entitykey", (Object)context.getEntitykeys().get(0));
            DynamicObjectCollection rows = targetObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                DynamicObject materialObj = row.getDynamicObject("bidmaterial");
                if (Objects.nonNull(materialObj)) {
                    row.set("purlistentry_fj", (Object)PdsCommonUtils.cloneAttachment((DynamicObject)materialObj, (String)"purlistentry_fj"));
                }
                row.set("entrystatus", (Object)context.getEntryStatus());
                PdsCommonUtils.setPrimaryKey((DynamicObject)row);
                row.set("purlist", row.getPkValue());
                row.set("project", (Object)parentId);
                SrcBotpUtils.setPurlistSupplier(context.getPentitykey(), supplierObj, row);
            }
            purlistObjs.add(targetObj);
        }
        context.setTargetObjs(purlistObjs);
    }

    public static void saveTargetObjs(SrcBotpContext context) {
        List<DynamicObject> targetObjs = context.getTargetObjs();
        if (targetObjs != null && targetObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])targetObjs.toArray(new DynamicObject[targetObjs.size()]));
            context.setSucced(true);
        }
    }

    public static void getConvertRule(SrcBotpContext context) {
        if (context.getRules() == null || context.getRules().size() == 0) {
            List rules = ConvertMetaServiceHelper.loadRules((String)context.getSourceBill(), (String)context.getTargetBill());
            if (rules != null && rules.size() > 0) {
                context.setRules(rules);
            } else {
                SrcBotpUtils.buildeMessage(context, ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6eBOTP\u8f6c\u6362\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e\u3002", (String)"SrcBotpUtils_8", (String)"scm-src-common", (Object[])new Object[0]));
            }
        }
    }

    private static String getBillNo(SrcBotpContext context) {
        if (CollectionUtils.isEmpty(context.getTargetObjs())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject projectObj : context.getTargetObjs()) {
            sb.append(projectObj.get("billno"));
            sb.append(',');
        }
        int index = sb.toString().lastIndexOf(44);
        String billNo = sb.substring(0, index);
        if (billNo.length() <= 0) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"SrcBotpUtils_9", (String)"scm-src-common", (Object[])new Object[0]);
        }
        return billNo;
    }

    private static void buildeMessage(SrcBotpContext context, String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        if (context.getMessage() == null || context.getMessage().trim().length() == 0) {
            context.setMessage(message);
        } else {
            context.setMessage(context.getMessage() + ";\n" + message);
        }
    }

    private static List<String> getEntityKeys(SrcBotpContext context, DynamicObject projectObj) {
        List<String> entityKeys;
        if (context.isBySceneItem()) {
            String sceneId = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("scene")));
            entityKeys = context.getSceneEntitykeys() == null ? null : context.getSceneEntitykeys().get(sceneId);
        } else {
            entityKeys = context.getEntitykeys();
        }
        if (entityKeys == null) {
            entityKeys = new ArrayList<String>(1);
        }
        if (entityKeys.size() == 0) {
            entityKeys.add("src_purlist_stand");
        }
        return entityKeys;
    }

    public static Map<String, List<String>> getPurListTpl4Scene(List<DynamicObject> sourceObjs) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(16);
        for (DynamicObject sourceObj : sourceObjs) {
            DynamicObject demandObj = BusinessDataServiceHelper.loadSingle((Object)sourceObj.getPkValue(), (String)sourceObj.getDataEntityType().getName());
            DynamicObjectCollection sceneEntries = demandObj.getDynamicObjectCollection("entry");
            for (DynamicObject sceneEntry : sceneEntries) {
                DynamicObjectCollection purListTpl = sceneEntry.getDynamicObjectCollection("purlisttpl");
                if (CollectionUtils.isEmpty((Collection)purListTpl)) continue;
                List purListTpls = purListTpl.stream().map(row -> row.getString("fbasedataid.bizobject.number")).distinct().collect(Collectors.toList());
                params.put(sceneEntry.getPkValue().toString(), purListTpls);
            }
        }
        return params;
    }

    public static DynamicObject getSceneSupplierObj(DynamicObject projectObj, Set<Long> sourceTypeSet) {
        if (null == projectObj) {
            return null;
        }
        DynamicObject sceneObj = projectObj.getDynamicObject("scene");
        if (null == sceneObj) {
            return null;
        }
        if (!sourceTypeSet.contains(sceneObj.getLong("purtype.id"))) {
            return null;
        }
        DynamicObjectCollection supplierRows = sceneObj.getDynamicObjectCollection("suppliers");
        if (supplierRows.size() > 0) {
            return ((DynamicObject)supplierRows.get(0)).getDynamicObject("fbasedataid");
        }
        return null;
    }

    public static long getDefaultPurlistTplId(DynamicObject sourceTypeObj) {
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(sourceTypeObj);
        SrcProjectBotpGetPurlistTpl handler = new SrcProjectBotpGetPurlistTpl();
        handler.process(context);
        return context.getBillId();
    }

    public static String getDefaultPurlistTplNumber(DynamicObject sourceTypeObj) {
        long tplId = SrcBotpUtils.getDefaultPurlistTplId(sourceTypeObj);
        DynamicObject compRegObj = QueryServiceHelper.queryOne((String)"pds_compreg", (String)"bizobject.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tplId)});
        if (null != compRegObj) {
            return compRegObj.getString("bizobject.number");
        }
        return "src_purlist_stand";
    }

    public static DynamicObject getApplyOrDemandSupplierObj(DynamicObject billObj, Set<Long> sourceTypeSet) {
        long sourceTypeId = billObj.getLong("sourcetype2.id");
        if (!sourceTypeSet.contains(sourceTypeId)) {
            return null;
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entrysupplier");
        if (rows.size() == 0) {
            return null;
        }
        return ((DynamicObject)rows.get(0)).getDynamicObject("supplier");
    }

    public static boolean setPriceConfirmSupplier(DynamicObject projectObj) {
        Set sourceTypeSet = PdsCommonUtils.buildSet((Long[])new Long[]{SourceTypeEnums.CONFIRM_PRICE.getId()});
        DynamicObject supplierObj = SrcBotpUtils.getSceneSupplierObj(projectObj, sourceTypeSet);
        if (null != supplierObj) {
            projectObj.set("suppliertype", (Object)"bd_supplier");
            projectObj.set("supplier_id", supplierObj.get("id"));
            return true;
        }
        return false;
    }

    public static boolean setPriceConfirmSupplier(DynamicObject billObj, DynamicObject projectObj) {
        Set sourceTypeSet = PdsCommonUtils.buildSet((Long[])new Long[]{SourceTypeEnums.CONFIRM_PRICE.getId()});
        DynamicObject supplierObj = SrcBotpUtils.getApplyOrDemandSupplierObj(billObj, sourceTypeSet);
        if (null != supplierObj) {
            projectObj.set("suppliertype", (Object)"bd_supplier");
            projectObj.set("supplier_id", supplierObj.get("id"));
            return true;
        }
        return false;
    }

    public static void setPurlistSupplier(String parentEntitykey, DynamicObject supplierObj, DynamicObject row) {
        if (null != supplierObj) {
            row.set("suppliertype", (Object)"bd_supplier");
            row.set("supplier_id", supplierObj.get("id"));
            row.set("suppliername", supplierObj.get("name"));
        }
        if (Objects.equals(parentEntitykey, "src_directpur")) {
            row.set("result", (Object)ResultStatusEnums.WIN.getValue());
            row.set("orderratio", (Object)BigDecimal.TEN.multiply(BigDecimal.TEN));
        }
    }
}

