/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.srcbotp;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcProjectBotpSupplier
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.copyVerify(context);
        if (!context.isVerifyOk()) {
            return;
        }
        this.getSourceSupliers(context);
        if (!context.isSucced()) {
            return;
        }
        this.copyDemandSuppliers(context);
    }

    public void copyVerify(ExtPluginContext context) {
        IFormView parentView = context.getView().getParentView();
        if (parentView == null) {
            context.setVerifyOk(false);
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity();
        if (!BillStatusEnum.SAVE.getVal().equals(projectObj.getString("billstatus"))) {
            context.setVerifyOk(false);
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        if (model.getEntryRowCount("entrysupplier") > 0) {
            context.setVerifyOk(false);
            return;
        }
        if (null == projectObj.get("srcapply")) {
            DynamicObject sourceObj = projectObj.getDynamicObject("source");
            if (null == sourceObj) {
                context.setVerifyOk(false);
                return;
            }
            DynamicObject sceneObj = projectObj.getDynamicObject("scene");
            if (null == sceneObj) {
                // empty if block
            }
        }
        context.setProjectObj(projectObj);
    }

    public void getSourceSupliers(ExtPluginContext context) {
        DynamicObjectCollection rows = null;
        if (null != context.getProjectObj().get("srcapply")) {
            long applyId = context.getProjectObj().getLong("srcapply.id");
            if (QueryServiceHelper.exists((String)"src_apply", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)applyId)})) {
                DynamicObject applyObj = BusinessDataServiceHelper.loadSingle((Object)applyId, (String)"src_apply");
                rows = applyObj.getDynamicObjectCollection("entrysupplier");
            }
        } else {
            long sourceId = context.getProjectObj().getLong("source.id");
            if (QueryServiceHelper.exists((String)"src_demand", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceId)})) {
                DynamicObject demandObj = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"src_demand");
                rows = demandObj.getDynamicObjectCollection("entrysupplier");
            }
            if (null == rows || rows.size() == 0) {
                long sceneId = context.getProjectObj().getLong("scene.id");
                if (QueryServiceHelper.exists((String)"src_demandscene", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sceneId)})) {
                    DynamicObject sceneObj = BusinessDataServiceHelper.loadSingle((Object)sceneId, (String)"src_demandscene");
                    rows = sceneObj.getDynamicObjectCollection("suppliers");
                    context.setEntryEntityId("entry");
                }
                if (null == rows || rows.size() == 0) {
                    context.setSucced(false);
                    return;
                }
            }
        }
        if (null == rows || rows.size() == 0) {
            context.setHandleOk(false);
        } else {
            context.setHandleOk(true);
        }
        context.setSourceObjs((List)rows);
    }

    public void copyDemandSuppliers(ExtPluginContext context) {
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        List properties = null;
        Set excludedFields = PdsCommonUtils.buildSet((String[])new String[]{"fid", "supplier"});
        model.beginInit();
        DynamicObjectCollection newRows = context.getView().getModel().getEntryEntity("entrysupplier");
        int seq = 1;
        for (DynamicObject row : context.getSourceObjs()) {
            DynamicObject newRow = newRows.addNew();
            newRow.set("suppliertype", (Object)"bd_supplier");
            if (context.isHandleOk()) {
                if ("entry".equals(context.getEntryEntityId())) {
                    newRow.set("supplier", row.get("fbasedataid"));
                    this.setSupplierInfo(newRow, row.getLong("fbasedataid.id"));
                    continue;
                }
                newRow.set("supplier", row.get("supplier"));
                if (null == properties) {
                    properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)row);
                }
                PdsCommonUtils.copyDynamicObjectValue((DynamicObject)row, (DynamicObject)newRow, (List)properties, (Set)excludedFields, (int)seq++);
                continue;
            }
            newRow.set("supplier", row.get("fbasedataid"));
            this.setSupplierInfo(newRow, row.getLong("fbasedataid.id"));
        }
        model.endInit();
        context.getView().updateView("entrysupplier");
    }

    public void setSupplierInfo(DynamicObject newRow, long supplierId) {
        DynamicObject bdSupplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier");
        newRow.set("supname", (Object)bdSupplier.getString("name"));
        newRow.set("societycreditcode", (Object)bdSupplier.getString("societycreditcode"));
        HashMap supMap = PdsLinkManFacade.getSupplierLinkMan((DynamicObject)bdSupplier);
        newRow.set("linkman", supMap.get("linkman"));
        newRow.set("phone", supMap.get("phone"));
        newRow.set("duty", supMap.get("duty"));
        newRow.set("email", supMap.get("email"));
        newRow.set("address", supMap.get("address"));
    }
}

