/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;

public class SrcAppCache {
    private static IAppCache cache = AppCache.get((String)"src");

    public static void put(String key, Object value, IFormView view) {
        String pageKey = SrcAppCache.initPageKey(view);
        if (StringUtils.isNotEmpty((String)pageKey)) {
            cache.put(pageKey + key, value);
        }
    }

    public static <T> T get(String key, Class<T> paramClass, IFormView view) {
        String pageKey = SrcAppCache.initPageKey(view);
        if (StringUtils.isNotEmpty((String)pageKey)) {
            try {
                return (T)cache.get(pageKey + key, paramClass);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static String initPageKey(IFormView view) {
        String pageKey = "";
        if (Objects.nonNull(view)) {
            pageKey = view.getEntityId() + view.getPageId();
        }
        return pageKey;
    }

    public static String getCacheOpenedPageIdKey(IFormView view, String entityKey, Object pkVal) {
        IFormView mainView = view.getMainView();
        if (null == mainView) {
            return "";
        }
        String appId = view.getFormShowParameter().getAppId();
        appId = StringUtils.isNull((String)appId) ? "src" : appId;
        StringBuilder cacheKeySb = new StringBuilder();
        cacheKeySb.append(appId).append("_").append(mainView.getPageId()).append("_").append(entityKey).append("_").append(pkVal);
        return cacheKeySb.toString();
    }

    public static DynamicObject getOtherCompObjByCache(IFormView currCompView, String cachePageId, String compKey) {
        if (null == currCompView) {
            return null;
        }
        IFormView parentView = currCompView.getParentView();
        if (null == parentView) {
            return null;
        }
        if (null == cachePageId && null != compKey) {
            switch (compKey) {
                case "src_project_base": {
                    cachePageId = "baseinfopageid";
                    break;
                }
                case "src_project_rule": {
                    cachePageId = "winrulepageid";
                    break;
                }
                case "src_vie_rule": {
                    cachePageId = "vierulepageid";
                    break;
                }
            }
        }
        if (null == cachePageId) {
            return null;
        }
        String compPageId = SrcAppCache.get(cachePageId, String.class, parentView);
        if (StringUtils.isEmpty((String)compPageId)) {
            return null;
        }
        IFormView compView = parentView.getView(compPageId);
        if (Objects.isNull(compView) || null == compView.getModel()) {
            return null;
        }
        if (!compView.getModel().isDataLoaded()) {
            return null;
        }
        return compView.getModel().getDataEntity(true);
    }
}

