/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.change.SrcCreateBidChangeBill;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcBidChangeUtil {
    public static Object getBidChangeObjId(String chgEntityName, String keyField, Object keyValue) {
        String selectFields = "id";
        QFilter qfilters = new QFilter(keyField, "=", (Object)Long.parseLong(keyValue.toString()));
        qfilters.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilters.and("supplier", "=", (Object)0L);
        if ("src_batchdecision".equals(chgEntityName)) {
            qfilters.and("template.biznode.number", "=", (Object)PdsBizNodeEnums.BATCHDECISION.getValue());
        } else {
            qfilters.and("template.biznode.number", "!=", (Object)PdsBizNodeEnums.BATCHDECISION.getValue());
        }
        DynamicObject bidChange = QueryServiceHelper.queryOne((String)chgEntityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (null == bidChange) {
            return null;
        }
        return bidChange.get("id");
    }

    public static List<String> getValidatePlugin(DynamicObject obj) {
        ArrayList<String> validatePluginList = new ArrayList<String>();
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("validateentry");
        for (DynamicObject col : cols) {
            DynamicObject condition = col.getDynamicObject("condition");
            if (null == condition) continue;
            String plugin = condition.getString("plugin");
            validatePluginList.add(plugin);
        }
        return validatePluginList;
    }

    public static List<String> getHandlePlugin(DynamicObject obj) {
        ArrayList<String> handlePluginList = new ArrayList<String>();
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("handleentry");
        for (DynamicObject col : cols) {
            DynamicObject condition = col.getDynamicObject("handler");
            if (null == condition) continue;
            String plugin = condition.getString("plugin");
            handlePluginList.add(plugin);
        }
        return handlePluginList;
    }

    public static Map<String, String> getHandlePluginMap(DynamicObject obj) {
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("handleentry");
        HashMap<String, String> handlePluginMap = new HashMap<String, String>(cols.size());
        for (DynamicObject col : cols) {
            DynamicObject condition = col.getDynamicObject("handler");
            if (null == condition) continue;
            String plugin = condition.getString("plugin");
            handlePluginMap.put(plugin, condition.getString("name"));
        }
        return handlePluginMap;
    }

    @Deprecated
    public static boolean log(DynamicObject obj, String message) {
        return true;
    }

    public static DynamicObjectCollection getCondtionObjs(List<Long> nodeIds, DynamicObject chgeType) {
        QFilter nodeFilter = new QFilter("biznode", "in", nodeIds);
        nodeFilter.and("chgtype", "=", chgeType.getPkValue());
        nodeFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection conditions = QueryServiceHelper.query((String)"pds_chgcondition", (String)"id,biznode,chgtype", (QFilter[])new QFilter[]{nodeFilter}, (String)"biznode,number");
        return conditions;
    }

    public static DynamicObjectCollection getHandleObjs(List<Long> nodeIds, DynamicObject chgeType) {
        QFilter nodeFilter = new QFilter("biznode", "in", nodeIds);
        nodeFilter.and("chgtype", "=", chgeType.getPkValue());
        nodeFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection conditions = QueryServiceHelper.query((String)"pds_chghandler", (String)"id,biznode,chgtype", (QFilter[])new QFilter[]{nodeFilter}, (String)"biznode,number");
        return conditions;
    }

    public static Set<String> getSourceTypeNumberSetByShowParams(IFormView view, boolean isList) {
        Object sourceType;
        IFormView parentView;
        IFormView getParamView = view;
        if (!isList && null != (parentView = view.getParentView())) {
            getParamView = parentView;
        }
        Map customParams = getParamView.getFormShowParameter().getCustomParams();
        HashSet<String> sourceTypeNumberSet = new HashSet<String>(8);
        for (int i = 1; i < 5 && null != (sourceType = customParams.get("sourcetype" + i)); ++i) {
            sourceTypeNumberSet.addAll(Arrays.asList(String.valueOf(sourceType).trim().split(",")));
        }
        return sourceTypeNumberSet;
    }

    public static ValidateResult commonValidate(ValidateEvent validateEvent, String compKey) {
        Object chgDataObj;
        ValidateResult result = new ValidateResult();
        DynamicObject bidChangeObj = validateEvent.getObj();
        DynamicObject billObj = null;
        String errMessage = null;
        String changeSource = PdsCommonUtils.object2String((Object)bidChangeObj.get("changesource"), (String)"3");
        if ("1".equals(changeSource)) {
            billObj = bidChangeObj.getDynamicObject("apply");
            errMessage = ResManager.loadKDString((String)"\u5bfb\u6e90\u7533\u8bf7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u3002", (String)"SrcBidChangeUtil_5", (String)"scm-src-common", (Object[])new Object[0]);
        } else if ("2".equals(changeSource)) {
            billObj = bidChangeObj.getDynamicObject("demand");
            errMessage = ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u3002", (String)"SrcBidChangeUtil_6", (String)"scm-src-common", (Object[])new Object[0]);
        } else {
            billObj = bidChangeObj.getDynamicObject("project");
            errMessage = ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u3002", (String)"SrcBidChangeUtil_7", (String)"scm-src-common", (Object[])new Object[0]);
        }
        if (null == billObj) {
            result.setSuccess(false);
            result.setMessage(errMessage);
            return result;
        }
        result.setProjectObj(billObj);
        DynamicObject chgCompObj = null;
        Map params = validateEvent.getParams();
        chgCompObj = null != params ? (null != (chgDataObj = params.get(compKey)) && chgDataObj instanceof DynamicObject ? (DynamicObject)chgDataObj : TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)compKey)) : TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)compKey);
        if (null == chgCompObj) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u7684\u7ec4\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u53d8\u66f4\u5355\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcBidChangeUtil_3", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        result.setChgCompObj(chgCompObj);
        return result;
    }

    public static DynamicObject getBidChangeObject(IDataModel model) {
        Object changeObj = null;
        String changeSource = PdsCommonUtils.object2String((Object)model.getValue("changesource"), (String)"3");
        changeObj = changeSource.equals("1") ? model.getValue("apply") : (changeSource.equals("2") ? model.getValue("demand") : model.getValue("project"));
        if (null == changeObj) {
            return null;
        }
        return (DynamicObject)changeObj;
    }

    public static String getBidChangeObjectKey(IDataModel model) {
        String key = null;
        String changeSource = PdsCommonUtils.object2String((Object)model.getValue("changesource"), (String)"3");
        key = changeSource.equals("1") ? "apply" : (changeSource.equals("2") ? "demand" : "project");
        return key;
    }

    public static void decisionIsAudit(ValidateResult result, DynamicObject chgObj) {
        DynamicObject projectObj = chgObj.getDynamicObject("project");
        if (null == projectObj) {
            result.setMessage(ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"SrcBidChangeUtil_8", (String)"scm-src-common", (Object[])new Object[0]));
            result.setSuccess(false);
        } else {
            DynamicObject purlistObject = QueryServiceHelper.queryOne((String)"src_decision", (String)"id,billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", projectObj.getPkValue())});
            String billStatus = purlistObject.getString("billstatus");
            if (SrcProjectEnum.AUDIT.getCode().equals(billStatus)) {
                result.setSuccess(true);
            } else {
                result.setMessage(ResManager.loadKDString((String)"\u5b9a\u6807\u5355\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcBidChangeUtil_9", (String)"scm-src-common", (Object[])new Object[0]));
                result.setSuccess(false);
            }
        }
    }

    public static String decisionIsSubmitOrAudit(ValidateResult result, DynamicObject chgObj) {
        DynamicObject projectObj = chgObj.getDynamicObject("project");
        if (null == projectObj) {
            result.setMessage(ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"SrcBidChangeUtil_8", (String)"scm-src-common", (Object[])new Object[0]));
            result.setSuccess(false);
        } else {
            DynamicObject purlistObject = QueryServiceHelper.queryOne((String)"src_decision", (String)"id,billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", projectObj.getPkValue())});
            String billStatus = purlistObject.getString("billstatus");
            if (SrcProjectEnum.SUBMIT.getCode().equals(billStatus) || SrcProjectEnum.AUDIT.getCode().equals(billStatus)) {
                return ResManager.loadKDString((String)"\u5b9a\u6807\u5355\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcBidChangeUtil_10", (String)"scm-src-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String preDecisionIsSubmitOrAudit(ValidateResult result, DynamicObject chgObj) {
        DynamicObject projectObj = chgObj.getDynamicObject("project");
        if (null == projectObj) {
            result.setMessage(ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"SrcBidChangeUtil_8", (String)"scm-src-common", (Object[])new Object[0]));
            result.setSuccess(false);
        } else {
            DynamicObject purlistObject = QueryServiceHelper.queryOne((String)"src_predecision", (String)"id,billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", projectObj.getPkValue())});
            String billStatus = purlistObject.getString("billstatus");
            if (SrcProjectEnum.SUBMIT.getCode().equals(billStatus) || SrcProjectEnum.AUDIT.getCode().equals(billStatus)) {
                return ResManager.loadKDString((String)"\u9884\u5b9a\u6807\u5355\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcBidChangeUtil_11", (String)"scm-src-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static IFormView getParentView(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return null;
        }
        String entityName = parentView.getEntityId();
        if ("src_bidchange".equals(entityName) || "src_batchdecision".equals(entityName) || "tnd_bidchange".equals(entityName)) {
            return parentView;
        }
        return null;
    }

    public static DynamicObject getBidChangeBill(ExtPluginContext context) {
        QFilter qfilters = new QFilter("project", "=", (Object)context.getProjectId());
        qfilters.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        long templateId = PdsCommonUtils.object2Long(context.getParamMap().get("template"));
        qfilters.and("template", "=", (Object)templateId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"src_bidchange", (String)"id", (QFilter[])qfilters.toArray());
        if (null == obj) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)"src_bidchange");
    }

    public static DynamicObject createBidChangeBill(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcCreateBidChangeBill.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        return context.getBillObj();
    }

    public static void createBidChangeHead(ExtPluginContext context) {
        DynamicObject changeObj = BusinessDataServiceHelper.newDynamicObject((String)"src_bidchange");
        PdsCommonUtils.setBillNo((String)changeObj.getDataEntityType().getName(), (DynamicObject)changeObj);
        changeObj.set("billdate", (Object)TimeServiceHelper.now());
        changeObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        PdsCommonUtils.setObjectValueFromMap((DynamicObject)changeObj, (Map)((Map)context.getParamMap2().get("src_bidchange")));
        context.setBillObj(changeObj);
    }

    public static void createBidChangeEntry(ExtPluginContext context) {
        List<DynamicObject> childNodes = SrcProjectUtil.getHandledBizNodes(SrcBidChangeUtil.getProjectObj(context.getProjectId()));
        List nodeIds = DynamicObjectUtil.array2ListId((DynamicObject[])childNodes.toArray(new DynamicObject[0]), (String)"id");
        DynamicObjectCollection conditionObjs = SrcBidChangeUtil.getCondtionObjs(nodeIds, context.getSourceObj());
        SrcBidChangeUtil.createBidChangeEntryData(context.getBillObj(), "validateentry", "condition", conditionObjs);
        DynamicObjectCollection handleObjs = SrcBidChangeUtil.getHandleObjs(nodeIds, context.getSourceObj());
        SrcBidChangeUtil.createBidChangeEntryData(context.getBillObj(), "handleentry", "handler", handleObjs);
    }

    public static void createBidChangeTplEntry(ExtPluginContext context) {
        DynamicObjectCollection tplRows = context.getBillObj().getDynamicObjectCollection("tplentry");
        tplRows.removeAll((Collection)tplRows);
        DynamicObjectCollection rows = context.getSourceObj().getDynamicObjectCollection("compentry");
        for (DynamicObject row : rows) {
            DynamicObject tplRow = tplRows.addNew();
            tplRow.set("tmp_template", context.getSourceObj().get("id"));
            tplRow.set("tmp_component", (Object)row.getLong("component.id"));
            tplRow.set("tmp_bizobject", (Object)row.getString("bizobject"));
        }
    }

    private static void createBidChangeEntryData(DynamicObject changeObj, String entryKey, String pro, DynamicObjectCollection objs) {
        DynamicObjectCollection rows = changeObj.getDynamicObjectCollection(entryKey);
        rows.removeAll((Collection)rows);
        for (DynamicObject obj : objs) {
            DynamicObject row = rows.addNew();
            row.set(pro, obj.get("id"));
        }
    }

    private static DynamicObject getProjectObj(long projectId) {
        QFilter filter = new QFilter("id", "=", (Object)projectId);
        String selectFields = "id,billno,template,entrymainflow.biznode,entrymainflow.flowbizstatus,entrysubflow.subbiznode,entrysubflow.subflowbizstatus,purdecision";
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((String)"src_project", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return projectObj;
    }

    public static void createBidChangeComps(ExtPluginContext args) {
        List<String> compKeys = SrcBidChangeUtil.getBidChangeCompKeys(args.getSourceObj());
        if (null == compKeys || compKeys.size() == 0) {
            return;
        }
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(args.getBillObj());
        context.setProjectObj(args.getProjectObj());
        context.setProjectId(args.getProjectId());
        context.setParamMap(args.getParamMap());
        for (String compKey : compKeys) {
            String number = "createChgComp_" + compKey;
            context.setEntityId(compKey);
            ExtPluginFactory.executeExtplugin((String)number, (ExtPluginContext)context, (boolean)false);
        }
    }

    private static List<String> getBidChangeCompKeys(DynamicObject changeType) {
        DynamicObjectCollection rows = changeType.getDynamicObjectCollection("compentry");
        if (rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getString("component.bizobject.number")).collect(Collectors.toList());
    }

    public static DynamicObject createBidChangeComp(ExtPluginContext context) {
        String entityName = context.getEntityId();
        DynamicObject compObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        compObj.set("pentitykey", (Object)context.getBillObj().getDataEntityType().getName());
        compObj.set("parentid", context.getBillObj().getPkValue());
        compObj.set("entitykey", (Object)context.getEntityId());
        compObj.set("bidchange", context.getBillObj().getPkValue());
        compObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        PdsCommonUtils.setObjectValueFromMap((DynamicObject)compObj, (Map)((Map)context.getParamMap2().get(entityName)));
        return compObj;
    }
}

