/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.src.common.enums.SrcBizStatusEnum;
import kd.scm.src.common.util.SrcProjectMemberUtil;

public class SrcBidCompTplUtil {
    public static DynamicObject createOrUpdateExtObjEntry(DynamicObject obj, DynamicObject node, int rowIndex) {
        DynamicObject template;
        String extObj;
        String prefix = "";
        if (node.getDataEntityType() instanceof SubEntryType) {
            prefix = "sub";
        }
        if (null == (extObj = node.getString(prefix + "extobject")) || extObj.trim().length() == 0) {
            return null;
        }
        Map<String, String> specialHandleExtObjMap = SrcBidCompTplUtil.getSpecialHandleExtObjs();
        if (null != specialHandleExtObjMap.get(extObj)) {
            SrcBidCompTplUtil.handleSpecialExtObjs(obj, node);
            return null;
        }
        DynamicObject extObjDy = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)extObj);
        DynamicObjectCollection entryCols = extObjDy.getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        if (entryCols.size() == 0) {
            entryCols.addNew();
        }
        entry = (DynamicObject)entryCols.get(0);
        String bizStatus = entry.getString("bizstatus");
        if (rowIndex == 0) {
            if (!SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus)) {
                entry.set("bizstatus", (Object)SrcBizStatusEnum.PROCESSING.getVal());
            }
        } else if (!SrcBizStatusEnum.PROCESSING.getVal().equals(bizStatus) && !SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus)) {
            entry.set("bizstatus", (Object)SrcBizStatusEnum.NOTSTART.getVal());
        }
        String billStatus = entry.getString("billstatus");
        if (!BillStatusEnum.SUBMIT.getVal().equals(billStatus) && !BillStatusEnum.AUDIT.getVal().equals(billStatus)) {
            entry.set("billstatus", (Object)SrcBizStatusEnum.NOTSTART.getVal());
        }
        if (null != (template = node.getDynamicObject(prefix + "comptemplate"))) {
            entry.set("template", template.getPkValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extObjDy});
        return extObjDy;
    }

    public static DynamicObject getCurrNode(DynamicObject node, boolean ignoreSubNode) {
        String nodeName = node.getDataEntityType().getName();
        return SrcBidCompTplUtil.getCurrNode(node, nodeName, ignoreSubNode);
    }

    public static DynamicObject getCurrNode(DynamicObject node, String nodeName, boolean ignoreSubNode) {
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (bizObject.equals(nodeName)) {
                return entryNodeCol;
            }
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subBizObject = subEntryCol.getString("subbizobject");
                if (!subBizObject.equals(nodeName)) continue;
                if (ignoreSubNode) {
                    return entryNodeCol;
                }
                return subEntryCol;
            }
        }
        return null;
    }

    public static DynamicObject getNextNode(DynamicObject node) {
        String nodeName = node.getDataEntityType().getName();
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (i < entryNodeSize - 1 && bizObject.equals(nodeName)) {
                return (DynamicObject)entryNodeCols.get(i + 1);
            }
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subBizObject = subEntryCol.getString("subbizobject");
                if (!subBizObject.equals(nodeName) || i >= entryNodeSize - 1) continue;
                return (DynamicObject)entryNodeCols.get(i + 1);
            }
        }
        return null;
    }

    public static DynamicObject getCurrNextNode(DynamicObject node) {
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)node);
        String nodeName = node.getDataEntityType().getName();
        int nodeSize = plainNodeList.size();
        for (int i = 0; i < nodeSize; ++i) {
            DynamicObject nodeCol = (DynamicObject)plainNodeList.get(i);
            String bizObject = nodeCol.getDataEntityType() instanceof SubEntryType ? nodeCol.getString("subbizobject") : nodeCol.getString("bizobject");
            if (i >= nodeSize - 1 || !bizObject.equals(nodeName)) continue;
            for (int j = i + 1; j < nodeSize; ++j) {
                DynamicObject nextNode = (DynamicObject)plainNodeList.get(j);
                if (nextNode.getDataEntityType() instanceof SubEntryType) {
                    if (!nextNode.getBoolean("subisaudit")) continue;
                    return nextNode;
                }
                return nextNode;
            }
        }
        return null;
    }

    public static String getCurrNextNodeNo(DynamicObject node) {
        DynamicObject nextNode = SrcBidCompTplUtil.getCurrNextNode(node);
        if (null == nextNode) {
            return null;
        }
        if ("entrymainflow".equals(nextNode.getDataEntityType().getName())) {
            return nextNode.getString("biznode.number");
        }
        if ("entrysubflow".equals(nextNode.getDataEntityType().getName())) {
            return nextNode.getString("subbiznode.number");
        }
        return null;
    }

    public static DynamicObject getNextNode(DynamicObject node, boolean ignoreSubNode) {
        if (ignoreSubNode) {
            return SrcBidCompTplUtil.getNextNode(node);
        }
        DynamicObject nextNode = null;
        String nodeName = node.getDataEntityType().getName();
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (i < entryNodeSize - 1 && bizObject.equals(nodeName)) {
                nextNode = (DynamicObject)entryNodeCols.get(i + 1);
                return nextNode;
            }
            boolean currNodeIsSubNode = false;
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                boolean isAudit;
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subBizObject = subEntryCol.getString("subbizobject");
                if (subBizObject.equals(nodeName)) {
                    currNodeIsSubNode = true;
                }
                if (!currNodeIsSubNode) continue;
                DynamicObject nextSubNode = null;
                if (j >= subEntrySize - 1 || !(isAudit = (nextSubNode = (DynamicObject)subEntryCols.get(j + 1)).getBoolean("subisaudit"))) continue;
                nextNode = nextSubNode;
                break;
            }
            if (!currNodeIsSubNode || nextNode != null || i >= entryNodeSize - 1) continue;
            nextNode = (DynamicObject)entryNodeCols.get(i + 1);
            return nextNode;
        }
        return nextNode;
    }

    private static List<DynamicObject> getAllChildrenNodes(DynamicObject node) {
        ArrayList<DynamicObject> childrenNodeList = new ArrayList<DynamicObject>();
        String nodeName = node.getDataEntityType().getName();
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        int curNodeIndex = -1;
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String bizObject = entryNodeCol.getString("bizobject");
            if (bizObject.equals(nodeName)) {
                curNodeIndex = i;
            }
            if (curNodeIndex < 0 || i <= curNodeIndex) continue;
            childrenNodeList.add(entryNodeCol);
        }
        return childrenNodeList;
    }

    public static DynamicObject getParentNode(DynamicObject node, boolean ignoreSubNode) {
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)node);
        String nodeName = node.getDataEntityType().getName();
        String bizObject = null;
        boolean isFindNode = false;
        boolean isFlowChart = false;
        for (int i = plainNodeList.size() - 1; i >= 0; --i) {
            boolean isSubNode = false;
            DynamicObject plainNode = (DynamicObject)plainNodeList.get(i);
            if (plainNode.getDynamicObjectType() instanceof SubEntryType) {
                bizObject = plainNode.getString("subbizobject");
                isSubNode = true;
            } else {
                bizObject = plainNode.getString("bizobject");
            }
            if (bizObject.equals(nodeName)) {
                isFindNode = true;
                continue;
            }
            if (!isFindNode || !(isFlowChart = isSubNode ? plainNode.getBoolean("subisflowchart") : plainNode.getBoolean("isflowchart"))) continue;
            return plainNode;
        }
        return null;
    }

    public static void updateNextNode(DynamicObject node, String bizStatus) {
        DynamicObject currNode = SrcBidCompTplUtil.getCurrNode(node, true);
        if (!SrcBidCompTplUtil.isUpdateNextNode(currNode)) {
            return;
        }
        DynamicObject nextNode = SrcBidCompTplUtil.getNextNode(node, true);
        if (null == nextNode) {
            return;
        }
        SrcBidCompTplUtil.updateNodeStatus(node, nextNode, bizStatus);
        if (!(nextNode.getDataEntityType() instanceof SubEntryType)) {
            DynamicObjectCollection subEntryCols = nextNode.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                SrcBidCompTplUtil.updateNodeStatus(node, subEntryCol, bizStatus);
            }
        }
    }

    public static void updateAllChildrenNodes(DynamicObject node, String bizStatus) {
        List<DynamicObject> childrenNodeList = SrcBidCompTplUtil.getAllChildrenNodes(node);
        if (childrenNodeList.size() == 0) {
            return;
        }
        for (DynamicObject childrenNode : childrenNodeList) {
            SrcBidCompTplUtil.updateNodeStatus(node, childrenNode, bizStatus);
            DynamicObjectCollection subEntryCols = childrenNode.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                SrcBidCompTplUtil.updateNodeStatus(node, subEntryCol, bizStatus);
            }
        }
    }

    public static void updateNodeStatus(DynamicObject parentNode, DynamicObject node, String bizStatus) {
        Map<String, String> specialHandleExtObjMap = SrcBidCompTplUtil.getSpecialHandleExtObjs();
        DynamicObject extObjDy = SrcBidCompTplUtil.getExtObj(parentNode, node, specialHandleExtObjMap);
        if (null == extObjDy) {
            return;
        }
        String bizStatusVal = "";
        String entityKey = extObjDy.getDataEntityType().getName();
        if (null != specialHandleExtObjMap.get(entityKey)) {
            bizStatusVal = extObjDy.getString("bizstatus");
            if (SrcBizStatusEnum.HANDLED.getVal().equals(bizStatusVal)) {
                return;
            }
            extObjDy.set("bizstatus", (Object)bizStatus);
        } else {
            DynamicObjectCollection entryCols = extObjDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryCol : entryCols) {
                bizStatusVal = entryCol.getString("bizstatus");
                if (SrcBizStatusEnum.HANDLED.getVal().equals(bizStatusVal)) {
                    return;
                }
                entryCol.set("bizstatus", (Object)bizStatus);
                entryCol.set("creator", (Object)RequestContext.get().getCurrUserId());
                entryCol.set("createtime", (Object)TimeServiceHelper.now());
            }
        }
        if (node.getDataEntityType() instanceof SubEntryType) {
            node.set("subflowbizstatus", (Object)bizStatus);
        } else {
            node.set("flowbizstatus", (Object)bizStatus);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extObjDy});
    }

    private static DynamicObject getExtObj(DynamicObject parentNode, DynamicObject node, Map<String, String> specialHandleExtObjMap) {
        String extObj;
        String prefix = "";
        if (node.getDataEntityType() instanceof SubEntryType) {
            prefix = "sub";
        }
        if (null == (extObj = node.getString(prefix + "extobject")) || extObj.trim().length() == 0) {
            return null;
        }
        DynamicObject extObjDy = null;
        extObjDy = null != specialHandleExtObjMap.get(extObj) ? SrcBidCompTplUtil.getSpecialExtObj(parentNode, node) : BusinessDataServiceHelper.loadSingle((Object)parentNode.getPkValue(), (String)extObj);
        return extObjDy;
    }

    public static DynamicObject getSpecialExtObj(DynamicObject parentNode, DynamicObject node) {
        String extObj;
        DynamicObject source = parentNode.getDynamicObject("source");
        if (null == source) {
            return null;
        }
        String prefix = "";
        if (node.getDataEntityType() instanceof SubEntryType) {
            prefix = "sub";
        }
        if (null == (extObj = node.getString(prefix + "extobject")) || extObj.trim().length() == 0) {
            return null;
        }
        QFilter filter = new QFilter("source", "=", source.getPkValue());
        String selectFields = DynamicObjectUtil.getSelectfields((String)extObj, (boolean)false);
        try {
            DynamicObject specialExtObj = BusinessDataServiceHelper.loadSingle((String)extObj, (String)selectFields, (QFilter[])new QFilter[]{filter});
            return specialExtObj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> getSpecialHandleExtObjs() {
        HashMap<String, String> specialHandleExtObjMap = new HashMap<String, String>(4);
        return specialHandleExtObjMap;
    }

    public static void handleSpecialExtObjs(DynamicObject obj, DynamicObject node) {
        String extObj;
        DynamicObject source = obj.getDynamicObject("source");
        if (null == source) {
            return;
        }
        String prefix = "";
        if (node.getDataEntityType() instanceof SubEntryType) {
            prefix = "sub";
        }
        if (null == (extObj = node.getString(prefix + "extobject")) || extObj.trim().length() == 0) {
            return;
        }
        QFilter filter = new QFilter("source", "=", source.getPkValue());
        try {
            if (QueryServiceHelper.exists((String)extObj, (QFilter[])new QFilter[]{filter})) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        DynamicObject bizObj = BusinessDataServiceHelper.newDynamicObject((String)extObj);
        bizObj.set("source", source.getPkValue());
        bizObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        bizObj.set("bizstatus", (Object)SrcBizStatusEnum.NOTSTART.getVal());
        DynamicObject template = node.getDynamicObject(prefix + "comptemplate");
        if (null != template) {
            bizObj.set("template", template.getPkValue());
        }
        bizObj.set("begindate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizObj});
    }

    public static void updateCurrentNode(DynamicObject node) {
        DynamicObject processingNode = SrcBidCompTplUtil.getProcessingNode(node);
        if (null == processingNode) {
            DynamicObject bizNode = BusinessDataServiceHelper.loadSingleFromCache((Object)1291998834741779456L, (String)"pds_biznode", (String)"id,name");
            node.set("currentnode", (Object)1291998834741779456L);
            node.set("currentnodename", (Object)bizNode.getString("name"));
            return;
        }
        String nodeName = "";
        DynamicObject bizNodeObj = null;
        if (processingNode.getDataEntityType() instanceof SubEntryType) {
            bizNodeObj = processingNode.getDynamicObject("subbiznode");
            nodeName = processingNode.getString("subnodename");
        } else {
            bizNodeObj = processingNode.getDynamicObject("biznode");
            nodeName = processingNode.getString("nodename");
        }
        if (null == bizNodeObj) {
            return;
        }
        node.set("currentnode", bizNodeObj.getPkValue());
        if (StringUtils.isBlank((String)nodeName)) {
            nodeName = bizNodeObj.getString("name");
        }
        node.set("currentnodename", (Object)nodeName);
    }

    public static DynamicObject getProcessingNode(DynamicObject node) {
        DynamicObjectCollection entryNodeCols = node.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            String flowBizStatus = entryNodeCol.getString("flowbizstatus");
            boolean isFlowChart = entryNodeCol.getBoolean("isflowchart");
            if (isFlowChart && SrcBizStatusEnum.PROCESSING.getVal().equals(flowBizStatus)) {
                return entryNodeCol;
            }
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                String subFlowBizStatus = subEntryCol.getString("subflowbizstatus");
                isFlowChart = subEntryCol.getBoolean("subisflowchart");
                boolean subIsAudit = subEntryCol.getBoolean("subisaudit");
                if (!isFlowChart || !subIsAudit || !SrcBizStatusEnum.PROCESSING.getVal().equals(subFlowBizStatus)) continue;
                return subEntryCol;
            }
        }
        return null;
    }

    public static void updateCurrFlowEntryNode(DynamicObject node, String operate) {
        DynamicObject currNode = SrcBidCompTplUtil.getCurrNode(node, false);
        if (null == currNode) {
            return;
        }
        SrcBidCompTplUtil.updateEntryNodeStatus(currNode, operate);
        if (!(currNode.getDataEntityType() instanceof SubEntryType)) {
            DynamicObjectCollection subEntryCols = currNode.getDynamicObjectCollection("entrysubflow");
            int subEntrySize = subEntryCols.size();
            for (int j = 0; j < subEntrySize; ++j) {
                DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                boolean isAudit = subEntryCol.getBoolean("subisaudit");
                if (!isAudit) continue;
            }
        }
    }

    public static boolean isNeedAudit(DynamicObject node) {
        DynamicObject currNode = SrcBidCompTplUtil.getCurrNode(node, false);
        if (null == currNode) {
            return false;
        }
        if (currNode.getDataEntityType() instanceof SubEntryType) {
            return currNode.getBoolean("subisaudit");
        }
        return true;
    }

    private static void updateEntryNodeStatus(DynamicObject node, String operate) {
        String prefix = "";
        if (node.getDataEntityType() instanceof SubEntryType) {
            prefix = "sub";
        }
        if ("audit".equals(operate)) {
            node.set(prefix + "flowbizstatus", (Object)SrcBizStatusEnum.HANDLED.getVal());
            node.set(prefix + "flowbillstatus", (Object)SrcBizStatusEnum.HANDLED.getVal());
        } else if ("unaudit".equals(operate)) {
            node.set(prefix + "flowbizstatus", (Object)SrcBizStatusEnum.PROCESSING.getVal());
            node.set(prefix + "flowbillstatus", (Object)SrcBizStatusEnum.NOTSTART.getVal());
        }
    }

    private static boolean isUpdateNextNode(DynamicObject node) {
        boolean isUpdate = true;
        if (null == node) {
            return isUpdate;
        }
        String flowBizStatus = node.getString("flowbizstatus");
        if (!SrcBizStatusEnum.HANDLED.getVal().equals(flowBizStatus)) {
            isUpdate = false;
            return isUpdate;
        }
        DynamicObjectCollection subEntryCols = node.getDynamicObjectCollection("entrysubflow");
        int subEntrySize = subEntryCols.size();
        for (int j = 0; j < subEntrySize; ++j) {
            DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
            String subFlowBizStatus = subEntryCol.getString("subflowbizstatus");
            boolean isAudit = subEntryCol.getBoolean("subisaudit");
            if (!isAudit || SrcBizStatusEnum.HANDLED.getVal().equals(subFlowBizStatus)) continue;
            isUpdate = false;
            return isUpdate;
        }
        return isUpdate;
    }

    public static DynamicObject getHandledChildrenNode(DynamicObject node) {
        DynamicObject handledNode = SrcBidCompTplUtil.getHandledSubChildrenNode(node);
        if (null != handledNode) {
            return handledNode;
        }
        DynamicObject nextNode = SrcBidCompTplUtil.getNextNode(node);
        if (null == nextNode) {
            return handledNode;
        }
        String flowBizStatus = nextNode.getString("flowbizstatus");
        if (SrcBizStatusEnum.HANDLED.getVal().equals(flowBizStatus)) {
            return nextNode;
        }
        DynamicObjectCollection subEntryCols = nextNode.getDynamicObjectCollection("entrysubflow");
        int subEntrySize = subEntryCols.size();
        for (int j = 0; j < subEntrySize; ++j) {
            DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
            String subFlowBizStatus = subEntryCol.getString("subflowbizstatus");
            boolean isAudit = subEntryCol.getBoolean("subisaudit");
            if (!isAudit || !SrcBizStatusEnum.HANDLED.getVal().equals(subFlowBizStatus)) continue;
            return subEntryCol;
        }
        return handledNode;
    }

    private static DynamicObject getHandledSubChildrenNode(DynamicObject node) {
        DynamicObject currNode = SrcBidCompTplUtil.getCurrNode(node, false);
        DynamicObject handledNode = null;
        if (null == currNode) {
            return handledNode;
        }
        if (currNode.getDataEntityType() instanceof SubEntryType) {
            return handledNode;
        }
        DynamicObjectCollection subEntryCols = currNode.getDynamicObjectCollection("entrysubflow");
        int subEntrySize = subEntryCols.size();
        for (int j = 0; j < subEntrySize; ++j) {
            DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
            String subFlowBizStatus = subEntryCol.getString("subflowbizstatus");
            boolean isAudit = subEntryCol.getBoolean("subisaudit");
            if (!isAudit || !SrcBizStatusEnum.HANDLED.getVal().equals(subFlowBizStatus)) continue;
            return subEntryCol;
        }
        return handledNode;
    }

    public static DynamicObject getUnHandledParentNode(DynamicObject node) {
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)node);
        DynamicObject parentNode = SrcBidCompTplUtil.getCurrNode(node, true);
        String nodeName = node.getDataEntityType().getName();
        if (null != parentNode) {
            nodeName = parentNode.getString("bizobject");
        }
        String bizObject = null;
        boolean isFindNode = false;
        String bizStatus = "";
        boolean isAudit = true;
        for (int i = plainNodeList.size() - 1; i >= 0; --i) {
            boolean isSubNode = false;
            DynamicObject plainNode = (DynamicObject)plainNodeList.get(i);
            if (plainNode.getDynamicObjectType() instanceof SubEntryType) {
                bizObject = plainNode.getString("subbizobject");
                isSubNode = true;
            } else {
                bizObject = plainNode.getString("bizobject");
            }
            if (bizObject.equals(nodeName)) {
                isFindNode = true;
                continue;
            }
            if (!isFindNode) continue;
            if (isSubNode) {
                isAudit = plainNode.getBoolean("subisaudit");
                bizStatus = plainNode.getString("subflowbizstatus");
            } else {
                isAudit = true;
                bizStatus = plainNode.getString("flowbizstatus");
            }
            if (!isAudit || SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus)) continue;
            return plainNode;
        }
        return null;
    }

    public static DynamicObject getHandledParentNode(DynamicObject node) {
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)node);
        DynamicObject parentNode = SrcBidCompTplUtil.getCurrNode(node, true);
        String nodeName = node.getDataEntityType().getName();
        if (null != parentNode) {
            nodeName = parentNode.getString("bizobject");
        }
        String bizObject = null;
        boolean isFindNode = false;
        String bizStatus = "";
        boolean isAudit = true;
        for (int i = plainNodeList.size() - 1; i >= 0; --i) {
            boolean isSubNode = false;
            DynamicObject plainNode = (DynamicObject)plainNodeList.get(i);
            if (plainNode.getDynamicObjectType() instanceof SubEntryType) {
                bizObject = plainNode.getString("subbizobject");
                isSubNode = true;
            } else {
                bizObject = plainNode.getString("bizobject");
            }
            if (bizObject.equals(nodeName)) {
                isFindNode = true;
                continue;
            }
            if (!isFindNode) continue;
            if (isSubNode) {
                isAudit = plainNode.getBoolean("subisaudit");
                bizStatus = plainNode.getString("subflowbizstatus");
            } else {
                bizStatus = plainNode.getString("flowbizstatus");
            }
            if (!isAudit || !SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus)) continue;
            return plainNode;
        }
        return null;
    }

    public static List<String> getProcessingOrHandledBizObjs(DynamicObject node) {
        ArrayList<String> bizObjList = new ArrayList<String>();
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)node);
        String bizObject = null;
        String bizStatus = "";
        for (int i = plainNodeList.size() - 1; i >= 0; --i) {
            boolean isSubNode = false;
            DynamicObject plainNode = (DynamicObject)plainNodeList.get(i);
            if (plainNode.getDynamicObjectType() instanceof SubEntryType) {
                isSubNode = true;
                bizStatus = plainNode.getString("subflowbizstatus");
            } else {
                bizStatus = plainNode.getString("flowbizstatus");
            }
            if (!SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus) && !SrcBizStatusEnum.PROCESSING.getVal().equals(bizStatus)) continue;
            bizObject = isSubNode ? plainNode.getString("subbizobject") : plainNode.getString("bizobject");
            bizObjList.add(bizObject);
        }
        return bizObjList;
    }

    public static boolean isProjectEnded(DynamicObject node) {
        boolean isHandle = false;
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)node);
        String bizStatus = "";
        for (DynamicObject plainNode : plainNodeList) {
            boolean isAudit = false;
            if (plainNode.getDynamicObjectType() instanceof SubEntryType) {
                bizStatus = plainNode.getString("subflowbizstatus");
                isAudit = plainNode.getBoolean("subisaudit");
            } else {
                bizStatus = plainNode.getString("flowbizstatus");
                isAudit = true;
            }
            if (!isAudit) continue;
            if (SrcBizStatusEnum.PROCESSING.getVal().equals(bizStatus)) {
                isHandle = false;
                continue;
            }
            if (!SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus) && !SrcBizStatusEnum.ENDED.getVal().equals(bizStatus)) continue;
            isHandle = true;
        }
        return isHandle;
    }

    public static DynamicObject[] getAutoPublishObjs(DynamicObject[] objs) {
        ArrayList<DynamicObject> autoPublishObjList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            if (SrcBidCompTplUtil.hasNode(obj, "src_bidpublish")) continue;
            autoPublishObjList.add(obj);
        }
        return autoPublishObjList.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] getAllCreateObjs(DynamicObject[] objs) {
        ArrayList<DynamicObject> allCreateObjList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            if (!SrcBidCompTplUtil.isNeedCreateTndBill(obj) || !SrcBidCompTplUtil.hasNode(obj, "tnd_quotebill") || !SrcBidCompTplUtil.hasNode(obj, "tnd_tenderbill")) continue;
            allCreateObjList.add(obj);
        }
        return allCreateObjList.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] getOnlyCreateQuoObjs(DynamicObject[] objs) {
        ArrayList<DynamicObject> needCreateQuoList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            if (!SrcBidCompTplUtil.isNeedCreateTndBill(obj) || !SrcBidCompTplUtil.hasNode(obj, "tnd_quotebill") || SrcBidCompTplUtil.hasNode(obj, "tnd_tenderbill")) continue;
            needCreateQuoList.add(obj);
        }
        return needCreateQuoList.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] getOnlyCreateTenderObjs(DynamicObject[] objs) {
        ArrayList<DynamicObject> needCreateQuoList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            if (!SrcBidCompTplUtil.isNeedCreateTndBill(obj) || SrcBidCompTplUtil.hasNode(obj, "tnd_quotebill") || !SrcBidCompTplUtil.hasNode(obj, "tnd_tenderbill")) continue;
            needCreateQuoList.add(obj);
        }
        return needCreateQuoList.toArray(new DynamicObject[0]);
    }

    public static boolean isNeedCreateTndBill(DynamicObject obj) {
        String sourceclass = obj.getString("sourceclass.number");
        return null == sourceclass || !sourceclass.equals("C011402");
    }

    public static boolean hasNode(DynamicObject obj, String nodeName) {
        DynamicObject node = SrcBidCompTplUtil.getCurrNode(obj, nodeName, false);
        return null != node;
    }

    public static QFilter getBillListFilter(String entityKey) {
        QFilter filter = new QFilter("bizstatus", "!=", (Object)"");
        filter.and("bizstatus", "!=", (Object)SrcBizStatusEnum.NOTSTART.getVal());
        filter.and("billno", "!=", (Object)"");
        filter.and(new QFilter("bidname", "!=", (Object)"").or("srctype", "!=", (Object)0));
        Object isbidderAuth = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isbidderauth");
        if (null == isbidderAuth || ((Boolean)isbidderAuth).booleanValue()) {
            filter.and(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).or("id", "in", SrcProjectMemberUtil.getProjMemberIDListByBizObj(entityKey)));
        }
        return filter;
    }

    public static boolean isExtObj(DynamicObject node) {
        DynamicObject currNode = SrcBidCompTplUtil.getCurrNode(node, false);
        boolean isExtObj = false;
        if (null != currNode) {
            String bizObject = "";
            bizObject = currNode.getDataEntityType() instanceof SubEntryType ? currNode.getString("subextobject") : currNode.getString("extobject");
            if (bizObject.startsWith("src_project_ext")) {
                isExtObj = true;
            }
        }
        return isExtObj;
    }
}

