/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scm.src.common.util.SrcAppCache;

public class SrcComponentUtil {
    private static Log log = LogFactory.getLog(SrcComponentUtil.class);

    public static IFormView getComponentView(IFormView view, String componentName) {
        String componentPageId = SrcAppCache.get(componentName, String.class, view);
        if (componentPageId == null) {
            return null;
        }
        IFormView componentView = view.getView(componentPageId);
        if (componentView == null) {
            return null;
        }
        return componentView;
    }

    public static DynamicObject getComponentObj(IFormView view, String componentName) {
        IFormView componentView = SrcComponentUtil.getComponentView(view, componentName);
        if (componentView == null) {
            return null;
        }
        DynamicObject componentObj = componentView.getModel().getDataEntity(true);
        if (componentObj == null) {
            return null;
        }
        return componentObj;
    }

    public static String getManagetype(IFormView view) {
        String manageType = "1";
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            return manageType;
        }
        DynamicObject obj = parentView.getModel().getDataEntity();
        try {
            manageType = "src_scoreassist".equals(parentView.getEntityId()) ? obj.getString("projectid.managetype") : obj.getString("managetype");
        }
        catch (Exception e) {
            try {
                manageType = obj.getString("project.managetype");
            }
            catch (Exception exe) {
                try {
                    manageType = obj.getString("projectf7.managetype");
                }
                catch (Exception e2) {
                    log.info("###cant get manageType:" + e2.getMessage());
                }
            }
        }
        return manageType;
    }

    public static String getCompTitleByBidComp(String entityKey, String compKey) {
        QFilter bidCompfilter = new QFilter("enable", "=", (Object)"1");
        if (null != entityKey) {
            bidCompfilter.and("biznode.bizobject", "=", (Object)entityKey);
        }
        if (null != compKey) {
            bidCompfilter.and("bizobject.number", "=", (Object)compKey);
        }
        DynamicObject bidComp = BusinessDataServiceHelper.loadSingle((String)"pds_compreg", (String)"id,name", (QFilter[])new QFilter[]{bidCompfilter});
        String title = "";
        if (null != bidComp) {
            title = bidComp.getString("name");
        } else {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)compKey);
            title = type.getDisplayName().toString();
        }
        return title;
    }
}

