/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcPackageUtil {
    private static Log log = LogFactory.getLog(SrcPackageUtil.class);

    public static void updateCompPackageData(DynamicObject obj) {
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj, (boolean)false);
        for (String compKey : compKeyList) {
            DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey);
            if (null == compObj) continue;
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)compKey);
            List<String> fieldList = SrcPackageUtil.getClearField(compKey);
            boolean isChanged = false;
            for (String field : fieldList) {
                IDataEntityType proParent;
                IDataEntityProperty pro = type.findProperty(field);
                if (null == pro || null == (proParent = pro.getParent()) || !(proParent instanceof EntryType)) continue;
                String entryKey = proParent.getName();
                DynamicObjectCollection cols = compObj.getDynamicObjectCollection(entryKey);
                for (DynamicObject col : cols) {
                    Object proVal = col.get(pro);
                    if (!Objects.nonNull(proVal)) continue;
                    if (proVal instanceof DynamicObject) {
                        pro.setValueFast((Object)col, (Object)0L);
                    } else {
                        pro.setValueFast((Object)col, null);
                    }
                    isChanged = true;
                }
            }
            if (!isChanged) continue;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compObj});
        }
    }

    public static List<String> getClearField(String compKey) {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("package");
        fieldList.add("packagename");
        return fieldList;
    }

    public static void deletePackageData(DynamicObject obj) {
        QFilter filter = new QFilter("project", "=", obj.getPkValue());
        int count = DeleteServiceHelper.delete((String)"src_packagef7", (QFilter[])filter.toArray());
        BizLog.log((String)("###SrcProjectCompTplEdit delete package count :" + count));
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"src_projectf7", (String)"id,ismultipackage");
        if (null != projectObj) {
            projectObj.set("ismultipackage", (Object)false);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectObj});
        }
    }

    public static void createPackage(IFormView view, DynamicObject projectObj) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        paramMap.put("projectid", projectId);
        paramMap.put("managetype", projectObj.getString("managetype"));
        paramMap.put("billstatus", projectObj.getString("billstatus"));
        OpenFormUtils.openListPage((IFormView)view, (String)"src_packagef7", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
    }

    public static QFilter getProjectFilter(IFormView view) {
        long projectId = PdsCommonUtils.object2Long((Object)PdsCommonUtils.getCustomParamValue((IFormView)view, (String)"projectid"));
        if (projectId == 0L && PdsCommonUtils.isValidBillType((IFormView)view.getParentView())) {
            try {
                projectId = PdsCommonUtils.object2Long((Object)view.getParentView().getModel().getValue("parentid"));
            }
            catch (Exception e2) {
                log.info("###getProjectFilter exception:" + e2.getMessage());
            }
        }
        if (projectId == 0L) {
            return null;
        }
        return new QFilter("project", "=", (Object)projectId);
    }

    public static void setCreatePackageVisible(IFormView view) {
        DynamicObject billObj = view.getModel().getDataEntity();
        String manageType = PdsCommonUtils.object2String((Object)billObj.get("managetype"), (String)"1");
        if (!"2".equals(manageType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"createpackage"});
        } else {
            long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
            boolean isManualCreatePackage = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isManualCreatePackage", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)billObj)));
            if (!isManualCreatePackage) {
                view.setVisible(Boolean.valueOf(false), new String[]{"createpackage"});
            } else {
                view.setVisible(Boolean.valueOf(true), new String[]{"createpackage"});
            }
        }
    }
}

