/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcProjectInitUtil {
    public static void initProject(DynamicObject billObj) {
        SrcProjectUtil.createEntryData(billObj);
        SrcProjectUtil.createExtObj(billObj);
        SrcProjectUtil.initAllExtObjs(billObj);
    }

    public static void updateProjectFlowStatusByContract(DynamicObject billObj) {
        SrcProjectInitUtil.initProjectFlowStatus(billObj, false);
    }

    public static void initProjectFlowStatus(DynamicObject billObj, boolean isShowFlow) {
        List plainNodeList = PdsFlowConfigUtils.getPlainNode((DynamicObject)billObj);
        String nodeName = billObj.getDataEntityType().getName();
        int nodeSize = plainNodeList.size();
        for (int i = 0; i < nodeSize; ++i) {
            String bizObject;
            DynamicObject nodeCol = (DynamicObject)plainNodeList.get(i);
            boolean isSubNode = false;
            if (nodeCol.getDataEntityType() instanceof SubEntryType) {
                bizObject = nodeCol.getString("subbizobject");
                isSubNode = true;
            } else {
                bizObject = nodeCol.getString("bizobject");
            }
            if (bizObject.equals(nodeName)) {
                return;
            }
            QFilter filter = new QFilter("id", "=", billObj.getPkValue());
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)bizObject, (String)"id,billstatus,bizstatus", (QFilter[])filter.toArray());
            String bizStatus = ProcessStatusEnums.PROCESSED.getValue();
            if (!isShowFlow && !"src_decision".equals(bizObject)) {
                bizStatus = ProcessStatusEnums.NOTSTARTED.getValue();
            }
            obj.set("bizstatus", (Object)bizStatus);
            obj.set("billstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            if (isSubNode) {
                nodeCol.set("subflowbizstatus", (Object)"C");
                nodeCol.set("subflowbillstatus", (Object)"C");
                continue;
            }
            nodeCol.set("flowbizstatus", (Object)"C");
            nodeCol.set("flowbillstatus", (Object)"C");
        }
    }

    public static void deleteProjectExtTable(DynamicObject billObj) {
        SrcProjectInitUtil.deleteProjectExtTable(billObj.getLong("id"));
    }

    public static void deleteProjectExtTable(long billId) {
        List<String> extObjList = SrcProjectUtil.getAllExtObjs();
        List<String> extNodeList = SrcProjectUtil.getAllExtNode();
        extObjList.addAll(extNodeList);
        for (String extTable : extObjList) {
            SrcProjectInitUtil.executeSql(billId, extTable);
        }
    }

    public static void executeSql(Object id, String extTable) {
        String sql = "delete from %s where fid = %s";
        StringBuilder tableSb = new StringBuilder();
        tableSb.append("t_").append(extTable);
        sql = String.format(sql, tableSb.toString(), String.valueOf(id));
        DBRoute dbRoute = new DBRoute("pur");
        DB.execute((DBRoute)dbRoute, (String)sql);
    }
}

