/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.util.TenderSupplierUtils;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.src.common.util.SrcTenderUtil;
import org.apache.commons.lang3.StringUtils;

public class SrcQuoteUtil {
    public static OperationResult deleteQuoteBill(DynamicObject[] objs) {
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])objs, (String)"id");
        if (idList.size() == 0) {
            return new OperationResult();
        }
        QFilter filter = new QFilter("project", "in", (Object)idList);
        DynamicObjectCollection quoBillCols = QueryServiceHelper.query((String)"tnd_quotebill", (String)"id", (QFilter[])new QFilter[]{filter});
        List quoBillIdList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)quoBillCols, (String)"id");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        return OperationServiceHelper.executeOperate((String)"delete", (String)"tnd_quotebill", (Object[])quoBillIdList.toArray(new Long[0]), (OperateOption)option);
    }

    public static boolean isSupplierQuoted(DynamicObject obj) {
        QFilter filter = new QFilter("project", "in", obj.getPkValue());
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        return QueryServiceHelper.exists((String)"tnd_quotebill", (QFilter[])new QFilter[]{filter});
    }

    public static void createQuoteBillBySupCol(DynamicObject[] objs, List<DynamicObject> supColList) {
        DynamicObject[] purListObjs;
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])objs, (String)"id");
        if (idList.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)idList);
        HashMap<String, DynamicObject> billID_objMap = new HashMap<String, DynamicObject>(4);
        HashMap billID_compKeyMap = new HashMap(4);
        String selectFields = "id,template,org,ismustapply,managetype,isitemsupplier,stopbiddate,isadd,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject,sourcetype.number,srctype.id,projectf7.isviepush";
        for (DynamicObject obj : purListObjs = BusinessDataServiceHelper.load((String)"src_purlist", (String)selectFields, (QFilter[])new QFilter[]{filter})) {
            HashMap<String, DynamicObject> compKey_objMap = new HashMap<String, DynamicObject>(4);
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj);
            for (String compKey : compKeyList) {
                DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey);
                if (null == compObj) continue;
                compKey_objMap.put(compKey, compObj);
            }
            billID_objMap.put(obj.getPkValue().toString(), obj);
            billID_compKeyMap.putIfAbsent(obj.getPkValue().toString(), compKey_objMap);
        }
        Map<String, List<String>> supKey_packageId = SrcTenderUtil.getSupGroupSetByData(purListObjs, supColList);
        ArrayList<String> supKeyList = new ArrayList<String>(supKey_packageId.keySet());
        if (supKeyList.size() == 0) {
            return;
        }
        for (String supGroup : supKeyList) {
            String billId;
            DynamicObject billObj;
            Object[] keys = CommonUtil.str2objs((String)supGroup, (String)"_");
            if (keys.length < 1 || null == (billObj = (DynamicObject)billID_objMap.get(billId = keys[0].toString()))) continue;
            Map compKey_objMap = (Map)billID_compKeyMap.get(billId);
            List<String> pkgOrPurListidList = null;
            String manageType = billObj.getString("managetype");
            if (!"3".equals(manageType)) {
                pkgOrPurListidList = supKey_packageId.get(supGroup);
            }
            DynamicObject quoBill = SrcQuoteUtil.createQuoBill(supGroup, billObj, null);
            SrcQuoteUtil.createCompData(quoBill, pkgOrPurListidList, compKey_objMap, manageType);
        }
    }

    public static void createQuoteBill(DynamicObject[] objs, DynamicObject[] bidChangeObjs) {
        DynamicObject[] purListObjs;
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])objs, (String)"id");
        if (idList.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)idList);
        HashMap<String, DynamicObject> billID_objMap = new HashMap<String, DynamicObject>(4);
        HashMap billID_compKeyMap = new HashMap(4);
        String selectFields = "id,template,org,ismustapply,managetype,isitemsupplier,stopbiddate,isadd,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject,sourcetype.number,projectf7.isviepush";
        for (DynamicObject obj : purListObjs = BusinessDataServiceHelper.load((String)"src_purlist", (String)selectFields, (QFilter[])new QFilter[]{filter})) {
            HashMap<String, DynamicObject> compKey_objMap = new HashMap<String, DynamicObject>(4);
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj);
            for (String compKey : compKeyList) {
                DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey);
                if (null == compObj) continue;
                compKey_objMap.put(compKey, compObj);
            }
            billID_objMap.put(obj.getPkValue().toString(), obj);
            billID_compKeyMap.putIfAbsent(obj.getPkValue().toString(), compKey_objMap);
        }
        Map<String, List<String>> supKey_packageId = SrcTenderUtil.getSupGroupSet(objs, bidChangeObjs);
        Map<String, List<String>> supKey_matIdMap = SrcTenderUtil.getSupMatGroupSet(objs, bidChangeObjs);
        ArrayList<String> supKeyList = new ArrayList<String>();
        supKeyList.addAll(supKey_packageId.keySet());
        supKeyList.addAll(supKey_matIdMap.keySet());
        if (supKeyList.size() == 0) {
            return;
        }
        for (String supGroup : supKeyList) {
            String billId;
            DynamicObject billObj;
            Object[] keys = CommonUtil.str2objs((String)supGroup, (String)"_");
            if (keys.length < 1 || null == (billObj = (DynamicObject)billID_objMap.get(billId = keys[0].toString()))) continue;
            Map compKey_objMap = (Map)billID_compKeyMap.get(billId);
            List<String> pkgOrPurListidList = null;
            String manageType = billObj.getString("managetype");
            pkgOrPurListidList = "3".equals(manageType) ? supKey_matIdMap.get(supGroup) : supKey_packageId.get(supGroup);
            DynamicObject quoBill = SrcQuoteUtil.createQuoBill(supGroup, billObj, bidChangeObjs);
            SrcQuoteUtil.createCompData(quoBill, pkgOrPurListidList, compKey_objMap, manageType);
        }
    }

    private static DynamicObject createQuoBill(String supGroup, DynamicObject billObj, DynamicObject[] bidChangeObjs) {
        DynamicObject bizPartner;
        DynamicObject org;
        DynamicObject quoBill = BusinessDataServiceHelper.newDynamicObject((String)"tnd_quotebill");
        Object[] keys = CommonUtil.str2objs((String)supGroup, (String)"_");
        if (keys.length < 2) {
            return quoBill;
        }
        String billId = String.valueOf(keys[0]);
        String supId = String.valueOf(keys[1]);
        ORMUtil.setPrimaryKey((DynamicObject)quoBill);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tnd_quotebill", (DynamicObject)quoBill, null);
        quoBill.set("billno", (Object)billNo);
        DynamicObject template = billObj.getDynamicObject("template");
        if (null != template) {
            quoBill.set("template", template.getPkValue());
        }
        quoBill.set("org", null == (org = billObj.getDynamicObject("org")) ? Long.valueOf(0L) : org.getPkValue());
        quoBill.set("supplier", (Object)supId);
        String supType = SupplierUtil.getSupType((DynamicObject)billObj);
        quoBill.set("suppliertype", (Object)supType);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(supId), (String)supType);
        if (null != supplier && null != (bizPartner = SupplierUtil.getBizPartner((Object)supplier.getPkValue(), (String)supType))) {
            quoBill.set("bizpartner", bizPartner.getPkValue());
        }
        quoBill.set("project", (Object)billId);
        quoBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date now = TimeServiceHelper.now();
        Date deadLine = billObj.getDate("stopbiddate") == null ? SrcDateUtils.getMaxDate() : billObj.getDate("stopbiddate");
        quoBill.set("deadline", (Object)deadLine);
        quoBill.set("createtime", (Object)now);
        quoBill.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        quoBill.set("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
        String sourceType = billObj.getString("sourcetype.number");
        boolean isViePublish = billObj.getBoolean("projectf7.isviepublish");
        if (SourceTypeEnums.VIE.getValue().equals(sourceType) || SourceTypeEnums.ELECTRONIC_AUCTION.getValue().equals(sourceType) || isViePublish) {
            quoBill.set("iscompete", (Object)Boolean.TRUE);
            quoBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
        }
        quoBill.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
        quoBill.set("opentype", (Object)PdsCommonUtils.object2String((Object)billObj.get("projectf7.opentype"), (String)"1"));
        quoBill.set("isadd", (Object)billObj.getBoolean("isadd"));
        if (bidChangeObjs != null && bidChangeObjs.length > 0) {
            quoBill.set("remark", (Object)bidChangeObjs[0].getString("remark"));
        }
        SupplierUtil.setIsPurAgent((DynamicObject)quoBill, (long)Long.parseLong(billId), (long)Long.parseLong(supId));
        SupplierUtil.setSupplierUser((DynamicObject)quoBill, (long)Long.parseLong(billId), (long)Long.parseLong(supId));
        TemplateUtil.createTplEntryData((DynamicObject)billObj, (DynamicObject)quoBill);
        TndQuoteUtil.copyDynamicObjectValueByTarget((DynamicObject)billObj, (DynamicObject)quoBill);
        Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{quoBill});
        if (objs.length > 0) {
            // empty if block
        }
        return quoBill;
    }

    private static void createCompData(DynamicObject quoBill, List<String> idList, Map<String, DynamicObject> compKey_objMap, String manageType) {
        String supType = quoBill.getString("suppliertype");
        long supplierId = quoBill.getLong("supplier");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)supType);
        DynamicObject supTaxItemObj = supplier.getDynamicObject("taxrate");
        boolean isByPackage = "2".equals(manageType);
        Map supplier_PurlistIdSet = TenderSupplierUtils.getSupplier_PurlistIdSet((String)"src_supplierinvite", (long)quoBill.getLong("project"), (long)supplierId, (boolean)isByPackage);
        List compKeys = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)quoBill.getLong("project"), (String)"src_purlist"));
        for (Map.Entry<String, DynamicObject> compKey_obj : compKey_objMap.entrySet()) {
            DynamicObject compData = compKey_obj.getValue();
            String compKey = compKey_obj.getKey();
            DynamicObject newCompData = (DynamicObject)OrmUtils.clone((IDataEntityBase)compData, (boolean)false, (boolean)true);
            newCompData.set("parentid", quoBill.getPkValue());
            newCompData.set("entitykey", (Object)compKey);
            newCompData.set("pentitykey", (Object)quoBill.getDynamicObjectType().getName());
            newCompData.set("origin", (Object)"2");
            DynamicObjectCollection newCols = null;
            try {
                newCols = newCompData.getDynamicObjectCollection("entryentity");
            }
            catch (Exception e) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
                continue;
            }
            SrcQuoteUtil.setOtherCompEntryData(compKey, quoBill, newCompData);
            newCols.clear();
            DynamicObjectCollection cols = compData.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                if ("3".equals(manageType)) {
                    String purlistId;
                    Object purListObj = col.get("purlist");
                    if (!(purListObj instanceof DynamicObject) || !idList.contains(purlistId = String.valueOf(((DynamicObject)purListObj).getPkValue()))) {
                        continue;
                    }
                } else {
                    String sup_Pkg_key;
                    Set purlistIds;
                    Object packageObj = col.get("package");
                    if (packageObj instanceof String) continue;
                    DynamicObject packageDyObj = (DynamicObject)packageObj;
                    if (null != packageObj) {
                        String packageName = packageDyObj.getString("packagename");
                        if (!idList.contains(packageDyObj.getPkValue().toString()) && !StringUtils.equals((CharSequence)packageName, (CharSequence)"ByItem")) continue;
                    }
                    if (null != (purlistIds = (Set)supplier_PurlistIdSet.get(sup_Pkg_key = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)col, (boolean)isByPackage, (long)PdsCommonUtils.object2Long((Object)supplierId), (long)0L))) && purlistIds.size() > 0 && !purlistIds.contains(col.getLong("id"))) continue;
                }
                DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
                newCol.set("supplier", quoBill.get("supplier"));
                if (compKeys.contains(compData.getDataEntityType().getExtendName())) {
                    newCol.set("suppliername", (Object)supplier.getString("name"));
                }
                newCol.set("supplier_id", quoBill.get("supplier"));
                newCol.set("suppliertype", quoBill.get("suppliertype"));
                newCol.set("billtype", (Object)"2");
                newCol.set("compkey", (Object)compKey);
                String turns = newCol.getString("turns");
                if (null == turns || turns.trim().length() == 0) {
                    newCol.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
                }
                if (null != supTaxItemObj && null == newCol.getDynamicObject("taxitem")) {
                    newCol.set("taxitem", supTaxItemObj.getPkValue());
                    newCol.set("taxitem_id", supTaxItemObj.getPkValue());
                    BigDecimal taxRateVal = supTaxItemObj.getBigDecimal("taxrate");
                    newCol.set("taxrate", (Object)taxRateVal);
                }
                newCol.set("costdetail", (Object)"0");
                newCols.add((Object)newCol);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
            PdsCostDetailUtils.handleCostDetail((String)"src_costdetail", (DynamicObjectCollection)cols, (boolean)true);
        }
    }

    private static void setOtherCompEntryData(String compKey, DynamicObject quoteObj, DynamicObject newCompData) {
        if ("src_purlist_item".equals(compKey)) {
            Object project = quoteObj.get("project");
            Object supplier = quoteObj.get("supplier");
            DynamicObjectCollection newCols = newCompData.getDynamicObjectCollection("itementity");
            for (DynamicObject col : newCols) {
                col.set("itemsupplier", supplier);
                col.set("itemsupplier_id", supplier);
                col.set("itemproject", project);
                col.set("itemproject_id", project);
            }
        }
    }
}

