/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcSchemeChgUtils {
    public static void updateConfigScheme(String configF7Name, Long projectId, Map<Long, DynamicObject> newAptSchemeMap) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("id", "in", newAptSchemeMap.keySet());
        String selectFields = DynamicObjectUtil.getSelectfields((String)configF7Name, (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)configF7Name, (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        boolean isAptitude = "src_aptitudeconfigf7".equals(configF7Name) || "src_aptitudeconfig2f7".equals(configF7Name);
        for (DynamicObject row : rows) {
            DynamicObject newSchemeObj;
            DynamicObject obj = newAptSchemeMap.get(row.getLong("id"));
            if (!Objects.nonNull(obj) || null == (newSchemeObj = obj.getDynamicObject("newscheme"))) continue;
            row.set("scheme", newSchemeObj.getPkValue());
            row.set("entrystatus", (Object)"A");
            row.set("expertcount", (Object)newSchemeObj.getInt("expertcount"));
            if (!isAptitude) continue;
            row.set("sumscore", (Object)newSchemeObj.getBigDecimal("sumscore"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public static void deleteConfigSchemeData(String resultF7Name, long projectId, Set<Long> packageIds, Set<Long> oldSchemeIds) {
        QFilter resultFilter = new QFilter("billid", "=", (Object)projectId);
        resultFilter.and("scoretask.package", "in", packageIds);
        resultFilter.and("scoretask.scheme", "in", oldSchemeIds);
        DeleteServiceHelper.delete((String)resultF7Name, (QFilter[])resultFilter.toArray());
        QFilter taskFilter = new QFilter("project", "=", (Object)projectId);
        taskFilter.and("package", "in", packageIds);
        taskFilter.and("scheme", "in", oldSchemeIds);
        taskFilter.and("bizstatus", "!=", (Object)"E");
        DeleteServiceHelper.delete((String)"src_scoretask", (QFilter[])taskFilter.toArray());
    }

    public static String getTemplateNumber(Object templateObj) {
        DynamicObject templateDy = null;
        Object template = templateObj;
        if (null == template || !(template instanceof DynamicObject)) {
            return null;
        }
        templateDy = (DynamicObject)template;
        String templateNumber = templateDy.getString("number");
        return templateNumber;
    }

    public static void updateConfigScorer(String configF7Name, Long projectId, Map<Long, DynamicObject> newAptSchemeMap) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("id", "in", newAptSchemeMap.keySet());
        String selectFields = DynamicObjectUtil.getSelectfields((String)configF7Name, (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)configF7Name, (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection newscorer;
            DynamicObject obj = newAptSchemeMap.get(row.getLong("id"));
            if (!Objects.nonNull(obj) || (newscorer = (DynamicObjectCollection)obj.get("newscorer")).size() == 0) continue;
            row.set("scorer", (Object)PdsCommonUtils.cloneCols((DynamicObject)obj, (String)"newscorer"));
            row.set("entrystatus", (Object)"A");
            if (row.getInt("expertcount") <= 0) continue;
            row.set("expertcount", (Object)newscorer.size());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public static void updateTenderSupplier(String fieldName, Long projectId, Set<Long> packageIds) {
        QFilter qfilter = new QFilter("billid.id", "=", (Object)projectId);
        qfilter.and("package.id", "in", packageIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)true);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set(fieldName, (Object)"A");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public static void updateEnrollSupplier(String fieldName, Long projectId, Set<Long> packageIds) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("package.id", "in", packageIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_enrollsupplier", (boolean)true);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_enrollsupplier", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set(fieldName, (Object)"A");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

