/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.OpenFormUtils;

public class SrcScoreUtil {
    public static void setPackageStatus(Set<Long> billIds) {
        DynamicObject[] packagebills = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)"billid,package,istecassess,tecassessdate,isbizassess,bizassessdate", (QFilter[])new QFilter[]{new QFilter("billid", "in", billIds)});
        if (packagebills == null || packagebills.length == 0) {
            return;
        }
        boolean haveChange = false;
        for (DynamicObject packagebill : packagebills) {
            boolean isBizScore;
            long projectId = packagebill.getLong("billid");
            long packagId = SrmCommonUtil.getPkValue((DynamicObject)packagebill.getDynamicObject("package"));
            QFilter qFilter = new QFilter("project.id", "=", (Object)projectId).and("package.id", "=", (Object)packagId);
            qFilter.and("bizstatus", "!=", (Object)"E");
            DynamicObject[] scoreRows = BusinessDataServiceHelper.load((String)"src_scoretask", (String)"bizstatus,indextype", (QFilter[])new QFilter[]{qFilter});
            if (scoreRows == null || scoreRows.length == 0) continue;
            boolean isTecScore = Arrays.stream(scoreRows).filter(obj -> !Objects.equals("SYS002", obj.getString("indextype.number"))).allMatch(obj -> SrmScoreStatusEnum.SCORED.getValue().equals(obj.getString("bizstatus")));
            if (isTecScore && !packagebill.getBoolean("istecassess")) {
                packagebill.set("istecassess", (Object)"1");
                packagebill.set("tecassessdate", (Object)TimeServiceHelper.now());
                haveChange = true;
            }
            if (!(isBizScore = Arrays.stream(scoreRows).filter(obj -> Objects.equals("SYS002", obj.getString("indextype.number"))).allMatch(obj -> SrmScoreStatusEnum.SCORED.getValue().equals(obj.getString("bizstatus")))) || packagebill.getBoolean("isbizassess")) continue;
            packagebill.set("isbizassess", (Object)"1");
            packagebill.set("bizassessdate", (Object)TimeServiceHelper.now());
            haveChange = true;
        }
        if (haveChange) {
            SaveServiceHelper.save((DynamicObject[])packagebills);
        }
    }

    public static void openSchemeRuleF7(IFormView view, String callbackClassName, String key) {
        EntryGrid entryentity = (EntryGrid)view.getControl("score_entry");
        int[] selectRows = entryentity.getSelectRows();
        QFilter qfilters = null;
        if (selectRows.length == 0) {
            return;
        }
        DynamicObject indexObj = ((DynamicObject)view.getModel().getEntryEntity("score_entry").get(selectRows[0])).getDynamicObject("index");
        qfilters = new QFilter("entryid", "=", indexObj.getPkValue());
        if (indexObj.getLong("srcindexid") > 0L) {
            qfilters.or("entryid", "=", (Object)indexObj.getLong("srcindexid"));
        }
        if (QueryServiceHelper.exists((String)"src_schemerulef7", (QFilter[])qfilters.toArray())) {
            OpenFormUtils.openBaseF7Page((IFormView)view, (String)"src_schemerulef7", (ShowType)ShowType.Modal, null, (QFilter)qfilters, (CloseCallBack)new CloseCallBack(callbackClassName, "src_schemerulef7"), (boolean)false);
            view.getPageCache().put("src_schemerulef7", key);
        } else {
            long billId = indexObj.getLong("indexlib.id");
            if (billId == 0L) {
                billId = indexObj.getLong("srcindexlibid");
            }
            if (billId > 0L) {
                QFilter indexFilters = new QFilter("billid", "=", (Object)billId);
                if (QueryServiceHelper.exists((String)"src_indexentryf7", (QFilter[])indexFilters.toArray())) {
                    OpenFormUtils.openBaseF7Page((IFormView)view, (String)"src_indexentryf7", (ShowType)ShowType.Modal, null, (QFilter)indexFilters, (CloseCallBack)new CloseCallBack(callbackClassName, "src_indexentryf7"), (boolean)false);
                    view.getPageCache().put("src_indexentryf7", key);
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6307\u6807\u672a\u8bbe\u7f6e\u8bc4\u5206\u89c4\u5219\uff0c\u8bf7\u5230\u8bc4\u5206\u65b9\u6848\u6216\u6307\u6807\u5e93\u4e2d\u8bbe\u7f6e\u8bc4\u5206\u89c4\u5219\u3002", (String)"SrcScoreUtil_0", (String)"scm-src-common", (Object[])new Object[0]));
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6307\u6807\u672a\u8bbe\u7f6e\u8bc4\u5206\u89c4\u5219\uff0c\u8bf7\u5230\u8bc4\u5206\u65b9\u6848\u6216\u6307\u6807\u5e93\u4e2d\u8bbe\u7f6e\u8bc4\u5206\u89c4\u5219\u3002", (String)"SrcScoreUtil_0", (String)"scm-src-common", (Object[])new Object[0]));
            }
        }
    }
}

