/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.util.PdsAptitudeUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.pds.common.util.SrcTypeUtil;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.util.TenderSupplierUtils;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import org.apache.commons.lang3.StringUtils;

public class SrcTenderUtil {
    private static final String BILLID_OBJ = "billID_obj";
    private static final String BILLID_COMPKEY = "billID_compKey";

    public static OperationResult deleteTenderBill(DynamicObject[] objs) {
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])objs, (String)"id");
        if (idList.size() == 0) {
            return new OperationResult();
        }
        QFilter filter = new QFilter("project", "in", (Object)idList);
        DynamicObjectCollection tenBillRows = QueryServiceHelper.query((String)"tnd_tenderbill", (String)"id", (QFilter[])new QFilter[]{filter});
        List tecBillIdList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)tenBillRows, (String)"id");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        return OperationServiceHelper.executeOperate((String)"delete", (String)"tnd_tenderbill", (Object[])tecBillIdList.toArray(new Long[0]), (OperateOption)option);
    }

    public static boolean isSupplierTendered(DynamicObject obj) {
        QFilter filter = new QFilter("project", "=", obj.getPkValue());
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        return QueryServiceHelper.exists((String)"tnd_tenderbill", (QFilter[])new QFilter[]{filter});
    }

    public static void createTenderBill(DynamicObject[] objs, List<DynamicObject> supColList, boolean mergePurList) {
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])objs, (String)"id");
        if (idList.size() == 0) {
            return;
        }
        HashMap<String, DynamicObject> billID_objMap = new HashMap<String, DynamicObject>(4);
        HashMap<String, Map<String, DynamicObject>> billID_compKeyMap = new HashMap<String, Map<String, DynamicObject>>(4);
        SrcTenderUtil.getDocData("src_biddoc", idList, billID_objMap, billID_compKeyMap);
        List<Long> notDocDataIdList = new ArrayList();
        if (billID_compKeyMap.size() == 0) {
            notDocDataIdList = idList;
        } else {
            for (Map.Entry<String, Map<String, DynamicObject>> billID_compKeyEntry : billID_compKeyMap.entrySet()) {
                Map<String, DynamicObject> compDataMap = billID_compKeyEntry.getValue();
                if (compDataMap.size() != 0) continue;
                notDocDataIdList.add(Long.valueOf(billID_compKeyEntry.getKey()));
            }
        }
        if (notDocDataIdList.size() > 0) {
            SrcTenderUtil.getDocData("src_project", notDocDataIdList, billID_objMap, billID_compKeyMap);
        }
        HashMap purListBillID_objMap = new HashMap(4);
        HashMap purListBillID_compKeyMap = new HashMap(4);
        if (mergePurList) {
            Map<String, Object> purListGroupDataMap = SrcTenderUtil.getPurlistGroupData(idList);
            if (null != purListGroupDataMap.get(BILLID_COMPKEY)) {
                purListBillID_compKeyMap = (HashMap)purListGroupDataMap.get(BILLID_COMPKEY);
            }
            if (null != purListGroupDataMap.get(BILLID_OBJ)) {
                purListBillID_objMap = (HashMap)purListGroupDataMap.get(BILLID_OBJ);
            }
        }
        boolean isSpiltDoc = false;
        Map<String, List<String>> supKey_packageId = SrcTenderUtil.getSupGroupSetByData(objs, supColList);
        ArrayList<String> supKeyList = new ArrayList<String>(supKey_packageId.keySet());
        for (String supKey : supKeyList) {
            Object[] tenObjs;
            DynamicObject purlistObj;
            String billId;
            DynamicObject billObj;
            Object[] keys = CommonUtil.str2objs((String)supKey, (String)"_");
            if (keys.length < 1 || null == (billObj = billID_objMap.get(billId = keys[0].toString())) || null == (purlistObj = (DynamicObject)purListBillID_objMap.get(billId))) continue;
            String manageType = purlistObj.getString("managetype");
            isSpiltDoc = billObj.getBoolean("issplitdoc");
            Map<String, DynamicObject> compKey_objMap = billID_compKeyMap.get(billId);
            List<String> pkgOrPurListidList = supKey_packageId.get(supKey);
            DynamicObject tendeBill = SrcTenderUtil.createTenBill(supKey, billObj, null);
            DynamicObject template = tendeBill.getDynamicObject("template");
            HashSet<String> compKeySet = new HashSet<String>(compKey_objMap.keySet());
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)billObj, (DynamicObject)template, (boolean)false);
            compKeySet.addAll(compKeyList);
            TemplateUtil.createTplEntryData((DynamicObject)billObj, (DynamicObject)tendeBill, compKeySet, (boolean)false);
            DynamicObject purListData = (DynamicObject)purListBillID_objMap.get(billId);
            if (null != purListData) {
                TemplateUtil.createTplEntryData((DynamicObject)purListData, (DynamicObject)tendeBill, (boolean)true);
            }
            if ((tenObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tendeBill})).length <= 0) continue;
            Map purListCompKey_objMap = (Map)purListBillID_compKeyMap.get(billId);
            if (null != purListCompKey_objMap) {
                compKey_objMap.putAll(purListCompKey_objMap);
            }
            SrcTenderUtil.createCompData(tendeBill, pkgOrPurListidList, compKey_objMap, isSpiltDoc, manageType);
        }
    }

    public static void createTenderBill(DynamicObject[] objs, boolean mergePurList, DynamicObject[] bidChangeObjs) {
        List idList = DynamicObjectUtil.array2ListId((DynamicObject[])objs, (String)"id");
        if (idList.size() == 0) {
            return;
        }
        HashMap<String, DynamicObject> billID_objMap = new HashMap<String, DynamicObject>(4);
        HashMap<String, Map<String, DynamicObject>> billID_compKeyMap = new HashMap<String, Map<String, DynamicObject>>(4);
        SrcTenderUtil.getDocData("src_biddoc", idList, billID_objMap, billID_compKeyMap);
        List<Long> notDocDataIdList = new ArrayList();
        if (billID_compKeyMap.size() == 0) {
            notDocDataIdList = idList;
        } else {
            for (Map.Entry<String, Map<String, DynamicObject>> billID_compKeyEntry : billID_compKeyMap.entrySet()) {
                Map<String, DynamicObject> compDataMap = billID_compKeyEntry.getValue();
                if (compDataMap.size() != 0) continue;
                notDocDataIdList.add(Long.valueOf(billID_compKeyEntry.getKey()));
            }
        }
        if (notDocDataIdList.size() > 0) {
            SrcTenderUtil.getDocData("src_project", notDocDataIdList, billID_objMap, billID_compKeyMap);
        }
        if (notDocDataIdList.size() > 0) {
            SrcTenderUtil.getDocData("src_bidpublish", notDocDataIdList, billID_objMap, billID_compKeyMap);
        }
        HashMap purListBillID_objMap = new HashMap(4);
        HashMap purListBillID_compKeyMap = new HashMap(4);
        if (mergePurList) {
            Map<String, Object> purListGroupDataMap = SrcTenderUtil.getPurlistGroupData(idList);
            if (null != purListGroupDataMap.get(BILLID_COMPKEY)) {
                purListBillID_compKeyMap = (HashMap)purListGroupDataMap.get(BILLID_COMPKEY);
            }
            if (null != purListGroupDataMap.get(BILLID_OBJ)) {
                purListBillID_objMap = (HashMap)purListGroupDataMap.get(BILLID_OBJ);
            }
        }
        boolean isSpiltDoc = false;
        Map<String, List<String>> supKey_packageId = SrcTenderUtil.getSupGroupSet(objs, bidChangeObjs);
        Map<String, List<String>> supKey_matIdMap = SrcTenderUtil.getSupMatGroupSet(objs, bidChangeObjs);
        ArrayList<String> supKeyList = new ArrayList<String>();
        supKeyList.addAll(supKey_packageId.keySet());
        supKeyList.addAll(supKey_matIdMap.keySet());
        for (String supKey : supKeyList) {
            Object[] tenObjs;
            DynamicObject purlistObj;
            String billId;
            DynamicObject billObj;
            Object[] keys = CommonUtil.str2objs((String)supKey, (String)"_");
            if (keys.length < 1 || null == (billObj = billID_objMap.get(billId = keys[0].toString())) || null == (purlistObj = (DynamicObject)purListBillID_objMap.get(billId))) continue;
            boolean isItemSup = false;
            String manageType = purlistObj.getString("managetype");
            if ("3".equals(manageType)) {
                isItemSup = true;
            }
            isSpiltDoc = billObj.getBoolean("issplitdoc");
            Map<String, DynamicObject> compKey_objMap = billID_compKeyMap.get(billId);
            List<String> pkgOrPurListidList = null;
            pkgOrPurListidList = isItemSup ? supKey_matIdMap.get(supKey) : supKey_packageId.get(supKey);
            DynamicObject tendeBill = SrcTenderUtil.createTenBill(supKey, billObj, bidChangeObjs);
            DynamicObject template = tendeBill.getDynamicObject("template");
            HashSet<String> compKeySet = new HashSet<String>(compKey_objMap.keySet());
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)billObj, (DynamicObject)template, (boolean)false);
            compKeySet.addAll(compKeyList);
            TemplateUtil.createTplEntryData((DynamicObject)billObj, (DynamicObject)tendeBill, compKeySet, (boolean)false);
            DynamicObject purListData = (DynamicObject)purListBillID_objMap.get(billId);
            if (null != purListData) {
                TemplateUtil.createTplEntryData((DynamicObject)purListData, (DynamicObject)tendeBill, (boolean)true);
            }
            if ((tenObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tendeBill})).length <= 0) continue;
            Map purListCompKey_objMap = (Map)purListBillID_compKeyMap.get(billId);
            if (null != purListCompKey_objMap) {
                compKey_objMap.putAll(purListCompKey_objMap);
            }
            SrcTenderUtil.createCompData(tendeBill, pkgOrPurListidList, compKey_objMap, isSpiltDoc, manageType);
        }
    }

    private static void getDocData(String entityKey, List<Long> idList, HashMap<String, DynamicObject> billID_objMap, HashMap<String, Map<String, DynamicObject>> billID_compKeyMap) {
        String selectFields = "id,template,issplitdoc,ismustapply,srctype,org,stopbiddate,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject";
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] bidDocObjs = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        if (bidDocObjs == null || bidDocObjs.length == 0) {
            return;
        }
        for (DynamicObject obj : bidDocObjs) {
            HashMap<String, DynamicObject> compKey_objMap = new HashMap<String, DynamicObject>(4);
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj);
            boolean isSplitDoc = obj.getBoolean("issplitdoc");
            for (String compKey : compKeyList) {
                DynamicObject compObj = null;
                if (compKey.equals("src_biddoc_tnd")) {
                    if (isSplitDoc) {
                        compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)"src_biddoc_tnd");
                    }
                } else {
                    if (!compKey.equals("src_biddoc_src")) continue;
                    compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)"src_biddoc_src");
                }
                compKey_objMap.put(compKey, compObj);
            }
            DynamicObject srcDocObj = (DynamicObject)compKey_objMap.get("src_biddoc_src");
            if (null == compKey_objMap.get("src_biddoc_tnd") && null != srcDocObj) {
                compKey_objMap.put("src_biddoc_tnd", srcDocObj);
            }
            if (compKey_objMap.size() <= 0) continue;
            billID_objMap.put(obj.getPkValue().toString(), obj);
            billID_compKeyMap.put(obj.getPkValue().toString(), compKey_objMap);
        }
    }

    public static Map<String, List<String>> getSupGroupSetByData(DynamicObject[] objs, List<DynamicObject> supList) {
        HashMap<String, List<String>> supKey_packageId = new HashMap<String, List<String>>(8);
        for (DynamicObject obj : objs) {
            boolean isItemSup = false;
            String manageType = obj.getString("managetype");
            if ("3".equals(manageType)) {
                isItemSup = true;
            }
            if (isItemSup) continue;
            DynamicObject bidDocObj = QueryServiceHelper.queryOne((String)"src_biddoc", (String)"ismustapply", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(obj.getPkValue().toString()))});
            boolean isMustApply = bidDocObj.getBoolean("ismustapply");
            for (DynamicObject col : supList) {
                boolean isdiscard = col.getBoolean("isdiscard");
                if (isdiscard) continue;
                DynamicObject supplier = col.getDynamicObject("supplier");
                DynamicObject packageObj = col.getDynamicObject("package");
                if (null == supplier || (isMustApply ? !col.getBoolean("isinvite") || !col.getBoolean("isconfirm") && !col.getBoolean("ispuragent") : !col.getBoolean("isinvite"))) continue;
                StringBuilder groupSb = new StringBuilder();
                groupSb.append(obj.getPkValue()).append('_').append(supplier.getPkValue());
                ArrayList<String> packageIdList = (ArrayList<String>)supKey_packageId.get(groupSb.toString());
                if (null == packageIdList) {
                    packageIdList = new ArrayList<String>();
                }
                if (null != packageObj) {
                    packageIdList.add(packageObj.getPkValue().toString());
                } else {
                    DynamicObject[] packageObjs;
                    QFilter qFilter = new QFilter("project.id", "=", obj.getPkValue());
                    for (DynamicObject tempObj : packageObjs = BusinessDataServiceHelper.load((String)"src_packagef7", (String)"package", (QFilter[])new QFilter[]{qFilter})) {
                        DynamicObject pakObj = tempObj.getDynamicObject("package");
                        if (pakObj == null) continue;
                        packageIdList.add(pakObj.getPkValue().toString());
                    }
                }
                supKey_packageId.put(groupSb.toString(), packageIdList);
            }
        }
        return supKey_packageId;
    }

    public static Map<String, List<String>> getSupGroupSet(DynamicObject[] objs, DynamicObject[] bidChangeObjs) {
        HashMap<String, List<String>> supKey_packageId = new HashMap<String, List<String>>(8);
        int i = 0;
        boolean isChangeObj = false;
        for (DynamicObject obj : objs) {
            boolean isItemSup = false;
            String manageType = obj.getString("managetype");
            if ("3".equals(manageType)) {
                isItemSup = true;
            }
            if (isItemSup) continue;
            String entityKey = obj.getDynamicObjectType().getName();
            DynamicObject compObj = null;
            boolean hasNode = SrcBidCompTplUtil.hasNode(obj, "src_selectsupplier");
            if (bidChangeObjs != null && bidChangeObjs.length > 0) {
                hasNode = false;
                isChangeObj = true;
                compObj = TemplateUtil.getCompData((DynamicObject)bidChangeObjs[i], (String)"src_invitesupplier_chg");
            } else {
                compObj = hasNode || "src_selectsupplier".equals(entityKey) ? TemplateUtil.getCompData((DynamicObject)obj, (String)"src_supplier_select") : TemplateUtil.getCompData((DynamicObject)obj, (String)"src_supplier_invite");
            }
            if (null == compObj) continue;
            DynamicObject bidDocObj = QueryServiceHelper.queryOne((String)"src_biddoc", (String)"ismustapply", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(obj.getPkValue().toString()))});
            boolean isMustApply = bidDocObj.getBoolean("ismustapply");
            DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entrysupplier");
            for (DynamicObject col : cols) {
                String publishStatus;
                String isAptitude;
                boolean isdiscard = col.getBoolean("isdiscard");
                if (isdiscard || !isChangeObj && "2".equals(isAptitude = col.getString("isaptitude"))) continue;
                DynamicObject supplier = col.getDynamicObject("supplier");
                DynamicObject packageObj = col.getDynamicObject("package");
                if (null == supplier || (!isMustApply ? !col.getBoolean("isinvite") : !col.getBoolean("isinvite") || !col.getBoolean("isconfirm") && !col.getBoolean("ispuragent"))) continue;
                if ((hasNode || "src_selectsupplier".equals(entityKey)) && "B".equals(publishStatus = col.getString("publishstatus"))) continue;
                StringBuilder groupSb = new StringBuilder();
                groupSb.append(obj.getPkValue()).append('_').append(supplier.getPkValue());
                ArrayList<String> packageIdList = (ArrayList<String>)supKey_packageId.get(groupSb.toString());
                if (null == packageIdList) {
                    packageIdList = new ArrayList<String>();
                }
                if (null != packageObj) {
                    packageIdList.add(packageObj.getPkValue().toString());
                } else {
                    DynamicObject[] packageObjs;
                    QFilter qFilter = new QFilter("project.id", "=", obj.getPkValue());
                    for (DynamicObject tempObj : packageObjs = BusinessDataServiceHelper.load((String)"src_packagef7", (String)"package", (QFilter[])new QFilter[]{qFilter})) {
                        DynamicObject pakObj = tempObj.getDynamicObject("package");
                        if (pakObj == null) continue;
                        packageIdList.add(pakObj.getPkValue().toString());
                    }
                }
                supKey_packageId.put(groupSb.toString(), packageIdList);
            }
            ++i;
        }
        return supKey_packageId;
    }

    public static Map<String, List<String>> getSupMatGroupSet(DynamicObject[] objs, DynamicObject[] bidChangeObjs) {
        HashMap<String, List<String>> supKey_matId = new HashMap<String, List<String>>(8);
        int i = 0;
        for (DynamicObject obj : objs) {
            boolean isItemSup = false;
            String manageType = obj.getString("managetype");
            if ("3".equals(manageType)) {
                isItemSup = true;
            }
            if (!isItemSup) continue;
            DynamicObject compObj = null;
            compObj = bidChangeObjs == null || bidChangeObjs.length == 0 ? TemplateUtil.getCompData((DynamicObject)obj, (String)"src_itemsupplier") : TemplateUtil.getCompData((DynamicObject)bidChangeObjs[i], (String)"src_itemsupplier_chg");
            if (null == compObj) continue;
            Set invaludSupplierIds = PdsAptitudeUtils.getAptitudeInvalidSupplierIds((long)SrmCommonUtil.getPkValue((DynamicObject)obj), (String)manageType);
            DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                DynamicObjectCollection supplierCols = col.getDynamicObjectCollection("supplier");
                if (null == supplierCols) continue;
                DynamicObject purlistObj = col.getDynamicObject("purlist");
                for (DynamicObject supplierCol : supplierCols) {
                    StringBuilder groupSb = new StringBuilder();
                    Object supObj = supplierCol.get("fbasedataid");
                    if (!(supObj instanceof DynamicObject) || null != invaludSupplierIds && invaludSupplierIds.size() > 0 && invaludSupplierIds.contains(((DynamicObject)supObj).getPkValue().toString())) continue;
                    groupSb.append(obj.getPkValue()).append('_').append(((DynamicObject)supObj).getPkValue());
                    ArrayList<String> materialIdList = (ArrayList<String>)supKey_matId.get(groupSb.toString());
                    if (null == materialIdList) {
                        materialIdList = new ArrayList<String>();
                    }
                    materialIdList.add(purlistObj.getPkValue().toString());
                    supKey_matId.put(groupSb.toString(), materialIdList);
                }
            }
            ++i;
        }
        return supKey_matId;
    }

    private static Map<String, Object> getPurlistGroupData(List<Long> idList) {
        DynamicObject[] purListObjs;
        QFilter filter = new QFilter("id", "in", idList);
        HashMap<String, Object> purListDataMap = new HashMap<String, Object>(2);
        HashMap<String, DynamicObject> billID_objMap = new HashMap<String, DynamicObject>(4);
        HashMap billID_compKeyMap = new HashMap(4);
        for (DynamicObject obj : purListObjs = BusinessDataServiceHelper.load((String)"src_purlist", (String)"id,template,ismustapply,managetype,isitemsupplier,stopbiddate,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject", (QFilter[])new QFilter[]{filter})) {
            HashMap<String, DynamicObject> compKey_objMap = new HashMap<String, DynamicObject>(4);
            List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj);
            for (String compKey : compKeyList) {
                DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey);
                if (null == compObj) continue;
                compKey_objMap.put(compKey, compObj);
            }
            billID_objMap.put(obj.getPkValue().toString(), obj);
            billID_compKeyMap.putIfAbsent(obj.getPkValue().toString(), compKey_objMap);
        }
        purListDataMap.put(BILLID_OBJ, billID_objMap);
        purListDataMap.put(BILLID_COMPKEY, billID_compKeyMap);
        return purListDataMap;
    }

    private static DynamicObject createTenBill(String supGroup, DynamicObject billObj, DynamicObject[] bidChangeObjs) {
        DynamicObject bizPartner;
        DynamicObject org;
        DynamicObject template;
        DynamicObject tenBill = BusinessDataServiceHelper.newDynamicObject((String)"tnd_tenderbill");
        Object[] keys = CommonUtil.str2objs((String)supGroup, (String)"_");
        if (keys.length < 2) {
            return tenBill;
        }
        String billId = String.valueOf(keys[0]);
        String supId = String.valueOf(keys[1]);
        ORMUtil.setPrimaryKey((DynamicObject)tenBill);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tnd_tenderbill", (DynamicObject)tenBill, null);
        tenBill.set("billno", (Object)billNo);
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(billId));
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"srctype", (QFilter[])new QFilter[]{filter});
        if (null != projectObj && null != (template = SrcTypeUtil.getTemplateBySrcType((Object)projectObj.get("srctype"), (String)"tnd_tenderbill"))) {
            tenBill.set("template", (Object)template);
        }
        tenBill.set("org", null == (org = billObj.getDynamicObject("org")) ? Long.valueOf(0L) : org.getPkValue());
        tenBill.set("supplier", (Object)supId);
        String supType = SupplierUtil.getSupType((DynamicObject)billObj);
        tenBill.set("suppliertype", (Object)supType);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)supId, (String)supType);
        if (null != supplier && null != (bizPartner = SupplierUtil.getBizPartner((Object)supplier.getPkValue(), (String)supType))) {
            tenBill.set("bizpartner", bizPartner.getPkValue());
        }
        tenBill.set("project", (Object)billId);
        tenBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date now = TimeServiceHelper.now();
        Date deadLine = billObj.getDate("stopbiddate") == null ? SrcDateUtils.getMaxDate() : billObj.getDate("stopbiddate");
        tenBill.set("deadline", (Object)deadLine);
        DynamicObject purlistObj = QueryServiceHelper.queryOne((String)"src_purlist", (String)"id,isadd", (QFilter[])new QFilter[]{new QFilter("id", "=", billObj.getPkValue())});
        if (purlistObj != null) {
            tenBill.set("isadd", (Object)purlistObj.getBoolean("isadd"));
        }
        tenBill.set("createtime", (Object)now);
        tenBill.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        tenBill.set("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
        tenBill.set("isneedbiddoc", (Object)billObj.getBoolean("srctype.isneedbiddoc"));
        if (bidChangeObjs != null && bidChangeObjs.length > 0) {
            tenBill.set("remark", (Object)bidChangeObjs[0].getString("remark"));
        }
        SupplierUtil.setIsPurAgent((DynamicObject)tenBill, (long)Long.parseLong(billId), (long)Long.parseLong(supId));
        SupplierUtil.setSupplierUser((DynamicObject)tenBill, (long)Long.parseLong(billId), (long)Long.parseLong(supId));
        TndQuoteUtil.copyDynamicObjectValueByTarget((DynamicObject)billObj, (DynamicObject)tenBill);
        return tenBill;
    }

    private static void createCompData(DynamicObject tenBill, List<String> idList, Map<String, DynamicObject> compKey_objMap, boolean isSplitDoc, String manageType) {
        String supType = tenBill.getString("suppliertype");
        long supplierId = tenBill.getLong("supplier");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)supType);
        DynamicObject supTaxItemObj = supplier.getDynamicObject("taxrate");
        boolean isByPackage = "2".equals(manageType);
        Map supplier_PurlistIdSet = TenderSupplierUtils.getSupplier_PurlistIdSet((String)"src_supplierinvite", (long)tenBill.getLong("project"), (long)supplierId, (boolean)isByPackage);
        DynamicObject purlistObj = BusinessDataServiceHelper.loadSingle((Object)tenBill.getLong("project"), (String)"src_purlist");
        List compKeys = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)purlistObj);
        for (Map.Entry<String, DynamicObject> compKey_obj : compKey_objMap.entrySet()) {
            DynamicObject compData = compKey_obj.getValue();
            if (null == compData) continue;
            String compKey = compKey_obj.getKey();
            DynamicObject newCompData = (DynamicObject)OrmUtils.clone((IDataEntityBase)compData, (boolean)false, (boolean)true);
            newCompData.set("parentid", tenBill.getPkValue());
            newCompData.set("entitykey", (Object)compKey);
            newCompData.set("pentitykey", (Object)tenBill.getDynamicObjectType().getName());
            newCompData.set("origin", (Object)"2");
            SrcTenderUtil.setOtherCompEntryData(compKey, tenBill, newCompData);
            DynamicObjectCollection newCols = newCompData.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection cols = compData.getDynamicObjectCollection("entryentity");
            newCols.clear();
            for (DynamicObject col : cols) {
                if ("3".equals(manageType)) {
                    if (!(StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_tnd") || StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_src") || StringUtils.equals((CharSequence)compKey, (CharSequence)"src_purlistbizitem"))) {
                        Object purListObj = col.get("purlist");
                        if (!(purListObj instanceof DynamicObject)) continue;
                        String purlistId = String.valueOf(((DynamicObject)purListObj).getPkValue());
                        if (null != idList && !idList.contains(purlistId)) {
                            continue;
                        }
                    }
                } else {
                    String sup_Pkg_key;
                    Set purlistIds;
                    Object packageObj = col.get("package");
                    if (packageObj instanceof String) continue;
                    DynamicObject packageDyObj = (DynamicObject)packageObj;
                    if (null != packageObj) {
                        String packageName = packageDyObj.getString("packagename");
                        if (null != idList && !idList.contains(packageDyObj.getPkValue().toString()) && !StringUtils.equals((CharSequence)packageName, (CharSequence)"ByItem")) continue;
                    }
                    if (null != (purlistIds = (Set)supplier_PurlistIdSet.get(sup_Pkg_key = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)col, (boolean)isByPackage, (long)PdsCommonUtils.object2Long((Object)supplierId), (long)0L))) && purlistIds.size() > 0 && !purlistIds.contains(col.getLong("id"))) continue;
                }
                DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
                newCol.set("supplier", (Object)supplierId);
                compData.getDataEntityType().getParent();
                if (compKeys.contains(compData.getDataEntityType().getExtendName())) {
                    newCol.set("suppliername", (Object)supplier.getString("name"));
                }
                newCol.set("supplier_id", (Object)supplierId);
                newCol.set("billtype", (Object)"2");
                newCol.set("compkey", (Object)compKey);
                if (!StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_tnd") && !StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_src")) {
                    String turns = newCol.getString("turns");
                    if (null == turns || turns.trim().length() == 0) {
                        newCol.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
                    }
                    if (null != supTaxItemObj && null == newCol.getDynamicObject("taxitem")) {
                        newCol.set("taxitem", supTaxItemObj.getPkValue());
                        newCol.set("taxitem_id", supTaxItemObj.getPkValue());
                        BigDecimal taxRateVal = supTaxItemObj.getBigDecimal("taxrate");
                        newCol.set("taxrate", (Object)taxRateVal);
                    }
                    newCol.set("costdetail", (Object)"0");
                }
                if (StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_tnd")) {
                    newCol.set("bidattach", null);
                    newCol.set("packnote", (Object)"");
                    if (!isSplitDoc) {
                        newCol.set("packfilename", null);
                    }
                }
                if (StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_src")) {
                    newCol.set("srcentryid", col.getPkValue());
                }
                newCols.add((Object)newCol);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
            if (StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_tnd") || StringUtils.equals((CharSequence)compKey, (CharSequence)"src_biddoc_src")) continue;
            PdsCostDetailUtils.handleCostDetail((String)"src_costdetail", (DynamicObjectCollection)cols, (boolean)true);
        }
    }

    private static void setOtherCompEntryData(String compKey, DynamicObject tenderObj, DynamicObject newCompData) {
        if ("src_purlist_item".equals(compKey)) {
            Object project = tenderObj.get("project");
            Object supplier = tenderObj.get("supplier");
            DynamicObjectCollection newCols = newCompData.getDynamicObjectCollection("itementity");
            for (DynamicObject col : newCols) {
                col.set("itemsupplier", supplier);
                col.set("itemsupplier_id", supplier);
                col.set("itemproject", project);
                col.set("itemproject_id", project);
            }
        }
    }
}

