/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.expertfilter.selecttool.PdsExpertSelectUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;

public class SrcUsualUserUtils {
    public static long getBillId(String compkey) {
        QFilter qFilter;
        DynamicObject billObj = null;
        Set<Long> userIds = SrcUsualUserUtils.getUnEnabledScorerIds();
        if (null != userIds && userIds.size() > 0) {
            DeleteServiceHelper.delete((String)"src_usualuser_meta", (QFilter[])new QFilter[]{new QFilter("bidder", "in", userIds)});
        }
        if (StringUtils.equals((CharSequence)compkey, (CharSequence)"src_project_man") || StringUtils.equals((CharSequence)compkey, (CharSequence)"src_project_reference") || StringUtils.equals((CharSequence)compkey, (CharSequence)"src_bidopen_config")) {
            compkey = "src_project_man";
        }
        if ((billObj = BusinessDataServiceHelper.loadSingle((String)"src_usualuser", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("compkey", "=", (Object)compkey).and("creator", "=", (Object)RequestContext.get().getCurrUserId())})) != null) {
            return (Long)billObj.getPkValue();
        }
        billObj = BusinessDataServiceHelper.newDynamicObject((String)"src_usualuser");
        billObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        billObj.set("compkey", (Object)compkey);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        return (Long)billObj.getPkValue();
    }

    public static void createMemberEntryData(IFormView view) {
        EntryGrid grid;
        int[] rows;
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        int index = parentView.getModel().getEntryCurrentRowIndex("entryentity");
        if (index < 0) {
            index = 0;
        }
        if ((rows = (grid = (EntryGrid)view.getControl("entryentity")).getSelectRows()) == null || rows.length == 0) {
            return;
        }
        DynamicObjectCollection entrys = view.getModel().getEntryEntity("entryentity");
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)((DynamicObject)entrys.get(rows[0])));
        IDataModel model = parentView.getModel();
        model.beginInit();
        for (int i = 0; i < rows.length; ++i) {
            if (null == model.getEntryRowEntity("entryentity", index)) {
                model.createNewEntryRow("entryentity");
            }
            for (String property : properties) {
                if (((DynamicObject)entrys.get(rows[i])).get(property) instanceof DynamicObject) {
                    model.setValue(property, ((DynamicObject)entrys.get(rows[i])).get(property + "." + "id"), index);
                    continue;
                }
                if (StringUtils.equals((CharSequence)property, (CharSequence)"seq")) continue;
                model.setValue(property, ((DynamicObject)entrys.get(rows[i])).get(property), index);
            }
            ++index;
        }
        model.endInit();
        view.getParentView().updateView("entryentity");
        view.sendFormAction(view.getParentView());
    }

    public static void createScorerEntryData(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        int[] rows = grid.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        ArrayList<Integer> selectList = new ArrayList<Integer>(8);
        EntryGrid parentGrid = (EntryGrid)parentView.getControl("entryentity");
        int[] parentViewRows = parentGrid.getSelectRows();
        if (parentViewRows == null || parentViewRows.length == 0) {
            selectList.add(0);
        } else {
            for (int i = 0; i < parentViewRows.length; ++i) {
                selectList.add(parentViewRows[i]);
            }
        }
        Iterator iterator = selectList.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ExpertContext context = new ExpertContext();
            context.setProjectId(PdsCommonUtils.object2Long((Object)parentView.getModel().getDataEntity().getPkValue()));
            Set expertIds = PdsExpertSelectUtils.getExcludedUserIds((ExpertContext)context);
            ArrayList<Long> userIds = new ArrayList<Long>(rows.length);
            for (int i = 0; i < rows.length; ++i) {
                DynamicObject row = view.getModel().getEntryRowEntity("entryentity", rows[i]);
                long userId = row.getLong("bidder.id");
                if (expertIds.contains(userId)) continue;
                userIds.add(userId);
            }
            if (userIds.size() == 0) {
                return;
            }
            Object[] basedataIds = userIds.toArray();
            if (parentView.getModel().getValue("scorer", index) == null) {
                parentView.getModel().createNewEntryRow("entryentity");
            }
            parentView.getModel().setValue("scorer", (Object)basedataIds, index);
        }
        view.sendFormAction(view.getParentView());
    }

    public static void getUserInfo(IFormView view, int index) {
        DynamicObject currRow = view.getModel().getEntryRowEntity("entryentity", index);
        if (currRow != null) {
            DynamicObjectCollection userRows = QueryServiceHelper.query((String)"bos_user", (String)"id,number,entryentity.dpt dept,entryentity.position position,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currRow.getLong("bidder.id"))});
            if (userRows != null && userRows.size() > 0) {
                view.getModel().setValue("number", ((DynamicObject)userRows.get(0)).get("number"), index);
                view.getModel().setValue("dept", ((DynamicObject)userRows.get(0)).get("dept"), index);
                view.getModel().setValue("position", ((DynamicObject)userRows.get(0)).get("position"), index);
                view.getModel().setValue("phone", ((DynamicObject)userRows.get(0)).get("phone"), index);
                view.getModel().setValue("email", ((DynamicObject)userRows.get(0)).get("email"), index);
            } else {
                view.getModel().setValue("number", (Object)"", index);
                view.getModel().setValue("dept", null, index);
                view.getModel().setValue("position", (Object)"", index);
                view.getModel().setValue("phone", (Object)"", index);
                view.getModel().setValue("email", (Object)"", index);
            }
        }
    }

    public static void addToUsualUser(IFormView view) {
        DynamicObjectCollection memberRows = view.getModel().getEntryEntity("entryentity");
        if (memberRows == null || memberRows.size() == 0) {
            return;
        }
        long billId = SrcUsualUserUtils.getBillId(view.getEntityId());
        if (billId == 0L) {
            return;
        }
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_usualuser");
        if (userObj == null) {
            return;
        }
        int index = 0;
        HashSet<String> userSet = new HashSet<String>();
        DynamicObjectCollection userRows = userObj.getDynamicObjectCollection("entryentity");
        if (userRows != null && userRows.size() > 0) {
            index = userRows.size();
            for (DynamicObject userRow : userRows) {
                userSet.add(userRow.getString("bidder.id"));
            }
        }
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"src_usualuser_meta"));
        ArrayList<DynamicObject> userObjs = new ArrayList<DynamicObject>();
        for (DynamicObject memberRow : memberRows) {
            String key = memberRow.getString("bidder.id");
            if (!userSet.add(key)) continue;
            SrcUsualUserUtils.createNewEntry(properties, memberRow, userObjs, billId, index++);
        }
        if (userObjs != null && userObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])userObjs.toArray(new DynamicObject[userObjs.size()]));
        }
    }

    public static void addToUsualScorer(IFormView view) {
        DynamicObjectCollection scorerRows = view.getModel().getEntryEntity("entryentity");
        if (scorerRows == null || scorerRows.size() == 0) {
            return;
        }
        long billId = SrcUsualUserUtils.getBillId(view.getEntityId());
        if (billId == 0L) {
            return;
        }
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_usualuser");
        if (userObj == null) {
            return;
        }
        int index = 1;
        HashSet<String> userSet = new HashSet<String>();
        DynamicObjectCollection userRows = userObj.getDynamicObjectCollection("entryentity");
        if (userRows != null && userRows.size() > 0) {
            index = userRows.size();
            for (DynamicObject userRow : userRows) {
                userSet.add(userRow.getString("bidder.id"));
            }
        }
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList("scorer", "billid", "fseq", "entryparentid"));
        ArrayList<DynamicObject> userObjs = new ArrayList<DynamicObject>();
        for (DynamicObject scorerRow : scorerRows) {
            DynamicObjectCollection rows = scorerRow.getDynamicObjectCollection("scorer");
            for (DynamicObject row : rows) {
                DynamicObject basedataObj = row.getDynamicObject("fbasedataid");
                long basedataId = (Long)basedataObj.getPkValue();
                String key = String.valueOf(basedataId);
                if (!userSet.add(key)) continue;
                SrcUsualUserUtils.createNewEntry(properties, row, userObjs, billId, index++);
            }
        }
        if (userObjs != null && userObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])userObjs.toArray(new DynamicObject[userObjs.size()]));
        }
    }

    private static void createNewEntry(List<String> properties, DynamicObject memberRow, List<DynamicObject> userObjs, long billId, int index) {
        DynamicObject userObj = BusinessDataServiceHelper.newDynamicObject((String)"src_usualuser_meta");
        for (String property : properties) {
            try {
                if (property.equals("billid")) {
                    userObj.set(property, (Object)billId);
                    continue;
                }
                if (property.equals("fseq")) {
                    userObj.set(property, (Object)index);
                    continue;
                }
                if (property.equals("entryparentid")) {
                    userObj.set(property, (Object)billId);
                    continue;
                }
                if (property.equals("scorer")) {
                    DynamicObject basedataObj = memberRow.getDynamicObject("fbasedataid");
                    long basedataId = (Long)basedataObj.getPkValue();
                    userObj.set("bidder", (Object)basedataId);
                    SrcClarifyUtils.setUserInfo((DynamicObject)userObj, (long)basedataId);
                    continue;
                }
                if (property.equals("note")) continue;
                if (memberRow.get(property) instanceof DynamicObject) {
                    userObj.set(property, memberRow.get(property + "." + "id"));
                    continue;
                }
                userObj.set(property, memberRow.get(property));
            }
            catch (Exception exception) {}
        }
        userObjs.add(userObj);
    }

    public static Set<Long> getUnEnabledScorerIds() {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_expert", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"0")});
        if (rows.size() > 0) {
            return rows.stream().map(e -> e.getLong("user.id")).collect(Collectors.toSet());
        }
        return null;
    }
}

