/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.util.SrcAppCache;

public class SrcWinruleUtils {
    public static boolean isNeedValidateOrderRatio(long projectId) {
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        qfilters.and("ratiotype", "=", (Object)"9");
        return !QueryServiceHelper.exists((String)"src_project_rule", (QFilter[])qfilters.toArray());
    }

    public static DynamicObject getWinRuleObj(SrcCalcContext context) {
        HashSet<String> ratioTypeSet = new HashSet<String>(3);
        ratioTypeSet.add("2");
        ratioTypeSet.add("3");
        ratioTypeSet.add("4");
        QFilter qfilters = new QFilter("id", "=", (Object)context.getBillId());
        qfilters.and("ratiotype", "in", ratioTypeSet);
        if (QueryServiceHelper.exists((String)"src_project_rule", (QFilter[])qfilters.toArray())) {
            return BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_project_rule");
        }
        return null;
    }

    public static Map<String, BigDecimal> getOrderRatioMap(DynamicObject winRuleObj) {
        HashMap<String, BigDecimal> orderRatioMap = new HashMap<String, BigDecimal>();
        String keyField = SrcWinruleUtils.getKeyField(winRuleObj);
        DynamicObjectCollection rows = winRuleObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            long keyId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(keyField));
            if (keyId == 0L) continue;
            for (int i = 1; i <= 10; ++i) {
                String valueField = "orderratio" + SrcWinruleUtils.formatInt(i, true);
                BigDecimal value = row.getBigDecimal(valueField);
                if (value.compareTo(BigDecimal.ZERO) <= 0) continue;
                String key = String.valueOf(keyId) + '|' + SrcWinruleUtils.formatInt(i, false);
                orderRatioMap.put(key, value);
            }
        }
        return orderRatioMap;
    }

    public static Map<Long, String> getSurplusRatioMap(DynamicObject winRuleObj) {
        HashMap<Long, String> suplusRatioMap = new HashMap<Long, String>();
        String keyField = SrcWinruleUtils.getKeyField(winRuleObj);
        DynamicObjectCollection rows = winRuleObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            long keyId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(keyField));
            if (keyId == 0L) continue;
            String value = row.getString("surplusratio");
            if (StringUtils.isBlank((CharSequence)value)) {
                value = "1";
            }
            suplusRatioMap.put(keyId, value);
        }
        return suplusRatioMap;
    }

    public static Map<Long, Integer> getWinerQtyMap(DynamicObject winRuleObj) {
        HashMap<Long, Integer> winerQtyMap = new HashMap<Long, Integer>(8);
        String keyField = SrcWinruleUtils.getKeyField(winRuleObj);
        DynamicObjectCollection rows = winRuleObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            int value;
            long keyId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(keyField));
            if (keyId == 0L || (value = row.getInt("entrywinerqty")) <= 0) continue;
            winerQtyMap.put(keyId, value);
        }
        return winerQtyMap;
    }

    public static Map<Long, Integer> getWinruleWinerQtyMap(long projectId) {
        DynamicObject winRuleObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_rule");
        int winSupQty = winRuleObj.getInt("winerqty");
        Map<Long, Integer> winerQtyMap = SrcWinruleUtils.getWinerQtyMap(winRuleObj);
        winerQtyMap.put(projectId, winSupQty);
        return winerQtyMap;
    }

    public static Map<String, Integer> getDecisionWinerQtyMap(long projectId) {
        Set resultValueSet = PdsParameterUtils.getResultValueSet();
        QFilter qFilters = new QFilter("project", "=", (Object)projectId);
        qFilters.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        qFilters.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id,package.packagename,purlist.id,purlist.materialnane,supplier.id,result", (QFilter[])qFilters.toArray());
        Map<String, DynamicObject> purlistGroup = rows.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("package.id")) + '|' + String.valueOf(e.getLong("purlist.id")) + '|' + e.getString("package.packagename") + '|' + e.getString("purlist.materialnane") + '~' + String.valueOf(e.getLong("supplier.id")), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        HashMap<String, Integer> winSupQtyMap = new HashMap<String, Integer>(purlistGroup.size());
        for (Map.Entry<String, DynamicObject> entry : purlistGroup.entrySet()) {
            int count = resultValueSet.contains(entry.getValue().getString("result")) ? 1 : 0;
            String key = entry.getKey().split("\\~")[0];
            if (winSupQtyMap.containsKey(key)) {
                winSupQtyMap.put(key, (Integer)winSupQtyMap.get(key) + count);
                continue;
            }
            winSupQtyMap.put(key, count);
        }
        return winSupQtyMap;
    }

    public static Map<Long, Integer> getAlterQtyMap(DynamicObject winRuleObj) {
        HashMap<Long, Integer> alterQtyMap = new HashMap<Long, Integer>();
        String keyField = SrcWinruleUtils.getKeyField(winRuleObj);
        DynamicObjectCollection rows = winRuleObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            int value;
            long keyId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(keyField));
            if (keyId == 0L || (value = row.getInt("entryalterqty")) <= 0) continue;
            alterQtyMap.put(keyId, value);
        }
        return alterQtyMap;
    }

    public static Map<Long, Integer> getTrainQtyMap(DynamicObject winRuleObj) {
        HashMap<Long, Integer> trainQtyMap = new HashMap<Long, Integer>();
        String keyField = SrcWinruleUtils.getKeyField(winRuleObj);
        DynamicObjectCollection rows = winRuleObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            int value;
            long keyId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject(keyField));
            if (keyId == 0L || (value = row.getInt("entrytrainqty")) <= 0) continue;
            trainQtyMap.put(keyId, value);
        }
        return trainQtyMap;
    }

    public static String formatInt(int i, boolean isAddZero) {
        if (!isAddZero) {
            return String.valueOf(i);
        }
        if (i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    public static String getKeyField(DynamicObject winRuleObj) {
        String ratioType = winRuleObj.getString("ratiotype");
        String keyField = "project";
        switch (ratioType) {
            case "2": {
                keyField = "project";
                break;
            }
            case "3": {
                keyField = "package";
                break;
            }
            case "4": {
                keyField = "purlist";
                break;
            }
        }
        return keyField;
    }

    public static DynamicObject getWinruleSchemeObj(IFormView compView) {
        long schemeId = 0L;
        IFormView parentView = compView.getParentView();
        if ("src_project".equals(compView.getParentView().getEntityId())) {
            String winRulePageId = SrcAppCache.get("winrulepageid", String.class, parentView);
            IFormView winRulePage = parentView.getView(winRulePageId);
            if (Objects.nonNull(winRulePage)) {
                schemeId = winRulePage.getModel().getDataEntity().getLong("scheme.id");
            } else {
                String vieRulePageId = SrcAppCache.get("vierulepageid", String.class, parentView);
                IFormView vieRulePage = parentView.getView(vieRulePageId);
                if (Objects.nonNull(vieRulePage)) {
                    schemeId = vieRulePage.getModel().getDataEntity().getLong("scheme.id");
                }
            }
        } else {
            schemeId = compView.getModel().getDataEntity().getLong("projectf7.scheme.id");
        }
        if (schemeId > 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"src_pattern");
        }
        return null;
    }
}

