/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.src.common.vie.ISrcFinishVerify;
import kd.scm.src.common.vie.SrcVieFacade;

public class SrcFinishVerifyBidCountQuote
implements ISrcFinishVerify {
    private static final long serialVersionUID = 1L;

    public void verifyData(PdsVieContext context) {
        int bidCount = context.getVieBillObj().getInt("bidcount");
        if (bidCount == 0) {
            return;
        }
        Set<Long> vieSupplierIds = SrcVieFacade.getVieSupplierIds(context);
        if (vieSupplierIds.size() == 0) {
            return;
        }
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("vieturns", "=", (Object)context.getVieturns());
        quoteFilter.and("supplier", "in", vieSupplierIds);
        String orderBy = "supplier,bidcount desc";
        DynamicObjectCollection quoteRows = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"supplier.id,bidcount", (QFilter[])quoteFilter.toArray(), (String)orderBy);
        if (quoteRows.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> supplierMap = quoteRows.stream().collect(Collectors.groupingBy(e -> e.getLong("supplier.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        int count = 0;
        for (Map.Entry<Long, DynamicObject> entry : supplierMap.entrySet()) {
            if (entry.getValue().getInt("bidcount") >= bidCount) continue;
            ++count;
        }
        if (count > 0) {
            context.setVerify(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u8fd8\u6709(%1$s)\u5bb6\u4f9b\u5e94\u5546\u62a5\u4ef7\u6b21\u6570\u5c11\u4e8e(%2$s)\u3002", (String)"SrcFinishVerifyBidCountQuote_0", (String)"scm-src-common", (Object[])new Object[0]), count, bidCount));
            return;
        }
    }
}

