/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.src.common.vie.ISrcVieFinish;
import kd.scm.src.common.vie.SrcVieFacade;

public class SrcVieFinishDetail
implements ISrcVieFinish {
    public void process(PdsVieContext context) {
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        HashSet<Long> validDetailIds = new HashSet<Long>(16);
        this.getQuoteDetails(context, srcEntryIds, validDetailIds);
        if (srcEntryIds.size() == 0) {
            return;
        }
        this.updateQuoteDetail(context, srcEntryIds, validDetailIds);
        this.updateCostDetail(context, srcEntryIds);
    }

    protected void getQuoteDetails(PdsVieContext context, Set<Long> srcEntryIds, Set<Long> validDetailIds) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("vieturns", "=", (Object)context.getVieturns());
        DynamicObjectCollection quoteDetails = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"id,srcentryid", (QFilter[])qfilter.toArray(), (String)"srcentryid,quotedate desc");
        if (quoteDetails == null || quoteDetails.size() == 0) {
            return;
        }
        Map<String, DynamicObject> srcEntryMap = quoteDetails.stream().collect(Collectors.groupingBy(e -> e.getString("srcentryid"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        srcEntryIds.addAll(srcEntryMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet()));
        validDetailIds.addAll(srcEntryMap.entrySet().stream().map(e -> ((DynamicObject)e.getValue()).getLong("id")).collect(Collectors.toSet()));
    }

    protected void updateQuoteDetail(PdsVieContext context, Set<Long> srcEntryIds, Set<Long> validDetailIds) {
        QFilter qfilter = new QFilter("srcentryid", "in", srcEntryIds).and("entrystatus", "!=", (Object)ProjectStatusEnums.CLOSED.getValue());
        DynamicObject[] quoteDetailObjs = BusinessDataServiceHelper.load((String)"src_vie_detailf7", (String)"id,entrystatus", (QFilter[])qfilter.toArray());
        if (quoteDetailObjs == null || quoteDetailObjs.length == 0) {
            return;
        }
        for (DynamicObject quoteDetailObj : quoteDetailObjs) {
            if (validDetailIds.contains(quoteDetailObj.getLong("id"))) {
                quoteDetailObj.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
                continue;
            }
            quoteDetailObj.set("entrystatus", (Object)ProjectStatusEnums.CLOSED.getValue());
        }
        SrcVieFacade.setFinishData(context, "src_vie_detailf7", quoteDetailObjs);
    }

    protected void updateCostDetail(PdsVieContext context, Set<Long> srcEntryIds) {
        QFilter qfilter = new QFilter("purlist", "in", srcEntryIds).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObject[] costDetailObjs = BusinessDataServiceHelper.load((String)"tnd_costdetail", (String)"id,billstatus", (QFilter[])qfilter.toArray());
        if (costDetailObjs == null || costDetailObjs.length == 0) {
            return;
        }
        for (DynamicObject costDetailObj : costDetailObjs) {
            costDetailObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
        }
        SrcVieFacade.setFinishData(context, "tnd_costdetail", costDetailObjs);
    }
}

