/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.src.common.vie.ISrcVieFinish;
import kd.scm.src.common.vie.SrcVieFacade;

public class SrcVieFinishPurlist
implements ISrcVieFinish {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("vieturns", "=", (Object)context.getVieturns());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_vie_detailf7", (boolean)true);
        DynamicObjectCollection quoteRows = QueryServiceHelper.query((String)"src_vie_detailf7", (String)selectFields, (QFilter[])quoteFilter.toArray(), (String)"srcentryid,quotedate desc");
        if (quoteRows == null || quoteRows.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> supplierMap = quoteRows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier")));
        Map<String, List<DynamicObject>> purlistMap = quoteRows.stream().collect(Collectors.groupingBy(e -> e.getString("purlist")));
        Set<Long> purlistIds = purlistMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> srcentryMap = quoteRows.stream().collect(Collectors.groupingBy(e -> e.getString("srcentryid")));
        Set<Long> srcentryIds = srcentryMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet());
        selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", srcentryIds)});
        Set negEntryIds = Arrays.asList(purlistObjs).stream().map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        DynamicObject[] negPurlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", negEntryIds)});
        Map<String, DynamicObject> negPurlistMap = Arrays.asList(negPurlistObjs).stream().collect(Collectors.groupingBy(e -> e.getString("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        List properties = context.getExtProperties();
        HashSet excludedFields = new HashSet();
        for (DynamicObject purlistObj : purlistObjs) {
            DynamicObject negPurlistObj;
            List<DynamicObject> srcentryList = srcentryMap.get(purlistObj.getString("id"));
            if (srcentryList == null || srcentryList.size() == 0) continue;
            this.setPurlistValue(purlistObj, srcentryList.get(0));
            purlistObj.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
            if (null != properties && properties.size() > 0) {
                PdsCommonUtils.copyDynamicObjectValue((DynamicObject)srcentryList.get(0), (DynamicObject)purlistObj, (List)properties, excludedFields, (int)-1);
            }
            if (null == (negPurlistObj = negPurlistMap.get(purlistObj.getString("srcentryid")))) continue;
            this.setPurlistValue(negPurlistObj, purlistObj);
        }
        SrcVieFacade.setFinishData(context, "purlistid", purlistObjs);
        if (negPurlistObjs.length > 0) {
            SrcVieFacade.setFinishData(context, "negotiate", negPurlistObjs);
        }
        this.closeOtherPurlist(context, supplierMap, purlistIds, srcentryIds);
    }

    protected void closeOtherPurlist(PdsVieContext context, Map<String, List<DynamicObject>> supplierMap, Set<Long> purlistIds, Set<Long> srcentryIds) {
        ArrayList<DynamicObject> closeOtherList = new ArrayList<DynamicObject>(srcentryIds.size());
        Set supplierIds = supplierMap.keySet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toSet());
        QFilter otherFilter = new QFilter("supplier", "in", supplierIds);
        otherFilter.and("purlist", "in", purlistIds);
        otherFilter.and("entryid", "not in", srcentryIds);
        otherFilter.and("entrystatus", "=", (Object)"C");
        DynamicObject[] otherObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"suppliertype,supplier,purlist,entrystatus", (QFilter[])otherFilter.toArray());
        if (otherObjs == null || otherObjs.length == 0) {
            return;
        }
        Map<String, List<DynamicObject>> otherMap = Arrays.asList(otherObjs).stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '|' + e.getString("purlist.id")));
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            for (DynamicObject entryObj : entry.getValue()) {
                String key = entry.getKey() + "|" + entryObj.getString("purlist");
                if (otherMap.get(key) == null || otherMap.get(key).size() == 0) continue;
                for (DynamicObject otherObj : otherMap.get(key)) {
                    otherObj.set("entrystatus", (Object)"D");
                    closeOtherList.add(otherObj);
                }
            }
        }
        SrcVieFacade.setFinishData(context, "purlist_id", closeOtherList.toArray(new DynamicObject[closeOtherList.size()]));
    }

    protected void setPurlistValue(DynamicObject purlistObj, DynamicObject quoteObj) {
        purlistObj.set("vieratio", (Object)quoteObj.getBigDecimal("vieratio"));
        purlistObj.set("viediffer", (Object)quoteObj.getBigDecimal("viediffer"));
        purlistObj.set("taxitem", (Object)quoteObj.getLong("taxitem"));
        purlistObj.set("taxrate", (Object)quoteObj.getBigDecimal("taxrate"));
        purlistObj.set("price", (Object)quoteObj.getBigDecimal("price"));
        purlistObj.set("taxprice", (Object)quoteObj.getBigDecimal("taxprice"));
        purlistObj.set("amount", (Object)quoteObj.getBigDecimal("amount"));
        purlistObj.set("tax", (Object)quoteObj.getBigDecimal("tax"));
        purlistObj.set("taxamount", (Object)quoteObj.getBigDecimal("taxamount"));
        purlistObj.set("currency", (Object)quoteObj.getLong("currency"));
        purlistObj.set("exratetable_id", quoteObj.get("exratetable"));
        purlistObj.set("exratedate", (Object)quoteObj.getDate("exratedate"));
        purlistObj.set("exrate", (Object)quoteObj.getBigDecimal("exrate"));
        purlistObj.set("quotation", (Object)quoteObj.getString("quotation"));
        purlistObj.set("loccurr", (Object)quoteObj.getLong("loccurr"));
        purlistObj.set("locprice", (Object)quoteObj.getBigDecimal("locprice"));
        purlistObj.set("loctaxprice", (Object)quoteObj.getBigDecimal("loctaxprice"));
        purlistObj.set("locamount", (Object)quoteObj.getBigDecimal("locamount"));
        purlistObj.set("loctaxamount", (Object)quoteObj.getBigDecimal("loctaxamount"));
        purlistObj.set("quotedate", (Object)quoteObj.getDate("quotedate"));
        purlistObj.set("note", (Object)quoteObj.getString("note"));
        purlistObj.set("ispresent", (Object)quoteObj.getString("ispresent"));
        purlistObj.set("isdiscarded", (Object)quoteObj.getString("isdiscarded"));
        purlistObj.set("costdetail", (Object)quoteObj.getString("costdetail"));
    }
}

