/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.vie.ISrcVieInitContext;

public class SrcVieInitContext
implements ISrcVieInitContext {
    private static final long serialVersionUID = 1L;

    @Override
    public PdsVieContext createVieContext(IFormView view) {
        PdsVieContext context = PdsVieHelper.getContextInstance();
        context.setView(view);
        Map paraMap = context.getView().getFormShowParameter().getCustomParams();
        context.setProjectId(PdsCommonUtils.object2Long(paraMap.get("billid")));
        this.setContextValue(context);
        return context;
    }

    @Override
    public PdsVieContext createVieContext(long projectId) {
        PdsVieContext context = PdsVieHelper.getContextInstance();
        context.setProjectId(projectId);
        this.setContextValue(context);
        return context;
    }

    private void setContextValue(PdsVieContext context) {
        Object vie_purlist;
        Object autoSaveTimes;
        Object tndRefreshTimes;
        DynamicObject vieBillObj = PdsVieHelper.getVieBillObj((long)context.getProjectId());
        context.setVieBillObj(vieBillObj);
        context.setReduceType(vieBillObj.getString("reducetype"));
        context.setReducePct(vieBillObj.getBigDecimal("reducepct"));
        String viePattern = vieBillObj.getString("viepattern");
        context.setViePattern(StringUtils.isBlank((CharSequence)viePattern) ? "1" : viePattern);
        context.setBidName(context.getVieBillObj().getString("bidname"));
        context.setOrgId(context.getVieBillObj().getLong("org.id"));
        context.setLocCurrencyId(context.getVieBillObj().getLong("currency.id"));
        context.setBidtimes(context.getVieBillObj().getInt("bidtime"));
        DynamicObject vieTurnsObj = PdsVieHelper.getLastVieTurnsObj((DynamicObject)context.getVieBillObj(), null);
        if (vieTurnsObj != null) {
            context.setTurns(vieTurnsObj.getString("turns"));
            context.setVieturns(vieTurnsObj.getString("vieturns"));
            context.setBidStatus(vieTurnsObj.getString("turnsbidstatus"));
        } else {
            String negTurns = PdsVieHelper.getLastNegTurns((DynamicObject)PdsVieHelper.getLastNegTurnsObj((long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())));
            if (null != negTurns && !"0".equals(negTurns)) {
                context.setTurns(negTurns);
            } else {
                context.setTurns(QuoteTurnsEnums.NEGOTIATE00.getValue());
            }
            context.setVieturns(VieTurnsEnums.VIE01.getValue());
            String bidStatus = context.getVieBillObj().getString("bidstatus");
            if (StringUtils.isBlank((CharSequence)bidStatus)) {
                context.setBidStatus(SrcVieStatusEnums.BEENEXAMINED.getValue());
            } else {
                context.setBidStatus(bidStatus);
            }
        }
        context.setVieTechScheme("1");
        Object srcRefreshTimes = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"srcrefreshtimes");
        if (!Objects.isNull(srcRefreshTimes)) {
            context.setSrcRefreshTimes(Integer.parseInt(srcRefreshTimes.toString()));
        }
        if (!Objects.isNull(tndRefreshTimes = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"tndrefreshtimes"))) {
            context.setTndRefreshTimes(Integer.parseInt(tndRefreshTimes.toString()));
        }
        if (!Objects.isNull(autoSaveTimes = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"autosavetimes"))) {
            context.setAutoSaveTimes(Integer.parseInt(autoSaveTimes.toString()));
        }
        if (StringUtils.isBlank((Object)(vie_purlist = vieBillObj.get("vie_purlist")))) {
            vie_purlist = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"vie_purlist");
        }
        if (!Objects.isNull(vie_purlist)) {
            context.setVie_purlist(vie_purlist.toString());
        } else {
            context.setVie_purlist("3");
        }
        this.setBidCountByTurns(context);
        this.setBidCountType(context);
        List extProperties = PdsCommonUtils.getPropertiesFromFieldMapper((String)"src_vie_detailf7", (String)"src_purlistf7");
        context.setExtProperties(extProperties);
    }

    private void setBidCountByTurns(PdsVieContext context) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("srctype"));
        boolean isBidCountByTurns = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isbidcountbyturns", (Object)true, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())));
        context.setBidCountByTurns(isBidCountByTurns);
    }

    private void setBidCountType(PdsVieContext context) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("srctype"));
        String bidCountType = PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isbidcounttype", (Object)"1", (long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())), (String)"1");
        if ("1".equals(bidCountType)) {
            context.setBidCountType("project");
        } else if ("2".equals(bidCountType)) {
            context.setBidCountType("package");
        } else if ("3".equals(bidCountType)) {
            context.setBidCountType("purlist");
        }
    }
}

