/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;

public class SrmScoreEndOpService {
    public void setEndEvaPlanStatus(Set<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)"srm_evaplan", (String)"id,bizstatus", (QFilter[])new QFilter[]{qFilter});
        if (taskObjs == null || taskObjs.length == 0) {
            taskObjs = BusinessDataServiceHelper.load((String)"srm_evaplan_batch", (String)"id,bizstatus", (QFilter[])new QFilter[]{qFilter});
        }
        if (taskObjs == null || taskObjs.length == 0) {
            return;
        }
        Boolean isChange = false;
        for (DynamicObject taskObj : taskObjs) {
            String status;
            long taskbillId = taskObj.getLong("id");
            qFilter = new QFilter("taskbillid", "=", (Object)taskbillId);
            DynamicObjectCollection scoreObjs = QueryServiceHelper.query((String)"srm_score", (String)"bizstatus", (QFilter[])new QFilter[]{qFilter});
            if (scoreObjs == null || scoreObjs.size() == 0 || !Objects.nonNull(status = this.getStatus(scoreObjs)) || status.equals(taskObj.getString("bizstatus"))) continue;
            taskObj.set("bizstatus", (Object)status);
            isChange = true;
        }
        if (isChange.booleanValue()) {
            SaveServiceHelper.update((DynamicObject[])taskObjs);
        }
    }

    public String getStatus(DynamicObjectCollection scoreObjs) {
        String status = null;
        Map<String, List<DynamicObject>> groupStatus = scoreObjs.stream().collect(Collectors.groupingBy(x -> x.getString("bizstatus")));
        if (Objects.isNull(groupStatus) || groupStatus.size() == 0) {
            return status;
        }
        if (groupStatus.size() == 1) {
            status = this.getEndStatus(groupStatus);
        } else if (groupStatus.size() == 2) {
            status = this.getEvaPlanStatus(groupStatus);
        } else {
            return status;
        }
        return status;
    }

    private String getEndStatus(Map<String, List<DynamicObject>> groupStatus) {
        String status = null;
        Set<String> keySet = groupStatus.keySet();
        for (String s : keySet) {
            if (!s.equals(SrmScoreStatusEnum.ENDED.getValue())) continue;
            status = SrmEvaPlanStatusEnum.ENDED.getValue();
        }
        return status;
    }

    private String getEvaPlanStatus(Map<String, List<DynamicObject>> groupStatus) {
        String status = null;
        Set<String> keySet = groupStatus.keySet();
        if (keySet.contains(SrmScoreStatusEnum.ENDED.getValue())) {
            for (String key : keySet) {
                if (key.equals(SrmScoreStatusEnum.TRIALED.getValue()) || key.equals(SrmScoreStatusEnum.UNTRIALED.getValue())) {
                    status = SrmEvaPlanStatusEnum.TRIALED.getValue();
                    return status;
                }
                if (!key.equals(SrmScoreStatusEnum.APPROVED.getValue()) && !key.equals(SrmScoreStatusEnum.UNAPPROVED.getValue())) continue;
                status = SrmEvaPlanStatusEnum.APPROVED.getValue();
                return status;
            }
        }
        return status;
    }
}

