/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.autocal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.srm.service.ISrmTimelyReceiptSyncService;
import kd.scm.srm.service.autocal.model.OrderInfo;

public class SrmTimelyReceiptSyncServiceImpl
implements ISrmTimelyReceiptSyncService {
    public void updateOrderInfos(List<Long> curReceiptIds) {
        DynamicObject[] loads;
        ArrayList<String> pobillIds = new ArrayList<String>();
        QFilter qf = new QFilter("id", "in", curReceiptIds);
        String selectProperties = "id,org,supplier,status,billdate,billno,billstatus,entryentity.id,entryentity.material,entryentity.pobillno,entryentity.orderqty,entryentity.basicunit,entryentity.receiptqty,entryentity.timelyreceiptqty,entryentity.untimelyreceiptqty,entryentity.receiptreturnqty,entryentity.receiptreturnqty,entryentity.loctaxamount,entryentity.loccurr,entryentity.lotnumber,entryentity.delidate,entryentity.pobillid,entryentity.poentryid";
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"srm_receipt_sync", (String)selectProperties, (QFilter[])new QFilter[]{qf})) {
            DynamicObjectCollection entryentitys = load.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                String pobillid = entryentity.getString("pobillid");
                pobillIds.add(pobillid);
            }
        }
        Map<String, OrderInfo> map = this.getOrderInfos(pobillIds);
        for (DynamicObject load : loads) {
            Date billdate = load.getDate("billdate");
            DynamicObjectCollection entryentitys = load.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                String poentryid = entryentity.getString("poentryid");
                BigDecimal receiptqty = entryentity.getBigDecimal("receiptqty");
                if (receiptqty.compareTo(BigDecimal.ZERO) < 0) {
                    entryentity.set("receiptreturnqty", (Object)receiptqty);
                }
                if (!map.containsKey(poentryid)) continue;
                OrderInfo orderInfo = map.get(poentryid);
                Date delidate = orderInfo.getDelidate();
                if (billdate != null && delidate != null) {
                    if (billdate.compareTo(delidate) <= 0) {
                        entryentity.set("timelyreceiptqty", (Object)receiptqty);
                    } else {
                        entryentity.set("untimelyreceiptqty", (Object)receiptqty);
                    }
                }
                entryentity.set("orderqty", (Object)orderInfo.getBasicqty());
                entryentity.set("delidate", (Object)delidate);
                entryentity.set("loctaxamount", (Object)orderInfo.getSumtaxamount());
                entryentity.set("loccurr", (Object)orderInfo.getLoccurr());
            }
            load.set("status", (Object)true);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
    }

    private Map<String, OrderInfo> getOrderInfos(List<String> pobillIds) {
        QFilter qf1 = new QFilter("entryentity.pobillid", "in", pobillIds);
        String selectOrderProps = "id,loccurr,entryentity.id,entryentity.basicqty,entryentity.basicunit,entryentity.loctaxamount,entryentity.delidate,entryentity.pobillid,entryentity.poentryid";
        HashMap<String, OrderInfo> map = new HashMap<String, OrderInfo>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"querySrmOrderSync", (String)"srm_order_sync", (String)selectOrderProps, (QFilter[])new QFilter[]{qf1}, (String)"id");){
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(row -> {
                    OrderInfo orderInfo = new OrderInfo();
                    Long basicunit = row.getLong("entryentity.basicunit");
                    BigDecimal basicqty = row.getBigDecimal("entryentity.basicqty");
                    Date delidate = row.getDate("entryentity.delidate");
                    String pobillid = row.getString("entryentity.pobillid");
                    String poentryid = row.getString("entryentity.poentryid");
                    BigDecimal sumtaxamount = row.getBigDecimal("entryentity.loctaxamount");
                    Long loccurr = row.getLong("loccurr");
                    orderInfo.setBasicunit(basicunit);
                    orderInfo.setBasicqty(basicqty);
                    orderInfo.setDelidate(delidate);
                    orderInfo.setPobillid(pobillid);
                    orderInfo.setPoentryid(poentryid);
                    orderInfo.setSumtaxamount(sumtaxamount);
                    orderInfo.setLoccurr(loccurr);
                    map.put(poentryid, orderInfo);
                });
            }
        }
        return map;
    }
}

