/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.nodeflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BOTPUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.constant.SrmConstant;
import kd.sdk.scm.srm.extpoint.ISrmAccessNodeService;

public class SrmAccessNodeService
implements ISrmAccessNodeService {
    protected Log log = LogFactory.getLog(this.getClass());

    public String pushBill(String objectnumber, List<DynamicObject> aptitudeObjs) {
        this.log.info("\u8d44\u8d28\u5ba1\u67e5\u5355\u5f00\u59cb\u4e0b\u63a8\u4e0b\u6e38\u5355\u636e(\u5355\u636e\u6807\u8bc6:" + objectnumber + ")");
        String message = null;
        if (aptitudeObjs != null && !aptitudeObjs.isEmpty()) {
            HashMap<Long, DynamicObject> pushAptitudeMap = new HashMap<Long, DynamicObject>(aptitudeObjs.size());
            message = this.pushBill(objectnumber, aptitudeObjs, pushAptitudeMap);
        }
        return message;
    }

    public String setAptitudeNodeStatus(String objectnumber, Long aptitudeId, boolean finished, Date billdate) {
        DynamicObject aptitudeObj = BusinessDataServiceHelper.loadSingle((Object)aptitudeId, (String)"srm_aptitudeexam");
        if (aptitudeObj != null) {
            DynamicObjectCollection dynList = aptitudeObj.getDynamicObjectCollection(SrmConstant.ENTRY_NODE);
            for (DynamicObject dyn : dynList) {
                DynamicObject accessnode = dyn.getDynamicObject("accessnode");
                String number = accessnode.getString("bizobject_id");
                if (!objectnumber.equals(number)) continue;
                if (finished) {
                    dyn.set("nodestatus", (Object)"1");
                } else {
                    dyn.set("nodestatus", (Object)" ");
                }
                if (billdate == null) continue;
                dyn.set("nodebilldate", (Object)billdate);
            }
            Map resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_aptitudeexam", (DynamicObject)aptitudeObj);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                return (String)resultMap.get("message");
            }
        }
        return null;
    }

    public String setSupapproveNodeStatus(String objectnumber, DynamicObject[] objects, boolean isAudit) {
        HashSet<Long> aptitudeIds = new HashSet<Long>(objects.length);
        Map<String, String> aptitudeStatusMap = this.getNodeEntryStatusMap(objectnumber, objects, aptitudeIds, isAudit);
        if (aptitudeStatusMap != null && !aptitudeStatusMap.isEmpty()) {
            DynamicObject[] supapproves;
            for (DynamicObject supapprove : supapproves = this.getSupapproves(aptitudeIds)) {
                DynamicObject aptitude = supapprove.getDynamicObject("aptitudeno");
                String aptitudeId = aptitude.getString("id");
                DynamicObjectCollection spentrys = supapprove.getDynamicObjectCollection("entryentity");
                for (DynamicObject spentry : spentrys) {
                    DynamicObjectCollection nodeentry = spentry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject entry : nodeentry) {
                        DynamicObject accessnode = entry.getDynamicObject("accessnode");
                        String biznumber = accessnode.getString("bizobject_id");
                        if (!objectnumber.equals(biznumber)) continue;
                        String nodestatus = aptitudeStatusMap.get(aptitudeId);
                        this.setSupapproveNodeStatus(entry, nodestatus, aptitudeStatusMap.get(aptitudeId + "_billno"));
                        if ("1".equals(nodestatus)) continue;
                        this.setNodeBillnoAndStatus(objectnumber, aptitude.getLong("id"), entry, spentry);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])supapproves);
        }
        return null;
    }

    protected void setSupapproveNodeStatus(DynamicObject nodeentry, String nodestatus, String nodebillno) {
        nodeentry.set("nodestatus", (Object)nodestatus);
        if ("0".equals(nodestatus)) {
            nodeentry.set("nodebillno", (Object)" ");
        } else if (StringUtils.isNotBlank((CharSequence)nodebillno)) {
            nodeentry.set("nodebillno", (Object)nodebillno);
        }
    }

    public String verifyAptitudeNo(String objectnumber, Long aptitudeId) {
        DynamicObject aptitude = this.getAptitudeexam(objectnumber, aptitudeId);
        if (aptitude == null) {
            return ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u672c\u73af\u8282\u5df2\u5904\u7406\u5b8c\u6bd5\uff0c\u4e0d\u9700\u8981\u518d\u5904\u7406\u3002", (String)"SrmAccessNodeService_0", (String)"scm-srm-mservice", (Object[])new Object[0]);
        }
        return null;
    }

    public void setNodeBillnoAndStatus(String objectnumber, Long aptitudeId, DynamicObject target, DynamicObject approveentry) {
        QFilter qFilter = new QFilter("aptitudeno.number", "=", (Object)aptitudeId);
        DynamicObject[] currentNodeObjects = BusinessDataServiceHelper.load((String)objectnumber, (String)this.getNodeBillnoAndStatusSql(), (QFilter[])qFilter.toArray());
        if (currentNodeObjects != null && currentNodeObjects.length > 0) {
            ArrayList<DynamicObject> auditList = new ArrayList<DynamicObject>(currentNodeObjects.length);
            ArrayList<DynamicObject> unauditList = new ArrayList<DynamicObject>(currentNodeObjects.length);
            for (DynamicObject temp : currentNodeObjects) {
                String auditstatus = temp.getString("auditstatus");
                if ("C".equals(auditstatus)) {
                    auditList.add(temp);
                    continue;
                }
                unauditList.add(temp);
            }
            HashMap<String, String> aptitudeStatusMap = new HashMap<String, String>(currentNodeObjects.length);
            if (!auditList.isEmpty()) {
                Map<String, String> auditStatusMap = this.getNodeEntryStatusMap(objectnumber, auditList.toArray(new DynamicObject[auditList.size()]), null, true);
                aptitudeStatusMap.putAll(auditStatusMap);
            } else if (!unauditList.isEmpty()) {
                Map<String, String> auditStatusMap = this.getNodeEntryStatusMap(objectnumber, unauditList.toArray(new DynamicObject[unauditList.size()]), null, false);
                aptitudeStatusMap.putAll(auditStatusMap);
            }
            if (!aptitudeStatusMap.isEmpty()) {
                this.setSupapproveNodeStatus(target, (String)aptitudeStatusMap.get(aptitudeId.toString()), (String)aptitudeStatusMap.get(aptitudeId + "_billno"));
            }
        } else {
            this.setSupapproveNodeStatus(target, "0", null);
        }
    }

    protected String getNodeBillnoAndStatusSql() {
        return "id,billno,aptitudeno,auditstatus";
    }

    protected String getNodeBillnoAndStatus(DynamicObject entry) {
        return "1";
    }

    protected Map<String, String> getNodeEntryStatusMap(String objectnumber, DynamicObject[] currentNodeObjects, Set<Long> aptitudeIds, boolean isAudit) {
        HashMap<String, String> aptitudeStatusMap = new HashMap<String, String>(currentNodeObjects == null ? 2 : currentNodeObjects.length * 2);
        if (currentNodeObjects != null && currentNodeObjects.length > 0) {
            for (DynamicObject object : currentNodeObjects) {
                String aptitudeIdStr;
                String tempSatus;
                String billno = object.getString("billno");
                DynamicObject dynamicObject = object.getDynamicObject("aptitudeno");
                if (dynamicObject == null) continue;
                Long aptitudeId = dynamicObject.getLong("id");
                if (aptitudeIds != null) {
                    aptitudeIds.add(aptitudeId);
                }
                String finished = "0";
                if (isAudit) {
                    finished = this.getNodeBillnoAndStatus(object);
                }
                if ((tempSatus = (String)aptitudeStatusMap.get(aptitudeIdStr = aptitudeId.toString())) == null || !"1".equals(tempSatus)) {
                    aptitudeStatusMap.put(aptitudeIdStr, finished);
                }
                aptitudeStatusMap.put(aptitudeId + "_billno", billno);
            }
        }
        return aptitudeStatusMap;
    }

    private void setModifierNull(String billType, Map<String, Object> resultMap) {
        DynamicObject botpobj;
        Boolean succed = (Boolean)resultMap.get("succed");
        if (succed.booleanValue() && (botpobj = BusinessDataServiceHelper.loadSingle((String)billType, (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(resultMap.get("billid").toString()))})) != null) {
            botpobj.set("modifier_id", (Object)0L);
            botpobj.set("modifytime", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{botpobj});
        }
    }

    protected DynamicObject getAptitudeexam(String objectnumber, Long aptitudeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)aptitudeId);
        qFilter.and(SrmConstant.ENTRY_NODE + ".accessnode.bizobject", "=", (Object)objectnumber);
        qFilter.and("auditstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qFilter.and(SrmConstant.ENTRY_NODE + ".nodestatus", "!=", (Object)"1");
        DynamicObject aptitude = BusinessDataServiceHelper.loadSingle((String)"srm_aptitudeexam", (String)"id,entry_node.accessnode,entry_node.nodestatus", (QFilter[])qFilter.toArray());
        return aptitude;
    }

    protected String pushBill(String objectnumber, List<DynamicObject> aptitudeObjs, Map<Long, DynamicObject> pushAptitudeMap) {
        StringBuilder sb = new StringBuilder();
        this.log.info("\u8d44\u8d28\u8bc4\u5ba1\u5355\u5ba1\u6838\u901a\u8fc7\uff0c\u5f00\u59cb\u4e0b\u63a8\u4e0b\u6e38\u5355\u636e(\u76ee\u6807\u5355\u636e\u6807\u8bc6:" + objectnumber + ")");
        HashSet<Long> idSet = new HashSet<Long>(aptitudeObjs.size());
        for (DynamicObject aptitudeObj : aptitudeObjs) {
            Long id = aptitudeObj.getLong("id");
            idSet.add(id);
            pushAptitudeMap.put(id, aptitudeObj);
        }
        if (!idSet.isEmpty()) {
            QFilter qFilter1 = new QFilter("aptitudeno", "in", idSet);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)objectnumber, (String)"id,aptitudeno", (QFilter[])qFilter1.toArray());
            HashSet<Long> existSet = new HashSet<Long>(dynamicObjects.length);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject temp = dynamicObjects[i].getDynamicObject("aptitudeno");
                existSet.add(temp.getLong("id"));
            }
            idSet.removeAll(existSet);
            if (!idSet.isEmpty()) {
                idSet.forEach(t -> {
                    DynamicObject aptitudeObj = (DynamicObject)pushAptitudeMap.get(t);
                    if (aptitudeObj != null) {
                        sb.append("aptitude_id:").append(t).append(';');
                        sb.append("targer bill number\uff1a").append(objectnumber).append(';');
                        Map resultMap = BOTPUtil.pushBill((String)"srm_aptitudeexam", (String)objectnumber, (DynamicObject)aptitudeObj, null);
                        sb.append("result:").append(resultMap);
                        this.setModifierNull(objectnumber, resultMap);
                    }
                });
                this.setAptitudeNodeInfo(objectnumber, idSet);
            }
        }
        this.log.info(sb.toString());
        return null;
    }

    protected void setAptitudeNodeInfo(String objectnumber, Set<Long> pushAptitudeIds) {
        QFilter qFilter2 = new QFilter("aptitudeno", "in", pushAptitudeIds);
        DynamicObjectCollection dynamicObjects1 = QueryServiceHelper.query((String)objectnumber, (String)"id,aptitudeno,billdate", (QFilter[])qFilter2.toArray());
        HashMap<Long, DynamicObject> nodeMap = new HashMap<Long, DynamicObject>(dynamicObjects1.size());
        for (DynamicObject temp : dynamicObjects1) {
            Long aptitudeId = temp.getLong("aptitudeno");
            nodeMap.put(aptitudeId, temp);
        }
        if (!nodeMap.isEmpty()) {
            DynamicObject[] aptitudeObjects;
            QFilter qFilter3 = new QFilter("id", "in", pushAptitudeIds);
            String selectedFiled = "id,entry_node,entry_node.id,entry_node.nodebilldate,entry_node.accessnode";
            for (DynamicObject aptitude : aptitudeObjects = BusinessDataServiceHelper.load((String)"srm_aptitudeexam", (String)selectedFiled, (QFilter[])qFilter3.toArray())) {
                Long aptitudeId = aptitude.getLong("id");
                DynamicObject temp = (DynamicObject)nodeMap.get(aptitudeId);
                if (temp == null) continue;
                DynamicObjectCollection ertrys = aptitude.getDynamicObjectCollection(SrmConstant.ENTRY_NODE);
                ertrys.forEach(t -> {
                    DynamicObject accessnode = t.getDynamicObject(SrmConstant.ACCESS_NODE);
                    String number = accessnode.getString("bizobject_id");
                    if (objectnumber.equals(number)) {
                        t.set("nodebilldate", (Object)temp.getDate("billdate"));
                    }
                });
            }
            SaveServiceHelper.save((DynamicObject[])aptitudeObjects);
        }
    }

    protected DynamicObject[] getSupapproves(Set<Long> aptitudeIds) {
        QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
        ArrayList<String> billStatusList = new ArrayList<String>();
        billStatusList.add(BillStatusEnum.SAVE.getVal());
        billStatusList.add(BillStatusEnum.SUBMIT.getVal());
        qFilter.and("billstatus", "in", billStatusList);
        ArrayList approvePkIds = new ArrayList();
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"srm_supapprove", (String)"id", (QFilter[])qFilter.toArray());
        dynList.forEach(row -> approvePkIds.add(row.getLong("id")));
        return BusinessDataServiceHelper.load((Object[])approvePkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"srm_supapprove"));
    }
}

