/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.nodeflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.srm.service.nodeflow.SrmAccessNodeService;

public class SrmMaterialNodeService
extends SrmAccessNodeService {
    @Override
    public String setSupapproveNodeStatus(String objectnumber, DynamicObject[] objects, boolean isAudit) {
        HashSet<Long> aptitudeIds = new HashSet<Long>(objects.length);
        Map<String, String> nodeEntryStatusMap = this.getNodeEntryStatusMap(objectnumber, objects, aptitudeIds, isAudit);
        if (!nodeEntryStatusMap.isEmpty()) {
            DynamicObject[] supapproves = this.getSupapproves(aptitudeIds);
            if (supapproves != null && supapproves.length > 0) {
                for (DynamicObject supapprove : supapproves) {
                    this.setNodeStatus(supapprove, objectnumber, nodeEntryStatusMap, isAudit);
                }
            }
            SaveServiceHelper.save((DynamicObject[])supapproves);
        }
        return null;
    }

    @Override
    public void setNodeBillnoAndStatus(String objectnumber, Long aptitudeId, DynamicObject target, DynamicObject approveentry) {
        QFilter qFilter = new QFilter("aptitudeno.number", "=", (Object)aptitudeId);
        DynamicObject[] currentNodeObjects = BusinessDataServiceHelper.load((String)objectnumber, (String)"id,billno,aptitudeno,auditstatus", (QFilter[])qFilter.toArray());
        if (currentNodeObjects != null && currentNodeObjects.length > 0) {
            DynamicObject category;
            ArrayList<DynamicObject> auditList = new ArrayList<DynamicObject>(currentNodeObjects.length);
            ArrayList<DynamicObject> unauditList = new ArrayList<DynamicObject>(currentNodeObjects.length);
            for (DynamicObject temp : currentNodeObjects) {
                String auditstatus = temp.getString("auditstatus");
                if ("C".equals(auditstatus)) {
                    auditList.add(temp);
                    continue;
                }
                unauditList.add(temp);
            }
            HashMap<String, String> nodeEntryStatusMap = new HashMap<String, String>(currentNodeObjects.length);
            if (!auditList.isEmpty()) {
                HashSet<Long> aptitudeIds = new HashSet<Long>(1);
                Map<String, String> auditStatusMap = this.getNodeEntryStatusMap(objectnumber, auditList.toArray(new DynamicObject[auditList.size()]), aptitudeIds, true);
                nodeEntryStatusMap.putAll(auditStatusMap);
            } else if (!unauditList.isEmpty()) {
                HashSet<Long> aptitudeIds = new HashSet<Long>(1);
                Map<String, String> auditStatusMap = this.getNodeEntryStatusMap(objectnumber, unauditList.toArray(new DynamicObject[unauditList.size()]), aptitudeIds, false);
                nodeEntryStatusMap.putAll(auditStatusMap);
            }
            if (!nodeEntryStatusMap.isEmpty() && (category = approveentry.getDynamicObject("category")) != null) {
                String categoryId = category.getString("id");
                String statusKey = aptitudeId + "_" + categoryId;
                String billno = (String)nodeEntryStatusMap.get(statusKey + "_billno");
                String nodestatus = this.getNodeStatus(statusKey, approveentry, nodeEntryStatusMap);
                if (nodestatus == null) {
                    nodestatus = "0";
                }
                this.setSupapproveNodeStatus(target, nodestatus, billno);
            }
        } else {
            this.setSupapproveNodeStatus(target, "0", null);
        }
    }

    protected String getNodeStatus(String statusKey, DynamicObject spentry, Map<String, String> nodeEntryStatusMap) {
        String categoryType = spentry.getString("categorytype");
        DynamicObject material = null;
        if (spentry.getDynamicObjectType().getProperty("material") != null) {
            material = spentry.getDynamicObject("material");
        }
        String nodestatus = null;
        if ("B".equals(categoryType)) {
            nodestatus = nodeEntryStatusMap.get(statusKey);
        } else if (material != null) {
            String materialId = material.getString("id");
            nodestatus = nodeEntryStatusMap.get(statusKey + "_" + materialId);
        }
        return nodestatus;
    }

    private void setNodeStatus(DynamicObject supapprove, String objectnumber, Map<String, String> nodeEntryStatusMap, boolean isAudit) {
        DynamicObject aptitude = supapprove.getDynamicObject("aptitudeno");
        Long aptitudeId = aptitude.getLong("id");
        DynamicObjectCollection spentrys = supapprove.getDynamicObjectCollection("entryentity");
        for (DynamicObject spentry : spentrys) {
            DynamicObject category = spentry.getDynamicObject("category");
            if (category == null) continue;
            String categoryId = category.getString("id");
            String statusKey = aptitudeId + "_" + categoryId;
            String billno = nodeEntryStatusMap.get(statusKey + "_billno");
            String nodestatus = this.getNodeStatus(statusKey, spentry, nodeEntryStatusMap);
            if (nodestatus == null) continue;
            this.setNodeStatus(spentry, objectnumber, nodestatus, billno, aptitudeId);
        }
    }

    private void setNodeStatus(DynamicObject spentry, String objectnumber, String nodestatus, String billno, Long aptitudeId) {
        DynamicObjectCollection nodeentrys = spentry.getDynamicObjectCollection("subentryentity");
        for (DynamicObject nodeentry : nodeentrys) {
            DynamicObject accessnode = nodeentry.getDynamicObject("accessnode");
            String biznumber = accessnode.getString("bizobject_id");
            if (!objectnumber.equals(biznumber)) continue;
            this.setSupapproveNodeStatus(nodeentry, nodestatus, billno);
            if ("1".equals(nodestatus)) continue;
            this.setNodeBillnoAndStatus(objectnumber, aptitudeId, nodeentry, spentry);
        }
    }

    @Override
    protected Map<String, String> getNodeEntryStatusMap(String objectnumber, DynamicObject[] currentFlowNodes, Set<Long> aptitudeIds, boolean isAudit) {
        HashMap<String, String> nodeEntryStatusMap = new HashMap<String, String>(currentFlowNodes.length * 3);
        HashSet<Long> ids = new HashSet<Long>(currentFlowNodes.length);
        for (DynamicObject flowNodes : currentFlowNodes) {
            DynamicObject aptitude = flowNodes.getDynamicObject("aptitudeno");
            if (aptitude != null) {
                aptitudeIds.add(aptitude.getLong("id"));
            }
            ids.add(flowNodes.getLong("id"));
        }
        if (!aptitudeIds.isEmpty()) {
            QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
            if (isAudit) {
                qFilter.and("billstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                qFilter.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
            } else {
                qFilter.and("id", "in", ids);
            }
            DynamicObjectCollection materialObjs = QueryServiceHelper.query((String)objectnumber, (String)"id,billno,aptitudeno,entryentity.category.id categoryid ,entryentity.material.id materialid,tryresult", (QFilter[])qFilter.toArray());
            aptitudeIds.clear();
            for (DynamicObject tmpObj : materialObjs) {
                String tempSatus;
                String nodestatus = "1";
                Long aptitudeno = tmpObj.getLong("aptitudeno");
                String categoryid = tmpObj.getString("categoryid");
                String billno = tmpObj.getString("billno");
                String materialid = tmpObj.getString("materialid");
                if (isAudit) {
                    nodestatus = tmpObj.getString("tryresult");
                    if (!"1".equals(nodestatus)) {
                        nodestatus = "2";
                    }
                } else {
                    nodestatus = "0";
                }
                aptitudeIds.add(aptitudeno);
                String statusKey = aptitudeno + "_" + categoryid;
                if (StringUtils.isNotBlank((CharSequence)materialid) && ((tempSatus = (String)nodeEntryStatusMap.get(statusKey + "_" + materialid)) == null || !"1".equals(tempSatus))) {
                    nodeEntryStatusMap.put(statusKey + "_" + materialid, nodestatus);
                }
                if ((tempSatus = (String)nodeEntryStatusMap.get(statusKey)) == null || !"1".equals(tempSatus)) {
                    nodeEntryStatusMap.put(statusKey, nodestatus);
                }
                nodeEntryStatusMap.put(statusKey + "_billno", billno);
            }
        }
        return nodeEntryStatusMap;
    }
}

