/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.nodeflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.srm.service.nodeflow.SrmMaterialNodeService;

public class SrmSampleNodeService
extends SrmMaterialNodeService {
    @Override
    public void setNodeBillnoAndStatus(String objectnumber, Long aptitudeId, DynamicObject target, DynamicObject approveentry) {
        QFilter qFilter = new QFilter("aptitudeno.number", "=", (Object)aptitudeId);
        DynamicObject[] currentNodeObjects = BusinessDataServiceHelper.load((String)objectnumber, (String)"id,billno,aptitudeno,auditstatus", (QFilter[])qFilter.toArray());
        if (currentNodeObjects != null && currentNodeObjects.length > 0) {
            DynamicObject category;
            ArrayList<DynamicObject> auditList = new ArrayList<DynamicObject>(currentNodeObjects.length);
            ArrayList<DynamicObject> unauditList = new ArrayList<DynamicObject>(currentNodeObjects.length);
            for (DynamicObject temp : currentNodeObjects) {
                String auditstatus = temp.getString("auditstatus");
                if ("C".equals(auditstatus)) {
                    auditList.add(temp);
                    continue;
                }
                unauditList.add(temp);
            }
            HashMap<String, String> nodeEntryStatusMap = new HashMap<String, String>(currentNodeObjects.length);
            if (!auditList.isEmpty()) {
                HashSet<Long> aptitudeIds = new HashSet<Long>(1);
                Map<String, String> auditStatusMap = this.getNodeEntryStatusMap(objectnumber, auditList.toArray(new DynamicObject[auditList.size()]), aptitudeIds, true);
                nodeEntryStatusMap.putAll(auditStatusMap);
            } else if (!unauditList.isEmpty()) {
                HashSet<Long> aptitudeIds = new HashSet<Long>(1);
                Map<String, String> auditStatusMap = this.getNodeEntryStatusMap(objectnumber, unauditList.toArray(new DynamicObject[unauditList.size()]), aptitudeIds, false);
                nodeEntryStatusMap.putAll(auditStatusMap);
            }
            if (!nodeEntryStatusMap.isEmpty() && (category = approveentry.getDynamicObject("category")) != null) {
                String categoryId = category.getString("id");
                String statusKey = aptitudeId + "_" + categoryId;
                String billno = (String)nodeEntryStatusMap.get(statusKey + "_billno");
                String nodestatus = this.getNodeStatus(statusKey, approveentry, nodeEntryStatusMap);
                if (nodestatus == null) {
                    nodestatus = "0";
                }
                this.setSupapproveNodeStatus(target, nodestatus, billno);
            }
        } else {
            this.setSupapproveNodeStatus(target, "0", null);
        }
    }

    @Override
    protected Map<String, String> getNodeEntryStatusMap(String objectnumber, DynamicObject[] currentFlowNodes, Set<Long> aptitudeIds, boolean isAudit) {
        HashMap<String, String> nodeEntryStatusMap = new HashMap<String, String>(currentFlowNodes.length * 2);
        HashSet<Long> ids = new HashSet<Long>(currentFlowNodes.length);
        for (DynamicObject flowNodes : currentFlowNodes) {
            DynamicObject aptitude = flowNodes.getDynamicObject("aptitudeno");
            if (aptitude != null) {
                aptitudeIds.add(aptitude.getLong("id"));
            }
            ids.add(flowNodes.getLong("id"));
        }
        if (!aptitudeIds.isEmpty()) {
            QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
            if (isAudit) {
                qFilter.and("billstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
                qFilter.and("auditstatus", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue());
            } else {
                qFilter.and("id", "in", ids);
            }
            DynamicObjectCollection materialObjs = QueryServiceHelper.query((String)objectnumber, (String)"id,billno,aptitudeno,entryentity.category.id categoryid ,entryentity.material.id materialid,entryentity.testresult testresult", (QFilter[])qFilter.toArray());
            aptitudeIds.clear();
            for (DynamicObject tmpObj : materialObjs) {
                String tempSatus;
                String nodestatus = "1";
                Long aptitudeno = tmpObj.getLong("aptitudeno");
                String categoryid = tmpObj.getString("categoryid");
                String billno = tmpObj.getString("billno");
                String materialid = tmpObj.getString("materialid");
                if (isAudit) {
                    nodestatus = tmpObj.getString("testresult");
                    if (!"1".equals(nodestatus)) {
                        nodestatus = "2";
                    }
                } else {
                    nodestatus = "0";
                }
                aptitudeIds.add(aptitudeno);
                String statusKey = aptitudeno + "_" + categoryid;
                if (StringUtils.isNotBlank((CharSequence)materialid) && ((tempSatus = (String)nodeEntryStatusMap.get(statusKey + "_" + materialid)) == null || !"1".equals(tempSatus))) {
                    nodeEntryStatusMap.put(statusKey + "_" + materialid, nodestatus);
                }
                if ((tempSatus = (String)nodeEntryStatusMap.get(statusKey)) == null || !"1".equals(tempSatus)) {
                    nodeEntryStatusMap.put(statusKey, nodestatus);
                }
                nodeEntryStatusMap.put(statusKey + "_billno", billno);
            }
        }
        return nodeEntryStatusMap;
    }
}

