/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.service.nodeflow;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;
import kd.scm.srm.common.constant.SrmConstant;
import kd.scm.srm.common.util.AccessNodeUtil;
import kd.scm.srm.service.nodeflow.SrmAccessNodeService;
import kd.sdk.scm.srm.extpoint.ISrmAccessNodeService;

public class SrmSupApproveNodeService
extends SrmAccessNodeService {
    @Override
    public String pushBill(String objectnumber, List<DynamicObject> aptitudeObjs) {
        this.log.info("\u8d44\u8d28\u5ba1\u67e5\u5355\u5f00\u59cb\u4e0b\u63a8\u4e0b\u6e38\u5355\u636e(\u5355\u636e\u6807\u8bc6:" + objectnumber + ")");
        String message = null;
        if (aptitudeObjs != null && !aptitudeObjs.isEmpty()) {
            HashMap<Long, DynamicObject> pushAptitudeMap = new HashMap<Long, DynamicObject>(aptitudeObjs.size());
            message = this.pushBill(objectnumber, aptitudeObjs, pushAptitudeMap);
            if (!pushAptitudeMap.isEmpty()) {
                DynamicObject[] supapproves;
                HashMap<String, String> billnoMap = new HashMap<String, String>(pushAptitudeMap.size() * 5);
                for (DynamicObject supapprove : supapproves = this.getSupapproves(pushAptitudeMap.keySet())) {
                    DynamicObject aptitude = supapprove.getDynamicObject("aptitudeno");
                    Long aptitudeId = aptitude.getLong("id");
                    DynamicObjectCollection dynList = ((DynamicObject)pushAptitudeMap.get(aptitudeId)).getDynamicObjectCollection(SrmConstant.ENTRY_NODE);
                    Map existNumberMap = AccessNodeUtil.getExistNumberMap((DynamicObjectCollection)dynList);
                    existNumberMap.remove("srm_aptitudeexam");
                    existNumberMap.remove("srm_supapprove");
                    this.setAccessnodeInfo(supapprove, existNumberMap, aptitudeId, billnoMap);
                }
                SaveServiceHelper.save((DynamicObject[])supapproves);
            }
        }
        return message;
    }

    private void setAccessnodeInfo(DynamicObject supapprove, Map<String, DynamicObject> existNumberMap, Long aptitudeId, Map<String, String> billnoMap) {
        if (!existNumberMap.isEmpty()) {
            DynamicObjectCollection spentrys = supapprove.getDynamicObjectCollection("entryentity");
            for (DynamicObject spentry : spentrys) {
                DynamicObjectCollection nodeentry = spentry.getDynamicObjectCollection("subentryentity");
                if (!nodeentry.isEmpty()) continue;
                for (Map.Entry<String, DynamicObject> entry : existNumberMap.entrySet()) {
                    DynamicObject temp = nodeentry.addNew();
                    String billno = this.getAccessNodeNumber(entry.getKey(), aptitudeId, billnoMap);
                    DynamicObject accessnode = entry.getValue().getDynamicObject("accessnode");
                    temp.set("accessnode", (Object)accessnode);
                    String serviceclass = accessnode.getString("serviceclass");
                    ISrmAccessNodeService nodeService = null;
                    String objectnumber = accessnode.getString("bizobject_id");
                    if (StringUtils.isNotBlank((CharSequence)serviceclass)) {
                        nodeService = (ISrmAccessNodeService)TypesContainer.createInstance((String)serviceclass);
                        nodeService.setNodeBillnoAndStatus(objectnumber, aptitudeId, temp, spentry);
                        continue;
                    }
                    this.setSupapproveNodeStatus(temp, "0", billno);
                }
                DynamicObjectUtil.setBillEntrySeq((DynamicObject)spentry, (String)"subentryentity");
            }
        }
    }

    @Override
    public String verifyAptitudeNo(String objectnumber, Long aptitudeId) {
        DynamicObject aptitude = this.getAptitudeexam(objectnumber, aptitudeId);
        if (aptitude == null) {
            return ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u672c\u73af\u8282\u5df2\u5904\u7406\u5b8c\u6bd5\uff0c\u4e0d\u9700\u8981\u518d\u5904\u7406\u3002", (String)"SrmSupApproveNodeService_0", (String)"scm-srm-mservice", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        Map numberNodeMap = AccessNodeUtil.getExistNumberMap((DynamicObjectCollection)aptitude.getDynamicObjectCollection(SrmConstant.ENTRY_NODE));
        for (Map.Entry entry : numberNodeMap.entrySet()) {
            String message;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            String nodestatus = dynamicObject.getString("nodestatus");
            String biznumber = (String)entry.getKey();
            if ("srm_sceneexam".equals(biznumber) && !"1".equals(nodestatus)) {
                DynamicObject accessNode = dynamicObject.getDynamicObject(SrmConstant.ACCESS_NODE);
                String name = accessNode.getString("name");
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u9700\u8981{0}(\u51c6\u5165\u8282\u70b9\u5355\u636e\u6807\u8bc6:{1})\uff0c\u4f46\u672a\u5b8c\u6210\u3002", (String)"SrmSupApproveNodeService_1", (String)"scm-srm-mservice", (Object[])new Object[0]), name, biznumber));
            }
            if (!"srm_sceneexam".equals(biznumber) || !"1".equals(nodestatus) || !StringUtils.isNotBlank((CharSequence)(message = SrmBillVerifyUtil.verifySceneAptitudeNo((Long)aptitudeId)))) continue;
            sb.append(message);
        }
        return sb.toString();
    }

    private String getAccessNodeNumber(String objectnumber, Long aptitudeId, Map<String, String> billnoMap) {
        QFilter qFilter;
        DynamicObject dyn;
        String billnokey = objectnumber + "_" + aptitudeId;
        String billno = billnoMap.get(billnokey);
        if (billno == null && (dyn = QueryServiceHelper.queryOne((String)objectnumber, (String)"id,billno", (QFilter[])(qFilter = new QFilter("aptitudeno", "=", (Object)aptitudeId)).toArray())) != null) {
            billno = dyn.getString("billno");
            billnoMap.put(billnokey, billno);
        }
        return billno;
    }
}

