/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.webapi.service.impl.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.DateUtil;
import kd.scm.srm.webapi.service.impl.portal.SrmGetPortalBigAnnService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SrmGetPortalNoticeService {
    private Log LOG = LogFactory.getLog(SrmGetPortalNoticeService.class);
    JSONArray showFields = new JSONArray();
    JSONArray noticedata = new JSONArray();
    public JSONObject resultData = new JSONObject();
    SrmGetPortalBigAnnService srmGetPortalBigAnnService = new SrmGetPortalBigAnnService();

    public JSONObject queryNotices(List<String> types, String name, String datetimefrom, String datetimeto, Integer page, Integer size, String componentid) {
        StringBuilder souNoticeType = new StringBuilder(12);
        StringBuilder bidNoticeType = new StringBuilder(12);
        if (!CollectionUtils.isEmpty(types)) {
            for (String type : types) {
                if ("bidproject".equals(type) || "decision".equals(type)) {
                    bidNoticeType.append(",").append(type);
                    continue;
                }
                souNoticeType.append(",").append(type);
            }
        }
        Date dateForm = this.dealDate(datetimefrom);
        Date dateTo = this.dealDate(datetimeto);
        try {
            if (StringUtils.isNotEmpty((CharSequence)componentid) && StringUtils.isNumeric((CharSequence)componentid)) {
                this.bulidBigNotice(componentid, souNoticeType.toString(), name, bidNoticeType.toString(), dateForm, dateTo);
            } else {
                this.bulidStandNotices(souNoticeType.toString(), bidNoticeType.toString(), name, dateForm, dateTo);
                this.bulidStandShowFileds();
            }
        }
        catch (Exception e) {
            this.LOG.error("SrmGetPortalNoticeService queryNotices bulidnotice is fail e is:" + e.getMessage());
        }
        this.sortNoticeData();
        this.dealNoticeData(page, size);
        this.resultData.put((Object)"noticedata", (Object)this.noticedata);
        this.resultData.put((Object)"showfields", (Object)this.showFields);
        return this.resultData;
    }

    private void sortNoticeData() {
        if (!CollectionUtils.isEmpty((Collection)this.noticedata)) {
            JSONArray jsonArray = new JSONArray();
            Iterator iterator = this.noticedata.iterator();
            while (iterator.hasNext()) {
                JSONObject next = (JSONObject)iterator.next();
                boolean istop = next.getBoolean("istop");
                if (!istop) continue;
                jsonArray.add((Object)next);
                iterator.remove();
            }
            jsonArray.sort((x, y) -> {
                if (Objects.nonNull(((JSONObject)y).get("publishtime")) && Objects.nonNull(((JSONObject)x).get("publishtime"))) {
                    return ((JSONObject)y).get("publishtime").toString().compareTo(((JSONObject)x).get("publishtime").toString());
                }
                return 1;
            });
            this.noticedata.sort((x, y) -> {
                if (Objects.nonNull(((JSONObject)y).get("publishtime")) && Objects.nonNull(((JSONObject)x).get("publishtime"))) {
                    return ((JSONObject)y).get("publishtime").toString().compareTo(((JSONObject)x).get("publishtime").toString());
                }
                return 1;
            });
            jsonArray.addAll((Collection)this.noticedata);
            this.noticedata.clear();
            this.noticedata.addAll((Collection)jsonArray);
        }
    }

    private void bulidStandShowFileds() {
        JSONObject titile = new JSONObject();
        titile.put((Object)"key", (Object)"noticename");
        titile.put((Object)"name", (Object)ResManager.loadResFormat((String)"\u6807\u9898", (String)"SrmGetPortalNoticeService_0", (String)"scm-srm-webapi", (Object[])new Object[0]));
        JSONObject org = new JSONObject();
        org.put((Object)"key", (Object)"orgname");
        org.put((Object)"name", (Object)ResManager.loadResFormat((String)"\u53d1\u5e03\u7ec4\u7ec7", (String)"SrmGetPortalNoticeService_1", (String)"scm-srm-webapi", (Object[])new Object[0]));
        JSONObject status = new JSONObject();
        status.put((Object)"key", (Object)"status");
        status.put((Object)"name", (Object)ResManager.loadResFormat((String)"\u72b6\u6001", (String)"SrmGetPortalNoticeService_2", (String)"scm-srm-webapi", (Object[])new Object[0]));
        JSONObject type = new JSONObject();
        type.put((Object)"key", (Object)"type");
        type.put((Object)"name", (Object)ResManager.loadResFormat((String)"\u7c7b\u578b", (String)"SrmGetPortalNoticeService_3", (String)"scm-srm-webapi", (Object[])new Object[0]));
        JSONObject time = new JSONObject();
        time.put((Object)"key", (Object)"publishtime");
        time.put((Object)"name", (Object)ResManager.loadResFormat((String)"\u53d1\u5e03\u65f6\u95f4", (String)"SrmGetPortalNoticeService_4", (String)"scm-srm-webapi", (Object[])new Object[0]));
        this.showFields.add((Object)titile);
        this.showFields.add((Object)org);
        this.showFields.add((Object)status);
        this.showFields.add((Object)type);
        this.showFields.add((Object)time);
    }

    private Date dealDate(String dateTime) {
        Date date = null;
        try {
            date = DateUtil.string2date((String)dateTime, (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            this.LOG.error("datetime  format fail date is :" + dateTime + "e is:" + e.getMessage());
        }
        return date;
    }

    public void dealNoticeData(Integer page, Integer pageSize) {
        if (Objects.isNull(page) && Objects.isNull(pageSize)) {
            return;
        }
        if (page <= 0) {
            page = page + 1;
        }
        int size = this.noticedata.size();
        this.resultData.put((Object)"total", (Object)size);
        int pageStart = page == 1 ? 0 : (page - 1) * pageSize;
        int pageEnd = size < page * pageSize ? size : page * pageSize;
        ArrayList objectList = new ArrayList(12);
        objectList.addAll(this.noticedata);
        if (size > pageStart) {
            List subList = objectList.subList(pageStart, pageEnd);
            this.noticedata.clear();
            this.noticedata.addAll(subList);
        }
    }

    public void bulidStandNotices(String souNoticeType, String bidNoticeType, String name, Date datetimefrom, Date datetimeto) {
        if (StringUtils.isNotEmpty((CharSequence)souNoticeType)) {
            String select = "id,noticetitle,billdate,org.name,org.number,biztype,srcbillid";
            DynamicObject[] notices = this.srmGetPortalBigAnnService.querySouNotice(souNoticeType, null, select, datetimefrom, datetimeto, name, 0);
            this.srmGetPortalBigAnnService.bulidstandNotice(notices, this.noticedata, "quo_notice");
        }
        if (StringUtils.isNotEmpty((CharSequence)bidNoticeType)) {
            String s = "id,annotitle,publishdate,org.name,org.number,bidproject,annotype";
            DynamicObject[] bid_notices = this.srmGetPortalBigAnnService.queryBidNotice(bidNoticeType, s, datetimefrom, datetimeto, name, 0);
            this.srmGetPortalBigAnnService.bulidstandNotice(bid_notices, this.noticedata, "bid_announcement");
        }
    }

    public void bulidBigNotice(String componentid, String souNoticeType, String name, String bidNoticeType, Date datetimefrom, Date datetimeto) {
        this.srmGetPortalBigAnnService.setComponentId(Long.parseLong(componentid));
        DynamicObject bigComponent = this.srmGetPortalBigAnnService.queryComponent();
        this.srmGetPortalBigAnnService.bulidNotices(bigComponent, false, this.showFields, souNoticeType, bidNoticeType, this.noticedata, datetimefrom, datetimeto, name);
    }
}

