/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.webapi.service.impl.portal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.srm.common.constant.SrmConstant;
import kd.scm.srm.webapi.service.impl.portal.SrmAbstractPortalService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SrmGetPortalStandService
extends SrmAbstractPortalService {
    private Log LOG = LogFactory.getLog(SrmGetPortalStandService.class);
    JSONObject componentData = new JSONObject();
    JSONObject componentInfo = new JSONObject();
    JSONObject componentObj = new JSONObject();

    public SrmGetPortalStandService(Long componentId, JSONArray resultArrayData) {
        super(componentId, resultArrayData);
    }

    @Override
    public DynamicObject queryComponent() {
        DynamicObject standComponent = BusinessDataServiceHelper.loadSingle((String)"srm_portal_standannounce", (String)"id,number,noticeshowtime,name,isfilter,leftpicture,leftname,leftnoticetype,leftsrctype,leftbidtype,rightpicture,rightname,rightnoticetype,rightsrctype,rightbidtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.componentId)});
        return standComponent;
    }

    @Override
    public void bulidComponent() {
        this.componentObj.put((Object)"type", (Object)"2");
        this.componentObj.put((Object)"about", (Object)this.compoent.getString("name"));
        this.componentObj.put((Object)"componentid", (Object)this.compoent.getString("id"));
        JSONObject standComponentObj = new JSONObject();
        String rightpicture = this.compoent.getString("rightpicture");
        if (StringUtils.isNotEmpty((CharSequence)rightpicture)) {
            standComponentObj.put((Object)"rightimgsrc", (Object)SrmGetPortalStandService.getPortalPathUrl(UrlService.getImageFullUrl((String)rightpicture)));
        } else {
            standComponentObj.put((Object)"rightimgsrc", (Object)(UrlService.getDomainContextUrl() + SrmConstant.SYS_PORTAL_RIGHTSTAND_BACK_PNG));
        }
        standComponentObj.put((Object)"rightname", (Object)this.compoent.getString("rightname"));
        String leftpicture = this.compoent.getString("leftpicture");
        if (StringUtils.isNotEmpty((CharSequence)leftpicture)) {
            standComponentObj.put((Object)"leftimgsrc", (Object)SrmGetPortalStandService.getPortalPathUrl(UrlService.getImageFullUrl((String)leftpicture)));
        } else {
            standComponentObj.put((Object)"leftimgsrc", (Object)(UrlService.getDomainContextUrl() + SrmConstant.SYS_PORTAL_LEFTSTAND_BACK_PNG));
        }
        standComponentObj.put((Object)"leftname", (Object)this.compoent.getString("leftname"));
        JSONArray letfNoticeTypes = this.bulidNoticeTypes("leftnoticetype", "leftbidtype");
        JSONArray rightNoticeTypes = this.bulidNoticeTypes("rightnoticetype", "rightbidtype");
        standComponentObj.put((Object)"leftnoticetypes", (Object)letfNoticeTypes);
        standComponentObj.put((Object)"rightnoticetypes", (Object)rightNoticeTypes);
        this.componentObj.put((Object)"standardcardcomponent", (Object)standComponentObj);
        this.componentData.put((Object)"component", (Object)this.componentObj);
        this.bulidStandcomponentData("leftnoticetype", "leftsrctype", "leftstandardcardinfos", "leftbidtype");
        this.bulidStandcomponentData("rightnoticetype", "rightsrctype", "rightstandardcardinfos", "rightbidtype");
        this.componentData.put((Object)"componentInfo", (Object)this.componentInfo);
        this.resultArrayData.add((Object)this.componentData);
    }

    public void bulidStandcomponentData(String noticeType, String srctype, String standardcardinfos_key, String bidtypeParm) {
        JSONArray standardcardinfos = new JSONArray();
        String type = this.compoent.getString(noticeType);
        String bidtype = this.compoent.getString(bidtypeParm);
        int noticeshowtime = this.compoent.getInt("noticeshowtime");
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            String selects = "id,noticetitle,billdate,org.name,org.number,biztype,srcbillid";
            DynamicObjectCollection srctypes = this.compoent.getDynamicObjectCollection(srctype);
            Set<Long> srctypesids = new HashSet<Long>(12);
            if (!CollectionUtils.isEmpty((Collection)srctypes)) {
                srctypesids = srctypes.stream().map(x -> x.getLong("fbasedataid.id")).collect(Collectors.toSet());
            }
            DynamicObject[] sou_notices = this.querySouNotice(type, srctypesids, selects, null, null, null, noticeshowtime);
            this.bulidstandNotice(sou_notices, standardcardinfos, "quo_notice");
        } else {
            this.LOG.info("noticetype is null ");
        }
        if (StringUtils.isNotEmpty((CharSequence)bidtype)) {
            String s = "id,annotitle,publishdate,org.name,org.number,bidproject,annotype";
            DynamicObject[] bid_notices = this.queryBidNotice(bidtype, s, null, null, null, noticeshowtime);
            this.bulidstandNotice(bid_notices, standardcardinfos, "bid_announcement");
        }
        standardcardinfos = this.srmPortalNoticeDtoToJsonArray(standardcardinfos, 6);
        this.componentInfo.put((Object)standardcardinfos_key, (Object)standardcardinfos);
    }

    private JSONArray bulidNoticeTypes(String noticetypeKey, String bidtypeKey) {
        String leftnoticetype = this.compoent.getString(noticetypeKey);
        String leftbidtype = this.compoent.getString(bidtypeKey);
        JSONArray noticeTypes = new JSONArray();
        if (StringUtils.isNotEmpty((CharSequence)leftnoticetype)) {
            JSONArray comFieldMapValue = this.getComFieldMapValue("srm_portal_standannounce", noticetypeKey, leftnoticetype);
            noticeTypes.addAll((Collection)comFieldMapValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)leftbidtype)) {
            JSONArray bidMapTypes = this.getComFieldMapValue("srm_portal_standannounce", bidtypeKey, leftbidtype);
            noticeTypes.addAll((Collection)bidMapTypes);
        }
        return noticeTypes;
    }
}

