/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.constant.SupplierLifeCycleConstant;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmApproveUtil;

public class BlackEnterpriseUtil {
    public static void auditUpdateSup(DynamicObject[] newDyo) {
        BlackEnterpriseUtil.updateSysSupStatus(newDyo);
        BlackEnterpriseUtil.updateSysSupSupplierStatus(newDyo);
        BlackEnterpriseUtil.updateSrmSupStatus(newDyo);
        BlackEnterpriseUtil.updateSrmSupSupplierStatus(newDyo);
        BlackEnterpriseUtil.updateSrmTempSupplierStatus(newDyo);
        BlackEnterpriseUtil.updateSrmCategorySupStatus(newDyo);
        BlackEnterpriseUtil.disablePurUser(newDyo);
    }

    public static void alertUpdateSup(DynamicObject[] newDyo) {
        BlackEnterpriseUtil.alertupdateSrmSupStatus(newDyo);
        BlackEnterpriseUtil.alertupdateSysSupStatus(newDyo);
    }

    public static void disablePurUser(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        HashSet<Long> bizpartnerIdSet = new HashSet<Long>(16);
        DynamicObjectCollection srm_suppliers = QueryServiceHelper.query((String)"srm_supplier", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("societycreditcode", "in", numberSet)});
        for (DynamicObject supplier : srm_suppliers) {
            long bizpartner = supplier.getLong("bizpartner");
            bizpartnerIdSet.add(bizpartner);
        }
        Map pur_supusers = BusinessDataServiceHelper.loadFromCache((String)"pur_supuser", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizpartnerIdSet)});
        OperationServiceHelper.executeOperate((String)"disable", (String)"pur_supuser", (DynamicObject[])pur_supusers.values().toArray(new DynamicObject[pur_supusers.size()]), null);
    }

    public static void alertupdateSysSupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getDynamicObject("supplier").getString("id"));
        }
        QFilter prodfilter = new QFilter("id", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,societycreditcode,enable,ctrlstrategy", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])supplierArr);
    }

    public static void alertupdateSrmSupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getDynamicObject("supplier").getString("id"));
        }
        QFilter prodfilter = new QFilter("id", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,number,enable", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])supplierArr);
    }

    public static void updateSrmCategorySupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("supplier.societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"id,number,auditstatus,supplier_id,org_id,category_id,modifier_id,issourcelist,modifytime,categorytype,material,material_id,sourcelistentryid,effectdate,expirydate", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("auditstatus", (Object)4);
            supplier.set("modifytime", (Object)TimeServiceHelper.now());
        }
        SrmCommonUtil.saveDynamicObject((String)"srm_supcategory", (DynamicObject[])supplierArr);
    }

    public static void updateSrmSupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,number,societycreditcode,enable", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])supplierArr);
    }

    public static void updateSrmSupSupplierStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,number,societycreditcode,enable,supplier_status", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("supplier_status", (Object)SupplierLifeCycleConstant.SUPSTATUS_INVALID);
        }
        SaveServiceHelper.save((DynamicObject[])supplierArr);
    }

    public static void updateSrmTempSupplierStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("supplier.societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"srm_supapprovetemp", (String)"id,tempstatus,remaindate", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("tempstatus", (Object)"C");
            supplier.set("remaindate", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])supplierArr);
    }

    public static void enableSrmSupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"srm_supplier", (String)"id,number,societycreditcode,enable", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        for (DynamicObject supplier : supplierArr) {
            supplier.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])supplierArr);
    }

    public static void updateSysSupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,societycreditcode,enable,ctrlstrategy", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        ArrayList<Long> bdSupIds = new ArrayList<Long>(1);
        for (DynamicObject dynamicObject : supplierArr) {
            bdSupIds.add(dynamicObject.getLong("id"));
        }
        SrmApproveUtil.updateSupplierStatus(bdSupIds, false);
    }

    public static void updateSysSupSupplierStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        QFilter prodfilter = new QFilter("societycreditcode", "in", numberSet);
        DynamicObject[] supplierArr = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,societycreditcode,enable,ctrlstrategy,supplier_status", (QFilter[])new QFilter[]{prodfilter});
        if (supplierArr.length <= 0) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            for (DynamicObject supplier : supplierArr) {
                supplier.set("supplier_status", (Object)SupplierLifeCycleConstant.SUPSTATUS_INVALID);
            }
            SaveServiceHelper.save((DynamicObject[])supplierArr);
        }
    }

    public static void updateEASSupStatus(DynamicObject[] newDyo) {
        HashSet<String> numberSet = new HashSet<String>(newDyo.length);
        for (DynamicObject dyn : newDyo) {
            numberSet.add(dyn.getString("number"));
        }
        HashMap<String, Object> billInfoMap = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        billInfoMap.put("cardnumber", numberSet);
        billInfoMap.put("operate", "blacklist");
        param.put("data", billInfoMap);
        param.put("code", "200");
        ApiUtil.srmSupplierOperateEasSupplier(param);
    }
}

