/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class SrmAddSupplierRegUtil {
    private static Log logger = LogFactory.getLog(SrmAddSupplierRegUtil.class);

    public static List<Object[]> addSupplierReg(DynamicObject[] dataEntities, ListSelectedRowCollection listSelectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber("srm_issuerfi");
        pushArgs.setTargetEntityNumber("adm_supplierreg");
        pushArgs.setSelectedRows((List)listSelectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        HashMap<String, String> supplierRegIdMap = new HashMap<String, String>(16);
        if (result != null && result.isSuccess()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"adm_supplierreg");
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            logger.info("\u53d1\u653eRFI\u4e0b\u63a8\u6ce8\u518c\u8d44\u6599,targetData:" + targetData);
            for (DynamicObject ts : targetData) {
                ts.set("curr", null);
                String name = ts.getLocaleString("name").getLocaleValue();
                String supplierId = ts.getString("id");
                supplierRegIdMap.put(name, supplierId);
            }
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"adm_supplierreg", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!saveOperate.isSuccess()) {
                logger.info("\u53d1\u653eRFI\u4e0b\u63a8\u6ce8\u518c\u8d44\u6599\u4fdd\u5b58\u5931\u8d25,saveOperate:" + saveOperate.getMessage() + saveOperate.getAllErrorOrValidateInfo());
                throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u653eRFI\u4e0b\u63a8\u6ce8\u518c\u8d44\u6599\u4fdd\u5b58\u5931\u8d25\uff1a%1", (String)"SrmSendEmailUtil_21", (String)"scm-srm-common", (Object[])new Object[]{saveOperate.getAllErrorOrValidateInfo()}));
            }
        } else {
            StringBuilder message = new StringBuilder();
            if (result != null && CollectionUtils.isNotEmpty((Collection)result.getBillReports())) {
                result.getBillReports().forEach(x -> message.append(x.getFailMessage()).append("\t"));
            }
            logger.info("\u53d1\u653eRFI\u4e0b\u63a8\u6ce8\u518c\u8d44\u6599\u5931\u8d25,result:" + message);
        }
        ArrayList<Object[]> ids = new ArrayList<Object[]>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            String suppliername = bill.getString("suppliername");
            String linkman = bill.getString("linkman");
            String email = bill.getString("email");
            DynamicObject srmUser = BusinessDataServiceHelper.newDynamicObject((String)"srm_user");
            srmUser.set("name", (Object)linkman);
            srmUser.set("supplierregid", supplierRegIdMap.get(suppliername));
            srmUser.set("number", (Object)email);
            srmUser.set("enterprise", (Object)suppliername);
            srmUser.set("enable", (Object)"1");
            srmUser.set("status", (Object)"C");
            srmUser.set("creator", (Object)RequestContext.get().getUserId());
            srmUser.set("createtime", (Object)TimeServiceHelper.now());
            Object[] id = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srmUser});
            ids.add(id);
        }
        return ids;
    }
}

