/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmCategoryEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;

public class SrmBillEditUtil {
    private static IAppCache cache = AppCache.get((String)"scm_group");
    private static Log logger = LogFactory.getLog(SrmBillEditUtil.class);

    public static Map<String, Object> getAptitudeCategoryFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long aptitudeId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("aptitudeno"));
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)aptitudeId)};
        DynamicObject aptitudeexam = BusinessDataServiceHelper.loadSingle((String)"srm_aptitudeexam", (String)"entryentity.category,iscategory,id", (QFilter[])filters);
        if (aptitudeexam == null || !aptitudeexam.getBoolean("iscategory") || aptitudeexam.getDynamicObjectCollection("entryentity").size() == 0 || !SrmBillEditUtil.isContainCategory(aptitudeexam.getDynamicObjectCollection("entryentity")).booleanValue()) {
            resultMap.put("succed", Boolean.TRUE);
            QFilter filter = new QFilter("standard", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID);
            resultMap.put("message", filter);
            return resultMap;
        }
        ArrayList<Long> categroyList = new ArrayList<Long>();
        DynamicObjectCollection categoryObjs = aptitudeexam.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : categoryObjs) {
            categroyList.add(obj.getLong("category.id"));
        }
        QFilter filter = new QFilter("id", "in", categroyList);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Boolean isContainCategory(DynamicObjectCollection categoryEntry) {
        Boolean isCategory = false;
        for (DynamicObject category : categoryEntry) {
            long aLong = category.getLong("category.id");
            if (0L == aLong) continue;
            isCategory = true;
        }
        return isCategory;
    }

    public static Map<String, Object> getSupOrgCategoryId(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("supplier"));
        if (supplierId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u3002", (String)"SrmBillEditUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("org"));
        if (!SrmBillEditUtil.hasSelectedOrg(orgId, resultMap)) {
            return resultMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("supplier", "=", (Object)supplierId).and("org", "=", (Object)orgId).and("auditstatus", "!=", (Object)SrmCategoryEnum.QUITED.getVal()).and("categorytype", "=", (Object)"B").and("auditstatus", "!=", (Object)SrmCategoryEnum.INVALID.getVal())};
        DynamicObjectCollection categoryObjs = QueryServiceHelper.query((String)"srm_supcategory", (String)"category", (QFilter[])filters);
        HashSet<Long> categroyList = new HashSet<Long>();
        for (DynamicObject obj : categoryObjs) {
            categroyList.add(obj.getLong("category"));
        }
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", categroyList);
        return resultMap;
    }

    public static boolean hasSelectedOrg(long orgId, Map<String, Object> resultMap) {
        if (orgId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u91c7\u8d2d\u65b9\u3002", (String)"SrmBillEditUtil_3", (String)"scm-srm-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Map<String, Object> getSupOrgFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("supplier"));
        if (supplierId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u3002", (String)"SrmBillEditUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("supplier", "=", (Object)supplierId).and("auditstatus", "!=", (Object)SrmCategoryEnum.QUITED.getVal())};
        DynamicObjectCollection orgObjs = QueryServiceHelper.query((String)"srm_supcategory", (String)"org", (QFilter[])filters);
        if (orgObjs == null || orgObjs.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u54c1\u7c7b\u5e93\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7ec4\u7ec7\u3002", (String)"SrmBillEditUtil_5", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        for (DynamicObject obj : orgObjs) {
            orgList.add(obj.getLong("org"));
        }
        QFilter filter = new QFilter("id", "in", orgList);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Map<String, Object> getEvaGradeFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long evatypeId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("evatype"));
        if (evatypeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7c7b\u578b\u3002", (String)"SrmBillEditUtil_6", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        QFilter filter = new QFilter("evatype", "=", (Object)evatypeId);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Map<String, Object> getSchemeFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long biztypeId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("evatype"));
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("org"));
        long categoryId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("category"));
        if (biztypeId == 0L && orgId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7c7b\u578b\u548c\u8bc4\u4f30\u7ec4\u7ec7\u3002", (String)"SrmBillEditUtil_7", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        if (biztypeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7c7b\u578b\u3002", (String)"SrmBillEditUtil_6", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        if (orgId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7ec4\u7ec7\u3002", (String)"SrmBillEditUtil_12", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        QFilter qFilter = new QFilter("evatype", "=", (Object)biztypeId).and(new QFilter("isorg", "=", (Object)Boolean.FALSE).or("orgscope.fbasedataid", "=", (Object)orgId));
        if (categoryId != 0L) {
            qFilter = qFilter.and(new QFilter("iscategory", "=", (Object)Boolean.FALSE).or("categoryscope.fbasedataid", "=", (Object)categoryId));
        }
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", qFilter);
        return resultMap;
    }

    public static Map<String, Object> getIndexFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        DynamicObject bizObj = currmodel.getDataEntity().getDynamicObject("evatype");
        if (bizObj == null) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7c7b\u578b\u3002", (String)"SrmBillEditUtil_6", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        long biztypeId = bizObj.getLong("id");
        QFilter qFilter = new QFilter("isevatype", "=", (Object)Boolean.FALSE).or("evatypescope.fbasedataid", "=", (Object)biztypeId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_index", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (rows == null || rows.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u7c7b\u578b\u65e0\u5bf9\u5e94\u8bc4\u4f30\u6307\u6807\u3002", (String)"SrmBillEditUtil_8", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> indexIds = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            indexIds.add(row.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", indexIds);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Map<String, Object> getIndexClassFilter(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        DynamicObjectCollection rows = currmodel.getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u6307\u6807\u3002", (String)"SrmBillEditUtil_9", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> indexClassIds = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            DynamicObject obj = row.getDynamicObject("index");
            if (obj == null || "9".equals(obj.getString("scoretype"))) continue;
            if (currmodel.getDataEntity().getBoolean("istypescorer")) {
                indexClassIds.add(obj.getLong("indextype.id"));
                continue;
            }
            indexClassIds.add(obj.getLong("indexclass.id"));
        }
        QFilter filter = new QFilter("id", "in", indexClassIds);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Map<String, Object> getIndexClassFilterFromScheme(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long schemeId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("scheme"));
        if (schemeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u65b9\u6848\u3002", (String)"SrmBillEditUtil_10", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
        DynamicObjectCollection rows = scheme.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8bc4\u4f30\u65b9\u6848\u5bf9\u5e94\u7684\u8bc4\u4f30\u6307\u6807\u3002", (String)"SrmBillEditUtil_11", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> indexClassIds = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            DynamicObject obj = row.getDynamicObject("index");
            if (obj == null || "9".equals(obj.getString("scoretype"))) continue;
            if (currmodel.getDataEntity().getBoolean("istypescorer")) {
                indexClassIds.add(obj.getLong("indextype.id"));
                continue;
            }
            indexClassIds.add(obj.getLong("indexclass.id"));
        }
        QFilter filter = new QFilter("id", "in", indexClassIds);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Map<String, Object> getIndexClassFilterFromScheme(long schemeId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        if (schemeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u65b9\u6848\u3002", (String)"SrmBillEditUtil_10", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"srm_scheme");
        DynamicObjectCollection rows = scheme.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8bc4\u4f30\u65b9\u6848\u5bf9\u5e94\u7684\u8bc4\u4f30\u6307\u6807\u3002", (String)"SrmBillEditUtil_11", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> indexClassIds = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            DynamicObject obj = row.getDynamicObject("index");
            if (obj == null || "9".equals(obj.getString("scoretype"))) continue;
            if (scheme.getBoolean("istypescorer")) {
                indexClassIds.add(obj.getLong("indextype.id"));
                continue;
            }
            indexClassIds.add(obj.getLong("indexclass.id"));
        }
        QFilter filter = new QFilter("id", "in", indexClassIds);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", filter);
        return resultMap;
    }

    public static Map<String, Object> getSchemeFilter(long biztypeId, long orgId, long categoryId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        if (biztypeId == 0L && orgId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7c7b\u578b\u548c\u8bc4\u4f30\u7ec4\u7ec7\u3002", (String)"SrmBillEditUtil_7", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        if (biztypeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7c7b\u578b\u3002", (String)"SrmBillEditUtil_6", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        if (orgId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u4f30\u7ec4\u7ec7\u3002", (String)"SrmBillEditUtil_12", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        QFilter qFilter = new QFilter("evatype", "=", (Object)biztypeId).and(new QFilter("isorg", "=", (Object)Boolean.FALSE).or("orgscope.fbasedataid", "=", (Object)orgId));
        if (categoryId != 0L) {
            qFilter = qFilter.and(new QFilter("iscategory", "=", (Object)Boolean.FALSE).or("categoryscope.fbasedataid", "=", (Object)categoryId));
        }
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", qFilter);
        return resultMap;
    }

    public static void setAptitudeNo(IDataModel currModel, String field2, String field3) {
        DynamicObjectCollection aptitudeObjs;
        DynamicObject billObj = currModel.getDataEntity(true);
        String bizType = billObj.getString("biztype");
        currModel.setValue("aptitudeno", null);
        currModel.setValue("bizpartner", null);
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        if (supplierId == 0L) {
            return;
        }
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("org"));
        DynamicObject supplier = (DynamicObject)currModel.getValue("supplier");
        currModel.setValue("bizpartner", (Object)supplier.getLong("bizpartner_id"));
        QFilter[] filters = new QFilter[]{new QFilter("supplier", "=", (Object)supplierId).and("org", "=", (Object)orgId).and(field2, "=", (Object)"1").and(field3, "=", (Object)"0").and("auditstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("examresult", "=", (Object)"0")};
        DynamicObject org = currModel.getDataEntity().getDynamicObject("org");
        boolean isCateGory = SrmCategoryConfigUtil.isCategory(org);
        if (org != null && !isCateGory && Objects.nonNull(org) && (field2.equals("issample") || field2.equals("ismaterial"))) {
            String billKey = field2.equals("issample") ? "srm_sampleexam" : "srm_materialexam";
            DynamicObjectCollection sampleexamcol = QueryServiceHelper.query((String)billKey, (String)"aptitudeno.id", (QFilter[])new QFilter[]{new QFilter("auditstatus", "=", (Object)"B").and("supplier.id", "=", (Object)supplierId).and("org.id", "=", org.getPkValue())});
            HashSet<Long> idSet = new HashSet<Long>(16);
            for (DynamicObject sampleexam : sampleexamcol) {
                long aptitudenoId = sampleexam.getLong("aptitudeno.id");
                idSet.add(aptitudenoId);
            }
            filters[0].and("id", "not in", idSet);
        }
        if ((aptitudeObjs = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"id", (QFilter[])filters, (String)"billdate")) == null || aptitudeObjs.size() == 0) {
            return;
        }
        long aptitudeId = ((DynamicObject)aptitudeObjs.get(0)).getLong("id");
        if (aptitudeId == 0L) {
            return;
        }
        currModel.setValue("aptitudeno", (Object)aptitudeId);
        if (bizType.equals("6")) {
            DynamicObject sceneObj = QueryRecordUtil.queryRecordSet((String)"srm_sceneexam", (String)"id", (String)"aptitudeno", (Object)aptitudeId, (String)"auditstatus", (Object)BillStatusEnum.AUDIT.getVal(), (String)"sceneresult", (Object)"1", null, null, null, (String)"queryOneOrder", (String)"billdate");
            if (sceneObj == null) {
                return;
            }
            long sceneId = sceneObj.getLong("id");
            if (sceneId == 0L) {
                return;
            }
            currModel.setValue("sceneno", (Object)sceneId);
        }
    }

    public static void setSampleInfo(IDataModel currModel) {
        long sampleNotifyId = SrmCommonUtil.getPkValue((DynamicObject)currModel.getDataEntity().getDynamicObject("notifyno"));
        if (sampleNotifyId == 0L) {
            return;
        }
        DynamicObject sampleObj = BusinessDataServiceHelper.loadSingle((Object)sampleNotifyId, (String)"srm_samplenotify");
        if (sampleObj == null) {
            return;
        }
        String remark = sampleObj.getString("remark");
        currModel.getDataEntity().set("remark", (Object)remark);
        DynamicObjectCollection sampleEntries = sampleObj.getDynamicObjectCollection("entryentity");
        if (sampleEntries == null || sampleEntries.size() == 0) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < sampleEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)sampleEntries.get(i);
            long categoryId = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("category"));
            long materielId = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("material"));
            long unitId = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("unit"));
            BigDecimal qty = entry.getBigDecimal("qty");
            Date senddate = entry.getDate("senddate");
            BigDecimal sendqty = entry.getBigDecimal("sendqty");
            Date arrivaldate = entry.getDate("arrivaldate");
            String receiver = entry.getString("receiver");
            String phone = entry.getString("phone");
            String address = entry.getString("address");
            vs.set("seq", (Object)(i + 1), i);
            vs.set("category", (Object)categoryId, i);
            vs.set("material", (Object)materielId, i);
            vs.set("unit", (Object)unitId, i);
            vs.set("qty", (Object)qty, i);
            vs.set("senddate", (Object)senddate, i);
            vs.set("sendqty", (Object)sendqty, i);
            vs.set("arrivaldate", (Object)arrivaldate, i);
            vs.set("receiver", (Object)receiver, i);
            vs.set("phone", (Object)phone, i);
            vs.set("address", (Object)address, i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)currModel;
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    public static void setCategory(AbstractFormDataModel currModel) {
        DynamicObject billObj = currModel.getDataEntity(true);
        String bizType = billObj.getString("biztype");
        if ("B".equals(bizType)) {
            bizType = "4";
        }
        currModel.deleteEntryData("entryentity");
        long aptitudeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("aptitudeno"));
        if (aptitudeId == 0L) {
            return;
        }
        DynamicObject aptitudeObj = BusinessDataServiceHelper.loadSingle((Object)aptitudeId, (String)"srm_aptitudeexam");
        if (aptitudeObj == null) {
            return;
        }
        DynamicObjectCollection categoryEntries = aptitudeObj.getDynamicObjectCollection("entryentity");
        if (!bizType.equals("3") && !bizType.equals("B")) {
            DynamicObjectCollection entryentity;
            String billType = "";
            switch (bizType) {
                case "4": {
                    billType = "srm_sampleexam";
                    break;
                }
                case "5": {
                    billType = "srm_materialexam";
                    break;
                }
                case "6": {
                    billType = "srm_supapprove";
                }
            }
            DynamicObjectCollection aptitudeBill = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.category.id,entryentity.material.id,entryentity.categorytype", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C").and(new QFilter("id", "=", (Object)aptitudeId))});
            HashMap<Object, Long> hasMap = new HashMap<Object, Long>(16);
            for (DynamicObject aptitudeDyo : aptitudeBill) {
                Long categoryId = aptitudeDyo.getLong("entryentity.category.id");
                DynamicObject[] materialId = Long.valueOf(aptitudeDyo.getLong("entryentity.material.id"));
                String categorytype = aptitudeDyo.getString("entryentity.categorytype");
                if (categorytype == null) continue;
                if (categorytype.equals("A")) {
                    hasMap.put(materialId, categoryId);
                    continue;
                }
                if (!categorytype.equals("B")) continue;
                hasMap.put(categoryId, 1L);
            }
            ArrayList<Object> categoryIdList = new ArrayList<Object>(16);
            ArrayList<Long> materialIdList = new ArrayList<Long>(16);
            if (billType.equals("srm_sampleexam")) {
                DynamicObject[] sampleexamBills;
                for (DynamicObject sampleexamBill : sampleexamBills = BusinessDataServiceHelper.load((String)billType, (String)"entryentity,entryentity.category,entryentity.category.id,entryentity.testresult,entryentity.material,entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("aptitudeno.number", "=", (Object)aptitudeId).and(new QFilter("auditstatus", "=", (Object)"C"))})) {
                    entryentity = sampleexamBill.getDynamicObjectCollection("entryentity");
                    for (Object entryData : entryentity) {
                        Long categoryId = entryData.getLong("category.id");
                        Long materialId = entryData.getLong("material.id");
                        String testresult = entryData.getString("testresult");
                        if (!testresult.equals("1")) continue;
                        if (!categoryIdList.contains(categoryId) && hasMap.get(categoryId) != null && (Long)hasMap.get(categoryId) == 1L) {
                            categoryIdList.add(categoryId);
                        }
                        if (!hasMap.containsKey(materialId)) continue;
                        materialIdList.add(materialId);
                    }
                }
            } else if (billType.equals("srm_materialexam")) {
                DynamicObject[] materialexamBills;
                for (DynamicObject materialexamBill : materialexamBills = BusinessDataServiceHelper.load((String)billType, (String)"entryentity,entryentity.category,entryentity.category.id,tryresult,entryentity.material,entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("aptitudeno.number", "=", (Object)aptitudeId).and(new QFilter("auditstatus", "=", (Object)"C"))})) {
                    entryentity = materialexamBill.getDynamicObjectCollection("entryentity");
                    String tryresult = materialexamBill.getString("tryresult");
                    if (!tryresult.equals("1")) continue;
                    for (Object entryData : entryentity) {
                        Long categoryId = entryData.getLong("category.id");
                        Long materialId = entryData.getLong("material.id");
                        if (!categoryIdList.contains(categoryId) && hasMap.get(categoryId) != null && (Long)hasMap.get(categoryId) == 1L) {
                            categoryIdList.add(categoryId);
                        }
                        if (!hasMap.containsKey(materialId)) continue;
                        materialIdList.add(materialId);
                    }
                }
            } else if (billType.equals("srm_supapprove")) {
                DynamicObject[] bizTypeDyos;
                for (DynamicObject bizTypeDyo : bizTypeDyos = BusinessDataServiceHelper.load((String)billType, (String)"aptitudeno,entryentity.categorystatus,entryentity,entryentity.category,entryentity.category.id,entryentity.tryresult,entryentity.testresult,entryentity.categoryfullname,entryentity.sampleno,entryentity.tryno,entryentity.material,entryentity.material.id,categorytype", (QFilter[])new QFilter[]{new QFilter("aptitudeno.number", "=", (Object)aptitudeId).and(new QFilter("auditstatus", "=", (Object)"C"))})) {
                    DynamicObjectCollection bizTypeentry = bizTypeDyo.getDynamicObjectCollection("entryentity");
                    Boolean issample = bizTypeDyo.getDynamicObject("aptitudeno").getBoolean("issample");
                    Boolean ismaterial = bizTypeDyo.getDynamicObject("aptitudeno").getBoolean("ismaterial");
                    for (DynamicObject dataRow : bizTypeentry) {
                        Long categoryId = dataRow.getDynamicObject("category").getLong("id");
                        String testresult = dataRow.getString("testresult");
                        String tryresult = dataRow.getString("tryresult");
                        String tryno = dataRow.getString("tryno");
                        String sampleno = dataRow.getString("sampleno");
                        String categorystatus = dataRow.getString("categorystatus");
                        String categorytype = dataRow.getString("categorytype");
                        if (issample.booleanValue() && (sampleno == null || sampleno.trim().equals("")) || ismaterial.booleanValue() && (tryno == null || tryno.trim().equals("")) || issample.booleanValue() && !testresult.equals("1") || ismaterial.booleanValue() && !tryresult.equals("1") || categorystatus == null || categorystatus.equals("")) continue;
                        if (categorytype.equals("A")) {
                            Long materialId = dataRow.getDynamicObject("material").getLong("id");
                            materialIdList.add(materialId);
                        }
                        categoryIdList.add(categoryId);
                    }
                }
            }
            for (int i = categoryEntries.size() - 1; i >= 0; --i) {
                Long materialId;
                String categorytype = ((DynamicObject)categoryEntries.get(i)).getString("categorytype");
                if (((DynamicObject)categoryEntries.get(i)).getDynamicObject("category") == null) continue;
                Long categoryId = ((DynamicObject)categoryEntries.get(i)).getDynamicObject("category").getLong("id");
                if (categorytype.equals("B") && categoryIdList.contains(categoryId)) {
                    categoryEntries.remove(i);
                    continue;
                }
                if (!categorytype.equals("A") || !materialIdList.contains(materialId = Long.valueOf(((DynamicObject)categoryEntries.get(i)).getDynamicObject("material").getLong("id")))) continue;
                categoryEntries.remove(i);
            }
        }
        if (categoryEntries == null || categoryEntries.size() == 0) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DynamicObjectCollection sampleObjs = QueryServiceHelper.query((String)"srm_sampleexam", (String)"id,entryentity.category.id,entryentity.material.id,entryentity.testresult", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C").and(new QFilter("aptitudeno.number", "=", (Object)aptitudeId)).and(new QFilter("auditstatus", "=", (Object)"C"))});
        DynamicObjectCollection materialObjs = QueryServiceHelper.query((String)"srm_materialexam", (String)"id,entryentity.category.id,entryentity.material.id,tryresult", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C").and(new QFilter("aptitudeno.number", "=", (Object)aptitudeId)).and(new QFilter("auditstatus", "=", (Object)"C"))});
        for (int i = 0; i < categoryEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)categoryEntries.get(i);
            if (bizType.equals("3")) {
                String categoryType = entry.getString("categorytype");
                vs.set("categorytype", (Object)categoryType, i);
            }
            long categoryId = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("category"));
            long materialId = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("material"));
            vs.set("seq", (Object)(i + 1), i);
            vs.set("category", (Object)categoryId, i);
            vs.set("material", (Object)materialId, i);
            vs.set("note", (Object)entry.getString("note"), i);
            if (!bizType.equals("6")) continue;
            String categoryType = entry.getString("categorytype");
            vs.set("categorytype", (Object)categoryType, i);
            boolean issourcelist = entry.getBoolean("issourcelist");
            Date effectdate = entry.getDate("effectdate");
            Date expirydate = entry.getDate("expirydate");
            vs.set("issourcelist", (Object)issourcelist, i);
            vs.set("effectdate", (Object)effectdate, i);
            vs.set("expirydate", (Object)expirydate, i);
            DynamicObject sampleObj = null;
            String sampleObjTestresult = "3";
            for (DynamicObject tmpObj : sampleObjs) {
                String testresult;
                if (categoryType.equals("B")) {
                    long curcategoryId = tmpObj.getLong("entryentity.category.id");
                    if (curcategoryId != categoryId) continue;
                    if (sampleObj == null) {
                        sampleObj = tmpObj;
                        sampleObjTestresult = "2";
                    }
                    if (StringUtils.isBlank((CharSequence)(testresult = tmpObj.getString("entryentity.testresult"))) || !testresult.equals("1")) continue;
                    sampleObj = tmpObj;
                    sampleObjTestresult = "1";
                    continue;
                }
                long curmaterialId = tmpObj.getLong("entryentity.material.id");
                if (curmaterialId != materialId) continue;
                if (sampleObj == null) {
                    sampleObj = tmpObj;
                    sampleObjTestresult = "2";
                }
                if (StringUtils.isBlank((CharSequence)(testresult = tmpObj.getString("entryentity.testresult"))) || !testresult.equals("1")) continue;
                sampleObj = tmpObj;
                sampleObjTestresult = "1";
            }
            if (sampleObj == null) {
                vs.set("sampleno", null, i);
                vs.set("testresult", (Object)"3", i);
            } else {
                vs.set("sampleno", (Object)sampleObj.getString("id"), i);
                vs.set("testresult", (Object)sampleObjTestresult, i);
            }
            DynamicObject materialObj = null;
            String materialObjTryresult = "3";
            for (DynamicObject tmpObj : materialObjs) {
                String tryresult = tmpObj.getString("tryresult");
                if (categoryType.equals("B")) {
                    Long curcategoryId = tmpObj.getLong("entryentity.category.id");
                    if (curcategoryId != categoryId) continue;
                    if (tryresult.equals("1")) {
                        materialObj = tmpObj;
                        materialObjTryresult = "1";
                        continue;
                    }
                    if (materialObj != null) continue;
                    materialObj = tmpObj;
                    materialObjTryresult = "2";
                    continue;
                }
                Long curmaterialId = tmpObj.getLong("entryentity.material.id");
                if (curmaterialId != materialId) continue;
                if (tryresult.equals("1")) {
                    materialObj = tmpObj;
                    materialObjTryresult = "1";
                    continue;
                }
                if (materialObj != null) continue;
                materialObj = tmpObj;
                materialObjTryresult = "2";
            }
            if (materialObj == null) {
                vs.set("tryno", null, i);
                vs.set("tryresult", (Object)"3", i);
                continue;
            }
            vs.set("tryno", (Object)materialObj.getString("id"), i);
            vs.set("tryresult", (Object)materialObjTryresult, i);
        }
        currModel.batchCreateNewEntryRow("entryentity", vs);
    }

    public static void setCategoryChg(AbstractFormDataModel currModel) {
        DynamicObject billObj = currModel.getDataEntity(true);
        currModel.deleteEntryData("entryentity");
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("org"));
        QFilter filter = new QFilter("supplier", "=", (Object)supplierId).and("org", "=", (Object)orgId).and("auditstatus", "!=", (Object)SrmCategoryEnum.QUITED.getVal()).and("auditstatus", "!=", (Object)SrmCategoryEnum.INVALID.getVal());
        DynamicObject[] categoryObjs = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"category,auditstatus,categorytype,material_id,issourcelist,effectdate,expirydate", (QFilter[])new QFilter[]{filter});
        if (categoryObjs == null || categoryObjs.length == 0) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < categoryObjs.length; ++i) {
            DynamicObject entry = categoryObjs[i];
            long categoryId = SrmCommonUtil.getPkValue((DynamicObject)entry.getDynamicObject("category"));
            String status = entry.getString("auditstatus");
            String categorytype = entry.getString("categorytype");
            boolean issourcelist = entry.getBoolean("issourcelist");
            long material_id = entry.getLong("material_id");
            vs.set("seq", (Object)(i + 1), i);
            vs.set("category", (Object)categoryId, i);
            vs.set("categorystatus_old", (Object)status, i);
            vs.set("categorytype", (Object)categorytype, i);
            vs.set("issourcelist", (Object)issourcelist, i);
            vs.set("material_id", (Object)material_id, i);
            vs.set("effectdate", (Object)entry.getDate("effectdate"), i);
            vs.set("expirydate", (Object)entry.getDate("expirydate"), i);
            vs.set("supcategory_id", entry.getPkValue(), i);
        }
        currModel.batchCreateNewEntryRow("entryentity", vs);
    }

    public static void setSampleNotifyNo(IDataModel currModel) {
        DynamicObject billObj = currModel.getDataEntity(true);
        long aptitudeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("aptitudeno"));
        if (aptitudeId == 0L) {
            currModel.setValue("notifyno", null);
            return;
        }
        QFilter filter = new QFilter("aptitudeno", "=", (Object)aptitudeId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal())).and(new QFilter("cfmstatus", "=", (Object)"B").or(new QFilter("cfmstatus", "=", (Object)"D")).or(new QFilter("cfmstatus", "=", (Object)"E")));
        DynamicObjectCollection tempObjs = QueryServiceHelper.query((String)"srm_samplenotify", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"billdate");
        if (tempObjs == null || tempObjs.size() == 0) {
            return;
        }
        long sampleNotifyId = ((DynamicObject)tempObjs.get(0)).getLong("id");
        if (sampleNotifyId == 0L) {
            return;
        }
        currModel.setValue("notifyno", (Object)sampleNotifyId);
    }

    public static void setScenenoMustinput(IDataModel currModel, IFormView currView) {
        DynamicObject billObj = currModel.getDataEntity(true);
        DynamicObject aptitudeObj = billObj.getDynamicObject("aptitudeno");
        if (aptitudeObj == null) {
            currModel.setValue("sceneno", null);
            return;
        }
        BasedataEdit sceneno = (BasedataEdit)currView.getControl("sceneno");
        if (aptitudeObj.getBoolean("isscene")) {
            currView.setVisible(Boolean.TRUE, new String[]{"sceneno"});
            sceneno.setMustInput(true);
        } else {
            currView.setVisible(Boolean.FALSE, new String[]{"sceneno"});
            sceneno.setMustInput(false);
        }
    }

    public static void setOrg_CategoryVisible(IFormView currView, String bizType, String pl_org, String pl_category) {
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (!((Boolean)paraMap.get("ispurorg")).booleanValue() && pl_org != null) {
            currView.setVisible(Boolean.FALSE, new String[]{pl_org});
        }
        if (!((Boolean)paraMap.get("iscategory")).booleanValue() && pl_category != null) {
            currView.setVisible(Boolean.FALSE, new String[]{pl_category});
        }
    }

    public static void setSupplier(IDataModel currModel) {
        DynamicObject supplierobj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"id,auditstatus,enable", (String)"societycreditcode", (Object)currModel.getDataEntity().getString("number"), (String)"name", (Object)currModel.getDataEntity().getString("name"), null, null, null, null, (String)"or", (String)"queryOne", null);
        if (supplierobj != null) {
            currModel.setValue("supplier", (Object)supplierobj.getLong("id"));
        } else {
            currModel.setValue("supplier", null);
        }
    }

    public static Map<String, Object> setAptitudeStatus(String bizType, DynamicObject dynamicObject, boolean finished) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long aptitudeId = SrmCommonUtil.getPkValue((DynamicObject)dynamicObject.getDynamicObject("aptitudeno"));
        if (aptitudeId == 0L) {
            return resultMap;
        }
        DynamicObject aptitudeObj = BusinessDataServiceHelper.loadSingle((Object)aptitudeId, (String)"srm_aptitudeexam");
        if (aptitudeObj == null) {
            return resultMap;
        }
        switch (bizType) {
            case "3": {
                aptitudeObj.set("hasscene", (Object)finished);
                break;
            }
            case "4": {
                aptitudeObj.set("hassample", (Object)finished);
                break;
            }
            case "5": {
                aptitudeObj.set("hasmaterial", (Object)finished);
                break;
            }
            case "6": {
                aptitudeObj.set("hasapprove", (Object)finished);
                if (finished) {
                    aptitudeObj.set("auditstatus", (Object)"E");
                    break;
                }
                aptitudeObj.set("auditstatus", (Object)"C");
                break;
            }
        }
        resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_aptitudeexam", (DynamicObject)aptitudeObj);
        return resultMap;
    }

    public static void setIndexClassValue(IFormView currView, IDataModel currModel) {
        FormShowParameter showParameter = currView.getFormShowParameter();
        Map params = showParameter.getCustomParams();
        Object tempValue = params.get("indexclass");
        DynamicObject obj = QueryRecordUtil.queryRecordSet((String)"srm_indexclass", (String)"id", (String)"id", tempValue, (String)"level", (Object)2, null, null, null, null, null, (String)"queryOne", null);
        if (obj != null) {
            currModel.setValue("indexclass", tempValue);
        } else {
            currModel.setValue("indexclass", null);
        }
    }

    public static Map<String, Object> getSupOrgMaterialId(IDataModel currmodel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("supplier"));
        if (supplierId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u3002", (String)"SrmBillEditUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)currmodel.getDataEntity().getDynamicObject("org"));
        if (!SrmBillEditUtil.hasSelectedOrg(orgId, resultMap)) {
            return resultMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("supplier", "=", (Object)supplierId).and("org", "=", (Object)orgId).and("auditstatus", "!=", (Object)SrmCategoryEnum.QUITED.getVal()).and("categorytype", "=", (Object)"A").and("auditstatus", "!=", (Object)SrmCategoryEnum.INVALID.getVal())};
        DynamicObjectCollection material = QueryServiceHelper.query((String)"srm_supcategory", (String)"material", (QFilter[])filters);
        HashSet<Long> materialList = new HashSet<Long>();
        for (DynamicObject obj : material) {
            materialList.add(obj.getLong("material"));
        }
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", materialList);
        return resultMap;
    }

    public static QFilter getMaterialFilter(String bizType, DynamicObject obj, Long aptitudeId) {
        DynamicObjectCollection entryMaterialColl;
        Set<Long> categoryIds = new HashSet<Long>();
        categoryIds.add((Long)obj.getPkValue());
        categoryIds = SrmCommonUtil.getAllNodes((String)"bd_materialgroup", (QFilter)new QFilter("enable", "=", (Object)"1"), categoryIds);
        DynamicObjectCollection aptitudeBillEntry = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.categorytype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)aptitudeId).and(new QFilter("entryentity.category.id", "=", (Object)Long.parseLong(obj.getPkValue().toString()))).and(new QFilter("entryentity.categorytype", "=", (Object)"B"))});
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        QFilter qf = new QFilter("aptitudeno.number", "=", (Object)aptitudeId).and(new QFilter("auditstatus", "=", (Object)"B").or(new QFilter("auditstatus", "=", (Object)"C")));
        if (obj != null) {
            qf.and(new QFilter("entryentity.category.id", "=", (Object)Long.parseLong(obj.getPkValue().toString())));
        }
        if (bizType.equals("srm_sampleexam")) {
            qf.and(new QFilter("entryentity.testresult", "=", (Object)"1"));
        } else if (bizType.equals("srm_materialexam")) {
            qf.and(new QFilter("tryresult", "=", (Object)"1"));
        }
        DynamicObjectCollection existBill = QueryServiceHelper.query((String)bizType, (String)"id,auditstatus,billno,entryentity.material,entryentity.material.id", (QFilter[])new QFilter[]{qf});
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject rowData : existBill) {
            if (StringUtils.isBlank((Object)rowData.getLong("entryentity.material.id"))) continue;
            Long materialId = rowData.getLong("entryentity.material.id");
            idSet.add(materialId);
        }
        if (aptitudeBillEntry == null || aptitudeBillEntry.isEmpty()) {
            entryMaterialColl = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)aptitudeId).and(new QFilter("entryentity.category.id", "=", (Object)Long.parseLong(obj.getPkValue().toString()))).and(new QFilter("entryentity.material.id", "not in", idSet))});
            for (DynamicObject groupdetail : entryMaterialColl) {
                materialIds.add((Long)groupdetail.get("entryentity.material.id"));
            }
        } else if (existBill == null || existBill.isEmpty()) {
            DynamicObjectCollection groupdetailColl = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("group.id", "in", categoryIds)});
            if (groupdetailColl.size() > 0) {
                for (DynamicObject groupdetail : groupdetailColl) {
                    materialIds.add((Long)groupdetail.get("material.id"));
                }
            }
        } else {
            entryMaterialColl = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)aptitudeId).and(new QFilter("entryentity.category.id", "=", (Object)Long.parseLong(obj.getPkValue().toString()))).and(new QFilter("entryentity.material.id", "not in", idSet))});
            for (DynamicObject groupdetail : entryMaterialColl) {
                materialIds.add((Long)groupdetail.get("entryentity.material.id"));
            }
        }
        QFilter qfilter = new QFilter("id", "in", materialIds).and(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        return qfilter;
    }

    public static QFilter getMaterialFilter(String bizType, Long aptitudeId) {
        HashSet<Long> idSet = new HashSet<Long>(1024);
        HashSet<Long> categoryIdSet = new HashSet<Long>(1024);
        QFilter qf = new QFilter("aptitudeno.number", "=", (Object)aptitudeId).and(new QFilter("auditstatus", "=", (Object)"B").or(new QFilter("auditstatus", "=", (Object)"C")));
        if (bizType.equals("srm_sampleexam")) {
            qf.and(new QFilter("entryentity.testresult", "=", (Object)"1"));
        } else if (bizType.equals("srm_materialexam")) {
            qf.and(new QFilter("tryresult", "=", (Object)"1"));
        }
        DynamicObjectCollection existBill = QueryServiceHelper.query((String)bizType, (String)"id,auditstatus,billno,entryentity.category.id,entryentity.material.id", (QFilter[])new QFilter[]{qf});
        for (DynamicObject rowData : existBill) {
            if (StringUtils.isBlank((Object)rowData.getLong("entryentity.material.id"))) continue;
            Long materialId = rowData.getLong("entryentity.material.id");
            Long categoryId = rowData.getLong("entryentity.category.id");
            idSet.add(materialId);
            categoryIdSet.add(categoryId);
        }
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        DynamicObjectCollection aptitudeexamEntry = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.categorytype,entryentity.category.id,entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)aptitudeId)});
        Set<Long> categoryIds = new HashSet<Long>();
        for (Object entryRow : aptitudeexamEntry) {
            String categorytype = entryRow.getString("entryentity.categorytype");
            if ("B".equals(categorytype)) {
                long categoryId = entryRow.getLong("entryentity.category.id");
                categoryIds.add(categoryId);
                continue;
            }
            if (!"A".equals(categorytype)) continue;
            long materialId = entryRow.getLong("entryentity.material.id");
            materialIds.add(materialId);
        }
        materialIds.removeAll(idSet);
        categoryIds.removeAll(categoryIdSet);
        categoryIds = SrmCommonUtil.getAllNodes((String)"bd_materialgroup", (QFilter)new QFilter("enable", "=", (Object)"1"), categoryIds);
        DynamicObjectCollection groupdetailColl = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("group.id", "in", categoryIds)});
        if (groupdetailColl.size() > 0) {
            for (DynamicObject groupdetail : groupdetailColl) {
                materialIds.add((Long)groupdetail.get("material.id"));
            }
        }
        QFilter qfilter = new QFilter("id", "in", materialIds).and(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        return qfilter;
    }

    public static QFilter getMaterialFilter(DynamicObject obj) {
        HashSet<Long> categoryIds = new HashSet<Long>();
        categoryIds.add((Long)obj.getPkValue());
        DynamicObjectCollection groupdetailColl = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])new QFilter[]{new QFilter("group.id", "in", categoryIds)});
        HashSet<Long> materialIds = new HashSet<Long>();
        if (groupdetailColl.size() > 0) {
            for (DynamicObject groupdetail : groupdetailColl) {
                materialIds.add((Long)groupdetail.get("material.id"));
            }
        }
        QFilter qf = new QFilter("id", "in", materialIds).and(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        return qf;
    }
}

