/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmImproveConfirmStatusEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.srm.common.SrmBillListUtil;
import kd.scm.srm.common.enums.SrmSampleTestResultEnum;
import kd.scm.srm.common.enums.SrmSceneResultEnum;

public class SrmBillVerifyUtil {
    public static Map<String, Object> isReferencedByOther(String bizType, long billId) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        switch (bizType) {
            case "2": {
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_sceneexam", "aptitudeno", billId, ResManager.loadKDString((String)"\u73b0\u573a\u8bc4\u5ba1", (String)"SrmBillVerifyUtil_0", (String)"scm-srm-common", (Object[])new Object[0]));
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    return resultMap;
                }
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_samplenotify", "aptitudeno", billId, ResManager.loadKDString((String)"\u9001\u6837\u901a\u77e5", (String)"SrmBillVerifyUtil_1", (String)"scm-srm-common", (Object[])new Object[0]));
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    return resultMap;
                }
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_sampleexam", "aptitudeno", billId, ResManager.loadKDString((String)"\u6837\u54c1\u786e\u8ba4", (String)"SrmBillVerifyUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    return resultMap;
                }
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_materialexam", "aptitudeno", billId, ResManager.loadKDString((String)"\u7269\u6599\u8bd5\u7528", (String)"SrmBillVerifyUtil_3", (String)"scm-srm-common", (Object[])new Object[0]));
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    return resultMap;
                }
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_supapprove", "aptitudeno", billId, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u751f\u6548", (String)"SrmBillVerifyUtil_4", (String)"scm-srm-common", (Object[])new Object[0]));
                if (((Boolean)resultMap.get("succed")).booleanValue()) break;
                return resultMap;
            }
            case "3": {
                StringBuilder message = new StringBuilder();
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_supapprove", "sceneno", billId, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u751f\u6548", (String)"SrmBillVerifyUtil_4", (String)"scm-srm-common", (Object[])new Object[0]));
                message.append(resultMap.get("message"));
                QFilter q1 = new QFilter("id", "=", (Object)billId);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"srm_sceneexam", (String)"billno", (QFilter[])new QFilter[]{q1});
                DynamicObject srmApprove = QueryServiceHelper.queryOne((String)"srm_improve", (String)"billno", (QFilter[])new QFilter[]{new QFilter("srcbillno", "=", dynamicObject.get("billno"))});
                if (srmApprove == null) break;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"srm_improve");
                message.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c", (String)"SrmBillVerifyUtil_51", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_33", (String)"scm-srm-common", (Object[])new Object[0])).append(mainEntityType.getDisplayName().getLocaleValue()).append('\uff1a').append(srmApprove.getString("billno")).append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SrmBillVerifyUtil_52", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_33", (String)"scm-srm-common", (Object[])new Object[0]));
                resultMap.put("message", message.toString());
                resultMap.put("succed", Boolean.FALSE);
                return resultMap;
            }
            case "B": {
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_sampleexam", "notifyno", billId, ResManager.loadKDString((String)"\u6837\u54c1\u786e\u8ba4", (String)"SrmBillVerifyUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
                if (((Boolean)resultMap.get("succed")).booleanValue()) break;
                return resultMap;
            }
            case "4": {
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_supapprove", "entryentity.sampleno", billId, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u751f\u6548", (String)"SrmBillVerifyUtil_4", (String)"scm-srm-common", (Object[])new Object[0]));
                if (((Boolean)resultMap.get("succed")).booleanValue()) break;
                return resultMap;
            }
            case "5": {
                resultMap = SrmBillVerifyUtil.getReferencedInfo("srm_supapprove", "entryentity.tryno", billId, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u751f\u6548", (String)"SrmBillVerifyUtil_4", (String)"scm-srm-common", (Object[])new Object[0]));
                if (((Boolean)resultMap.get("succed")).booleanValue()) break;
                return resultMap;
            }
        }
        return resultMap;
    }

    public static Map<String, Object> getReferencedInfo(String metadataName, String field1, Object value1, String billName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        DynamicObject tempObj = QueryRecordUtil.queryRecordSet((String)metadataName, (String)"billno", (String)field1, (Object)value1, null, null, null, null, null, null, null, (String)"queryOne", null);
        if (tempObj != null && tempObj.getString("billno") != null) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e %1  %2 \u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u3002", (String)"SrmBillVerifyUtil_33", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_5", (String)"scm-srm-common", (Object[])new Object[]{billName == null ? "" : billName + ":", tempObj.getString("billno")}));
            resultMap.put("billName", billName + ":" + tempObj.getString("billno"));
        }
        return resultMap;
    }

    public static Map<String, Object> verifyAptitudeNo(String metadataName, long aptitudeId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.FALSE);
        resultMap.put("message", "");
        StringBuilder sb = new StringBuilder();
        boolean isSucced = true;
        if (aptitudeId == 0L) {
            resultMap.put("message", ResManager.loadKDString((String)"\u8d44\u5ba1\u5355\u53f7\u4e3a\u7a7a\u3002", (String)"SrmBillVerifyUtil_6", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObject aptitudeObj = null;
        switch (metadataName) {
            case "srm_sceneexam": {
                aptitudeObj = QueryRecordUtil.queryRecordSet((String)"srm_aptitudeexam", (String)"id", (String)"id", (Object)aptitudeId, (String)"auditstatus", (Object)BillStatusEnum.AUDIT.getVal(), (String)"isscene", (Object)"1", (String)"hasscene", (Object)"0", null, (String)"queryOne", null);
                break;
            }
            case "srm_samplenotify": 
            case "srm_sampleexam": {
                aptitudeObj = QueryRecordUtil.queryRecordSet((String)"srm_aptitudeexam", (String)"id", (String)"id", (Object)aptitudeId, (String)"auditstatus", (Object)BillStatusEnum.AUDIT.getVal(), (String)"issample", (Object)"1", (String)"hassample", (Object)"0", null, (String)"queryOne", null);
                break;
            }
            case "srm_materialexam": {
                aptitudeObj = QueryRecordUtil.queryRecordSet((String)"srm_aptitudeexam", (String)"id", (String)"id", (Object)aptitudeId, (String)"auditstatus", (Object)BillStatusEnum.AUDIT.getVal(), (String)"ismaterial", (Object)"1", (String)"hasmaterial", (Object)"0", null, (String)"queryOne", null);
                break;
            }
            case "srm_supapprove": {
                String selectFields = "id,isscene,issample,ismaterial,isapprove,hasscene,hassample,hasmaterial,hasapprove";
                aptitudeObj = QueryRecordUtil.queryRecordSet((String)"srm_aptitudeexam", (String)selectFields, (String)"id", (Object)aptitudeId, (String)"auditstatus", (Object)BillStatusEnum.AUDIT.getVal(), (String)"isapprove", (Object)"1", (String)"hasapprove", (Object)"0", null, (String)"queryOne", null);
                break;
            }
        }
        if (aptitudeObj == null) {
            resultMap.put("message", ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u672c\u73af\u8282\u5df2\u5904\u7406\u5b8c\u6bd5\uff0c\u4e0d\u9700\u8981\u518d\u5904\u7406\u3002", (String)"SrmBillVerifyUtil_7", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        if (metadataName.equalsIgnoreCase("srm_supapprove")) {
            if (aptitudeObj.getBoolean("isscene")) {
                String message;
                DynamicObject sceneExamDyn;
                if (!aptitudeObj.getBoolean("hasscene")) {
                    sb = sb.append(ResManager.loadKDString((String)"\u8be5\u8d44\u5ba1\u5355\u53f7\u9700\u8981\u73b0\u573a\u8bc4\u5ba1\uff0c\u4f46\u672a\u5b8c\u6210\u3002", (String)"SrmBillVerifyUtil_8", (String)"scm-srm-common", (Object[])new Object[0]));
                    isSucced = false;
                }
                if (null != (sceneExamDyn = SrmBillListUtil.getRelatedSceneBill("srm_sceneexam", aptitudeObj.getString("id"), "sceneresult,id")) && SrmSceneResultEnum.NO_PASS.getVal().equals(sceneExamDyn.getString("sceneresult"))) {
                    sb = sb.append(ResManager.loadKDString((String)"\u73b0\u573a\u8bc4\u5ba1\u5355\u7ed3\u8bba\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\uff0c\u4e0d\u5141\u8bb8\u751f\u6548\u3002", (String)"SrmBillVerifyUtil_9", (String)"scm-srm-common", (Object[])new Object[0]));
                    isSucced = false;
                }
                if (StringUtils.isNotBlank((CharSequence)(message = SrmBillVerifyUtil.verifySceneAptitudeNo(aptitudeObj.getLong("id"))))) {
                    sb.append(message);
                    isSucced = false;
                }
            }
            if (!isSucced) {
                resultMap.put("succed", Boolean.FALSE);
                resultMap.put("message", sb.toString());
                return resultMap;
            }
        }
        resultMap.put("succed", Boolean.TRUE);
        return resultMap;
    }

    public static String verifySceneAptitudeNo(Long aptitudeId) {
        StringBuilder sb = new StringBuilder();
        QFilter aptitudenoFilter = new QFilter("aptitudeno", "=", (Object)aptitudeId);
        QFilter auditStatus = new QFilter("auditstatus", "=", (Object)"C");
        QFilter sceneresult = new QFilter("sceneresult", "=", (Object)SrmSceneResultEnum.RECTIFICATION_REVIEW.getVal());
        boolean exists = QueryServiceHelper.exists((String)"srm_sceneexam", (QFilter[])new QFilter[]{aptitudenoFilter, auditStatus, sceneresult});
        if (exists) {
            QFilter srcbillidFilter;
            QFilter[] filters = new QFilter[1];
            DynamicObject sceneExamDyn = QueryServiceHelper.queryOne((String)"srm_sceneexam", (String)"id", (QFilter[])new QFilter[]{aptitudenoFilter, auditStatus, sceneresult});
            filters[0] = srcbillidFilter = new QFilter("srcbillid", "=", (Object)sceneExamDyn.getString("id"));
            DynamicObject improveDyn = QueryServiceHelper.queryOne((String)"srm_improve", (String)"id,billno,confirmstatus", (QFilter[])filters);
            if (null != improveDyn && !SrmImproveConfirmStatusEnum.IMPROVE_PASS.getVal().equals(improveDyn.getString("confirmstatus"))) {
                sb.append(ResManager.loadKDString((String)"\u6539\u5584\u5355", (String)"SrmBillVerifyUtil_10", (String)"scm-srm-common", (Object[])new Object[0])).append(improveDyn.get("billno")).append(ResManager.loadKDString((String)"\u786e\u8ba4\u72b6\u6001\u4e3a", (String)"SrmBillVerifyUtil_11", (String)"scm-srm-common", (Object[])new Object[0])).append(SrmImproveConfirmStatusEnum.IMPROVE_PASS.getName()).append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u751f\u6548\u3002", (String)"SrmBillVerifyUtil_12", (String)"scm-srm-common", (Object[])new Object[0]));
            }
        }
        return sb.toString();
    }

    public static DynamicObjectCollection getSampleTestQualified(long aptitudeId) {
        QFilter[] filters = new QFilter[3];
        QFilter aptitudenoFilter = new QFilter("aptitudeno", "=", (Object)aptitudeId);
        QFilter auditStatusFilter = new QFilter("auditstatus", "=", (Object)"C");
        QFilter testResultFilter = new QFilter("entryentity.testresult", "=", (Object)SrmSampleTestResultEnum.QUALIFIED.getVal());
        filters[0] = aptitudenoFilter;
        filters[1] = auditStatusFilter;
        filters[2] = testResultFilter;
        return QueryServiceHelper.query((String)"srm_sampleexam", (String)"id", (QFilter[])filters);
    }

    public static boolean verifySupplierId(String metadataName, long supplierId) {
        if (supplierId == 0L) {
            return false;
        }
        ArrayList<String> statusList = new ArrayList<String>(10);
        statusList.add(SrmSupplierStatusEnum.AUDIT.getValue());
        statusList.add(SrmSupplierStatusEnum.APTITUDE.getValue());
        statusList.add(SrmSupplierStatusEnum.SCENE.getValue());
        statusList.add(SrmSupplierStatusEnum.SAMPLE.getValue());
        statusList.add(SrmSupplierStatusEnum.MATERIAL.getValue());
        statusList.add(SrmSupplierStatusEnum.SUCCESS.getValue());
        statusList.add(SrmSupplierStatusEnum.UNAPROVE.getValue());
        statusList.add(SrmSupplierStatusEnum.UNAPTITUDE.getValue());
        QFilter filter = new QFilter("id", "=", (Object)supplierId).and("auditstatus", "in", statusList);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject supplierObj = BusinessDataServiceHelper.loadSingle((String)"srm_supplier", (String)"id", (QFilter[])filters);
        return supplierObj != null;
    }

    public static Map<String, Object> sampleNotifyHaveCfm(long aptitudeId, long simpleNotifyId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        if (aptitudeId == 0L) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8d44\u8d28\u5355\u7684\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmBillVerifyUtil_17", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        StringBuilder billNo = new StringBuilder();
        QFilter simpleQfilter = new QFilter("cfmstatus", "in", (Object)"A");
        if (simpleNotifyId == -1L) {
            simpleQfilter.and("aptitudeno", "=", (Object)aptitudeId);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_samplenotify", (String)"billno", (QFilter[])new QFilter[]{simpleQfilter}, (String)"billno");){
                dataSet.forEach(row -> billNo.append(row.getString("billno")).append('\u3001'));
            }
        }
        if (simpleNotifyId > 0L) {
            simpleQfilter.and("id", "=", (Object)simpleNotifyId);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_samplenotify", (String)"billno", (QFilter[])new QFilter[]{simpleQfilter}, (String)"id");){
                dataSet.forEach(row -> billNo.append(row.getString("billno")).append('\u3001'));
            }
        }
        if (billNo != null && billNo.length() > 0) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u9001\u6837\u901a\u77e5\u5355\u201c%1\u201d\u7684\u4f9b\u5e94\u5546\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"SrmBillVerifyUtil_53", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_18", (String)"scm-srm-common", (Object[])new Object[]{billNo.subSequence(0, billNo.length() - 1).toString()}));
            return resultMap;
        }
        resultMap.put("succed", Boolean.TRUE);
        return resultMap;
    }

    public static Map<String, Object> sampleNotifyHaveCfm(long aptitudeId) {
        return SrmBillVerifyUtil.sampleNotifyHaveCfm(aptitudeId, 1L);
    }

    public static boolean verifyCategoryEntry(String metadataName, DynamicObjectCollection entryentityRows, ExtendedDataEntity row) {
        DynamicObject org = row.getDataEntity().getDynamicObject("org");
        Boolean categoryConfig = false;
        categoryConfig = Objects.nonNull(org) ? SrmBillVerifyUtil.isCategoryConfig(org.getLong("id")) : (Boolean)SrmCommonUtil.getSrmParameter().get("iscategory");
        if (categoryConfig.booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)entryentityRows)) {
                return false;
            }
            for (DynamicObject entryentityRow : entryentityRows) {
                DynamicObject category = entryentityRow.getDynamicObject("category");
                if (category != null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean verifyQuitOrgEntry(String metadataName, DynamicObjectCollection rows, String scope) {
        if (scope.equals("1")) {
            return true;
        }
        return rows != null && rows.size() != 0 && ((DynamicObject)rows.get(0)).getDynamicObject("quitorg") != null;
    }

    public static Map<String, Object> blackListCheck(DynamicObject billObj) {
        DynamicObjectCollection pRows;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        StringBuilder esb = new StringBuilder();
        boolean isSucced = true;
        DynamicObjectCollection eRows = billObj.getDynamicObjectCollection("entryentity_e");
        if (eRows.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject erow : eRows) {
                String enumber = erow.getString("enumber");
                String ename = erow.getString("ename");
                if (!StringUtils.isNotEmpty((CharSequence)enumber) || !StringUtils.isEmpty((CharSequence)ename)) continue;
                isSucced = false;
                sb.append(enumber).append(' ');
            }
            if (sb.length() > 0) {
                esb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5173\u8054\u4f01\u4e1a\u7684\u4f01\u4e1a\u540d\u79f0\u3002", (String)"SrmBillVerifyUtil_54", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_36", (String)"scm-srm-common", (Object[])new Object[]{sb}));
            }
        }
        if ((pRows = billObj.getDynamicObjectCollection("entryentity_p")).size() > 0) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sbNumber = new StringBuilder();
            StringBuilder sbName = new StringBuilder();
            for (DynamicObject obj : pRows) {
                String pnumber = obj.getString("pnumber");
                String pname = obj.getString("pname");
                if (StringUtils.isNotEmpty((CharSequence)pnumber) && StringUtils.isEmpty((CharSequence)pname)) {
                    sbNumber.append(pnumber).append(' ');
                    isSucced = false;
                }
                if (StringUtils.isNotEmpty((CharSequence)pname) && StringUtils.isEmpty((CharSequence)pnumber)) {
                    sbName.append(pname).append(' ');
                    isSucced = false;
                }
                if (!pnumber.trim().equals("") && ValidateMatchUtil.isIdCard((String)pnumber)) continue;
                sb.append(pnumber).append(' ');
                isSucced = false;
            }
            if (sbNumber.length() > 0) {
                esb.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5173\u8054\u4eba\u5458\u7684\u59d3\u540d\u3002", (String)"SrmBillVerifyUtil_55", (String)"scm-srm-common", (Object[])new Object[0]));
            }
            if (sbName.length() > 0) {
                esb.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5173\u8054\u4eba\u5458\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\u3002", (String)"SrmBillVerifyUtil_56", (String)"scm-srm-common", (Object[])new Object[0]));
            }
            if (sb.length() > 0) {
                esb.append(ResManager.loadKDString((String)"\u5173\u8054\u4eba\u5458\u7684\u8eab\u4efd\u8bc1\u53f7\u65e0\u6548\u3002", (String)"SrmBillVerifyUtil_20", (String)"scm-srm-common", (Object[])new Object[0]));
            }
        }
        resultMap.put("succed", isSucced);
        resultMap.put("message", esb.toString());
        return resultMap;
    }

    public static Map<String, Object> aptitudeRepeatCheck(DynamicObject billObj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        long billId = (Long)billObj.getPkValue();
        long orgId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("org"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        long entertypeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("entertype"));
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        QFilter filter = new QFilter("org", "=", (Object)orgId).and("supplier", "=", (Object)supplierId).and("entertype", "=", (Object)entertypeId).and("auditstatus", "!=", (Object)"D").and("auditstatus", "!=", (Object)"E").and("id", "!=", (Object)billId).and("examresult", "=", (Object)"0");
        for (DynamicObject row : rows) {
            long pkValue;
            String categorytype = row.getString("categorytype");
            if (categorytype.equals("B")) {
                pkValue = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("category"));
                SrmBillVerifyUtil.validRepeatCategoryEntry(resultMap, filter, categorytype, pkValue);
                continue;
            }
            pkValue = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("material"));
            SrmBillVerifyUtil.validRepeatCategoryEntry(resultMap, filter, categorytype, pkValue);
        }
        return resultMap;
    }

    private static void validRepeatCategoryEntry(Map<String, Object> resultMap, QFilter filter, String categorytype, long pkValue) {
        QFilter qf = null;
        qf = categorytype.equals("B") ? new QFilter("entryentity.category", "=", (Object)pkValue) : new QFilter("entryentity.material", "=", (Object)pkValue);
        QFilter queryFilter = new QFilter("entryentity.categorytype", "=", (Object)categorytype);
        queryFilter.and(qf);
        queryFilter.and(filter);
        DynamicObjectCollection aptitudeObjs = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"billno,entryentity.category,entryentity.material", (QFilter[])new QFilter[]{queryFilter});
        Object o = resultMap.get("message");
        StringBuilder msg = new StringBuilder();
        if (o != null && StringUtils.isNotBlank((CharSequence)o.toString())) {
            msg.append(o.toString());
        }
        for (DynamicObject aptitudeObj : aptitudeObjs) {
            DynamicObject bd_materialgroup;
            String billno;
            boolean existC;
            if (aptitudeObj == null || (existC = QueryServiceHelper.exists((String)"srm_supapprove", (QFilter[])new QFilter[]{qf.and("aptitudeno.name", "=", (Object)(billno = aptitudeObj.getString("billno"))).and("auditstatus", "=", (Object)"C").and("entryentity.categorytype", "=", (Object)categorytype)}))) continue;
            String categoryOrMaterialName = "";
            resultMap.put("succed", Boolean.FALSE);
            if (msg.length() > 0) {
                msg.append("\r\n");
            }
            if (categorytype.equals("B")) {
                bd_materialgroup = QueryServiceHelper.queryOne((String)"bd_materialgroup", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkValue)});
                categoryOrMaterialName = bd_materialgroup.getString("name");
                msg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c \u91c7\u8d2d\u65b9+\u4f9b\u5e94\u5546+\u51c6\u5165\u7c7b\u578b+\u54c1\u7c7b(%1) \u7684\u8d44\u5ba1\u5355(%2)\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e\u8d44\u5ba1\u5355\u3002", (String)"SrmBillVerifyUtil_57", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_41", (String)"scm-srm-common", (Object[])new Object[]{categoryOrMaterialName, aptitudeObj.getString("billno")}));
                continue;
            }
            bd_materialgroup = QueryServiceHelper.queryOne((String)"bd_material", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkValue)});
            categoryOrMaterialName = bd_materialgroup.getString("name");
            msg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c \u91c7\u8d2d\u65b9+\u4f9b\u5e94\u5546+\u51c6\u5165\u7c7b\u578b+\u7269\u6599(%1) \u7684\u8d44\u5ba1\u5355(%2)\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e\u8d44\u5ba1\u5355\u3002", (String)"SrmBillVerifyUtil_42", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_42", (String)"scm-srm-common", (Object[])new Object[]{categoryOrMaterialName, aptitudeObj.getString("billno")}));
        }
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            resultMap.put("message", msg.toString());
        }
    }

    public static Map<String, Object> verifyApproveEntry(DynamicObjectCollection rows, boolean issample, boolean ismaterial) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        if (rows == null || rows.size() == 0) {
            return resultMap;
        }
        StringBuilder sb = new StringBuilder();
        boolean isSucced = true;
        int i = 1;
        for (DynamicObject row : rows) {
            String categorystatus = row.getString("categorystatus");
            String sampleno = row.getString("sampleno");
            String tryno = row.getString("tryno");
            if (categorystatus == null || categorystatus.trim().equals("")) {
                isSucced = false;
                sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c%1\u884c\u54c1\u7c7b\u5f15\u5165\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmBillVerifyUtil_22", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_22", (String)"scm-srm-common", (Object[])new Object[]{i}));
            }
            ++i;
        }
        resultMap.put("succed", isSucced);
        resultMap.put("message", sb.toString());
        return resultMap;
    }

    public static Map<String, Object> verifyScorerEntry(DynamicObjectCollection indexRows, DynamicObjectCollection scorerRows) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        StringBuilder sb = new StringBuilder();
        boolean isSucced = true;
        if (indexRows == null || indexRows.isEmpty()) {
            isSucced = false;
            sb = sb.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmBillVerifyUtil_25", (String)"scm-srm-common", (Object[])new Object[0])).append("\n");
            resultMap.put("succed", isSucced);
            resultMap.put("message", sb.toString());
            return resultMap;
        }
        List indexs = indexRows.stream().map(x -> x.getDynamicObject("index")).filter(x -> {
            if (Objects.nonNull(x)) {
                return !"9".equals(x.getString("scoretype"));
            }
            return false;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(indexs) && CollectionUtils.isEmpty((Collection)scorerRows)) {
            isSucced = false;
            sb = sb.append(ResManager.loadKDString((String)"\u8bc4\u59d4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrmBillVerifyUtil_26", (String)"scm-srm-common", (Object[])new Object[0])).append("\n");
        }
        if (!isSucced) {
            resultMap.put("succed", isSucced);
            resultMap.put("message", sb.toString());
            return resultMap;
        }
        resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)scorerRows, (String)"indexclass", (String)"scorer", null);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            isSucced = false;
            Object message = resultMap.get("message");
            if (Objects.nonNull(message)) {
                String s = message.toString().replaceAll("\n", "");
                sb.append(ResManager.loadResFormat((String)"\u8bc4\u59d4\u4fe1\u606f%1\n", (String)"SrmBillVerifyUtil_39", (String)"scm-srm-common", (Object[])new Object[]{s}));
            }
        }
        if (!((Boolean)(resultMap = SrmBillVerifyUtil.varifyScorerIndexClass(indexRows, scorerRows)).get("succed")).booleanValue()) {
            isSucced = false;
            sb.append(resultMap.get("message"));
        }
        if (!((Boolean)(resultMap = SrmBillVerifyUtil.varifyIndexHaveSetScorer(indexRows, scorerRows)).get("succed")).booleanValue()) {
            isSucced = false;
            sb.append(resultMap.get("message"));
        }
        if (!((Boolean)(resultMap = SrmBillVerifyUtil.varifyIndexClas_ScorersWeight(scorerRows)).get("succed")).booleanValue()) {
            isSucced = false;
            sb.append(resultMap.get("message"));
        }
        resultMap.put("succed", isSucced);
        resultMap.put("message", sb.toString());
        return resultMap;
    }

    public static Map<String, Object> varifyScorerIndexClass(DynamicObjectCollection indexRows, DynamicObjectCollection scorerRows) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        ArrayList<Long> classIds = new ArrayList<Long>();
        boolean isSucced = true;
        StringBuilder sb = new StringBuilder();
        long classId = 0L;
        for (DynamicObject row : indexRows) {
            String scoretype = row.getString("index.scoretype");
            if ("9".equals(scoretype)) continue;
            classId = row.getLong("index.indexclass.id");
            classIds.add(classId);
            classId = row.getLong("index.indextype.id");
            classIds.add(classId);
        }
        for (DynamicObject row : scorerRows) {
            classId = row.getLong("indexclass.id");
            if (classIds.contains(classId)) continue;
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u59d4\u4fe1\u606f\u4e2d (%1)\u884c\u7684\u6307\u6807\u5206\u7c7b\u5728\u624b\u5de5\u8bc4\u4f30\u6307\u6807\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"SrmBillVerifyUtil_58", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_28", (String)"scm-srm-common", (Object[])new Object[]{row.getString("seq")})).append("\n");
        }
        if (!isSucced) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", sb);
        }
        return resultMap;
    }

    public static Map<String, Object> varifyIndexHaveSetScorer(DynamicObjectCollection indexRows, DynamicObjectCollection scorerRows) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        boolean isSucced = true;
        StringBuilder sb = new StringBuilder();
        long classId = 0L;
        long typeId = 0L;
        String indexName = null;
        for (DynamicObject row : indexRows) {
            classId = row.getLong("index.indexclass.id");
            typeId = row.getLong("index.indextype.id");
            indexName = row.getString("index.name");
            String scoretype = row.getString("index.scoretype");
            boolean haveSet = false;
            for (DynamicObject sorerRow : scorerRows) {
                long tempId = sorerRow.getLong("indexclass.id");
                if (classId != tempId && typeId != tempId) continue;
                haveSet = true;
                break;
            }
            if (haveSet || "9".equals(scoretype)) continue;
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bc4\u4f30\u6307\u6807\u4e2d\u7684\u6307\u6807(%1) \u672a\u8bbe\u7f6e\u8bc4\u59d4\u3002", (String)"SrmBillVerifyUtil_29", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_29", (String)"scm-srm-common", (Object[])new Object[]{indexName == null ? "" : indexName}));
            break;
        }
        if (!isSucced) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", sb);
        }
        return resultMap;
    }

    public static Map<String, Object> varifyIndexClas_ScorersWeight(DynamicObjectCollection scorerRows) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean isSucced = true;
        StringBuilder sb = new StringBuilder();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        BigDecimal sumWeight = BigDecimal.ZERO;
        for (DynamicObject row : scorerRows) {
            sumWeight = BigDecimal.ZERO;
            String key = row.getString("indexclass.name");
            String scorer = row.getString("scorer.name");
            BigDecimal weight = row.getBigDecimal("scorerweight");
            if (weight.compareTo(BigDecimal.ZERO) == 0) {
                isSucced = false;
                sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6307\u6807\u5206\u7c7b (%1)\u4e2d\u8bc4\u59d4(%2) \u7684\u6743\u91cd\u4e0d\u5141\u8bb8\u4e3a0\u3002", (String)"SrmBillVerifyUtil_50", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_50", (String)"scm-srm-common", (Object[])new Object[]{key == null ? "" : key, scorer == null ? ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"SrmBillVerifyUtil_30", (String)"scm-srm-common", (Object[])new Object[0]) : scorer})).append("\n");
                continue;
            }
            sumWeight = weightMap.get(key) == null ? weight : ((BigDecimal)weightMap.get(key)).add(weight);
            weightMap.put(key, sumWeight);
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            sumWeight = (BigDecimal)entry.getValue();
            if (sumWeight.compareTo(BigDecimal.TEN.multiply(BigDecimal.TEN)) == 0) continue;
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6307\u6807\u5206\u7c7b (%1) \u5404\u8bc4\u59d4\u6743\u91cd\u4e4b\u548c (%2) \u4e0d\u7b49\u4e8e100%\u3002", (String)"SrmBillVerifyUtil_31", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_31", (String)"scm-srm-common", (Object[])new Object[]{entry.getKey(), sumWeight})).append("\n");
        }
        if (!isSucced) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", sb);
        } else {
            resultMap.put("succed", Boolean.TRUE);
        }
        return resultMap;
    }

    public static Map<String, Object> verifySubmitedCategory(String bizType, Long aptitudeNo, DynamicObject billObj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObjectCollection entryentity = billObj.getDynamicObjectCollection("entryentity");
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("hasMsg", Boolean.FALSE);
        String billName = "";
        String billType = "";
        String selectFileds = "billno,entryentity,entryentity.category.id,entryentity.category.name,entryentity.material.id,entryentity.material.name,billstatus,auditstatus";
        switch (bizType) {
            case "4": {
                billName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6837\u54c1\u786e\u8ba4\u5355", (String)"SrmBillVerifyUtil_59", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_32", (String)"scm-srm-common", (Object[])new Object[0]);
                billType = "srm_sampleexam";
                selectFileds = selectFileds + ",entryentity.testresult";
                break;
            }
            case "5": {
                billName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7269\u6599\u8bd5\u7528\u5355", (String)"SrmBillVerifyUtil_60", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_33", (String)"scm-srm-common", (Object[])new Object[0]);
                billType = "srm_materialexam";
                selectFileds = selectFileds + ",tryresult";
                break;
            }
            case "6": {
                billName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u751f\u6548\u5355", (String)"SrmBillVerifyUtil_61", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmBillVerifyUtil_34", (String)"scm-srm-common", (Object[])new Object[0]);
                billType = "srm_supapprove";
                selectFileds = selectFileds + ",entryentity.categorytype";
            }
        }
        DynamicObjectCollection bizTypeEntry = QueryServiceHelper.query((String)billType, (String)selectFileds, (QFilter[])new QFilter[]{new QFilter("aptitudeno.number", "=", (Object)aptitudeNo).and(new QFilter("auditstatus", "=", (Object)"B").or(new QFilter("auditstatus", "=", (Object)"C")))});
        DynamicObjectCollection aptitudeEntryEntity = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)aptitudeNo).and(new QFilter("auditstatus", "=", (Object)"C"))});
        HashSet<Long> existCategoryIdSet = new HashSet<Long>(1024);
        HashSet<Long> aptitudeMaterialIdSet = new HashSet<Long>(1024);
        for (DynamicObject dyo : bizTypeEntry) {
            Long categoryId = dyo.getLong("entryentity.category.id");
            if (!(billType.equals("srm_sampleexam") && dyo.getString("entryentity.testresult").equals("1") || billType.equals("srm_materialexam") && dyo.getString("tryresult").equals("1")) && !billType.equals("srm_supapprove")) continue;
            existCategoryIdSet.add(categoryId);
        }
        for (DynamicObject dyo : aptitudeEntryEntity) {
            Long materialId = dyo.getLong("entryentity.material.id");
            aptitudeMaterialIdSet.add(materialId);
        }
        StringBuilder msgContent = new StringBuilder("\r\n");
        HashMap<Long, String> mp = new HashMap<Long, String>(32);
        HashMap<Long, String> materialNameMp = new HashMap<Long, String>(32);
        HashMap<Long, String> categoryNameMp = new HashMap<Long, String>(32);
        for (DynamicObject dyo : entryentity) {
            materialNameMp.put(dyo.getLong("material.id"), dyo.getString("material.name"));
            categoryNameMp.put(dyo.getLong("category.id"), dyo.getString("category.name"));
        }
        for (DynamicObject dyo : bizTypeEntry) {
            String tryresult;
            String testresult;
            String auditstatus = dyo.getString("auditstatus");
            if (auditstatus.equals("C") && (billType.equals("srm_sampleexam") ? (testresult = dyo.getString("entryentity.testresult")).equals("2") : billType.equals("srm_materialexam") && (tryresult = dyo.getString("tryresult")).equals("2"))) continue;
            mp.put(dyo.getLong("entryentity.material.id"), dyo.getString("billno"));
            mp.put(dyo.getLong("entryentity.category.id"), dyo.getString("billno"));
            materialNameMp.put(dyo.getLong("entryentity.material.id"), dyo.getString("entryentity.material.name"));
            categoryNameMp.put(dyo.getLong("entryentity.category.id"), dyo.getString("entryentity.category.name"));
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(32);
        int i = 0;
        if (!"srm_supapprove".equals(billType)) {
            for (DynamicObject entryRow : entryentity) {
                if (entryRow.getDynamicObject("category") == null || entryRow.getDynamicObject("material") == null) continue;
                long categoryId = entryRow.getDynamicObject("category").getLong("id");
                long materialId = entryRow.getDynamicObject("material").getLong("id");
                if (mp.containsKey(materialId)) {
                    msgContent.append(ResManager.loadResFormat((String)"\u7269\u6599\"%1\"\u5df2\u7ecf\u5728%2%3\u4e0a\u5b58\u5728\u3002", (String)"SrmBillVerifyUtil_62", (String)"scm-srm-common", (Object[])new Object[]{materialNameMp.get(materialId), billName, mp.get(materialId)}));
                    indexList.add(i);
                } else if (existCategoryIdSet.contains(categoryId) && !aptitudeMaterialIdSet.contains(materialId)) {
                    msgContent.append(ResManager.loadResFormat((String)"\u54c1\u7c7b\"%1\"\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u65e0\u6cd5\u901a\u8fc7\u7269\u6599\"%2\"\u518d\u6b21\u5ba1\u6279\u3002", (String)"SrmBillVerifyUtil_65", (String)"scm-srm-common", (Object[])new Object[]{categoryNameMp.get(categoryId), materialNameMp.get(materialId)}));
                    indexList.add(i);
                }
                ++i;
            }
        } else {
            for (DynamicObject entryRow : entryentity) {
                String categorytype = entryRow.getString("categorytype");
                if (entryRow.getDynamicObject("category") == null) continue;
                long categoryId = entryRow.getDynamicObject("category").getLong("id");
                long materialId = 0L;
                if ("A".equals(categorytype)) {
                    if (entryRow.getDynamicObject("material") == null) continue;
                    materialId = entryRow.getDynamicObject("material").getLong("id");
                    if (mp.containsKey(materialId)) {
                        msgContent.append(ResManager.loadResFormat((String)"\u7269\u6599\"%1\"\u5df2\u7ecf\u5728%2%3\u4e0a\u5b58\u5728\u3002", (String)"SrmBillVerifyUtil_63", (String)"scm-srm-common", (Object[])new Object[]{materialNameMp.get(materialId), billName, mp.get(materialId)}));
                        indexList.add(i);
                    }
                } else if (existCategoryIdSet.contains(categoryId)) {
                    msgContent.append(ResManager.loadResFormat((String)"\u54c1\u7c7b\"%1\"\u5df2\u7ecf\u5728%2%3\u4e0a\u5b58\u5728\u3002", (String)"SrmBillVerifyUtil_66", (String)"scm-srm-common", (Object[])new Object[]{categoryNameMp.get(categoryId), billName, mp.get(categoryId)}));
                    indexList.add(i);
                }
                ++i;
            }
        }
        if (entryentity.size() == indexList.size()) {
            resultMap.put("succed", Boolean.FALSE);
        }
        if (indexList.size() > 0) {
            resultMap.put("hasMsg", Boolean.TRUE);
        }
        resultMap.put("message", msgContent);
        resultMap.put("indexList", indexList);
        return resultMap;
    }

    public static Boolean quitOrgValid(DynamicObject billObj) {
        Boolean flag = true;
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        String scope = billObj.getString("scope");
        if ("2".equals(scope)) {
            if (!CollectionUtils.isEmpty((Collection)rows)) {
                SrmBillVerifyUtil.partQuitOrgValid(billObj);
            }
            return flag;
        }
        if ("1".equals(scope)) {
            Boolean result = SrmBillVerifyUtil.wholeQuitOrgValid(billObj);
            return result;
        }
        return flag;
    }

    private static void partQuitOrgValid(DynamicObject billObj) {
        long supplier_id = billObj.getLong("supplier.id");
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        List quitOrgIds = rows.stream().map(x -> x.getLong("quitorg.id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(quitOrgIds)) {
            Map<Long, List<DynamicObject>> orgMapList;
            QFilter qFilter = new QFilter("supplier", "=", (Object)supplier_id);
            qFilter.and(new QFilter("org", "in", quitOrgIds));
            DynamicObjectCollection srm_supcategory = QueryServiceHelper.query((String)"srm_supcategory", (String)"id,auditstatus,supplier,org", (QFilter[])new QFilter[]{qFilter});
            if (!CollectionUtils.isEmpty((Collection)srm_supcategory) && !CollectionUtils.isEmpty(orgMapList = srm_supcategory.stream().collect(Collectors.groupingBy(x -> x.getLong("org"))))) {
                Iterator iteratorRow = rows.iterator();
                while (iteratorRow.hasNext()) {
                    List auditstatus;
                    DynamicObject dy = (DynamicObject)iteratorRow.next();
                    long quitorg_id = dy.getLong("quitorg_id");
                    List<DynamicObject> categoryList = orgMapList.get(quitorg_id);
                    if (CollectionUtils.isEmpty(categoryList) || !CollectionUtils.isEmpty(auditstatus = categoryList.stream().filter(x -> !x.getString("auditstatus").equals("4")).collect(Collectors.toList()))) continue;
                    iteratorRow.remove();
                }
            }
        }
    }

    private static Boolean wholeQuitOrgValid(DynamicObject billObj) {
        List unQuitDy;
        DynamicObjectCollection srm_supcategory;
        List orgIds;
        Long orgId = billObj.getLong("org.id");
        long supplier_id = billObj.getLong("supplier.id");
        QFilter qFilter = new QFilter("supplier", "=", (Object)supplier_id);
        if (!orgId.equals(OrgUnitServiceHelper.getRootOrgId()) && !CollectionUtils.isEmpty((Collection)(orgIds = OrgServiceHelper.getAllSubordinateOrgs((long)orgId, (boolean)true)))) {
            qFilter.and(new QFilter("org", "in", (Object)orgIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(srm_supcategory = QueryServiceHelper.query((String)"srm_supcategory", (String)"id,auditstatus,supplier,org", (QFilter[])new QFilter[]{qFilter}))) && CollectionUtils.isEmpty(unQuitDy = srm_supcategory.stream().filter(x -> !x.getString("auditstatus").equals("4")).collect(Collectors.toList()))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isCategoryConfig(Long orgId) {
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId("XV1IC150UR4");
        appParam.setOrgId(orgId);
        Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Object iscategory = systemMap.get("iscategory");
        if (iscategory != null && !iscategory.toString().isEmpty()) {
            return (Boolean)iscategory;
        }
        return null;
    }
}

