/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.SrmCategoryEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;

public class SrmCategoryLibUtil {
    private static Log log = LogFactory.getLog(SrmCategoryLibUtil.class);

    public static DynamicObject getSupplierCategory(long supplierId, long orgId, long categoryId, long materielId, String type) {
        DynamicObject categoryObj = null;
        String field2 = null;
        long value2 = 0L;
        String field3 = null;
        long value3 = 0L;
        String field4 = null;
        long value4 = 0L;
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (((Boolean)paraMap.get("ispurorg")).booleanValue()) {
            field2 = "org";
            value2 = orgId;
        }
        if (((Boolean)paraMap.get("iscategory")).booleanValue()) {
            field3 = "category";
            value3 = categoryId;
        }
        if (materielId != 0L) {
            field4 = "material";
            value4 = materielId;
        }
        categoryObj = "B".equals(type) ? QueryRecordUtil.queryRecordSet((String)"srm_supcategory", (String)"id,supplier,org,category,auditstatus", (String)"supplier", (Object)supplierId, (String)field2, (Object)value2, (String)field3, (Object)value3, (String)"categorytype", (Object)"B", null, (String)"queryOneOrder", (String)"auditstatus") : QueryRecordUtil.queryRecordSet((String)"srm_supcategory", (String)"id,supplier,org,category,auditstatus", (String)"supplier", (Object)supplierId, (String)field2, (Object)value2, (String)"categorytype", (Object)"A", (String)field4, (Object)value4, null, (String)"queryOneOrder", (String)"auditstatus");
        return categoryObj;
    }

    public static DynamicObject querySupplierCategory(long supplierId, long orgId, long categoryId) {
        DynamicObject categoryObj = null;
        String field2 = null;
        long value2 = 0L;
        String field3 = null;
        long value3 = 0L;
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (((Boolean)paraMap.get("ispurorg")).booleanValue() && orgId > 0L) {
            field2 = "org";
            value2 = orgId;
        }
        if (((Boolean)paraMap.get("iscategory")).booleanValue() && categoryId > 0L) {
            field3 = "category";
            value3 = categoryId;
        }
        categoryObj = QueryRecordUtil.queryRecordSet((String)"srm_supcategory", (String)"id,supplier,org,category,auditstatus", (String)"supplier", (Object)supplierId, (String)field2, (Object)value2, (String)field3, (Object)value3, null, null, null, (String)"queryOneOrder", (String)"auditstatus");
        return categoryObj;
    }

    public static DynamicObject querySupplierCategoryOrMaterial(long supplierId, long orgId, long categoryOrMaterialId, String type) {
        DynamicObject obj = null;
        String field2 = null;
        long value2 = 0L;
        String field3 = null;
        long value3 = 0L;
        Map paraMap = SrmCommonUtil.getSrmParameter();
        if (((Boolean)paraMap.get("ispurorg")).booleanValue() && orgId > 0L) {
            field2 = "org";
            value2 = orgId;
        }
        if (((Boolean)paraMap.get("iscategory")).booleanValue() && categoryOrMaterialId > 0L) {
            if (type.equals("B")) {
                field3 = "category";
                value3 = categoryOrMaterialId;
            } else if (type.equals("A")) {
                field3 = "material";
                value3 = categoryOrMaterialId;
            }
        }
        obj = QueryRecordUtil.queryRecordSet((String)"srm_supcategory", (String)"id,supplier,org,category,auditstatus", (String)"supplier", (Object)supplierId, (String)field2, (Object)value2, (String)field3, (Object)value3, (String)"categorytype", (Object)type, null, (String)"queryOneOrder", (String)"auditstatus");
        return obj;
    }

    public static Map<String, Object> addToCategoryLib(String billMetaData, long billId) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        Map paraMap = SrmCommonUtil.getSrmParameter();
        boolean ispurorg = (Boolean)paraMap.get("ispurorg");
        boolean iscategory = (Boolean)paraMap.get("iscategory");
        DynamicObject billObj = QueryRecordUtil.queryRecordSet((String)billMetaData, (String)"id", (String)"id", (Object)billId, null, null, null, null, null, null, null, (String)"loadBill", null);
        if (billObj == null) {
            return resultMap;
        }
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        if (supplierId == 0L) {
            return resultMap;
        }
        long orgId = 0L;
        if (ispurorg) {
            orgId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("org"));
        }
        String orgStatus = billObj.getString("orgstatus");
        DynamicObjectCollection categoryRows = billObj.getDynamicObjectCollection("entryentity");
        if (!iscategory || categoryRows == null || categoryRows.size() == 0) {
            resultMap = SrmCategoryLibUtil.updateCategoryLib(supplierId, orgId, 0L, orgStatus);
            return resultMap;
        }
        HashMap<String, DynamicObject> categoryMap = new HashMap<String, DynamicObject>();
        QFilter filter = new QFilter("supplier", "=", (Object)supplierId).and("org", "=", (Object)orgId);
        HashSet<Long> categoryIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (DynamicObject row : categoryRows) {
            long categoryId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("category"));
            long materialId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("material"));
            String categorystatus = row.getString("categorystatus");
            if (categoryId <= 0L || categorystatus == null || categorystatus.equals("")) continue;
            categoryMap.put(categoryId + "_" + materialId, row);
            if (materialId > 0L) {
                materialIdSet.add(materialId);
                continue;
            }
            categoryIdSet.add(categoryId);
        }
        filter.and(new QFilter("category", "in", categoryIdSet).and("material", "=", (Object)0L).or("material", "in", materialIdSet));
        DynamicObject[] categoryObjs = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"sourcelistentryid,category,auditstatus,modifier,modifytime,supplier.id,org.id,category.id,issourcelist,categorytype,material.id,effectdate,expirydate,origin", (QFilter[])new QFilter[]{filter});
        if (categoryObjs != null && categoryObjs.length > 0) {
            SrmCategoryLibUtil.updateCateGoryRow(categoryObjs, categoryMap, billMetaData, resultMap);
        }
        if (categoryMap.isEmpty()) {
            return resultMap;
        }
        ArrayList<DynamicObject> newcategoryObjs = new ArrayList<DynamicObject>();
        int i = 0;
        for (Map.Entry entry : categoryMap.entrySet()) {
            DynamicObject supcategory;
            DynamicObject category = (DynamicObject)entry.getValue();
            if ("srm_categorychg".equals(billMetaData) && Objects.nonNull(supcategory = category.getDynamicObject("supcategory"))) continue;
            long categoryId = SrmCommonUtil.getPkValue((DynamicObject)category.getDynamicObject("category"));
            DynamicObject categoryObj = ORMUtil.newDynamicObject((String)"srm_supcategory");
            SrmCategoryLibUtil.setMaterialCategoryLib(category, supplierId, orgId, categoryId, categoryObj);
            if (billMetaData.equals("srm_categorychg")) {
                categoryObj.set("origin", (Object)"2");
            }
            newcategoryObjs.add(i++, categoryObj);
        }
        if (newcategoryObjs != null && newcategoryObjs.size() > 0) {
            resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_supcategory", (DynamicObject[])newcategoryObjs.toArray(new DynamicObject[0]));
        }
        return resultMap;
    }

    private static void updateCateGoryRow(DynamicObject[] categoryObjs, Map<String, DynamicObject> categoryMap, String billMetaData, Map<String, Object> resultMap) {
        boolean ischange = false;
        for (DynamicObject row : categoryObjs) {
            String categoryId = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("category")));
            long materialId = row.getLong("material.id");
            Date cateEffectdate = row.getDate("effectdate");
            Date cateExpirydate = row.getDate("expirydate");
            String auditstatus = row.getString("auditstatus");
            DynamicObject categoryRow = categoryMap.get(categoryId + "_" + materialId);
            if (categoryRow == null) continue;
            Date effectdate = categoryRow.getDate("effectdate");
            Date expirydate = categoryRow.getDate("expirydate");
            if (Objects.nonNull(cateEffectdate) && Objects.nonNull(cateExpirydate) && Objects.nonNull(effectdate) && Objects.nonNull(expirydate)) {
                if (!effectdate.after(cateExpirydate) && !expirydate.before(cateEffectdate)) {
                    if ("srm_supapprove".equals(billMetaData) && ("1".equals(auditstatus) || "3".equals(auditstatus))) {
                        row.set("auditstatus", (Object)"2");
                        row.set("modifier", (Object)RequestContext.get().getUserId());
                        row.set("modifytime", (Object)TimeServiceHelper.now());
                        ischange = true;
                    } else if ("srm_categorychg".equals(billMetaData) && "1".equals(categoryRow.getString("categorystatus")) && ("1".equals(auditstatus) || "3".equals(auditstatus))) {
                        row.set("auditstatus", (Object)"2");
                        row.set("modifier", (Object)RequestContext.get().getUserId());
                        row.set("modifytime", (Object)TimeServiceHelper.now());
                        ischange = true;
                    }
                }
                if (!"srm_categorychg".equals(billMetaData) || !Objects.nonNull(categoryRow.getDynamicObject("supcategory")) || categoryRow.getDynamicObject("supcategory").getLong("id") != row.getLong("id") || "2".equals(auditstatus)) continue;
                row.set("auditstatus", (Object)categoryRow.getString("categorystatus"));
                row.set("modifier", (Object)RequestContext.get().getUserId());
                row.set("effectdate", (Object)categoryRow.getDate("effectdate"));
                row.set("expirydate", (Object)categoryRow.getDate("expirydate"));
                row.set("modifytime", (Object)TimeServiceHelper.now());
                ischange = true;
                continue;
            }
            row.set("auditstatus", (Object)categoryRow.getString("categorystatus"));
            row.set("modifier", (Object)RequestContext.get().getUserId());
            row.set("modifytime", (Object)TimeServiceHelper.now());
            categoryMap.remove(categoryId + "_" + materialId);
            ischange = true;
        }
        if (ischange) {
            resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_supcategory", (DynamicObject[])categoryObjs);
        }
    }

    public static Map<String, Object> updateCategoryLib(long supplierId, long orgId, long categoryId, String categorystatus) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        DynamicObject categoryObj = QueryRecordUtil.queryRecordSet((String)"srm_supcategory", (String)"id,supplier,group,org,category,auditstatus,modifier,modifytime,createorg,origin,issourcelist,categorytype,material,sourcelistentryid", (String)"supplier", (Object)supplierId, (String)"org", (Object)orgId, (String)"category", (Object)categoryId, null, null, null, (String)"loadOne", (String)"categorystatus");
        if (categoryObj != null) {
            categoryObj.set("auditstatus", (Object)categorystatus);
            categoryObj.set("modifier", (Object)RequestContext.get().getUserId());
            categoryObj.set("modifytime", (Object)TimeServiceHelper.now());
        } else {
            categoryObj = ORMUtil.newDynamicObject((String)"srm_supcategory");
            SrmCategoryLibUtil.setCategoryLibValue(supplierId, orgId, categoryId, categorystatus, categoryObj);
        }
        resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_supcategory", (DynamicObject)categoryObj);
        return resultMap;
    }

    public static void setCategoryLibValue(long supplierId, long orgId, long categoryId, String categorystatus, DynamicObject categoryObj) {
        DynamicObject supplierObj = QueryRecordUtil.queryRecordSet((String)"srm_supplier", (String)"id,group,bizpartner", (String)"id", (Object)supplierId, null, null, null, null, null, null, null, (String)"loadOne", null);
        long groupId = 0L;
        long bizpartnerId = 0L;
        if (supplierObj != null) {
            groupId = SrmCommonUtil.getPkValue((DynamicObject)supplierObj.getDynamicObject("group"));
            bizpartnerId = SrmCommonUtil.getPkValue((DynamicObject)supplierObj.getDynamicObject("bizpartner"));
        }
        categoryObj.set("supplier_id", (Object)supplierId);
        categoryObj.set("group_id", (Object)groupId);
        categoryObj.set("bizpartner_id", (Object)bizpartnerId);
        categoryObj.set("org_id", (Object)orgId);
        categoryObj.set("category_id", (Object)categoryId);
        categoryObj.set("auditstatus", (Object)categorystatus);
        categoryObj.set("modifier_id", (Object)RequestContext.get().getUserId());
        categoryObj.set("modifytime", (Object)TimeServiceHelper.now());
        categoryObj.set("createorg_id", (Object)RequestContext.get().getOrgId());
        categoryObj.set("origin", (Object)"1");
    }

    public static Map<String, Object> exitFromCategoryLib(String billMetaData, long billId) {
        DynamicObject[] categoryObjs;
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        DynamicObject billObj = QueryRecordUtil.queryRecordSet((String)billMetaData, (String)"id", (String)"id", (Object)billId, null, null, null, null, null, null, null, (String)"loadBill", null);
        if (billObj == null) {
            return resultMap;
        }
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        if (supplierId == 0L) {
            return resultMap;
        }
        String scope = billObj.getString("scope");
        String selectedFiled = "id,number,auditstatus,supplier_id,org_id,category,category_id,modifier_id,issourcelist,modifytime,categorytype,material,material_id,sourcelistentryid,effectdate,expirydate";
        if (scope.equals("1") || !((Boolean)SrmCommonUtil.getSrmParameter().get("ispurorg")).booleanValue()) {
            DynamicObject[] categoryObjs2;
            QFilter filter = new QFilter("supplier", "=", (Object)supplierId);
            Long orgId = billObj.getLong("org_id");
            if (!orgId.equals(OrgUnitServiceHelper.getRootOrgId())) {
                ArrayList<Long> curOrgList = new ArrayList<Long>(10);
                curOrgList.add(orgId);
                DynamicObject[] orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"02", curOrgList, (boolean)true);
                log.info("\u4f9b\u5e94\u5546\u9000\u51fa\u65f6\u54c1\u7c7b\u5e93\u9000\u51fa\u83b7\u53d6\u5230\u7684\u7ec4\u7ec7\uff1a" + orgIds);
                filter.and("org", "in", (Object)orgIds);
            }
            if ((categoryObjs2 = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)selectedFiled, (QFilter[])new QFilter[]{filter})) == null) {
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("message", ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5efa\u7acb\u54c1\u7c7b\u5e93\uff0c\u4e0d\u9700\u8981\u5904\u7406\u3002", (String)"SrmCategoryLibUtil_0", (String)"scm-srm-common", (Object[])new Object[0]));
                return resultMap;
            }
            for (DynamicObject row : categoryObjs2) {
                row.set("auditstatus", (Object)SrmSupplierStatusEnum.EXIT.getValue());
                row.set("modifytime", (Object)TimeServiceHelper.now());
            }
            resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_supcategory", (DynamicObject[])categoryObjs2);
            return resultMap;
        }
        DynamicObjectCollection orgRows = billObj.getDynamicObjectCollection("entryentity");
        if (orgRows == null || orgRows.size() == 0) {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("message", ResManager.loadKDString((String)"\u9000\u51fa\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u5904\u7406\u3002", (String)"SrmCategoryLibUtil_1", (String)"scm-srm-common", (Object[])new Object[0]));
            return resultMap;
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        for (DynamicObject row : orgRows) {
            long orgId;
            if (!row.getBoolean("isquit") || (orgId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("quitorg"))) <= 0L) continue;
            orgList.add(orgId);
        }
        QFilter filter = new QFilter("supplier", "=", (Object)supplierId).and("org", "in", orgList);
        for (DynamicObject row : categoryObjs = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)selectedFiled, (QFilter[])new QFilter[]{filter})) {
            row.set("auditstatus", (Object)SrmSupplierStatusEnum.EXIT.getValue());
            row.set("modifytime", (Object)TimeServiceHelper.now());
        }
        resultMap = SrmCommonUtil.saveDynamicObject((String)"srm_supcategory", (DynamicObject[])categoryObjs);
        return resultMap;
    }

    public static void setEnableByType(IFormView view) {
        DynamicObjectCollection entryentity = view.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            String categorystatus;
            String categorytype = ((DynamicObject)entryentity.get(i)).getString("categorytype");
            String old_status = ((DynamicObject)entryentity.get(i)).getString("categorystatus_old");
            if ("1".equals(old_status) || "3".equals(old_status)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"category", "material", "categorytype"});
            } else if ("A".equals(categorytype)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"category"});
                view.setEnable(Boolean.TRUE, i, new String[]{"material"});
            } else if ("B".equals(categorytype)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"material"});
                view.setEnable(Boolean.TRUE, i, new String[]{"category"});
            }
            if (!"5".equals(old_status)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"issourcelist"});
            }
            if (!"1".equals(categorystatus = ((DynamicObject)entryentity.get(i)).getString("categorystatus"))) {
                view.setEnable(Boolean.FALSE, i, new String[]{"effectdate"});
                view.setEnable(Boolean.FALSE, i, new String[]{"expirydate"});
                continue;
            }
            view.setEnable(Boolean.TRUE, i, new String[]{"effectdate"});
            view.setEnable(Boolean.TRUE, i, new String[]{"expirydate"});
        }
    }

    public static void setMaterialCategoryLib(DynamicObject categoryDy, long supplierId, long orgId, long categoryId, DynamicObject newCategoryObj) {
        SrmCategoryLibUtil.setCategoryLibValue(supplierId, orgId, categoryId, categoryDy.getString("categorystatus"), newCategoryObj);
        long materialId = SrmCommonUtil.getPkValue((DynamicObject)categoryDy.getDynamicObject("material"));
        newCategoryObj.set("categorytype", (Object)categoryDy.getString("categorytype"));
        newCategoryObj.set("issourcelist", (Object)categoryDy.getString("issourcelist"));
        newCategoryObj.set("material_id", (Object)materialId);
        newCategoryObj.set("effectdate", (Object)categoryDy.getDate("effectdate"));
        newCategoryObj.set("expirydate", (Object)categoryDy.getDate("expirydate"));
    }

    public static void materialUpStatusByCateStaus(List<Long> cateIds, String status, Long orgId, Long supId) {
        if (CollectionUtils.isEmpty(cateIds)) {
            return;
        }
        QFilter filter = new QFilter("supplier", "=", (Object)supId).and("org", "=", (Object)orgId).and("category", "in", cateIds).and("auditstatus", "=", (Object)SrmCategoryEnum.VALID.getVal()).and("auditstatus", "=", (Object)SrmCategoryEnum.FREEZED.getVal()).and("categorytype", "=", (Object)"A");
        DynamicObject[] categoryObjs = BusinessDataServiceHelper.load((String)"srm_supcategory", (String)"category,auditstatus,modifier,modifytime,supplier.id,org.id,category.id,issourcelist,categorytype,material.id", (QFilter[])new QFilter[]{filter});
        if (Objects.isNull(categoryObjs) || categoryObjs.length == 0) {
            return;
        }
        for (DynamicObject categoryObj : categoryObjs) {
            categoryObj.set("auditstatus", (Object)status);
            categoryObj.set("modifier", (Object)RequestContext.get().getUserId());
            categoryObj.set("modifytime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.update((DynamicObject[])categoryObjs);
    }
}

