/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SrmCommUtil {
    private static Log log = LogFactory.getLog(SrmCommUtil.class);

    public static final String getBaseName(long groupId, String entityName) {
        StringBuilder content = new StringBuilder();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)entityName, (String)"name");
        if (obj == null) {
            return ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"SrmCommUtil_0", (String)"scm-srm-common", (Object[])new Object[0]);
        }
        content.append(obj.getString("name"));
        return content.toString();
    }

    public static void deleteRowRule(DynamicObjectCollection entryEntityRows, String valueFrom, String valueTo) {
        if (entryEntityRows.getRowCount() <= 1) {
            return;
        }
        for (int i = 1; i < entryEntityRows.size(); ++i) {
            BigDecimal beforeRowScorefrom = ((DynamicObject)entryEntityRows.get(i - 1)).getBigDecimal(valueFrom);
            BigDecimal currentRowScoreto = ((DynamicObject)entryEntityRows.get(i)).getBigDecimal(valueTo);
            if (currentRowScoreto.compareTo(beforeRowScorefrom) == 0) continue;
            ((DynamicObject)entryEntityRows.get(i)).set(valueTo, (Object)beforeRowScorefrom);
        }
    }

    public static void addAptitudeNoBeforeF7Listener(AbstractFormPlugin dataModelPlugin) {
        ((BasedataEdit)dataModelPlugin.getControl("aptitudeno")).addBeforeF7SelectListener(beforeF7SelectEvent -> {
            IFormView view;
            IDataModel model;
            DynamicObject suppler;
            if (dataModelPlugin != null && dataModelPlugin.getView() != null && dataModelPlugin.getView().getModel() != null && (suppler = (model = (view = dataModelPlugin.getView()).getModel()).getDataEntity().getDynamicObject("supplier")) == null) {
                dataModelPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrmCommUtil_1", (String)"scm-srm-common", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
    }

    public static void addSampleExamBeforeF7Listener(AbstractFormPlugin dataModelPlugin) {
        ((BasedataEdit)dataModelPlugin.getControl("notifyno")).addBeforeF7SelectListener(beforeF7SelectEvent -> {
            IFormView view;
            IDataModel model;
            DynamicObject aptitudeno;
            if (dataModelPlugin != null && dataModelPlugin.getView() != null && dataModelPlugin.getView().getModel() != null && (aptitudeno = (model = (view = dataModelPlugin.getView()).getModel()).getDataEntity().getDynamicObject("aptitudeno")) == null) {
                dataModelPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u8d28\u5ba1\u67e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8d44\u8d28\u5ba1\u67e5\u5355\u3002", (String)"SrmCommUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
    }

    public static void addValidatePreValueBeforeF7Listener(AbstractFormPlugin dataModelPlugin, String currentControl, String preControl) {
        ((BasedataEdit)dataModelPlugin.getControl(currentControl)).addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (dataModelPlugin != null && dataModelPlugin.getView() != null && dataModelPlugin.getView().getModel() != null) {
                BasedataEdit edit = (BasedataEdit)dataModelPlugin.getControl(preControl);
                Object preValue = dataModelPlugin.getView().getModel().getValue(preControl);
                if (edit != null && preValue == null) {
                    String nameValue = edit.getProperty().getDisplayName().getLocaleValue();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(ResManager.loadResFormat((String)"%1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9%2\u3002", (String)"SrmCommUtil_3", (String)"scm-srm-common", (Object[])new Object[]{nameValue, nameValue}));
                    dataModelPlugin.getView().showTipNotification(stringBuilder.toString());
                    beforeF7SelectEvent.setCancel(true);
                }
            }
        });
    }

    public static Set<Long> getEntryCategory(String billType, Long aptitudeId) {
        HashSet<Long> acCategoryIdSet = new HashSet<Long>(16);
        QFilter qf = new QFilter("auditstatus", "=", (Object)"C");
        if (billType.equals("srm_sampleexam")) {
            qf = qf.and(new QFilter("entryentity.testresult", "=", (Object)"1"));
        } else if (billType.equals("srm_materialexam")) {
            qf = qf.and(new QFilter("tryresult", "=", (Object)"1"));
        }
        qf = qf.and(new QFilter("aptitudeno.number", "=", (Object)aptitudeId));
        DynamicObjectCollection aptitudeBill = QueryServiceHelper.query((String)"srm_aptitudeexam", (String)"entryentity.category.id,entryentity.material.id,entryentity.categorytype", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C").and(new QFilter("id", "=", (Object)aptitudeId))});
        DynamicObjectCollection bizBills = QueryServiceHelper.query((String)billType, (String)"entryentity.category.id,entryentity.material.id", (QFilter[])new QFilter[]{qf});
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        HashSet<Long> categoryIdSet = new HashSet<Long>(16);
        for (DynamicObject bizBill : bizBills) {
            materialIdSet.add(bizBill.getLong("entryentity.material.id"));
            categoryIdSet.add(bizBill.getLong("entryentity.category.id"));
        }
        for (DynamicObject dyo : aptitudeBill) {
            Long categoryId = dyo.getLong("entryentity.category.id");
            acCategoryIdSet.add(categoryId);
        }
        for (DynamicObject dyo : aptitudeBill) {
            String categorytype = dyo.getString("entryentity.categorytype");
            Long categoryId = dyo.getLong("entryentity.category.id");
            if ("A".equals(categorytype)) {
                Long materialId = dyo.getLong("entryentity.material.id");
                if (materialIdSet.contains(materialId)) continue;
                acCategoryIdSet.remove(categoryId);
                continue;
            }
            if (categoryIdSet.contains(categoryId)) continue;
            acCategoryIdSet.remove(categoryId);
        }
        return acCategoryIdSet;
    }

    public static HashMap<String, Object> getModifyTimeAndModifer(DynamicObject modifier, DynamicObject lastupdateuser, Date modifytime, Date lastupdatetime) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (Objects.nonNull(lastupdateuser)) {
            result.put("lastupdateuser", lastupdateuser.getPkValue());
        } else if (Objects.nonNull(modifier)) {
            result.put("lastupdateuser", modifier.getPkValue());
        } else {
            result.put("lastupdateuser", RequestContext.get().getCurrUserId());
        }
        if (Objects.nonNull(lastupdatetime)) {
            result.put("lastupdatetime", lastupdatetime);
        } else if (Objects.nonNull(modifytime)) {
            result.put("lastupdatetime", modifytime);
        } else {
            result.put("lastupdatetime", TimeServiceHelper.now());
        }
        return result;
    }

    public static ArrayList<String> getSysSrmRoleParam(String permRoleControl) {
        ArrayList<String> roleList = new ArrayList<String>(12);
        try {
            AppParam appParam = new AppParam();
            appParam.setViewType("15");
            appParam.setAppId("XV1IC150UR4");
            appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
            Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            Object supplierpotentialroles = systemMap.get(permRoleControl);
            if (Objects.nonNull(supplierpotentialroles)) {
                if (supplierpotentialroles instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection supplierpotentialroles1 = (MulBasedataDynamicObjectCollection)supplierpotentialroles;
                    for (DynamicObject dynamicObject : supplierpotentialroles1) {
                        Object fbasedataid_id = dynamicObject.get("fbasedataid_id");
                        if (!Objects.nonNull(fbasedataid_id)) continue;
                        roleList.add(fbasedataid_id.toString());
                    }
                }
                if (supplierpotentialroles instanceof ArrayList) {
                    ArrayList supplierpotentialrolesCollection = (ArrayList)supplierpotentialroles;
                    for (LinkedHashMap stringObjectLinkedHashMap : supplierpotentialrolesCollection) {
                        LinkedHashMap fbasedata;
                        Object id;
                        Object fbasedataid = stringObjectLinkedHashMap.get("fbasedataid");
                        if (!Objects.nonNull(fbasedataid) || !(fbasedataid instanceof LinkedHashMap) || !Objects.nonNull(id = (fbasedata = (LinkedHashMap)fbasedataid).get("id"))) continue;
                        roleList.add(id.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("getSysSrmRoleParam is fail e:" + e);
            return roleList;
        }
        log.info("sysParam roles is " + roleList.toString());
        return roleList;
    }

    public static void isNewPermission() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currUserId, null, null, (String)"srm_portal_component", (String)"47156aff000000ac");
        if (CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.hasAllOrgPerm()) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u65e0\u95e8\u6237\u7ec4\u4ef6\u914d\u7f6e\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SrmCommUtil_4", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmCompconfigSaveOp_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }

    public static void isModifyPermission() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currUserId, null, null, (String)"srm_portal_component", (String)"4715a0df000000ac");
        if (CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.hasAllOrgPerm()) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u65e0\u95e8\u6237\u7ec4\u4ef6\u914d\u7f6e\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"SrmCommUtil_5", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmCompconfigSaveOp_0", (String)"scm-srm-formplugin", (Object[])new Object[0]));
        }
    }
}

