/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.FormulaUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.sdk.SrmAllScorerScoredDefService;
import kd.scm.srm.common.sdk.SrmCalEvaGradeService;
import kd.scm.srm.common.sdk.SrmEvaplanWritebackScoredService;
import kd.sdk.scm.srm.extpoint.ISrmAllScorerScoredService;
import kd.sdk.scm.srm.extpoint.ISrmCalEvaGradeService;
import kd.sdk.scm.srm.extpoint.ISrmEvaplanWritebackScoredService;

public class SrmScoreUtil {
    public static StringBuilder assembleScoreSelectFields() {
        return new StringBuilder().append("id billid,billno,billdate,billstatus,bizstatus,taskbillno,taskbillid,name,evatype,org,supplier,supplier.name suppliername,category,material,scheme,grade,datefrom,dateto,sumscore,calgrade,period,plandate,remark,").append("entry.index.id entryid,entry.index index,entry.index.formulaid formulaid,entry.sysscore sysscore,entry.manscore manscore,entry.veto veto,entry.indexweight indexweight,entry.finalscore finalscore,entry.indexscored indexscored,").append("entry.subentry.id detailid,entry.subentry.scorer scorer,entry.subentry.value value,entry.subentry.scorerveto scorerveto,entry.subentry.score score,entry.subentry.scorerweight scorerweight,entry.subentry.scorerscore scorerscore,entry.subentry.note note,entry.subentry.scorerscored scorerscored").append(",entry.subentry.scoreattachment,bizbilltype,bizbillno,entry.subentry.scorersave scorersave,entry.subentry.accordance accordance,entry.subentry.abstain abstain");
    }

    public static QFilter[] assembleQueryFilter(String supplier, IPageCache cache) {
        String name;
        String material;
        String categoryId;
        String[] supplierArr;
        String orgId;
        String evatypeId;
        String dateTo;
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        String scoreStatus = cache.get("scorestatus");
        ArrayList<String> bizStatusList = new ArrayList<String>(3);
        if (null != scoreStatus && scoreStatus.equals("0")) {
            bizStatusList.add(SrmScoreStatusEnum.TOBESCORE.getValue());
            bizStatusList.add(SrmScoreStatusEnum.PARTSCORED.getValue());
            filter.and("entry.subentry.scorerscored", "=", (Object)"0");
        } else if (null != scoreStatus && scoreStatus.equals("1")) {
            bizStatusList.add(SrmScoreStatusEnum.PARTSCORED.getValue());
            filter.and("entry.subentry.scorerscored", "=", (Object)"1");
        } else {
            bizStatusList.add(SrmScoreStatusEnum.TOBESCORE.getValue());
            bizStatusList.add(SrmScoreStatusEnum.PARTSCORED.getValue());
        }
        filter.and("bizstatus", "in", bizStatusList);
        String isworkbench = cache.get("isworkbench");
        if (StringUtils.isNotBlank((CharSequence)isworkbench)) {
            String taskBillnos = cache.get("taskbillnos");
            String[] taskBillnoCol = taskBillnos.split(",");
            HashSet<Long> taskIdSet = new HashSet<Long>(16);
            for (String taskBillno : taskBillnoCol) {
                if (!StringUtils.isNotBlank((CharSequence)taskBillno)) continue;
                taskIdSet.add(Long.parseLong(taskBillno));
            }
            if (!taskIdSet.isEmpty()) {
                filter.and("id", "in", taskIdSet);
            }
        }
        filter.and("entry.index.scoretype", "=", (Object)"1");
        filter.and("entry.subentry.scorer", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        String dateFrom = cache.get("datefrom");
        if (null != dateFrom && !dateFrom.isEmpty()) {
            filter.and("billdate", ">=", (Object)DateUtil.string2date((String)dateFrom, null));
        }
        if (null != (dateTo = cache.get("dateto")) && !dateTo.isEmpty()) {
            filter.and("billdate", "<=", (Object)DateUtil.string2date((String)dateTo, null));
        }
        if (null != (evatypeId = cache.get("evatype")) && !evatypeId.isEmpty()) {
            filter.and("evatype", "=", (Object)Long.parseLong(evatypeId));
        }
        if (null != (orgId = cache.get("org")) && !orgId.isEmpty()) {
            filter.and("org", "=", (Object)Long.valueOf(orgId));
        }
        String supplierId = cache.get("supplier_id");
        ArrayList<Long> supplierList = new ArrayList<Long>(32);
        if (supplierId != null && (supplierArr = supplierId.split(",")) != null && supplierArr.length > 0) {
            for (String str : supplierArr) {
                if ("".equals(str)) continue;
                supplierList.add(Long.parseLong(str));
            }
        }
        if (null != supplierId && !supplierId.isEmpty()) {
            filter.and("supplier", "in", supplierList);
        }
        if (supplier != null) {
            filter.and("supplier", "=", (Object)Long.valueOf(supplier));
        }
        if (null != (categoryId = cache.get("category")) && !categoryId.isEmpty()) {
            filter.and("category", "=", (Object)Long.valueOf(categoryId));
        }
        if (StringUtils.isNotEmpty((CharSequence)(material = cache.get("material")))) {
            String replaceMaterail;
            String replace = material.replace("[", "");
            ArrayList<Long> materials = new ArrayList<Long>(12);
            if (StringUtils.isNotEmpty((CharSequence)replace) && StringUtils.isNotEmpty((CharSequence)(replaceMaterail = replace.replace("]", "")))) {
                String[] splitMaterial;
                for (String id : splitMaterial = replaceMaterail.split(",")) {
                    materials.add(Long.valueOf(id.trim()));
                }
                filter.and("material", "in", materials);
            }
        }
        if (null != (name = cache.get("name")) && !name.trim().isEmpty()) {
            filter.and("name", "like", (Object)("%" + name + "%"));
        }
        return new QFilter[]{filter};
    }

    public static Map<String, Object> verifyData(DynamicObjectCollection scoreRows, Set<Long> taskIds, Set<Long> scoreIds, Map<String, Object> scoreMap, String verfyType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", null);
        StringBuilder errMsg = new StringBuilder();
        boolean succed = true;
        int scoredCount = 0;
        int rowIndex = 1;
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SrmScoreStatusEnum.TOBESCORE.getValue());
        statusList.add(SrmScoreStatusEnum.PARTSCORED.getValue());
        statusList.add(SrmScoreStatusEnum.SCORED.getValue());
        for (DynamicObject row : scoreRows) {
            String bizStatus = row.getString("bizstatus_a");
            boolean success = false;
            String valuetext_a = row.getString("valuetext_a");
            if (StringUtils.isNotBlank((CharSequence)valuetext_a) && SrmScoreUtil.isNumeric(valuetext_a)) {
                success = true;
            }
            boolean abstain_a = row.getBoolean("abstain_a");
            if (!success || !statusList.contains(bizStatus)) continue;
            BigDecimal indexScore = (BigDecimal)row.get("index_a.score");
            BigDecimal score = (BigDecimal)row.get("score_a");
            if ("submit".equals(verfyType) && score.compareTo(indexScore) > 0) {
                succed = false;
                errMsg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c%1\u884c\uff1a\u8bc4\u59d4\u6253\u5206\u5e94\u5c0f\u4e8e\u6307\u6807\u5206\u503c\u3002", (String)"SrmScoreUtil_3", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmScoreUtil_0", (String)"scm-srm-common", (Object[])new Object[]{rowIndex})).append("\r\n");
            } else if (!abstain_a) {
                taskIds.add(row.getLong("taskbillid_a"));
                scoreIds.add(row.getLong("billid_a"));
                scoreMap.put(row.getString("detailid_a"), row);
                ++scoredCount;
            }
            ++rowIndex;
        }
        if (!succed) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", errMsg);
        } else if (scoredCount > 0) {
            resultMap.put("succed", Boolean.TRUE);
            resultMap.put("message", ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5df2\u8bc4\u5206\u8bb0\u5f55\u6570\uff1a%1", (String)"SrmScoreUtil_1", (String)"scm-srm-common", (Object[])new Object[0]), (String)"SrmScoreUtil_1", (String)"scm-srm-common", (Object[])new Object[]{scoredCount}));
            resultMap.put("taskNos", taskIds);
            resultMap.put("scoreNos", scoreIds);
            resultMap.put("scoreMap", scoreMap);
        } else {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bc4\u5206\u8bb0\u5f55\uff0c\u4e0d\u9700\u8981\u63d0\u4ea4\u3002", (String)"SrmScoreUtil_2", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static void writeToScore(Set<Long> taskIds, Set<Long> scoreIds, Map<String, Object> scoreMap) {
        SrmScoreUtil.saveScoreDetail(scoreMap, "submit");
        SrmScoreUtil.setScoreStatus(scoreIds);
        SrmScoreUtil.setEvaplanStatus(taskIds);
    }

    public static void saveScoreDetail(Map<String, Object> scoreMap, String saveType) {
        DynamicObject[] detailRows;
        String selectFields = "id,scorer,value,score,accordance,scorerveto,scorerweight,scorerscore,note,scorerscored,scoreattachment,scorersave";
        for (DynamicObject row : detailRows = BusinessDataServiceHelper.load((String)"srm_score_detail", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)scoreMap.keySet().stream().mapToLong(s -> Long.parseLong(s)).toArray())})) {
            DynamicObject obj = (DynamicObject)scoreMap.get(row.getString("id"));
            if (obj == null) continue;
            if ("save".equals(saveType) && Objects.isNull(obj.getBigDecimal("value_a"))) {
                row.set("value", (Object)new BigDecimal(-1));
            } else {
                row.set("value", (Object)obj.getBigDecimal("value_a"));
            }
            row.set("accordance", (Object)obj.getString("accordance"));
            row.set("scorersave", (Object)true);
            row.set("score", (Object)obj.getBigDecimal("score_a"));
            row.set("scorerveto", (Object)obj.getString("scorerveto_a"));
            row.set("scorerscore", (Object)obj.getBigDecimal("scorerscore_a"));
            row.set("note", (Object)obj.getString("note_a"));
            row.set("scoreattachment", (Object)obj.getDynamicObjectCollection("scoreattachment"));
            if ("save".equals(saveType)) continue;
            row.set("scorerscored", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])detailRows);
    }

    public static DynamicObject getScoreGrade(Object gradeId, BigDecimal score) {
        DynamicObject gradeObj = BusinessDataServiceHelper.loadSingle((Object)gradeId, (String)"srm_grade");
        if (gradeObj == null) {
            return null;
        }
        for (DynamicObject row : gradeObj.getDynamicObjectCollection("entryentity")) {
            if (score.compareTo(row.getBigDecimal("scorefrom")) < 0 || score.compareTo(row.getBigDecimal("scoreto")) >= 0) continue;
            return row.getDynamicObject("evagrade");
        }
        return null;
    }

    public static void setScoreStatus(Set<Long> billIds) {
        DynamicObject[] bills;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1024);
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"srm_score"))) {
            resultMap.clear();
            DynamicObjectCollection indexRows = bill.getDynamicObjectCollection("entry");
            String trialresult = bill.getString("trialresult");
            String auditresult = bill.getString("auditresult");
            if (StringUtils.isNotBlank((CharSequence)trialresult) && "C".equals(trialresult)) {
                bill.set("trialresult", (Object)"A");
            }
            if (StringUtils.isNotBlank((CharSequence)auditresult) && "C".equals(auditresult)) {
                bill.set("auditresult", (Object)"A");
            }
            resultMap.put("bill", bill);
            resultMap.put("allscored", Boolean.TRUE);
            resultMap.put("partscored", Boolean.FALSE);
            resultMap.put("sumscore", BigDecimal.ZERO);
            for (DynamicObject indexRow : indexRows) {
                String scoreType = indexRow.getString("index.scoretype");
                boolean isdeduct = indexRow.getBoolean("index.isdeduct");
                boolean isformula = indexRow.getBoolean("index.isformula");
                BigDecimal indexweight = indexRow.getBigDecimal("indexweight");
                if (indexweight.compareTo(BigDecimal.ZERO) == 0) {
                    indexweight = BigDecimal.TEN.multiply(BigDecimal.TEN);
                }
                resultMap.put("row", indexRow);
                resultMap.put("scoretype", scoreType);
                resultMap.put("isdeduct", isdeduct);
                resultMap.put("isformula", isformula);
                resultMap.put("indexweight", indexweight);
                if ("2".equals(scoreType)) continue;
                resultMap.put("indexscored", Boolean.TRUE);
                resultMap.put("manscore", BigDecimal.ZERO);
                resultMap.put("veto", "9");
                SrmScoreUtil.handleScorerStatus(resultMap);
                if (!((Boolean)resultMap.get("indexscored")).booleanValue()) continue;
                SrmScoreUtil.handleManualIndexStatus(resultMap);
            }
            SrmScoreUtil.handleIndexTypeScore(resultMap);
            SrmScoreUtil.handleBillStatus(resultMap);
        }
        SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])bills);
    }

    private static void handleIndexTypeScore(Map<String, Object> resultMap) {
        Map scoreMap = (Map)resultMap.get("scoreMap");
        if (scoreMap == null) {
            return;
        }
        DynamicObjectCollection indexRows = ((DynamicObject)resultMap.get("bill")).getDynamicObjectCollection("entry");
        ArrayList<String> classIds = new ArrayList<String>(10);
        boolean haveAllVeto = false;
        for (DynamicObject row : indexRows) {
            String veto;
            String indexTypeNubmer = row.getString("index.indextype.number");
            String indexClassNubmer = row.getString("index.indexclass.number");
            String indexNubmer = row.getString("index.number");
            switch (veto = row.getString("veto")) {
                case "1": {
                    classIds.add(indexTypeNubmer);
                    break;
                }
                case "2": {
                    classIds.add(indexClassNubmer);
                    break;
                }
                case "3": {
                    classIds.add(indexNubmer);
                    break;
                }
                case "4": {
                    haveAllVeto = true;
                    break;
                }
            }
        }
        if (haveAllVeto) {
            return;
        }
        Set indexTypeEntries = scoreMap.entrySet();
        BigDecimal sumScore = BigDecimal.ZERO;
        for (Map.Entry indexTypeEntry : indexTypeEntries) {
            BigDecimal indexTypeSumScore = BigDecimal.ZERO;
            String indextypeNumber = (String)indexTypeEntry.getKey();
            HashMap value = (HashMap)indexTypeEntry.getValue();
            Set indexClassEntries = value.entrySet();
            if (classIds.contains(indextypeNumber)) continue;
            for (Map.Entry indexClassEntry : indexClassEntries) {
                String indexClassNumber = (String)indexClassEntry.getKey();
                BigDecimal indexClassScore = BigDecimal.ZERO;
                if (classIds.contains(indexClassNumber)) continue;
                HashMap indexClass = (HashMap)indexClassEntry.getValue();
                Set indexs = indexClass.entrySet();
                for (Map.Entry index : indexs) {
                    String indexNumber = (String)index.getKey();
                    if (classIds.contains(indexNumber)) continue;
                    BigDecimal indexScore = (BigDecimal)index.getValue();
                    indexClassScore = indexClassScore.add(indexScore);
                }
                String indexClassLowestScore = SrmScoreUtil.getIndexLowestScore(indexClassNumber);
                if (StringUtils.isNotBlank((CharSequence)indexClassLowestScore) && indexClassLowestScore.equals("2")) {
                    indexClassScore = indexClassScore.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : indexClassScore;
                }
                indexTypeSumScore = indexTypeSumScore.add(indexClassScore);
            }
            String indexTypeLowestScore = SrmScoreUtil.getIndexLowestScore(indextypeNumber);
            if (StringUtils.isNotBlank((CharSequence)indexTypeLowestScore) && indexTypeLowestScore.equals("2")) {
                indexTypeSumScore = indexTypeSumScore.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : indexTypeSumScore;
            }
            sumScore = sumScore.add(indexTypeSumScore);
        }
        resultMap.put("sumscore", sumScore);
    }

    private static String getIndexLowestScore(String indexTypeNumber) {
        DynamicObject indextypeLowestscoreDyo = QueryServiceHelper.queryOne((String)"srm_indexclass", (String)"lowestscore", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)indexTypeNumber)});
        String indextypeLowestscore = indextypeLowestscoreDyo.getString("lowestscore");
        return indextypeLowestscore;
    }

    public static void handleScorerStatus(Map<String, Object> resultMap) {
        boolean partScored = (Boolean)resultMap.get("partscored");
        boolean allScored = (Boolean)resultMap.get("allscored");
        boolean indexScored = (Boolean)resultMap.get("indexscored");
        BigDecimal manscore = (BigDecimal)resultMap.get("manscore");
        String veto = (String)resultMap.get("veto");
        DynamicObjectCollection subRows = ((DynamicObject)resultMap.get("row")).getDynamicObjectCollection("subentry");
        for (DynamicObject subRow : subRows) {
            if (subRow.getBoolean("scorerscored")) {
                manscore = manscore.add(subRow.getBigDecimal("scorerscore"));
                String subVeto = subRow.getString("scorerveto");
                if (subVeto != null && subVeto.compareTo(veto) < 0) {
                    veto = subVeto;
                }
                partScored = true;
                continue;
            }
            indexScored = false;
            allScored = false;
        }
        resultMap.put("manscore", manscore);
        resultMap.put("veto", veto);
        resultMap.put("partscored", partScored);
        resultMap.put("indexscored", indexScored);
        resultMap.put("allscored", allScored);
    }

    private static void handleSystemIndexStatus(Map<String, Object> resultMap) {
    }

    private static void handleManualIndexStatus(Map<String, Object> resultMap) {
        HashMap<String, BigDecimal> indexMap;
        String veto_old;
        DynamicObject indexRow = (DynamicObject)resultMap.get("row");
        BigDecimal indexweight = (BigDecimal)resultMap.get("indexweight");
        if (indexweight.compareTo(BigDecimal.ZERO) <= 0) {
            indexweight = BigDecimal.TEN.multiply(BigDecimal.TEN);
        }
        BigDecimal manscore = (BigDecimal)resultMap.get("manscore");
        String veto = (String)resultMap.get("veto");
        boolean isdeduct = (Boolean)resultMap.get("isdeduct");
        BigDecimal sumScore = (BigDecimal)resultMap.get("sumscore");
        indexRow.set("indexscored", (Object)Boolean.TRUE);
        if (isdeduct) {
            indexRow.set("manscore", (Object)manscore.negate());
        } else {
            indexRow.set("manscore", (Object)manscore);
        }
        if (!(veto == null || veto.equals("9") || (veto_old = indexRow.getString("veto")) != null && veto.compareTo(veto_old) >= 0)) {
            indexRow.set("veto", (Object)veto);
        }
        indexRow.set("finalscore", (Object)indexRow.getBigDecimal("manscore").multiply(indexweight).divide(BigDecimal.TEN.multiply(BigDecimal.TEN)));
        HashMap scoreMap = (HashMap)resultMap.get("scoreMap");
        if (scoreMap == null) {
            scoreMap = new HashMap(64);
        }
        String indextypeNumber = indexRow.getString("index.indextype.number");
        String indexclassNumber = indexRow.getString("index.indexclass.number");
        String indexNumber = indexRow.getString("index.number");
        HashMap<String, HashMap<String, BigDecimal>> indexclassMap = (HashMap<String, HashMap<String, BigDecimal>>)scoreMap.get(indextypeNumber);
        if (indexclassMap == null) {
            indexclassMap = new HashMap<String, HashMap<String, BigDecimal>>(128);
        }
        if ((indexMap = (HashMap<String, BigDecimal>)indexclassMap.get(indexclassNumber)) == null) {
            indexMap = new HashMap<String, BigDecimal>(128);
        }
        indexMap.put(indexNumber, indexRow.getBigDecimal("finalscore"));
        indexclassMap.put(indexclassNumber, indexMap);
        scoreMap.put(indextypeNumber, indexclassMap);
        resultMap.put("scoreMap", scoreMap);
    }

    private static void handleBillStatus(Map<String, Object> resultMap) {
        boolean partScored = (Boolean)resultMap.get("partscored");
        boolean allScored = (Boolean)resultMap.get("allscored");
        DynamicObject bill = (DynamicObject)resultMap.get("bill");
        if (allScored) {
            BigDecimal sumScore = (BigDecimal)resultMap.get("sumscore");
            DynamicObject scoreGrade = bill.getDynamicObject("grade");
            if (sumScore.compareTo(BigDecimal.ZERO) < 0) {
                sumScore = BigDecimal.ZERO;
            }
            long scoreGradeId = 0L;
            if (Objects.nonNull(scoreGrade)) {
                scoreGradeId = scoreGrade.getLong("id");
            }
            long scoreBillId = bill.getLong("id");
            SrmCalEvaGradeService defPlugin = new SrmCalEvaGradeService();
            PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISrmCalEvaGradeService.class, (String)"SCM_SRM_CALEVAGRADE_EXT", null);
            BigDecimal finalSumScore = sumScore;
            long finalScoreGradeId = scoreGradeId;
            pluginProxy.callReplaceIfPresent(p -> {
                DynamicObject evaGrade = p.calGrade(resultMap, scoreBillId, finalScoreGradeId, finalSumScore);
                if (evaGrade != null) {
                    bill.set("calgrade", (Object)evaGrade.getLong("id"));
                }
                return null;
            });
            bill.set("bizstatus", (Object)SrmScoreStatusEnum.SCORED.getValue());
            bill.set("sumscore", (Object)sumScore);
            bill.set("finishdate", (Object)TimeServiceHelper.now());
            SrmScoreUtil.submitreview(bill);
            SrmAllScorerScoredDefService defSdkPlugin = new SrmAllScorerScoredDefService();
            PluginProxy pluginSdkProxy = PluginProxy.create((Object)defSdkPlugin, ISrmAllScorerScoredService.class, (String)"SCM_SRM_ALLSCORERSCOREDEXECSOMETHING_EXT", null);
            pluginSdkProxy.callReplaceIfPresent(p -> {
                p.doExecExt(resultMap, scoreBillId, finalSumScore);
                return null;
            });
        } else if (partScored) {
            bill.set("bizstatus", (Object)SrmScoreStatusEnum.PARTSCORED);
        }
    }

    private static void submitreview(DynamicObject bill) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationServiceHelper.executeOperate((String)"submitreview", (String)"srm_scorerpt", (Object[])new Object[]{bill.getPkValue()}, (OperateOption)option);
    }

    private static void handleVeto(Map<String, Object> resultMap) {
        DynamicObjectCollection indexRows = ((DynamicObject)resultMap.get("bill")).getDynamicObjectCollection("entry");
        ArrayList<Long> classIds = new ArrayList<Long>();
        boolean haveVeto = false;
        boolean haveAllVeto = false;
        for (DynamicObject row : indexRows) {
            String veto;
            long typeId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("index.indextype"));
            long classId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("index.indexclass"));
            long indexId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("index"));
            switch (veto = row.getString("veto")) {
                case "1": {
                    classIds.add(typeId);
                    haveVeto = true;
                    break;
                }
                case "2": {
                    classIds.add(classId);
                    haveVeto = true;
                    break;
                }
                case "3": {
                    classIds.add(indexId);
                    haveVeto = true;
                    break;
                }
                case "4": {
                    haveVeto = true;
                    haveAllVeto = true;
                    break;
                }
            }
        }
        if (haveVeto) {
            BigDecimal sumScore = BigDecimal.ZERO;
            for (DynamicObject row : indexRows) {
                boolean isdeduct = row.getBoolean("index.isdeduct");
                long typeId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("index.indextype"));
                long classId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("index.indexclass"));
                long indexId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("index"));
                BigDecimal finalScore = row.getBigDecimal("finalscore");
                if (classIds.contains(typeId) || classIds.contains(classId) || classIds.contains(indexId) || haveAllVeto) {
                    row.set("finalscore", null);
                    continue;
                }
                if (isdeduct) {
                    String indexTypeNubmer = row.getString("index.indextype.number");
                    String indexClassNubmer = row.getString("index.indexclass.number");
                    if (SrmScoreUtil.getIndexLowestScore(indexTypeNubmer).equals("2") || SrmScoreUtil.getIndexLowestScore(indexClassNubmer).equals("2")) {
                        finalScore = BigDecimal.ZERO;
                    }
                    sumScore = sumScore.add(finalScore);
                    continue;
                }
                sumScore = sumScore.add(finalScore);
            }
            resultMap.put("sumscore", sumScore);
        }
    }

    public static void setEvaplanStatus(Set<Long> billIds) {
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"srm_evaplan", (String)"billno,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        if (bills == null || bills.length == 0) {
            bills = BusinessDataServiceHelper.load((String)"srm_evaplan_batch", (String)"billno,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        if (bills == null || bills.length == 0) {
            return;
        }
        for (DynamicObject bill : bills) {
            String billNo = bill.getString("billno");
            DynamicObject[] scoreRows = BusinessDataServiceHelper.load((String)"srm_score", (String)"bizstatus", (QFilter[])new QFilter[]{new QFilter("taskbillno", "=", (Object)billNo)});
            if (scoreRows == null || scoreRows.length == 0) continue;
            boolean scored = true;
            String bizStatus = null;
            for (DynamicObject row : scoreRows) {
                bizStatus = row.getString("bizstatus");
                if (!bizStatus.equals(SrmScoreStatusEnum.PARTSCORED.getValue()) && !bizStatus.equals(SrmScoreStatusEnum.TOBESCORE.getValue())) continue;
                scored = false;
                break;
            }
            if (scored) {
                bill.set("bizstatus", (Object)SrmEvaPlanStatusEnum.SCORED);
                SrmEvaplanWritebackScoredService defPlugin = new SrmEvaplanWritebackScoredService();
                PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISrmEvaplanWritebackScoredService.class, (String)"SCM_SRM_EVAPLANWRITEBACKSCOREDEXECSOMETHING_EXT", null);
                pluginProxy.callAfter(p -> {
                    p.exec(bill);
                    return null;
                });
                continue;
            }
            bill.set("bizstatus", (Object)SrmEvaPlanStatusEnum.TOBESCORE);
        }
        SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])bills);
    }

    public static Map<String, Object> calculateScore(DynamicObject scoreRow, DynamicObjectCollection ruleRows) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.FALSE);
        resultMap.put("scorerscored", Boolean.FALSE);
        resultMap.put("score", BigDecimal.ZERO);
        resultMap.put("scorerveto", "9");
        resultMap.put("scorerscore", BigDecimal.ZERO);
        if (scoreRow == null) {
            return resultMap;
        }
        String property = scoreRow.getString("index_a.property");
        boolean isformula = scoreRow.getBoolean("index_a.isformula");
        BigDecimal indexscore = scoreRow.getBigDecimal("index_a.score");
        BigDecimal value = scoreRow.getBigDecimal("value_a");
        String accordance = scoreRow.getString("accordance");
        if (value == null || value.compareTo(BigDecimal.ZERO) < 0) {
            return resultMap;
        }
        BigDecimal scorerweight = scoreRow.getBigDecimal("scorerweight_a").divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        if (scorerweight.compareTo(BigDecimal.ZERO) <= 0) {
            scorerweight = BigDecimal.ONE;
        }
        BigDecimal score = BigDecimal.ZERO;
        Map<Object, Object> tempMap = new HashMap();
        if (property.equals("1")) {
            tempMap = isformula ? SrmScoreUtil.getScoreByFormula(ruleRows, value, indexscore) : SrmScoreUtil.getScore(ruleRows, value);
            score = (BigDecimal)tempMap.get("score");
            resultMap.put("scorerveto", tempMap.get("scorerveto"));
        } else if (property.equals("2")) {
            if (score.compareTo(indexscore) <= 0) {
                score = value;
                for (DynamicObject ruleRow : ruleRows) {
                    if (value.compareTo(ruleRow.getBigDecimal("itemscore_b")) != 0) continue;
                    resultMap.put("scorerveto", ruleRow.getBigDecimal("veto_b"));
                    break;
                }
            } else {
                score = BigDecimal.valueOf(-1L);
            }
        } else if (StringUtils.isNotBlank((CharSequence)accordance)) {
            for (DynamicObject ruleRow : ruleRows) {
                String accordance_b = ruleRow.getString("accordance_b");
                if (!accordance.equals(accordance_b)) continue;
                resultMap.put("scorerveto", ruleRow.getBigDecimal("veto_b"));
                score = ruleRow.getBigDecimal("itemscore_b");
                break;
            }
        }
        BigDecimal scorerscore = score.multiply(scorerweight);
        resultMap.put("scorerscored", Boolean.TRUE);
        resultMap.put("score", score);
        resultMap.put("scorerscore", scorerscore);
        if (score.compareTo(BigDecimal.ZERO) < 0) {
            resultMap.put("succed", Boolean.FALSE);
        } else {
            resultMap.put("succed", Boolean.TRUE);
        }
        return resultMap;
    }

    public static Map<String, Object> getScore(DynamicObjectCollection ruleRows, BigDecimal value) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("score", BigDecimal.valueOf(-1L));
        resultMap.put("scorerveto", "9");
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return resultMap;
        }
        for (DynamicObject row : ruleRows) {
            if (value.compareTo(row.getBigDecimal("valuefrom_b")) < 0 || value.compareTo(row.getBigDecimal("valueto_b")) >= 0) continue;
            resultMap.put("score", row.getBigDecimal("itemscore_b"));
            resultMap.put("scorerveto", row.getBigDecimal("veto_b"));
            break;
        }
        return resultMap;
    }

    public static Map<String, Object> getScoreByFormula(DynamicObjectCollection ruleRows, BigDecimal value, BigDecimal indexscore) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("score", BigDecimal.valueOf(-1L));
        resultMap.put("scorerveto", "9");
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return resultMap;
        }
        BigDecimal score = BigDecimal.ZERO;
        for (DynamicObject row : ruleRows) {
            if (value.compareTo(row.getBigDecimal("valuefrom_b")) < 0 || value.compareTo(row.getBigDecimal("valueto_b")) >= 0) continue;
            resultMap.put("scorerveto", row.getBigDecimal("veto_b"));
            String formula = row.getString("formula_b");
            if (formula != null && !formula.trim().equals("")) {
                HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
                valueMap.put("value", value);
                Object result = FormulaUtil.runFormula((String)("result = " + formula + " ;"), valueMap);
                BigDecimal bigDecimal = score = result == null ? BigDecimal.ZERO : new BigDecimal(result.toString());
            }
            if (score.compareTo(indexscore) < 0) {
                resultMap.put("score", score);
                break;
            }
            resultMap.put("score", indexscore);
            break;
        }
        return resultMap;
    }
}

