/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.srm.common.enums.SrmEvaDimensionEnum;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.SrmAutoCalCtxModel;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.service.ISrmCalIsBatchService;
import kd.scm.srm.common.formula.service.SrmAutoCalServiceFactory;
import kd.scm.srm.common.formula.utils.ScDataHandleLogInfoUtils;
import kd.scm.srm.common.formula.utils.SrmAutoCalCtxBuildUtils;
import kd.scm.srm.common.formula.utils.SrmCalResultHelper;

public class SrmCalBatchService
implements ISrmCalIsBatchService {
    private static final Log LOG = LogFactory.getLog(SrmCalBatchService.class);

    @Override
    public List<SrmGetAutoScoreReq> doAutoCal(SrmAutoFormulaReq srmAutoFormulaReq, DynamicObject formulaDy, Boolean isAlgox, Integer timeOut) {
        LOG.info("\u6279\u91cf\u8ba1\u7b97\u4e2d\uff0csrmAutoFormulaReq={}", (Object)srmAutoFormulaReq.toString());
        Long orgId = srmAutoFormulaReq.getOrgId();
        String evaDimension = srmAutoFormulaReq.getEvaDimension();
        Date startDate = srmAutoFormulaReq.getStartDate();
        Date endDate = srmAutoFormulaReq.getEndDate();
        Long evaplanId = srmAutoFormulaReq.getEvaplanId();
        ArrayList<SrmGetAutoScoreReq> list = new ArrayList<SrmGetAutoScoreReq>(8);
        List<SrmAutoFormulaReq.SrmAutoFormulaData> datas = srmAutoFormulaReq.getData();
        SrmAutoFormulaReq.SrmAutoFormulaData firstData = datas.get(0);
        Long formulaId = firstData.getFormulaId();
        Long indexId = firstData.getIndexId();
        DynamicObject loadCal = SrmCalResultHelper.getCalResult(orgId, evaplanId, formulaId, evaDimension);
        Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> collect = datas.stream().collect(Collectors.groupingBy(SrmAutoFormulaReq.SrmAutoFormulaData::getGroupOrgId));
        for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> orgCol : collect.entrySet()) {
            List<SrmGetAutoScoreReq> calResultList;
            SrmFormulaModel model;
            Long supplierId;
            Long groupOrgId = orgCol.getKey();
            List<SrmAutoFormulaReq.SrmAutoFormulaData> values = orgCol.getValue();
            Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> supplierIds = values.stream().collect(Collectors.groupingBy(SrmAutoFormulaReq.SrmAutoFormulaData::getSupplierId));
            if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension)) {
                for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry : supplierIds.entrySet()) {
                    supplierId = entry.getKey();
                    Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> materialIds = entry.getValue().stream().collect(Collectors.groupingBy(SrmAutoFormulaReq.SrmAutoFormulaData::getMaterialId));
                    model = this.buildSrmFormulaModel(groupOrgId, evaplanId, evaDimension, startDate, endDate, supplierId, formulaId, indexId, materialIds);
                    loadCal = this.doAutoCal(loadCal, model, formulaDy, isAlgox, timeOut);
                    calResultList = SrmCalResultHelper.getCalResultList(loadCal, model);
                    list.addAll(calResultList);
                }
                continue;
            }
            if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) {
                for (Map.Entry<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> entry : supplierIds.entrySet()) {
                    supplierId = entry.getKey();
                    Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> categoryIds = entry.getValue().stream().collect(Collectors.groupingBy(SrmAutoFormulaReq.SrmAutoFormulaData::getCategoryId));
                    model = this.buildSrmFormulaModel(groupOrgId, evaplanId, evaDimension, startDate, endDate, supplierId, formulaId, indexId, categoryIds);
                    loadCal = this.doAutoCal(loadCal, model, formulaDy, isAlgox, timeOut);
                    calResultList = SrmCalResultHelper.getCalResultList(loadCal, model);
                    list.addAll(calResultList);
                }
                continue;
            }
            SrmFormulaModel model2 = this.buildSrmFormulaModel(groupOrgId, evaplanId, evaDimension, startDate, endDate, null, formulaId, indexId, supplierIds);
            loadCal = this.doAutoCal(loadCal, model2, formulaDy, isAlgox, timeOut);
            List<SrmGetAutoScoreReq> calResultList2 = SrmCalResultHelper.getCalResultList(loadCal, model2);
            list.addAll(calResultList2);
        }
        String config = "isBatch:true;isAlgox:" + isAlgox;
        String resultDesc = ResManager.loadKDString((String)"\u6279\u91cf\u8ba1\u7b97\u5b50\u8868\u8fbe\u5f0fresult", (String)"SrmCalBatchService_0", (String)"scm-srm-common", (Object[])new Object[0]);
        ScDataHandleLogInfoUtils.info(srmAutoFormulaReq, config, resultDesc, list);
        LOG.info("\u6279\u91cf\u5904\u7406\u8ba1\u7b97\u7ed3\u679c={}", (Object)JSON.toJSONString(list));
        return list;
    }

    private DynamicObject doAutoCal(DynamicObject loadCal, SrmFormulaModel req, DynamicObject formulaDy, Boolean isAlgox, Integer timeOut) {
        String config = "isBatch:true;isAlgox:" + isAlgox;
        try {
            String formula = formulaDy.getString("formula");
            DynamicObjectCollection entryEntitys = formulaDy.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntitys.size(); ++i) {
                DynamicObject dy = (DynamicObject)entryEntitys.get(i);
                String entitycode = dy.getString("entitycode");
                SrmAutoCalCtxModel ctx = SrmAutoCalCtxBuildUtils.buildCtx(req, dy, timeOut);
                List<SrmGetAutoScoreReq> list = SrmAutoCalServiceFactory.getISrmAutoCalAlgoService(isAlgox).queryDataSetBatch(req, dy, ctx);
                String resultDesc = ResManager.loadKDString((String)"\u6279\u91cf\u8ba1\u7b97\u5b50\u8868\u8fbe\u5f0fresult", (String)"SrmCalBatchService_0", (String)"scm-srm-common", (Object[])new Object[0]);
                String resultStr = resultDesc + (i + 1) + ":";
                ScDataHandleLogInfoUtils.info(req, ctx.toString(), config, config, resultStr, list);
                if (list == null) continue;
                loadCal = SrmCalResultHelper.saveOrNewCalResult(loadCal, list, req, formula, entitycode);
                SrmCalResultHelper.saveCalResult(loadCal);
            }
            return SrmCalResultHelper.calFinalFormula(loadCal, req, formula);
        }
        catch (Exception e) {
            ScDataHandleLogInfoUtils.error(req, config, e);
            return null;
        }
    }

    private SrmFormulaModel buildSrmFormulaModel(Long orgId, Long evaplanId, String evaDimension, Date startDate, Date endDate, Long supplierId, Long formulaId, Long indexId, Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> groupIds) {
        SrmFormulaModel model = new SrmFormulaModel();
        model.setEndDate(endDate);
        model.setStartDate(startDate);
        model.setEvaplanId(evaplanId);
        model.setOrgId(orgId);
        model.setEvaDimension(evaDimension);
        model.setFormulaId(formulaId);
        model.setIndexId(indexId);
        if (SrmEvaDimensionEnum.CATEGORY_DIMENSION.getVal().equals(evaDimension)) {
            model.setSupplierId(supplierId);
            model.setCategoryIds(groupIds);
        } else if (SrmEvaDimensionEnum.MATERIAL_DIMENSION.getVal().equals(evaDimension)) {
            model.setSupplierId(supplierId);
            model.setMaterialIds(groupIds);
        } else {
            model.setSupplierIds(groupIds);
        }
        model.setBatch(true);
        return model;
    }
}

