/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.common.formula.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.srm.common.formula.SrmAutoFormulaReq;
import kd.scm.srm.common.formula.SrmGetAutoScoreReq;
import kd.scm.srm.common.formula.model.SrmFormulaModel;
import kd.scm.srm.common.formula.utils.SrmCalResultHelper;

public class SrmCalConditionService {
    private static final Log LOG = LogFactory.getLog(SrmCalConditionService.class);

    public List<SrmGetAutoScoreReq> doAutoCal(SrmAutoFormulaReq srmAutoFormulaReq, DynamicObject formulaDy, Long formulaId) {
        Map<String, BigDecimal> map;
        DynamicObject conditionbillid = formulaDy.getDynamicObject("conditionbillid");
        if (conditionbillid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u6761\u4ef6\u53d6\u503c\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u914d\u7f6e\u53d6\u503c\u5355\u636e\u3002", (String)"SrmCalConditionService_0", (String)"scm-srm-common", (Object[])new Object[0]));
        }
        String entityName = conditionbillid.getString("number");
        List<SrmGetAutoScoreReq> list = this.getSupplierScore(srmAutoFormulaReq, entityName, formulaDy, map = this.getConditionScore(formulaDy));
        if (list != null) {
            SrmFormulaModel srmFormulaModel = this.buildSrmFormulaModel(formulaId, srmAutoFormulaReq);
            SrmCalResultHelper.saveOrNewCalResult(list, srmFormulaModel, "result");
        }
        return list;
    }

    private SrmFormulaModel buildSrmFormulaModel(Long formulaId, SrmAutoFormulaReq srmAutoFormulaReq) {
        List<SrmAutoFormulaReq.SrmAutoFormulaData> datas = srmAutoFormulaReq.getData();
        SrmFormulaModel model = new SrmFormulaModel();
        model.setEndDate(srmAutoFormulaReq.getEndDate());
        model.setStartDate(srmAutoFormulaReq.getStartDate());
        model.setEvaplanId(srmAutoFormulaReq.getEvaplanId());
        model.setOrgId(srmAutoFormulaReq.getOrgId());
        model.setEvaDimension(srmAutoFormulaReq.getEvaDimension());
        model.setFormulaId(formulaId);
        Optional<SrmAutoFormulaReq.SrmAutoFormulaData> findFirst = datas.stream().filter(d -> d.getFormulaId().equals(formulaId)).findFirst();
        if (findFirst.isPresent()) {
            model.setIndexId(findFirst.get().getIndexId());
        }
        Map<Long, List<SrmAutoFormulaReq.SrmAutoFormulaData>> supplierIds = datas.stream().collect(Collectors.groupingBy(SrmAutoFormulaReq.SrmAutoFormulaData::getSupplierId));
        model.setSupplierIds(supplierIds);
        return model;
    }

    private Map<String, BigDecimal> getConditionScore(DynamicObject formulaDy) {
        DynamicObjectCollection conditionentitys = formulaDy.getDynamicObjectCollection("conditionentity");
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
        for (DynamicObject dy : conditionentitys) {
            String conditionid = dy.getString("conditionid");
            BigDecimal conditionscore = dy.getBigDecimal("conditionscore");
            map.put(conditionid, conditionscore);
        }
        LOG.info(JSON.toJSONString(map));
        return map;
    }

    private List<SrmGetAutoScoreReq> getSupplierScore(SrmAutoFormulaReq srmAutoFormulaReq, String entityName, DynamicObject formulaDy, Map<String, BigDecimal> map) {
        String conditionfield = formulaDy.getString("conditionfield");
        String conditionSupplierField = formulaDy.getString("conditionsupplierfield");
        String conditionorderbyfield = formulaDy.getString("conditionorderbyfield");
        String conditionorderbytype = formulaDy.getString("conditionorderbytype");
        String orderBy = "";
        if (StringUtils.isNotEmpty((String)conditionorderbyfield)) {
            orderBy = conditionorderbyfield + " " + conditionorderbytype;
        }
        List<SrmAutoFormulaReq.SrmAutoFormulaData> datas = srmAutoFormulaReq.getData();
        ArrayList<SrmGetAutoScoreReq> list = new ArrayList<SrmGetAutoScoreReq>(8);
        QFilter qf = new QFilter("1", "=", (Object)1);
        ArrayList<Long> pkIds = new ArrayList<Long>(8);
        HashMap<Long, SrmGetAutoScoreReq> srmGetAutoScoreReqs = new HashMap<Long, SrmGetAutoScoreReq>(8);
        for (SrmAutoFormulaReq.SrmAutoFormulaData data : datas) {
            Long evaplanId = srmAutoFormulaReq.getEvaplanId();
            Long supplierId = data.getSupplierId();
            SrmGetAutoScoreReq buildSrmGetAutoScoreReq = this.buildSrmGetAutoScoreReq(evaplanId, data);
            srmGetAutoScoreReqs.put(supplierId, buildSrmGetAutoScoreReq);
            pkIds.add(supplierId);
        }
        if ("bd_supplier".equals(entityName)) {
            qf.and("id", "in", pkIds);
        } else {
            qf.and(conditionSupplierField, "in", pkIds);
        }
        StringBuilder sb = this.buildSelectProperties(conditionSupplierField, conditionfield, conditionorderbyfield);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"SrmConditionQuery", (String)entityName, (String)sb.toString(), (QFilter[])new QFilter[]{qf}, (String)orderBy);
        HashMap mapResult = new HashMap(8);
        if (queryDataSet != null && !queryDataSet.isEmpty()) {
            queryDataSet.forEach(row -> {
                Long pkValue = 0L;
                pkValue = "bd_supplier".equals(entityName) ? row.getLong("id") : row.getLong(conditionSupplierField);
                Object result = mapResult.get(pkValue);
                if (result == null) {
                    Object conditiondyObj = row.get(conditionfield);
                    mapResult.put(pkValue, conditiondyObj);
                    this.setResult(conditiondyObj, map, srmGetAutoScoreReqs, pkValue);
                }
            });
        }
        for (SrmAutoFormulaReq.SrmAutoFormulaData data : datas) {
            SrmGetAutoScoreReq srmGetAutoScoreReq = new SrmGetAutoScoreReq();
            Long supplierId = data.getSupplierId();
            SrmGetAutoScoreReq srmGetAutoScoreReq0 = (SrmGetAutoScoreReq)srmGetAutoScoreReqs.get(supplierId);
            if (srmGetAutoScoreReq0 == null) continue;
            srmGetAutoScoreReq.setEvaplanId(srmGetAutoScoreReq0.getEvaplanId());
            srmGetAutoScoreReq.setResult(srmGetAutoScoreReq0.getResult());
            srmGetAutoScoreReq.setMaterialId(data.getMaterialId());
            srmGetAutoScoreReq.setCategoryId(data.getCategoryId());
            srmGetAutoScoreReq.setIndexScoreDetailId(data.getIndexScoreDetailId());
            srmGetAutoScoreReq.setScoreTaskId(data.getScoreTaskId());
            srmGetAutoScoreReq.setIndexId(data.getIndexId());
            srmGetAutoScoreReq.setSupplierId(supplierId);
            list.add(srmGetAutoScoreReq);
        }
        return list;
    }

    private StringBuilder buildSelectProperties(String conditionSupplierField, String conditionfield, String conditionorderbyfield) {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        if (StringUtils.isNotEmpty((String)conditionSupplierField)) {
            sb.append(",").append(conditionSupplierField);
        }
        sb.append(",").append(conditionfield);
        if (StringUtils.isNotEmpty((String)conditionorderbyfield)) {
            sb.append(",").append(conditionorderbyfield);
        }
        return sb;
    }

    private void setResult(Object conditiondy, Map<String, BigDecimal> map, Map<Long, SrmGetAutoScoreReq> srmGetAutoScoreReqs, Long supplierId) {
        SrmGetAutoScoreReq srmGetAutoScoreReq = srmGetAutoScoreReqs.get(supplierId);
        if (srmGetAutoScoreReq == null) {
            return;
        }
        BigDecimal score = map.get(conditiondy.toString());
        if (srmGetAutoScoreReq != null) {
            srmGetAutoScoreReq.setResult(score);
            srmGetAutoScoreReqs.put(supplierId, srmGetAutoScoreReq);
        }
    }

    private SrmGetAutoScoreReq buildSrmGetAutoScoreReq(Long evaplanId, SrmAutoFormulaReq.SrmAutoFormulaData req) {
        SrmGetAutoScoreReq autoFormulaResp = new SrmGetAutoScoreReq();
        autoFormulaResp.setEvaplanId(evaplanId);
        autoFormulaResp.setSupplierId(req.getSupplierId());
        autoFormulaResp.setMaterialId(req.getMaterialId());
        autoFormulaResp.setScoreTaskId(req.getScoreTaskId());
        autoFormulaResp.setIndexScoreDetailId(req.getIndexScoreDetailId());
        autoFormulaResp.setIndexId(req.getIndexId());
        autoFormulaResp.setResult(BigDecimal.ZERO);
        return autoFormulaResp;
    }

    private Map<String, String> getBaseProperties(String entityKey, String conditionfield) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Map allFieldProp = dataEntityType.getAllFields();
        if (allFieldProp == null) {
            map.put(conditionfield, "");
            return map;
        }
        for (Map.Entry fieldPropEntry : allFieldProp.entrySet()) {
            IDataEntityProperty fieldProp = (IDataEntityProperty)fieldPropEntry.getValue();
            String fieldKey = (String)fieldPropEntry.getKey();
            IDataEntityType parent = fieldProp.getParent();
            if (parent instanceof EntryType) {
                fieldKey = ((EntryType)parent).getName() + "." + fieldKey;
            }
            if (!conditionfield.equals(fieldKey)) continue;
            if (parent instanceof EntryType) {
                map.put(fieldKey, parent.getName());
                return map;
            }
            map.put(fieldKey, "");
            return map;
        }
        map.put(conditionfield, "");
        return map;
    }
}

